/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.net.Network;
import android.net.NetworkStats;
import android.net.RouteInfo;
import android.net.UidRange;
import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.INetworkActivityListener;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.List;

public interface INetworkManagementService
extends IInterface {
    public void addIdleTimer(String var1, int var2, int var3) throws RemoteException;

    public void addInterfaceToLocalNetwork(String var1, List<RouteInfo> var2) throws RemoteException;

    public void addInterfaceToNetwork(String var1, int var2) throws RemoteException;

    public void addLegacyRouteForNetId(int var1, RouteInfo var2, int var3) throws RemoteException;

    public void addRoute(int var1, RouteInfo var2) throws RemoteException;

    public void addVpnUidRanges(int var1, UidRange[] var2) throws RemoteException;

    public void allowProtect(int var1) throws RemoteException;

    public void attachPppd(String var1, String var2, String var3, String var4, String var5) throws RemoteException;

    public void clearDefaultNetId() throws RemoteException;

    public void clearInterfaceAddresses(String var1) throws RemoteException;

    public void clearPermission(int[] var1) throws RemoteException;

    public void createPhysicalNetwork(int var1) throws RemoteException;

    public void createVirtualNetwork(int var1, boolean var2, boolean var3) throws RemoteException;

    public void denyProtect(int var1) throws RemoteException;

    public void detachPppd(String var1) throws RemoteException;

    public void disableIpv6(String var1) throws RemoteException;

    public void disableNat(String var1, String var2) throws RemoteException;

    public void enableIpv6(String var1) throws RemoteException;

    public void enableNat(String var1, String var2) throws RemoteException;

    public void flushNetworkDnsCache(int var1) throws RemoteException;

    public String[] getDnsForwarders() throws RemoteException;

    public InterfaceConfiguration getInterfaceConfig(String var1) throws RemoteException;

    public boolean getIpForwardingEnabled() throws RemoteException;

    public NetworkStats getNetworkStatsDetail() throws RemoteException;

    public NetworkStats getNetworkStatsSummaryDev() throws RemoteException;

    public NetworkStats getNetworkStatsSummaryXt() throws RemoteException;

    public NetworkStats getNetworkStatsTethering() throws RemoteException;

    public NetworkStats getNetworkStatsUidDetail(int var1) throws RemoteException;

    public RouteInfo[] getRoutes(String var1) throws RemoteException;

    public boolean isBandwidthControlEnabled() throws RemoteException;

    public boolean isClatdStarted() throws RemoteException;

    public boolean isFirewallEnabled() throws RemoteException;

    public boolean isNetworkActive() throws RemoteException;

    public boolean isTetheringStarted() throws RemoteException;

    public String[] listInterfaces() throws RemoteException;

    public String[] listTetheredInterfaces() throws RemoteException;

    public String[] listTtys() throws RemoteException;

    public void registerNetworkActivityListener(INetworkActivityListener var1) throws RemoteException;

    public void registerObserver(INetworkManagementEventObserver var1) throws RemoteException;

    public void removeIdleTimer(String var1) throws RemoteException;

    public void removeInterfaceAlert(String var1) throws RemoteException;

    public void removeInterfaceFromLocalNetwork(String var1) throws RemoteException;

    public void removeInterfaceFromNetwork(String var1, int var2) throws RemoteException;

    public void removeInterfaceQuota(String var1) throws RemoteException;

    public void removeNetwork(int var1) throws RemoteException;

    public void removeRoute(int var1, RouteInfo var2) throws RemoteException;

    public void removeVpnUidRanges(int var1, UidRange[] var2) throws RemoteException;

    public void setAccessPoint(WifiConfiguration var1, String var2) throws RemoteException;

    public void setDefaultNetId(int var1) throws RemoteException;

    public void setDnsForwarders(Network var1, String[] var2) throws RemoteException;

    public void setDnsServersForNetwork(int var1, String[] var2, String var3) throws RemoteException;

    public void setFirewallEgressDestRule(String var1, int var2, boolean var3) throws RemoteException;

    public void setFirewallEgressSourceRule(String var1, boolean var2) throws RemoteException;

    public void setFirewallEnabled(boolean var1) throws RemoteException;

    public void setFirewallInterfaceRule(String var1, boolean var2) throws RemoteException;

    public void setFirewallUidRule(int var1, boolean var2) throws RemoteException;

    public void setGlobalAlert(long var1) throws RemoteException;

    public void setInterfaceAlert(String var1, long var2) throws RemoteException;

    public void setInterfaceConfig(String var1, InterfaceConfiguration var2) throws RemoteException;

    public void setInterfaceDown(String var1) throws RemoteException;

    public void setInterfaceIpv6PrivacyExtensions(String var1, boolean var2) throws RemoteException;

    public void setInterfaceQuota(String var1, long var2) throws RemoteException;

    public void setInterfaceUp(String var1) throws RemoteException;

    public void setIpForwardingEnabled(boolean var1) throws RemoteException;

    public void setMtu(String var1, int var2) throws RemoteException;

    public void setPermission(String var1, int[] var2) throws RemoteException;

    public void setUidNetworkRules(int var1, boolean var2) throws RemoteException;

    public void shutdown() throws RemoteException;

    public void startAccessPoint(WifiConfiguration var1, String var2) throws RemoteException;

    public void startClatd(String var1) throws RemoteException;

    public void startTethering(String[] var1) throws RemoteException;

    public void stopAccessPoint(String var1) throws RemoteException;

    public void stopClatd() throws RemoteException;

    public void stopTethering() throws RemoteException;

    public void tetherInterface(String var1) throws RemoteException;

    public void unregisterNetworkActivityListener(INetworkActivityListener var1) throws RemoteException;

    public void unregisterObserver(INetworkManagementEventObserver var1) throws RemoteException;

    public void untetherInterface(String var1) throws RemoteException;

    public void wifiFirmwareReload(String var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkManagementService {
        private static final String DESCRIPTOR = "android.os.INetworkManagementService";
        static final int TRANSACTION_addIdleTimer = 48;
        static final int TRANSACTION_addInterfaceToLocalNetwork = 78;
        static final int TRANSACTION_addInterfaceToNetwork = 69;
        static final int TRANSACTION_addLegacyRouteForNetId = 71;
        static final int TRANSACTION_addRoute = 13;
        static final int TRANSACTION_addVpnUidRanges = 58;
        static final int TRANSACTION_allowProtect = 76;
        static final int TRANSACTION_attachPppd = 30;
        static final int TRANSACTION_clearDefaultNetId = 73;
        static final int TRANSACTION_clearInterfaceAddresses = 6;
        static final int TRANSACTION_clearPermission = 75;
        static final int TRANSACTION_createPhysicalNetwork = 66;
        static final int TRANSACTION_createVirtualNetwork = 67;
        static final int TRANSACTION_denyProtect = 77;
        static final int TRANSACTION_detachPppd = 31;
        static final int TRANSACTION_disableIpv6 = 10;
        static final int TRANSACTION_disableNat = 28;
        static final int TRANSACTION_enableIpv6 = 11;
        static final int TRANSACTION_enableNat = 27;
        static final int TRANSACTION_flushNetworkDnsCache = 51;
        static final int TRANSACTION_getDnsForwarders = 26;
        static final int TRANSACTION_getInterfaceConfig = 4;
        static final int TRANSACTION_getIpForwardingEnabled = 17;
        static final int TRANSACTION_getNetworkStatsDetail = 38;
        static final int TRANSACTION_getNetworkStatsSummaryDev = 36;
        static final int TRANSACTION_getNetworkStatsSummaryXt = 37;
        static final int TRANSACTION_getNetworkStatsTethering = 40;
        static final int TRANSACTION_getNetworkStatsUidDetail = 39;
        static final int TRANSACTION_getRoutes = 12;
        static final int TRANSACTION_isBandwidthControlEnabled = 47;
        static final int TRANSACTION_isClatdStarted = 62;
        static final int TRANSACTION_isFirewallEnabled = 53;
        static final int TRANSACTION_isNetworkActive = 65;
        static final int TRANSACTION_isTetheringStarted = 21;
        static final int TRANSACTION_listInterfaces = 3;
        static final int TRANSACTION_listTetheredInterfaces = 24;
        static final int TRANSACTION_listTtys = 29;
        static final int TRANSACTION_registerNetworkActivityListener = 63;
        static final int TRANSACTION_registerObserver = 1;
        static final int TRANSACTION_removeIdleTimer = 49;
        static final int TRANSACTION_removeInterfaceAlert = 44;
        static final int TRANSACTION_removeInterfaceFromLocalNetwork = 79;
        static final int TRANSACTION_removeInterfaceFromNetwork = 70;
        static final int TRANSACTION_removeInterfaceQuota = 42;
        static final int TRANSACTION_removeNetwork = 68;
        static final int TRANSACTION_removeRoute = 14;
        static final int TRANSACTION_removeVpnUidRanges = 59;
        static final int TRANSACTION_setAccessPoint = 35;
        static final int TRANSACTION_setDefaultNetId = 72;
        static final int TRANSACTION_setDnsForwarders = 25;
        static final int TRANSACTION_setDnsServersForNetwork = 50;
        static final int TRANSACTION_setFirewallEgressDestRule = 56;
        static final int TRANSACTION_setFirewallEgressSourceRule = 55;
        static final int TRANSACTION_setFirewallEnabled = 52;
        static final int TRANSACTION_setFirewallInterfaceRule = 54;
        static final int TRANSACTION_setFirewallUidRule = 57;
        static final int TRANSACTION_setGlobalAlert = 45;
        static final int TRANSACTION_setInterfaceAlert = 43;
        static final int TRANSACTION_setInterfaceConfig = 5;
        static final int TRANSACTION_setInterfaceDown = 7;
        static final int TRANSACTION_setInterfaceIpv6PrivacyExtensions = 9;
        static final int TRANSACTION_setInterfaceQuota = 41;
        static final int TRANSACTION_setInterfaceUp = 8;
        static final int TRANSACTION_setIpForwardingEnabled = 18;
        static final int TRANSACTION_setMtu = 15;
        static final int TRANSACTION_setPermission = 74;
        static final int TRANSACTION_setUidNetworkRules = 46;
        static final int TRANSACTION_shutdown = 16;
        static final int TRANSACTION_startAccessPoint = 33;
        static final int TRANSACTION_startClatd = 60;
        static final int TRANSACTION_startTethering = 19;
        static final int TRANSACTION_stopAccessPoint = 34;
        static final int TRANSACTION_stopClatd = 61;
        static final int TRANSACTION_stopTethering = 20;
        static final int TRANSACTION_tetherInterface = 22;
        static final int TRANSACTION_unregisterNetworkActivityListener = 64;
        static final int TRANSACTION_unregisterObserver = 2;
        static final int TRANSACTION_untetherInterface = 23;
        static final int TRANSACTION_wifiFirmwareReload = 32;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkManagementService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof INetworkManagementService) {
                return (INetworkManagementService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerObserver(INetworkManagementEventObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterObserver(INetworkManagementEventObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.listInterfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InterfaceConfiguration interfaceConfiguration = this.getInterfaceConfig(parcel.readString());
                    parcel2.writeNoException();
                    if (interfaceConfiguration != null) {
                        parcel2.writeInt(1);
                        interfaceConfiguration.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    InterfaceConfiguration interfaceConfiguration = parcel.readInt() != 0 ? InterfaceConfiguration.CREATOR.createFromParcel(parcel) : null;
                    this.setInterfaceConfig(string2, interfaceConfiguration);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearInterfaceAddresses(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInterfaceDown(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInterfaceUp(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setInterfaceIpv6PrivacyExtensions(string3, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableIpv6(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableIpv6(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getRoutes(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    RouteInfo routeInfo = parcel.readInt() != 0 ? RouteInfo.CREATOR.createFromParcel(parcel) : null;
                    this.addRoute(n3, routeInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    RouteInfo routeInfo = parcel.readInt() != 0 ? RouteInfo.CREATOR.createFromParcel(parcel) : null;
                    this.removeRoute(n4, routeInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setMtu(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.shutdown();
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getIpForwardingEnabled();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setIpForwardingEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startTethering(parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopTethering();
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isTetheringStarted();
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.tetherInterface(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.untetherInterface(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.listTetheredInterfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = parcel.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel) : null;
                    this.setDnsForwarders(network, parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getDnsForwarders();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableNat(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableNat(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.listTtys();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.attachPppd(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.detachPppd(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.wifiFirmwareReload(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    this.startAccessPoint(wifiConfiguration, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopAccessPoint(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    this.setAccessPoint(wifiConfiguration, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getNetworkStatsSummaryDev();
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getNetworkStatsSummaryXt();
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getNetworkStatsDetail();
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getNetworkStatsUidDetail(parcel.readInt());
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getNetworkStatsTethering();
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInterfaceQuota(parcel.readString(), parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeInterfaceQuota(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInterfaceAlert(parcel.readString(), parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeInterfaceAlert(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setGlobalAlert(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setUidNetworkRules(n7, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBandwidthControlEnabled();
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addIdleTimer(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeIdleTimer(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDnsServersForNetwork(parcel.readInt(), parcel.createStringArray(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.flushNetworkDnsCache(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setFirewallEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isFirewallEnabled();
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setFirewallInterfaceRule(string4, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setFirewallEgressSourceRule(string5, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    int n10 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setFirewallEgressDestRule(string6, n10, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setFirewallUidRule(n11, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addVpnUidRanges(parcel.readInt(), parcel.createTypedArray(UidRange.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeVpnUidRanges(parcel.readInt(), parcel.createTypedArray(UidRange.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startClatd(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopClatd();
                    parcel2.writeNoException();
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isClatdStarted();
                    parcel2.writeNoException();
                    int n12 = bl ? 1 : 0;
                    parcel2.writeInt(n12);
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerNetworkActivityListener(INetworkActivityListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterNetworkActivityListener(INetworkActivityListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isNetworkActive();
                    parcel2.writeNoException();
                    int n13 = bl ? 1 : 0;
                    parcel2.writeInt(n13);
                    return true;
                }
                case 66: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.createPhysicalNetwork(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 67: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    this.createVirtualNetwork(n14, bl, bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 68: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeNetwork(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 69: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addInterfaceToNetwork(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 70: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeInterfaceFromNetwork(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 71: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = parcel.readInt();
                    RouteInfo routeInfo = parcel.readInt() != 0 ? RouteInfo.CREATOR.createFromParcel(parcel) : null;
                    this.addLegacyRouteForNetId(n15, routeInfo, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 72: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDefaultNetId(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 73: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearDefaultNetId();
                    parcel2.writeNoException();
                    return true;
                }
                case 74: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setPermission(parcel.readString(), parcel.createIntArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 75: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearPermission(parcel.createIntArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 76: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.allowProtect(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 77: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.denyProtect(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 78: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addInterfaceToLocalNetwork(parcel.readString(), parcel.createTypedArrayList(RouteInfo.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 79: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.removeInterfaceFromLocalNetwork(parcel.readString());
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements INetworkManagementService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void addIdleTimer(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void addInterfaceToLocalNetwork(String string2, List<RouteInfo> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeTypedList(list);
                    this.mRemote.transact(78, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void addInterfaceToNetwork(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addLegacyRouteForNetId(int n, RouteInfo routeInfo, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (routeInfo != null) {
                        parcel.writeInt(1);
                        routeInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addRoute(int n, RouteInfo routeInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (routeInfo != null) {
                        parcel.writeInt(1);
                        routeInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void addVpnUidRanges(int n, UidRange[] uidRangeArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeTypedArray(uidRangeArray, 0);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void allowProtect(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(76, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void attachPppd(String string2, String string3, String string4, String string5, String string6) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    parcel.writeString(string5);
                    parcel.writeString(string6);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearDefaultNetId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(73, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearInterfaceAddresses(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearPermission(int[] nArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeIntArray(nArray);
                    this.mRemote.transact(75, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void createPhysicalNetwork(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createVirtualNetwork(int n, boolean bl, boolean bl2) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n3 = bl ? n2 : 0;
                    parcel.writeInt(n3);
                    if (!bl2) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void denyProtect(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(77, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void detachPppd(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disableIpv6(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disableNat(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableIpv6(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableNat(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void flushNetworkDnsCache(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getDnsForwarders() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InterfaceConfiguration getInterfaceConfig(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    InterfaceConfiguration interfaceConfiguration = parcel2.readInt() != 0 ? InterfaceConfiguration.CREATOR.createFromParcel(parcel2) : null;
                    return interfaceConfiguration;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public boolean getIpForwardingEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getNetworkStatsDetail() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getNetworkStatsSummaryDev() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getNetworkStatsSummaryXt() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getNetworkStatsTethering() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getNetworkStatsUidDetail(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public RouteInfo[] getRoutes(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    RouteInfo[] routeInfoArray = parcel2.createTypedArray(RouteInfo.CREATOR);
                    return routeInfoArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isBandwidthControlEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isClatdStarted() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isFirewallEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isNetworkActive() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isTetheringStarted() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String[] listInterfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] listTetheredInterfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] listTtys() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerNetworkActivityListener(INetworkActivityListener iNetworkActivityListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNetworkActivityListener != null ? iNetworkActivityListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerObserver(INetworkManagementEventObserver iNetworkManagementEventObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNetworkManagementEventObserver != null ? iNetworkManagementEventObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void removeIdleTimer(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeInterfaceAlert(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeInterfaceFromLocalNetwork(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(79, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeInterfaceFromNetwork(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeInterfaceQuota(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeNetwork(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeRoute(int n, RouteInfo routeInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (routeInfo != null) {
                        parcel.writeInt(1);
                        routeInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeVpnUidRanges(int n, UidRange[] uidRangeArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeTypedArray(uidRangeArray, 0);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAccessPoint(WifiConfiguration wifiConfiguration, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfiguration != null) {
                        parcel.writeInt(1);
                        wifiConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDefaultNetId(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(72, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setDnsForwarders(Network network, String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        parcel.writeInt(1);
                        network.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDnsServersForNetwork(int n, String[] stringArray, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStringArray(stringArray);
                    parcel.writeString(string2);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setFirewallEgressDestRule(String string2, int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(56, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFirewallEgressSourceRule(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(55, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFirewallEnabled(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(52, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFirewallInterfaceRule(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(54, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFirewallUidRule(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(57, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setGlobalAlert(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInterfaceAlert(String string2, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeLong(l);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInterfaceConfig(String string2, InterfaceConfiguration interfaceConfiguration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (interfaceConfiguration != null) {
                        parcel.writeInt(1);
                        interfaceConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInterfaceDown(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInterfaceIpv6PrivacyExtensions(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(9, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setInterfaceQuota(String string2, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeLong(l);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInterfaceUp(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setIpForwardingEnabled(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(18, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setMtu(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setPermission(String string2, int[] nArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeIntArray(nArray);
                    this.mRemote.transact(74, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setUidNetworkRules(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(46, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void shutdown() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startAccessPoint(WifiConfiguration wifiConfiguration, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfiguration != null) {
                        parcel.writeInt(1);
                        wifiConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startClatd(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startTethering(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopAccessPoint(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopClatd() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopTethering() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void tetherInterface(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterNetworkActivityListener(INetworkActivityListener iNetworkActivityListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNetworkActivityListener != null ? iNetworkActivityListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterObserver(INetworkManagementEventObserver iNetworkManagementEventObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNetworkManagementEventObserver != null ? iNetworkManagementEventObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void untetherInterface(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void wifiFirmwareReload(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

