/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.CommonTimeUtils;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;

public class CommonTimeConfig {
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_DEAD_OBJECT = -7;
    public static final long INVALID_GROUP_ID = -1L;
    private static final int METHOD_FORCE_NETWORKLESS_MASTER_MODE = 17;
    private static final int METHOD_GET_AUTO_DISABLE = 15;
    private static final int METHOD_GET_CLIENT_SYNC_INTERVAL = 11;
    private static final int METHOD_GET_INTERFACE_BINDING = 7;
    private static final int METHOD_GET_MASTER_ANNOUNCE_INTERVAL = 9;
    private static final int METHOD_GET_MASTER_ELECTION_ENDPOINT = 3;
    private static final int METHOD_GET_MASTER_ELECTION_GROUP_ID = 5;
    private static final int METHOD_GET_MASTER_ELECTION_PRIORITY = 1;
    private static final int METHOD_GET_PANIC_THRESHOLD = 13;
    private static final int METHOD_SET_AUTO_DISABLE = 16;
    private static final int METHOD_SET_CLIENT_SYNC_INTERVAL = 12;
    private static final int METHOD_SET_INTERFACE_BINDING = 8;
    private static final int METHOD_SET_MASTER_ANNOUNCE_INTERVAL = 10;
    private static final int METHOD_SET_MASTER_ELECTION_ENDPOINT = 4;
    private static final int METHOD_SET_MASTER_ELECTION_GROUP_ID = 6;
    private static final int METHOD_SET_MASTER_ELECTION_PRIORITY = 2;
    private static final int METHOD_SET_PANIC_THRESHOLD = 14;
    public static final String SERVICE_NAME = "common_time.config";
    public static final int SUCCESS;
    private IBinder.DeathRecipient mDeathHandler;
    private String mInterfaceDesc = "";
    private final Object mListenerLock = new Object();
    private IBinder mRemote = null;
    private OnServerDiedListener mServerDiedListener = null;
    private CommonTimeUtils mUtils;

    public CommonTimeConfig() throws RemoteException {
        this.mDeathHandler = new IBinder.DeathRecipient(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void binderDied() {
                Object object = CommonTimeConfig.this.mListenerLock;
                synchronized (object) {
                    if (CommonTimeConfig.this.mServerDiedListener != null) {
                        CommonTimeConfig.this.mServerDiedListener.onServerDied();
                    }
                    return;
                }
            }
        };
        this.mRemote = ServiceManager.getService(SERVICE_NAME);
        if (this.mRemote == null) {
            throw new RemoteException();
        }
        this.mInterfaceDesc = this.mRemote.getInterfaceDescriptor();
        this.mUtils = new CommonTimeUtils(this.mRemote, this.mInterfaceDesc);
        this.mRemote.linkToDeath(this.mDeathHandler, 0);
    }

    private boolean checkDeadServer() {
        return this.mRemote == null || this.mUtils == null;
    }

    public static CommonTimeConfig create() {
        try {
            CommonTimeConfig commonTimeConfig = new CommonTimeConfig();
            return commonTimeConfig;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private void throwOnDeadServer() throws RemoteException {
        if (this.checkDeadServer()) {
            throw new RemoteException();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public int forceNetworklessMasterMode() {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(17, parcel, parcel2, 0);
            int n = parcel2.readInt();
            return n;
        }
        catch (RemoteException remoteException) {
            return -7;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    public boolean getAutoDisable() throws RemoteException {
        this.throwOnDeadServer();
        return 1 == this.mUtils.transactGetInt(15, 1);
    }

    public int getClientSyncInterval() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetInt(11, -1);
    }

    public String getInterfaceBinding() throws RemoteException {
        this.throwOnDeadServer();
        String string2 = this.mUtils.transactGetString(7, null);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public int getMasterAnnounceInterval() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetInt(9, -1);
    }

    public InetSocketAddress getMasterElectionEndpoint() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetSockaddr(3);
    }

    public long getMasterElectionGroupId() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetLong(5, -1L);
    }

    public byte getMasterElectionPriority() throws RemoteException {
        this.throwOnDeadServer();
        return (byte)this.mUtils.transactGetInt(1, -1);
    }

    public int getPanicThreshold() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetInt(13, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        if (this.mRemote != null) {
            try {
                this.mRemote.unlinkToDeath(this.mDeathHandler, 0);
            }
            catch (NoSuchElementException noSuchElementException) {}
            this.mRemote = null;
        }
        this.mUtils = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setAutoDisable(boolean bl) {
        int n;
        if (this.checkDeadServer()) {
            return -7;
        }
        CommonTimeUtils commonTimeUtils = this.mUtils;
        if (bl) {
            n = 1;
            return commonTimeUtils.transactSetInt(16, n);
        }
        n = 0;
        return commonTimeUtils.transactSetInt(16, n);
    }

    public int setClientSyncInterval(int n) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetInt(12, n);
    }

    public int setMasterAnnounceInterval(int n) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetInt(10, n);
    }

    public int setMasterElectionEndpoint(InetSocketAddress inetSocketAddress) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetSockaddr(4, inetSocketAddress);
    }

    public int setMasterElectionGroupId(long l) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetLong(6, l);
    }

    public int setMasterElectionPriority(byte by) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetInt(2, by);
    }

    public int setNetworkBinding(String string2) {
        if (this.checkDeadServer()) {
            return -7;
        }
        CommonTimeUtils commonTimeUtils = this.mUtils;
        if (string2 == null) {
            string2 = "";
        }
        return commonTimeUtils.transactSetString(8, string2);
    }

    public int setPanicThreshold(int n) {
        if (this.checkDeadServer()) {
            return -7;
        }
        return this.mUtils.transactSetInt(14, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServerDiedListener(OnServerDiedListener onServerDiedListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mServerDiedListener = onServerDiedListener;
            return;
        }
    }

    public static interface OnServerDiedListener {
        public void onServerDied();
    }
}

