/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class NdefMessage
implements Parcelable {
    public static final Parcelable.Creator<NdefMessage> CREATOR = new Parcelable.Creator<NdefMessage>(){

        @Override
        public NdefMessage createFromParcel(Parcel parcel) {
            NdefRecord[] ndefRecordArray = new NdefRecord[parcel.readInt()];
            parcel.readTypedArray(ndefRecordArray, NdefRecord.CREATOR);
            return new NdefMessage(ndefRecordArray);
        }

        public NdefMessage[] newArray(int n) {
            return new NdefMessage[n];
        }
    };
    private final NdefRecord[] mRecords;

    public NdefMessage(NdefRecord ndefRecord, NdefRecord ... ndefRecordArray) {
        if (ndefRecord == null) {
            throw new NullPointerException("record cannot be null");
        }
        int n = ndefRecordArray.length;
        for (int i = 0; i < n; ++i) {
            if (ndefRecordArray[i] != null) continue;
            throw new NullPointerException("record cannot be null");
        }
        this.mRecords = new NdefRecord[1 + ndefRecordArray.length];
        this.mRecords[0] = ndefRecord;
        System.arraycopy(ndefRecordArray, 0, this.mRecords, 1, ndefRecordArray.length);
    }

    public NdefMessage(byte[] byArray) throws FormatException {
        if (byArray == null) {
            throw new NullPointerException("data is null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.mRecords = NdefRecord.parse(byteBuffer, false);
        if (byteBuffer.remaining() > 0) {
            throw new FormatException("trailing data");
        }
    }

    public NdefMessage(NdefRecord[] ndefRecordArray) {
        if (ndefRecordArray.length < 1) {
            throw new IllegalArgumentException("must have at least one record");
        }
        int n = ndefRecordArray.length;
        for (int i = 0; i < n; ++i) {
            if (ndefRecordArray[i] != null) continue;
            throw new NullPointerException("records cannot contain null");
        }
        this.mRecords = ndefRecordArray;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object == null) return bl;
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        bl = false;
        if (clazz != clazz2) return bl;
        NdefMessage ndefMessage = (NdefMessage)object;
        return Arrays.equals(this.mRecords, ndefMessage.mRecords);
    }

    public int getByteArrayLength() {
        int n = 0;
        NdefRecord[] ndefRecordArray = this.mRecords;
        int n2 = ndefRecordArray.length;
        for (int i = 0; i < n2; ++i) {
            n += ndefRecordArray[i].getByteLength();
        }
        return n;
    }

    public NdefRecord[] getRecords() {
        return this.mRecords;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mRecords);
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getByteArrayLength());
        int n = 0;
        while (n < this.mRecords.length) {
            boolean bl = n == 0;
            boolean bl2 = n == -1 + this.mRecords.length;
            this.mRecords[n].writeToByteBuffer(byteBuffer, bl, bl2);
            ++n;
        }
        return byteBuffer.array();
    }

    public String toString() {
        return "NdefMessage " + Arrays.toString(this.mRecords);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mRecords.length);
        parcel.writeTypedArray(this.mRecords, n);
    }
}

