/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;

public class WifiLinkLayerStats
implements Parcelable {
    public static final Parcelable.Creator<WifiLinkLayerStats> CREATOR = new Parcelable.Creator<WifiLinkLayerStats>(){

        @Override
        public WifiLinkLayerStats createFromParcel(Parcel parcel) {
            WifiLinkLayerStats wifiLinkLayerStats = new WifiLinkLayerStats();
            wifiLinkLayerStats.SSID = parcel.readString();
            wifiLinkLayerStats.BSSID = parcel.readString();
            wifiLinkLayerStats.on_time = parcel.readInt();
            wifiLinkLayerStats.tx_time = parcel.readInt();
            wifiLinkLayerStats.rx_time = parcel.readInt();
            wifiLinkLayerStats.on_time_scan = parcel.readInt();
            return wifiLinkLayerStats;
        }

        public WifiLinkLayerStats[] newArray(int n) {
            return new WifiLinkLayerStats[n];
        }
    };
    private static final String TAG = "WifiLinkLayerStats";
    public String BSSID;
    public String SSID;
    public int beacon_rx;
    public long lostmpdu_be;
    public long lostmpdu_bk;
    public long lostmpdu_vi;
    public long lostmpdu_vo;
    public int on_time;
    public int on_time_scan;
    public long retries_be;
    public long retries_bk;
    public long retries_vi;
    public long retries_vo;
    public int rssi_mgmt;
    public int rx_time;
    public long rxmpdu_be;
    public long rxmpdu_bk;
    public long rxmpdu_vi;
    public long rxmpdu_vo;
    public int status;
    public int tx_time;
    public long txmpdu_be;
    public long txmpdu_bk;
    public long txmpdu_vi;
    public long txmpdu_vo;

    @Override
    public int describeContents() {
        return 0;
    }

    public String getPrintableSsid() {
        if (this.SSID == null) {
            return "";
        }
        int n = this.SSID.length();
        if (n > 2 && this.SSID.charAt(0) == '\"' && this.SSID.charAt(n - 1) == '\"') {
            return this.SSID.substring(1, n - 1);
        }
        if (n > 3 && this.SSID.charAt(0) == 'P' && this.SSID.charAt(1) == '\"' && this.SSID.charAt(n - 1) == '\"') {
            return WifiSsid.createFromAsciiEncoded(this.SSID.substring(2, n - 1)).toString();
        }
        return this.SSID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" WifiLinkLayerStats: ").append('\n');
        if (this.SSID != null) {
            stringBuilder.append(" SSID: ").append(this.SSID).append('\n');
        }
        if (this.BSSID != null) {
            stringBuilder.append(" BSSID: ").append(this.BSSID).append('\n');
        }
        stringBuilder.append(" my bss beacon rx: ").append(Integer.toString(this.beacon_rx)).append('\n');
        stringBuilder.append(" RSSI mgmt: ").append(Integer.toString(this.rssi_mgmt)).append('\n');
        stringBuilder.append(" BE : ").append(" rx=").append(Long.toString(this.rxmpdu_be)).append(" tx=").append(Long.toString(this.txmpdu_be)).append(" lost=").append(Long.toString(this.lostmpdu_be)).append(" retries=").append(Long.toString(this.retries_be)).append('\n');
        stringBuilder.append(" BK : ").append(" rx=").append(Long.toString(this.rxmpdu_bk)).append(" tx=").append(Long.toString(this.txmpdu_bk)).append(" lost=").append(Long.toString(this.lostmpdu_bk)).append(" retries=").append(Long.toString(this.retries_bk)).append('\n');
        stringBuilder.append(" VI : ").append(" rx=").append(Long.toString(this.rxmpdu_vi)).append(" tx=").append(Long.toString(this.txmpdu_vi)).append(" lost=").append(Long.toString(this.lostmpdu_vi)).append(" retries=").append(Long.toString(this.retries_vi)).append('\n');
        stringBuilder.append(" VO : ").append(" rx=").append(Long.toString(this.rxmpdu_vo)).append(" tx=").append(Long.toString(this.txmpdu_vo)).append(" lost=").append(Long.toString(this.lostmpdu_vo)).append(" retries=").append(Long.toString(this.retries_vo)).append('\n');
        stringBuilder.append(" on_time : ").append(Integer.toString(this.on_time)).append(" tx_time=").append(Integer.toString(this.tx_time)).append(" rx_time=").append(Integer.toString(this.rx_time)).append(" scan_time=").append(Integer.toString(this.on_time_scan)).append('\n');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.SSID);
        parcel.writeString(this.BSSID);
        parcel.writeInt(this.on_time);
        parcel.writeInt(this.tx_time);
        parcel.writeInt(this.rx_time);
        parcel.writeInt(this.on_time_scan);
    }
}

