/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class WifiEnterpriseConfig
implements Parcelable {
    public static final String ANON_IDENTITY_KEY = "anonymous_identity";
    public static final String CA_CERT_KEY = "ca_cert";
    public static final String CA_CERT_PREFIX = "keystore://CACERT_";
    public static final String CLIENT_CERT_KEY = "client_cert";
    public static final String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static final Parcelable.Creator<WifiEnterpriseConfig> CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private X509Certificate readCertificate(Parcel parcel) {
            int n = parcel.readInt();
            X509Certificate x509Certificate = null;
            if (n <= 0) return x509Certificate;
            try {
                byte[] byArray = new byte[n];
                parcel.readByteArray(byArray);
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
            }
            catch (CertificateException certificateException) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public WifiEnterpriseConfig createFromParcel(Parcel parcel) {
            WifiEnterpriseConfig wifiEnterpriseConfig = new WifiEnterpriseConfig();
            int n = parcel.readInt();
            for (int i = 0; i < n; ++i) {
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                wifiEnterpriseConfig.mFields.put(string2, string3);
            }
            WifiEnterpriseConfig.access$102(wifiEnterpriseConfig, this.readCertificate(parcel));
            int n2 = parcel.readInt();
            PrivateKey privateKey = null;
            if (n2 > 0) {
                try {
                    PrivateKey privateKey2;
                    byte[] byArray = new byte[n2];
                    parcel.readByteArray(byArray);
                    privateKey = privateKey2 = KeyFactory.getInstance(parcel.readString()).generatePrivate(new PKCS8EncodedKeySpec(byArray));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    privateKey = null;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    privateKey = null;
                }
            }
            WifiEnterpriseConfig.access$202(wifiEnterpriseConfig, privateKey);
            WifiEnterpriseConfig.access$302(wifiEnterpriseConfig, this.readCertificate(parcel));
            return wifiEnterpriseConfig;
        }

        public WifiEnterpriseConfig[] newArray(int n) {
            return new WifiEnterpriseConfig[n];
        }
    };
    public static final String EAP_KEY = "eap";
    public static final String EMPTY_VALUE = "NULL";
    public static final String ENGINE_DISABLE = "0";
    public static final String ENGINE_ENABLE = "1";
    public static final String ENGINE_ID_KEY = "engine_id";
    public static final String ENGINE_ID_KEYSTORE = "keystore";
    public static final String ENGINE_KEY = "engine";
    public static final String IDENTITY_KEY = "identity";
    public static final String KEYSTORE_URI = "keystore://";
    public static final String OPP_KEY_CACHING = "proactive_key_caching";
    public static final String PASSWORD_KEY = "password";
    public static final String PHASE2_KEY = "phase2";
    public static final String PRIVATE_KEY_ID_KEY = "key_id";
    public static final String SUBJECT_MATCH_KEY = "subject_match";
    private X509Certificate mCaCert;
    private X509Certificate mClientCertificate;
    private PrivateKey mClientPrivateKey;
    private HashMap<String, String> mFields = new HashMap();

    public WifiEnterpriseConfig() {
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig wifiEnterpriseConfig) {
        for (String string2 : wifiEnterpriseConfig.mFields.keySet()) {
            this.mFields.put(string2, wifiEnterpriseConfig.mFields.get(string2));
        }
    }

    static /* synthetic */ X509Certificate access$102(WifiEnterpriseConfig wifiEnterpriseConfig, X509Certificate x509Certificate) {
        wifiEnterpriseConfig.mCaCert = x509Certificate;
        return x509Certificate;
    }

    static /* synthetic */ PrivateKey access$202(WifiEnterpriseConfig wifiEnterpriseConfig, PrivateKey privateKey) {
        wifiEnterpriseConfig.mClientPrivateKey = privateKey;
        return privateKey;
    }

    static /* synthetic */ X509Certificate access$302(WifiEnterpriseConfig wifiEnterpriseConfig, X509Certificate x509Certificate) {
        wifiEnterpriseConfig.mClientCertificate = x509Certificate;
        return x509Certificate;
    }

    private String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getStringIndex(String[] stringArray, String string2, int n) {
        if (!TextUtils.isEmpty(string2)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return i;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int n = string2.length();
        if (n <= 1) return string2;
        if (string2.charAt(0) != '\"') return string2;
        if (string2.charAt(n - 1) != '\"') return string2;
        return string2.substring(1, n - 1);
    }

    private void writeCertificate(Parcel parcel, X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            try {
                byte[] byArray = x509Certificate.getEncoded();
                parcel.writeInt(byArray.length);
                parcel.writeByteArray(byArray);
                return;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                parcel.writeInt(0);
                return;
            }
        }
        parcel.writeInt(0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getAnonymousIdentity() {
        return this.getFieldValue(ANON_IDENTITY_KEY, "");
    }

    public X509Certificate getCaCertificate() {
        return this.mCaCert;
    }

    public String getCaCertificateAlias() {
        return this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX);
    }

    public X509Certificate getClientCertificate() {
        return this.mClientCertificate;
    }

    public String getClientCertificateAlias() {
        return this.getFieldValue(CLIENT_CERT_KEY, CLIENT_CERT_PREFIX);
    }

    public PrivateKey getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    public int getEapMethod() {
        String string2 = this.mFields.get(EAP_KEY);
        return this.getStringIndex(Eap.strings, string2, -1);
    }

    public String getFieldValue(String string2, String string3) {
        String string4 = this.mFields.get(string2);
        if (TextUtils.isEmpty(string4) || EMPTY_VALUE.equals(string4)) {
            return "";
        }
        String string5 = this.removeDoubleQuotes(string4);
        if (string5.startsWith(string3)) {
            return string5.substring(string3.length());
        }
        return string5;
    }

    public HashMap<String, String> getFields() {
        return this.mFields;
    }

    public String getIdentity() {
        return this.getFieldValue(IDENTITY_KEY, "");
    }

    String getKeyId(WifiEnterpriseConfig wifiEnterpriseConfig) {
        String string2 = this.mFields.get(EAP_KEY);
        String string3 = this.mFields.get(PHASE2_KEY);
        if (TextUtils.isEmpty(string2)) {
            string2 = wifiEnterpriseConfig.mFields.get(EAP_KEY);
        }
        if (TextUtils.isEmpty(string3)) {
            string3 = wifiEnterpriseConfig.mFields.get(PHASE2_KEY);
        }
        return string2 + "_" + string3;
    }

    public String getPassword() {
        return this.getFieldValue(PASSWORD_KEY, "");
    }

    public int getPhase2Method() {
        String string2 = this.removeDoubleQuotes(this.mFields.get(PHASE2_KEY));
        if (string2.startsWith("auth=")) {
            string2 = string2.substring("auth=".length());
        }
        return this.getStringIndex(Phase2.strings, string2, 0);
    }

    public String getSubjectMatch() {
        return this.getFieldValue(SUBJECT_MATCH_KEY, "");
    }

    public void resetCaCertificate() {
        this.mCaCert = null;
    }

    public void resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificate = null;
    }

    public void setAnonymousIdentity(String string2) {
        this.setFieldValue(ANON_IDENTITY_KEY, string2, "");
    }

    public void setCaCertificate(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            if (x509Certificate.getBasicConstraints() >= 0) {
                this.mCaCert = x509Certificate;
                return;
            }
            throw new IllegalArgumentException("Not a CA certificate");
        }
        this.mCaCert = null;
    }

    public void setCaCertificateAlias(String string2) {
        this.setFieldValue(CA_CERT_KEY, string2, CA_CERT_PREFIX);
    }

    public void setClientCertificateAlias(String string2) {
        this.setFieldValue(CLIENT_CERT_KEY, string2, CLIENT_CERT_PREFIX);
        this.setFieldValue(PRIVATE_KEY_ID_KEY, string2, "USRPKEY_");
        if (TextUtils.isEmpty(string2)) {
            this.mFields.put(ENGINE_KEY, ENGINE_DISABLE);
            this.mFields.put(ENGINE_ID_KEY, EMPTY_VALUE);
            return;
        }
        this.mFields.put(ENGINE_KEY, ENGINE_ENABLE);
        this.mFields.put(ENGINE_ID_KEY, this.convertToQuotedString(ENGINE_ID_KEYSTORE));
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            if (x509Certificate.getBasicConstraints() != -1) {
                throw new IllegalArgumentException("Cannot be a CA certificate");
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            if (privateKey.getEncoded() == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificate = x509Certificate;
    }

    public void setEapMethod(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
            case 1: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        this.mFields.put(EAP_KEY, Eap.strings[n]);
        this.mFields.put(OPP_KEY_CACHING, ENGINE_ENABLE);
    }

    public void setFieldValue(String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            this.mFields.put(string2, EMPTY_VALUE);
            return;
        }
        this.mFields.put(string2, this.convertToQuotedString(string3));
    }

    public void setFieldValue(String string2, String string3, String string4) {
        if (TextUtils.isEmpty(string3)) {
            this.mFields.put(string2, EMPTY_VALUE);
            return;
        }
        this.mFields.put(string2, this.convertToQuotedString(string4 + string3));
    }

    public void setIdentity(String string2) {
        this.setFieldValue(IDENTITY_KEY, string2, "");
    }

    public void setPassword(String string2) {
        this.setFieldValue(PASSWORD_KEY, string2, "");
    }

    public void setPhase2Method(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
            case 0: {
                this.mFields.put(PHASE2_KEY, EMPTY_VALUE);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        this.mFields.put(PHASE2_KEY, this.convertToQuotedString("auth=" + Phase2.strings[n]));
    }

    public void setSubjectMatch(String string2) {
        this.setFieldValue(SUBJECT_MATCH_KEY, string2, "");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : this.mFields.keySet()) {
            stringBuffer.append(string2).append(" ").append(this.mFields.get(string2)).append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mFields.size());
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            parcel.writeString(entry.getKey());
            parcel.writeString(entry.getValue());
        }
        this.writeCertificate(parcel, this.mCaCert);
        if (this.mClientPrivateKey != null) {
            String string2 = this.mClientPrivateKey.getAlgorithm();
            byte[] byArray = this.mClientPrivateKey.getEncoded();
            parcel.writeInt(byArray.length);
            parcel.writeByteArray(byArray);
            parcel.writeString(string2);
        } else {
            parcel.writeInt(0);
        }
        this.writeCertificate(parcel, this.mClientCertificate);
    }

    public static final class Eap {
        public static final int AKA = 5;
        public static final int NONE = -1;
        public static final int PEAP = 0;
        public static final int PWD = 3;
        public static final int SIM = 4;
        public static final int TLS = 1;
        public static final int TTLS = 2;
        public static final String[] strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA"};

        private Eap() {
        }
    }

    public static final class Phase2 {
        public static final int GTC = 4;
        public static final int MSCHAP = 2;
        public static final int MSCHAPV2 = 3;
        public static final int NONE = 0;
        public static final int PAP = 1;
        private static final String PREFIX = "auth=";
        public static final String[] strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC"};

        private Phase2() {
        }
    }
}

