/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.IpConfiguration;
import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class WifiConfiguration
implements Parcelable {
    public static final int AUTO_JOIN_DELETED = 200;
    public static final int AUTO_JOIN_DISABLED_NO_CREDENTIALS = 160;
    public static final int AUTO_JOIN_DISABLED_ON_AUTH_FAILURE = 128;
    public static final int AUTO_JOIN_DISABLED_USER_ACTION = 161;
    public static final int AUTO_JOIN_ENABLED = 0;
    public static final int AUTO_JOIN_TEMPORARY_DISABLED = 1;
    public static final int AUTO_JOIN_TEMPORARY_DISABLED_AT_SUPPLICANT = 64;
    public static final int AUTO_JOIN_TEMPORARY_DISABLED_LINK_ERRORS = 32;
    public static int A_BAND_PREFERENCE_RSSI_THRESHOLD = 0;
    public static int BAD_RSSI_24 = 0;
    public static int BAD_RSSI_5 = 0;
    public static final Parcelable.Creator<WifiConfiguration> CREATOR;
    public static final int DISABLED_ASSOCIATION_REJECT = 4;
    public static final int DISABLED_AUTH_FAILURE = 3;
    public static final int DISABLED_BY_WIFI_MANAGER = 5;
    public static final int DISABLED_DHCP_FAILURE = 2;
    public static final int DISABLED_DNS_FAILURE = 1;
    public static final int DISABLED_UNKNOWN_REASON = 0;
    public static int GOOD_RSSI_24 = 0;
    public static int GOOD_RSSI_5 = 0;
    public static int G_BAND_PREFERENCE_RSSI_THRESHOLD = 0;
    public static int HOME_NETWORK_RSSI_BOOST = 0;
    public static int INITIAL_AUTO_JOIN_ATTEMPT_MIN_24 = 0;
    public static int INITIAL_AUTO_JOIN_ATTEMPT_MIN_5 = 0;
    public static final int INVALID_NETWORK_ID = -1;
    public static int INVALID_RSSI = 0;
    public static int LOW_RSSI_24 = 0;
    public static int LOW_RSSI_5 = 0;
    public static int MAX_INITIAL_AUTO_JOIN_RSSI_BOOST = 0;
    private static final String TAG = "WifiConfiguration";
    public static int UNBLACKLIST_THRESHOLD_24_HARD = 0;
    public static int UNBLACKLIST_THRESHOLD_24_SOFT = 0;
    public static int UNBLACKLIST_THRESHOLD_5_HARD = 0;
    public static int UNBLACKLIST_THRESHOLD_5_SOFT = 0;
    public static int UNWANTED_BLACKLIST_HARD_BUMP = 0;
    public static int UNWANTED_BLACKLIST_SOFT_BUMP = 0;
    public static int UNWANTED_BLACKLIST_SOFT_RSSI_24 = 0;
    public static int UNWANTED_BLACKLIST_SOFT_RSSI_5 = 0;
    public static final int WAPI_ASCII_PASSWORD = 0;
    public static final int WAPI_HEX_PASSWORD = 1;
    public static final String bssidVarName = "bssid";
    public static final String hiddenSSIDVarName = "scan_ssid";
    public static final String pmfVarName = "ieee80211w";
    public static final String priorityVarName = "priority";
    public static final String pskVarName = "psk";
    public static final String ssidVarName = "ssid";
    public static final String updateIdentiferVarName = "update_identifier";
    public static final String wapiAsCertVarName = "wapi_as_cert";
    public static final String wapiCertIndexVarName = "cert_index";
    public static final String wapiPskTypeVarName = "psk_key_type";
    public static final String wapiUserCertVarName = "wapi_user_cert";
    public static final String[] wepKeyVarNames;
    public static final String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public String BSSID;
    public String FQDN;
    public String SSID;
    public BitSet allowedAuthAlgorithms;
    public BitSet allowedGroupCiphers;
    public BitSet allowedKeyManagement;
    public BitSet allowedPairwiseCiphers;
    public BitSet allowedProtocols;
    public String autoJoinBSSID;
    public boolean autoJoinBailedDueToLowRssi;
    public int autoJoinStatus;
    public int autoJoinUseAggressiveJoinAttemptThreshold;
    public long blackListTimestamp;
    public int channel;
    public HashMap<String, Integer> connectChoices;
    public int creatorUid;
    public String defaultGwMacAddress;
    public String dhcpServer;
    public boolean didSelfAdd;
    public boolean dirty;
    public int disableReason;
    public WifiEnterpriseConfig enterpriseConfig;
    public boolean ephemeral;
    public boolean hiddenSSID;
    public int lastConnectUid;
    public long lastConnected;
    public long lastConnectionFailure;
    public long lastDisconnected;
    public String lastFailure;
    public int lastUpdateUid;
    public HashMap<String, Integer> linkedConfigurations;
    String mCachedConfigKey;
    private IpConfiguration mIpConfiguration;
    public String naiRealm;
    public int networkId;
    public boolean noInternetAccess;
    public int numAssociation;
    public int numAuthFailures;
    public int numConnectionFailures;
    public int numIpConfigFailures;
    public int numScorerOverride;
    public int numScorerOverrideAndSwitchedNetwork;
    public int numTicksAtBadRSSI;
    public int numTicksAtLowRSSI;
    public int numTicksAtNotHighRSSI;
    public int numUserTriggeredJoinAttempts;
    public int numUserTriggeredWifiDisableBadRSSI;
    public int numUserTriggeredWifiDisableLowRSSI;
    public int numUserTriggeredWifiDisableNotHighRSSI;
    public String peerWifiConfiguration;
    public String preSharedKey;
    public int priority;
    public boolean requirePMF;
    public HashMap<String, ScanResult> scanResultCache;
    public boolean selfAdded;
    public int status;
    public String updateIdentifier;
    public Visibility visibility;
    public String wapiAsCert;
    public int wapiCertIndex;
    public int wapiPskType;
    public String wapiUserCert;
    public String[] wepKeys;
    public int wepTxKeyIndex;

    static {
        wepKeyVarNames = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
        INVALID_RSSI = -127;
        UNWANTED_BLACKLIST_SOFT_RSSI_24 = -80;
        UNWANTED_BLACKLIST_SOFT_RSSI_5 = -70;
        GOOD_RSSI_24 = -65;
        LOW_RSSI_24 = -77;
        BAD_RSSI_24 = -87;
        GOOD_RSSI_5 = -60;
        LOW_RSSI_5 = -72;
        BAD_RSSI_5 = -82;
        UNWANTED_BLACKLIST_SOFT_BUMP = 4;
        UNWANTED_BLACKLIST_HARD_BUMP = 8;
        UNBLACKLIST_THRESHOLD_24_SOFT = -77;
        UNBLACKLIST_THRESHOLD_24_HARD = -68;
        UNBLACKLIST_THRESHOLD_5_SOFT = -63;
        UNBLACKLIST_THRESHOLD_5_HARD = -56;
        INITIAL_AUTO_JOIN_ATTEMPT_MIN_24 = -80;
        INITIAL_AUTO_JOIN_ATTEMPT_MIN_5 = -70;
        A_BAND_PREFERENCE_RSSI_THRESHOLD = -65;
        G_BAND_PREFERENCE_RSSI_THRESHOLD = -75;
        HOME_NETWORK_RSSI_BOOST = 5;
        MAX_INITIAL_AUTO_JOIN_RSSI_BOOST = 8;
        CREATOR = new Parcelable.Creator<WifiConfiguration>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public WifiConfiguration createFromParcel(Parcel parcel) {
                boolean bl = true;
                WifiConfiguration wifiConfiguration = new WifiConfiguration();
                wifiConfiguration.networkId = parcel.readInt();
                wifiConfiguration.status = parcel.readInt();
                wifiConfiguration.disableReason = parcel.readInt();
                wifiConfiguration.SSID = parcel.readString();
                wifiConfiguration.BSSID = parcel.readString();
                wifiConfiguration.autoJoinBSSID = parcel.readString();
                wifiConfiguration.FQDN = parcel.readString();
                wifiConfiguration.naiRealm = parcel.readString();
                wifiConfiguration.preSharedKey = parcel.readString();
                for (int i = 0; i < wifiConfiguration.wepKeys.length; ++i) {
                    wifiConfiguration.wepKeys[i] = parcel.readString();
                }
                wifiConfiguration.wepTxKeyIndex = parcel.readInt();
                wifiConfiguration.priority = parcel.readInt();
                boolean bl2 = parcel.readInt() != 0 ? bl : false;
                wifiConfiguration.hiddenSSID = bl2;
                boolean bl3 = parcel.readInt() != 0 ? bl : false;
                wifiConfiguration.requirePMF = bl3;
                wifiConfiguration.updateIdentifier = parcel.readString();
                wifiConfiguration.allowedKeyManagement = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedProtocols = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedAuthAlgorithms = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedPairwiseCiphers = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedGroupCiphers = WifiConfiguration.readBitSet(parcel);
                if (wifiConfiguration.allowedKeyManagement.get(5)) {
                    wifiConfiguration.wapiPskType = parcel.readInt();
                } else if (wifiConfiguration.allowedKeyManagement.get(6)) {
                    wifiConfiguration.wapiAsCert = parcel.readString();
                    wifiConfiguration.wapiUserCert = parcel.readString();
                    wifiConfiguration.wapiCertIndex = parcel.readInt();
                }
                wifiConfiguration.enterpriseConfig = (WifiEnterpriseConfig)parcel.readParcelable(null);
                WifiConfiguration.access$102(wifiConfiguration, (IpConfiguration)parcel.readParcelable(null));
                wifiConfiguration.dhcpServer = parcel.readString();
                wifiConfiguration.defaultGwMacAddress = parcel.readString();
                wifiConfiguration.autoJoinStatus = parcel.readInt();
                boolean bl4 = parcel.readInt() != 0 ? bl : false;
                wifiConfiguration.selfAdded = bl4;
                boolean bl5 = parcel.readInt() != 0 ? bl : false;
                wifiConfiguration.didSelfAdd = bl5;
                boolean bl6 = parcel.readInt() != 0 ? bl : false;
                wifiConfiguration.noInternetAccess = bl6;
                wifiConfiguration.creatorUid = parcel.readInt();
                wifiConfiguration.lastConnectUid = parcel.readInt();
                wifiConfiguration.lastUpdateUid = parcel.readInt();
                wifiConfiguration.blackListTimestamp = parcel.readLong();
                wifiConfiguration.lastConnectionFailure = parcel.readLong();
                wifiConfiguration.numConnectionFailures = parcel.readInt();
                wifiConfiguration.numIpConfigFailures = parcel.readInt();
                wifiConfiguration.numAuthFailures = parcel.readInt();
                wifiConfiguration.numScorerOverride = parcel.readInt();
                wifiConfiguration.numScorerOverrideAndSwitchedNetwork = parcel.readInt();
                wifiConfiguration.numAssociation = parcel.readInt();
                wifiConfiguration.numUserTriggeredWifiDisableLowRSSI = parcel.readInt();
                wifiConfiguration.numUserTriggeredWifiDisableBadRSSI = parcel.readInt();
                wifiConfiguration.numUserTriggeredWifiDisableNotHighRSSI = parcel.readInt();
                wifiConfiguration.numTicksAtLowRSSI = parcel.readInt();
                wifiConfiguration.numTicksAtBadRSSI = parcel.readInt();
                wifiConfiguration.numTicksAtNotHighRSSI = parcel.readInt();
                wifiConfiguration.numUserTriggeredJoinAttempts = parcel.readInt();
                wifiConfiguration.autoJoinUseAggressiveJoinAttemptThreshold = parcel.readInt();
                if (parcel.readInt() == 0) {
                    bl = false;
                }
                wifiConfiguration.autoJoinBailedDueToLowRssi = bl;
                wifiConfiguration.channel = parcel.readInt();
                return wifiConfiguration;
            }

            public WifiConfiguration[] newArray(int n) {
                return new WifiConfiguration[n];
            }
        };
    }

    public WifiConfiguration() {
        this.networkId = -1;
        this.SSID = null;
        this.BSSID = null;
        this.FQDN = null;
        this.naiRealm = null;
        this.priority = 0;
        this.hiddenSSID = false;
        this.disableReason = 0;
        this.allowedKeyManagement = new BitSet();
        this.allowedProtocols = new BitSet();
        this.allowedAuthAlgorithms = new BitSet();
        this.allowedPairwiseCiphers = new BitSet();
        this.allowedGroupCiphers = new BitSet();
        this.wepKeys = new String[4];
        for (int i = 0; i < this.wepKeys.length; ++i) {
            this.wepKeys[i] = null;
            this.wapiAsCert = null;
            this.wapiUserCert = null;
            this.wapiCertIndex = -1;
            this.wapiPskType = -1;
        }
        this.enterpriseConfig = new WifiEnterpriseConfig();
        this.autoJoinStatus = 0;
        this.selfAdded = false;
        this.didSelfAdd = false;
        this.ephemeral = false;
        this.noInternetAccess = false;
        this.mIpConfiguration = new IpConfiguration();
        this.channel = 6;
    }

    public WifiConfiguration(WifiConfiguration wifiConfiguration) {
        if (wifiConfiguration != null) {
            this.networkId = wifiConfiguration.networkId;
            this.status = wifiConfiguration.status;
            this.disableReason = wifiConfiguration.disableReason;
            this.disableReason = wifiConfiguration.disableReason;
            this.SSID = wifiConfiguration.SSID;
            this.BSSID = wifiConfiguration.BSSID;
            this.FQDN = wifiConfiguration.FQDN;
            this.naiRealm = wifiConfiguration.naiRealm;
            this.preSharedKey = wifiConfiguration.preSharedKey;
            this.wapiAsCert = null;
            this.wapiUserCert = null;
            this.wapiCertIndex = -1;
            this.wapiPskType = -1;
            this.wepKeys = new String[4];
            for (int i = 0; i < this.wepKeys.length; ++i) {
                this.wepKeys[i] = wifiConfiguration.wepKeys[i];
            }
            this.wepTxKeyIndex = wifiConfiguration.wepTxKeyIndex;
            this.priority = wifiConfiguration.priority;
            this.hiddenSSID = wifiConfiguration.hiddenSSID;
            this.allowedKeyManagement = (BitSet)wifiConfiguration.allowedKeyManagement.clone();
            this.allowedProtocols = (BitSet)wifiConfiguration.allowedProtocols.clone();
            this.allowedAuthAlgorithms = (BitSet)wifiConfiguration.allowedAuthAlgorithms.clone();
            this.allowedPairwiseCiphers = (BitSet)wifiConfiguration.allowedPairwiseCiphers.clone();
            this.allowedGroupCiphers = (BitSet)wifiConfiguration.allowedGroupCiphers.clone();
            this.enterpriseConfig = new WifiEnterpriseConfig(wifiConfiguration.enterpriseConfig);
            this.defaultGwMacAddress = wifiConfiguration.defaultGwMacAddress;
            this.mIpConfiguration = new IpConfiguration(wifiConfiguration.mIpConfiguration);
            if (wifiConfiguration.scanResultCache != null && wifiConfiguration.scanResultCache.size() > 0) {
                this.scanResultCache = new HashMap();
                this.scanResultCache.putAll(wifiConfiguration.scanResultCache);
            }
            if (wifiConfiguration.connectChoices != null && wifiConfiguration.connectChoices.size() > 0) {
                this.connectChoices = new HashMap();
                this.connectChoices.putAll(wifiConfiguration.connectChoices);
            }
            if (wifiConfiguration.linkedConfigurations != null && wifiConfiguration.linkedConfigurations.size() > 0) {
                this.linkedConfigurations = new HashMap();
                this.linkedConfigurations.putAll(wifiConfiguration.linkedConfigurations);
            }
            this.mCachedConfigKey = null;
            this.autoJoinStatus = wifiConfiguration.autoJoinStatus;
            this.selfAdded = wifiConfiguration.selfAdded;
            this.noInternetAccess = wifiConfiguration.noInternetAccess;
            if (wifiConfiguration.visibility != null) {
                this.visibility = new Visibility(wifiConfiguration.visibility);
            }
            this.lastFailure = wifiConfiguration.lastFailure;
            this.didSelfAdd = wifiConfiguration.didSelfAdd;
            this.lastConnectUid = wifiConfiguration.lastConnectUid;
            this.lastUpdateUid = wifiConfiguration.lastUpdateUid;
            this.creatorUid = wifiConfiguration.creatorUid;
            this.peerWifiConfiguration = wifiConfiguration.peerWifiConfiguration;
            this.blackListTimestamp = wifiConfiguration.blackListTimestamp;
            this.lastConnected = wifiConfiguration.lastConnected;
            this.lastDisconnected = wifiConfiguration.lastDisconnected;
            this.lastConnectionFailure = wifiConfiguration.lastConnectionFailure;
            this.numConnectionFailures = wifiConfiguration.numConnectionFailures;
            this.numIpConfigFailures = wifiConfiguration.numIpConfigFailures;
            this.numAuthFailures = wifiConfiguration.numAuthFailures;
            this.numScorerOverride = wifiConfiguration.numScorerOverride;
            this.numScorerOverrideAndSwitchedNetwork = wifiConfiguration.numScorerOverrideAndSwitchedNetwork;
            this.numAssociation = wifiConfiguration.numAssociation;
            this.numUserTriggeredWifiDisableLowRSSI = wifiConfiguration.numUserTriggeredWifiDisableLowRSSI;
            this.numUserTriggeredWifiDisableBadRSSI = wifiConfiguration.numUserTriggeredWifiDisableBadRSSI;
            this.numUserTriggeredWifiDisableNotHighRSSI = wifiConfiguration.numUserTriggeredWifiDisableNotHighRSSI;
            this.numTicksAtLowRSSI = wifiConfiguration.numTicksAtLowRSSI;
            this.numTicksAtBadRSSI = wifiConfiguration.numTicksAtBadRSSI;
            this.numTicksAtNotHighRSSI = wifiConfiguration.numTicksAtNotHighRSSI;
            this.numUserTriggeredJoinAttempts = wifiConfiguration.numUserTriggeredJoinAttempts;
            this.autoJoinBSSID = wifiConfiguration.autoJoinBSSID;
            this.autoJoinUseAggressiveJoinAttemptThreshold = wifiConfiguration.autoJoinUseAggressiveJoinAttemptThreshold;
            this.autoJoinBailedDueToLowRssi = wifiConfiguration.autoJoinBailedDueToLowRssi;
            this.dirty = wifiConfiguration.dirty;
            this.channel = wifiConfiguration.channel;
        }
    }

    static /* synthetic */ IpConfiguration access$102(WifiConfiguration wifiConfiguration, IpConfiguration ipConfiguration) {
        wifiConfiguration.mIpConfiguration = ipConfiguration;
        return ipConfiguration;
    }

    public static String configKey(ScanResult scanResult) {
        String string2 = "\"" + scanResult.SSID + "\"";
        if (scanResult.capabilities.contains("WEP")) {
            string2 = string2 + "-WEP";
        }
        if (scanResult.capabilities.contains("PSK")) {
            string2 = string2 + "-" + KeyMgmt.strings[1];
        }
        if (scanResult.capabilities.contains("EAP")) {
            string2 = string2 + "-" + KeyMgmt.strings[2];
        }
        return string2;
    }

    private static BitSet readBitSet(Parcel parcel) {
        int n = parcel.readInt();
        BitSet bitSet = new BitSet();
        for (int i = 0; i < n; ++i) {
            bitSet.set(parcel.readInt());
        }
        return bitSet;
    }

    private ArrayList<ScanResult> sortScanResults() {
        ArrayList<ScanResult> arrayList = new ArrayList<ScanResult>(this.scanResultCache.values());
        if (arrayList.size() != 0) {
            Collections.sort(arrayList, new Comparator(){

                /*
                 * Enabled aggressive block sorting
                 */
                public int compare(Object object, Object object2) {
                    ScanResult scanResult;
                    ScanResult scanResult2;
                    block7: {
                        block6: {
                            scanResult2 = (ScanResult)object;
                            scanResult = (ScanResult)object2;
                            if (scanResult2.numIpConfigFailures > scanResult.numIpConfigFailures) break block6;
                            if (scanResult2.numIpConfigFailures < scanResult.numIpConfigFailures) {
                                return -1;
                            }
                            if (scanResult2.seen > scanResult.seen) {
                                return -1;
                            }
                            if (scanResult2.seen < scanResult.seen) break block6;
                            if (scanResult2.level > scanResult.level) {
                                return -1;
                            }
                            if (scanResult2.level >= scanResult.level) break block7;
                        }
                        return 1;
                    }
                    return scanResult2.BSSID.compareTo(scanResult.BSSID);
                }
            });
        }
        return arrayList;
    }

    private String trimStringForKeyId(String string2) {
        return string2.replace("\"", "").replace(" ", "");
    }

    private static void writeBitSet(Parcel parcel, BitSet bitSet) {
        int n = -1;
        parcel.writeInt(bitSet.cardinality());
        while ((n = bitSet.nextSetBit(n + 1)) != -1) {
            parcel.writeInt(n);
        }
    }

    public String configKey() {
        return this.configKey(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String configKey(boolean bl) {
        if (bl && this.mCachedConfigKey != null) {
            return this.mCachedConfigKey;
        }
        String string2 = this.allowedKeyManagement.get(1) ? this.SSID + KeyMgmt.strings[1] : (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3) ? this.SSID + KeyMgmt.strings[2] : (this.wepKeys[0] != null ? this.SSID + "WEP" : this.SSID + KeyMgmt.strings[0]));
        this.mCachedConfigKey = string2;
        return string2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAuthType() {
        if (!this.isValid()) {
            throw new IllegalStateException("Invalid configuration");
        }
        if (this.allowedKeyManagement.get(1)) {
            return 1;
        }
        if (this.allowedKeyManagement.get(4)) {
            return 4;
        }
        if (this.allowedKeyManagement.get(2)) {
            return 2;
        }
        if (this.allowedKeyManagement.get(3)) {
            return 3;
        }
        if (this.allowedKeyManagement.get(5)) {
            return 5;
        }
        if (this.allowedKeyManagement.get(6)) {
            return 6;
        }
        return 0;
    }

    public ProxyInfo getHttpProxy() {
        return this.mIpConfiguration.httpProxy;
    }

    public IpConfiguration.IpAssignment getIpAssignment() {
        return this.mIpConfiguration.ipAssignment;
    }

    public IpConfiguration getIpConfiguration() {
        return this.mIpConfiguration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKeyIdForCredentials(WifiConfiguration wifiConfiguration) {
        String string2;
        try {
            if (TextUtils.isEmpty(this.SSID)) {
                this.SSID = wifiConfiguration.SSID;
            }
            if (this.allowedKeyManagement.cardinality() == 0) {
                this.allowedKeyManagement = wifiConfiguration.allowedKeyManagement;
            }
            boolean bl = this.allowedKeyManagement.get(2);
            string2 = null;
            if (bl) {
                string2 = KeyMgmt.strings[2];
            }
            if (this.allowedKeyManagement.get(3)) {
                string2 = string2 + KeyMgmt.strings[3];
            }
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalStateException("Not an EAP network");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Invalid config details");
        }
        {
            StringBuilder stringBuilder = new StringBuilder().append(this.trimStringForKeyId(this.SSID)).append("_").append(string2).append("_");
            WifiEnterpriseConfig wifiEnterpriseConfig = this.enterpriseConfig;
            WifiEnterpriseConfig wifiEnterpriseConfig2 = wifiConfiguration != null ? wifiConfiguration.enterpriseConfig : null;
            return stringBuilder.append(this.trimStringForKeyId(wifiEnterpriseConfig.getKeyId(wifiEnterpriseConfig2))).toString();
        }
    }

    public String getPrintableSsid() {
        if (this.SSID == null) {
            return "";
        }
        int n = this.SSID.length();
        if (n > 2 && this.SSID.charAt(0) == '\"' && this.SSID.charAt(n - 1) == '\"') {
            return this.SSID.substring(1, n - 1);
        }
        if (n > 3 && this.SSID.charAt(0) == 'P' && this.SSID.charAt(1) == '\"' && this.SSID.charAt(n - 1) == '\"') {
            return WifiSsid.createFromAsciiEncoded(this.SSID.substring(2, n - 1)).toString();
        }
        return this.SSID;
    }

    public IpConfiguration.ProxySettings getProxySettings() {
        return this.mIpConfiguration.proxySettings;
    }

    public StaticIpConfiguration getStaticIpConfiguration() {
        return this.mIpConfiguration.getStaticIpConfiguration();
    }

    public boolean isLinked(WifiConfiguration wifiConfiguration) {
        return wifiConfiguration.linkedConfigurations != null && this.linkedConfigurations != null && wifiConfiguration.linkedConfigurations.get(this.configKey()) != null && this.linkedConfigurations.get(wifiConfiguration.configKey()) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isValid() {
        return this.allowedKeyManagement != null && (this.allowedKeyManagement.cardinality() <= 1 || this.allowedKeyManagement.cardinality() == 2 && this.allowedKeyManagement.get(2) && (this.allowedKeyManagement.get(3) || this.allowedKeyManagement.get(1)));
    }

    public ScanResult lastSeen() {
        ScanResult scanResult = null;
        if (this.scanResultCache == null) {
            return null;
        }
        for (ScanResult scanResult2 : this.scanResultCache.values()) {
            if (scanResult == null) {
                if (scanResult2.seen == 0L) continue;
                scanResult = scanResult2;
                continue;
            }
            if (scanResult2.seen <= scanResult.seen) continue;
            scanResult = scanResult2;
        }
        return scanResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAutoJoinStatus(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n == 0) {
            this.blackListTimestamp = 0L;
        } else if (n > this.autoJoinStatus) {
            this.blackListTimestamp = System.currentTimeMillis();
        }
        if (n != this.autoJoinStatus) {
            this.autoJoinStatus = n;
            this.dirty = true;
        }
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        this.mIpConfiguration.httpProxy = proxyInfo;
    }

    public void setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        this.mIpConfiguration.ipAssignment = ipAssignment;
    }

    public void setIpConfiguration(IpConfiguration ipConfiguration) {
        this.mIpConfiguration = ipConfiguration;
    }

    public void setProxy(IpConfiguration.ProxySettings proxySettings, ProxyInfo proxyInfo) {
        this.mIpConfiguration.proxySettings = proxySettings;
        this.mIpConfiguration.httpProxy = proxyInfo;
    }

    public void setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        this.mIpConfiguration.proxySettings = proxySettings;
    }

    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.mIpConfiguration.setStaticIpConfiguration(staticIpConfiguration);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Visibility setVisibility(long l) {
        if (this.scanResultCache == null) {
            this.visibility = null;
            return null;
        }
        Visibility visibility = new Visibility();
        long l2 = System.currentTimeMillis();
        Iterator<ScanResult> iterator = this.scanResultCache.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.visibility = visibility;
                return visibility;
            }
            ScanResult scanResult = iterator.next();
            if (scanResult.seen == 0L) continue;
            if (scanResult.is5GHz()) {
                visibility.num5 = 1 + visibility.num5;
            } else if (scanResult.is24GHz()) {
                visibility.num24 = 1 + visibility.num24;
            }
            if (l2 - scanResult.seen > l) continue;
            if (scanResult.is5GHz()) {
                if (scanResult.level <= visibility.rssi5) continue;
                visibility.rssi5 = scanResult.level;
                visibility.age5 = scanResult.seen;
                visibility.BSSID5 = scanResult.BSSID;
                continue;
            }
            if (!scanResult.is24GHz() || scanResult.level <= visibility.rssi24) continue;
            visibility.rssi24 = scanResult.level;
            visibility.age24 = scanResult.seen;
            visibility.BSSID24 = scanResult.BSSID;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        int n;
        int n2;
        int n3;
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.status == 0) {
            stringBuilder.append("* ");
        } else if (this.status == 1) {
            stringBuilder.append("- DSBLE ");
        }
        stringBuilder.append("ID: ").append(this.networkId).append(" SSID: ").append(this.SSID).append(" BSSID: ").append(this.BSSID).append(" FQDN: ").append(this.FQDN).append(" REALM: ").append(this.naiRealm).append(" PRIO: ").append(this.priority).append('\n');
        if (this.numConnectionFailures > 0) {
            stringBuilder.append(" numConnectFailures ").append(this.numConnectionFailures).append("\n");
        }
        if (this.numIpConfigFailures > 0) {
            stringBuilder.append(" numIpConfigFailures ").append(this.numIpConfigFailures).append("\n");
        }
        if (this.numAuthFailures > 0) {
            stringBuilder.append(" numAuthFailures ").append(this.numAuthFailures).append("\n");
        }
        if (this.autoJoinStatus > 0) {
            stringBuilder.append(" autoJoinStatus ").append(this.autoJoinStatus).append("\n");
        }
        if (this.disableReason > 0) {
            stringBuilder.append(" disableReason ").append(this.disableReason).append("\n");
        }
        if (this.numAssociation > 0) {
            stringBuilder.append(" numAssociation ").append(this.numAssociation).append("\n");
        }
        if (this.didSelfAdd) {
            stringBuilder.append(" didSelfAdd");
        }
        if (this.selfAdded) {
            stringBuilder.append(" selfAdded");
        }
        if (this.noInternetAccess) {
            stringBuilder.append(" noInternetAccess");
        }
        if (this.didSelfAdd || this.selfAdded || this.noInternetAccess) {
            stringBuilder.append("\n");
        }
        stringBuilder.append(" KeyMgmt:");
        for (int i = 0; i < (n4 = this.allowedKeyManagement.size()); ++i) {
            if (!this.allowedKeyManagement.get(i)) continue;
            stringBuilder.append(" ");
            int n5 = KeyMgmt.strings.length;
            if (i < n5) {
                stringBuilder.append(KeyMgmt.strings[i]);
                continue;
            }
            stringBuilder.append("??");
        }
        stringBuilder.append(" Protocols:");
        for (int i = 0; i < (n3 = this.allowedProtocols.size()); ++i) {
            if (!this.allowedProtocols.get(i)) continue;
            stringBuilder.append(" ");
            int n6 = Protocol.strings.length;
            if (i < n6) {
                stringBuilder.append(Protocol.strings[i]);
                continue;
            }
            stringBuilder.append("??");
        }
        stringBuilder.append('\n');
        stringBuilder.append(" AuthAlgorithms:");
        for (int i = 0; i < this.allowedAuthAlgorithms.size(); ++i) {
            if (!this.allowedAuthAlgorithms.get(i)) continue;
            stringBuilder.append(" ");
            if (i < AuthAlgorithm.strings.length) {
                stringBuilder.append(AuthAlgorithm.strings[i]);
                continue;
            }
            stringBuilder.append("??");
        }
        stringBuilder.append('\n');
        stringBuilder.append(" PairwiseCiphers:");
        for (int i = 0; i < (n2 = this.allowedPairwiseCiphers.size()); ++i) {
            if (!this.allowedPairwiseCiphers.get(i)) continue;
            stringBuilder.append(" ");
            int n7 = PairwiseCipher.strings.length;
            if (i < n7) {
                stringBuilder.append(PairwiseCipher.strings[i]);
                continue;
            }
            stringBuilder.append("??");
        }
        stringBuilder.append('\n');
        stringBuilder.append(" GroupCiphers:");
        for (int i = 0; i < (n = this.allowedGroupCiphers.size()); ++i) {
            if (!this.allowedGroupCiphers.get(i)) continue;
            stringBuilder.append(" ");
            int n8 = GroupCipher.strings.length;
            if (i < n8) {
                stringBuilder.append(GroupCipher.strings[i]);
                continue;
            }
            stringBuilder.append("??");
        }
        stringBuilder.append('\n').append(" PSK: ");
        if (this.preSharedKey != null) {
            stringBuilder.append('*');
        }
        stringBuilder.append('\n');
        if (this.wapiAsCert != null) {
            stringBuilder.append(" WapiAsCert: ").append(this.wapiAsCert);
        }
        stringBuilder.append('\n');
        if (this.wapiUserCert != null) {
            stringBuilder.append(" WapiUserCert: ").append(this.wapiUserCert);
        }
        stringBuilder.append('\n');
        if (this.wapiCertIndex != -1) {
            stringBuilder.append(" WapiCertIndex: ").append(this.wapiCertIndex);
        }
        stringBuilder.append('\n');
        if (this.wapiPskType != -1) {
            stringBuilder.append(" WapiPskType: ").append(this.wapiPskType);
        }
        stringBuilder.append("\nEnterprise config:\n");
        stringBuilder.append(this.enterpriseConfig);
        stringBuilder.append("IP config:\n");
        stringBuilder.append(this.mIpConfiguration.toString());
        if (this.creatorUid != 0) {
            stringBuilder.append(" uid=" + Integer.toString(this.creatorUid));
        }
        if (this.autoJoinBSSID != null) {
            stringBuilder.append(" autoJoinBSSID=" + this.autoJoinBSSID);
        }
        long l = System.currentTimeMillis();
        if (this.blackListTimestamp != 0L) {
            stringBuilder.append('\n');
            long l2 = l - this.blackListTimestamp;
            if (l2 <= 0L) {
                stringBuilder.append(" blackListed since <incorrect>");
            } else {
                stringBuilder.append(" blackListed: ").append(Long.toString(l2 / 1000L)).append("sec");
            }
        }
        if (this.lastConnected != 0L) {
            stringBuilder.append('\n');
            long l3 = l - this.lastConnected;
            if (l3 <= 0L) {
                stringBuilder.append("lastConnected since <incorrect>");
            } else {
                stringBuilder.append("lastConnected: ").append(Long.toString(l3 / 1000L)).append("sec");
            }
        }
        if (this.lastConnectionFailure != 0L) {
            stringBuilder.append('\n');
            long l4 = l - this.lastConnectionFailure;
            if (l4 <= 0L) {
                stringBuilder.append("lastConnectionFailure since <incorrect>");
            } else {
                stringBuilder.append("lastConnectionFailure: ").append(Long.toString(l4 / 1000L));
                stringBuilder.append("sec");
            }
        }
        stringBuilder.append('\n');
        if (this.linkedConfigurations != null) {
            for (String string2 : this.linkedConfigurations.keySet()) {
                stringBuilder.append(" linked: ").append(string2);
                stringBuilder.append('\n');
            }
        }
        if (this.connectChoices != null) {
            for (String string3 : this.connectChoices.keySet()) {
                Integer n9 = this.connectChoices.get(string3);
                if (n9 == null) continue;
                stringBuilder.append(" choice: ").append(string3);
                stringBuilder.append(" = ").append(n9);
                stringBuilder.append('\n');
            }
        }
        if (this.scanResultCache != null) {
            stringBuilder.append("Scan Cache:  ").append('\n');
            ArrayList<ScanResult> arrayList = this.sortScanResults();
            if (arrayList.size() > 0) {
                for (ScanResult scanResult : arrayList) {
                    long l5 = l - scanResult.seen;
                    long l6 = 0L;
                    long l7 = 0L;
                    long l8 = 0L;
                    long l9 = 0L;
                    long l10 = 0L;
                    if (l > scanResult.seen && scanResult.seen > 0L) {
                        l9 = l5 % 1000L;
                        l6 = l5 / 1000L % 60L;
                        l7 = l5 / 60000L % 60L;
                        l8 = l5 / 3600000L % 24L;
                        l10 = l5 / 86400000L;
                    }
                    stringBuilder.append("{").append(scanResult.BSSID).append(",").append(scanResult.frequency);
                    StringBuilder stringBuilder2 = stringBuilder.append(",");
                    Object[] objectArray = new Object[]{scanResult.level};
                    stringBuilder2.append(String.format("%3d", objectArray));
                    if (scanResult.autoJoinStatus > 0) {
                        stringBuilder.append(",st=").append(scanResult.autoJoinStatus);
                    }
                    if (l6 > 0L || l9 > 0L) {
                        Object[] objectArray2 = new Object[]{l10, l8, l7, l6, l9};
                        stringBuilder.append(String.format(",%4d.%02d.%02d.%02d.%03dms", objectArray2));
                    }
                    if (scanResult.numIpConfigFailures > 0) {
                        stringBuilder.append(",ipfail=");
                        stringBuilder.append(scanResult.numIpConfigFailures);
                    }
                    stringBuilder.append("} ");
                }
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("triggeredLow: ").append(this.numUserTriggeredWifiDisableLowRSSI);
        stringBuilder.append(" triggeredBad: ").append(this.numUserTriggeredWifiDisableBadRSSI);
        stringBuilder.append(" triggeredNotHigh: ").append(this.numUserTriggeredWifiDisableNotHighRSSI);
        stringBuilder.append('\n');
        stringBuilder.append("ticksLow: ").append(this.numTicksAtLowRSSI);
        stringBuilder.append(" ticksBad: ").append(this.numTicksAtBadRSSI);
        stringBuilder.append(" ticksNotHigh: ").append(this.numTicksAtNotHighRSSI);
        stringBuilder.append('\n');
        stringBuilder.append("triggeredJoin: ").append(this.numUserTriggeredJoinAttempts);
        stringBuilder.append('\n');
        stringBuilder.append("autoJoinBailedDueToLowRssi: ").append(this.autoJoinBailedDueToLowRssi);
        stringBuilder.append('\n');
        stringBuilder.append("autoJoinUseAggressiveJoinAttemptThreshold: ");
        stringBuilder.append(this.autoJoinUseAggressiveJoinAttemptThreshold);
        stringBuilder.append('\n');
        stringBuilder.append("channel: ").append(this.channel);
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.networkId);
        parcel.writeInt(this.status);
        parcel.writeInt(this.disableReason);
        parcel.writeString(this.SSID);
        parcel.writeString(this.BSSID);
        parcel.writeString(this.autoJoinBSSID);
        parcel.writeString(this.FQDN);
        parcel.writeString(this.naiRealm);
        parcel.writeString(this.preSharedKey);
        String[] stringArray = this.wepKeys;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            parcel.writeString(stringArray[i]);
        }
        parcel.writeInt(this.wepTxKeyIndex);
        parcel.writeInt(this.priority);
        int n4 = this.hiddenSSID ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.requirePMF ? n2 : 0;
        parcel.writeInt(n5);
        parcel.writeString(this.updateIdentifier);
        WifiConfiguration.writeBitSet(parcel, this.allowedKeyManagement);
        WifiConfiguration.writeBitSet(parcel, this.allowedProtocols);
        WifiConfiguration.writeBitSet(parcel, this.allowedAuthAlgorithms);
        WifiConfiguration.writeBitSet(parcel, this.allowedPairwiseCiphers);
        WifiConfiguration.writeBitSet(parcel, this.allowedGroupCiphers);
        if (this.allowedKeyManagement.get(5)) {
            parcel.writeInt(this.wapiPskType);
        } else if (this.allowedKeyManagement.get(6)) {
            parcel.writeString(this.wapiAsCert);
            parcel.writeString(this.wapiUserCert);
            parcel.writeInt(this.wapiCertIndex);
        }
        parcel.writeParcelable(this.enterpriseConfig, n);
        parcel.writeParcelable(this.mIpConfiguration, n);
        parcel.writeString(this.dhcpServer);
        parcel.writeString(this.defaultGwMacAddress);
        parcel.writeInt(this.autoJoinStatus);
        int n6 = this.selfAdded ? n2 : 0;
        parcel.writeInt(n6);
        int n7 = this.didSelfAdd ? n2 : 0;
        parcel.writeInt(n7);
        int n8 = this.noInternetAccess ? n2 : 0;
        parcel.writeInt(n8);
        parcel.writeInt(this.creatorUid);
        parcel.writeInt(this.lastConnectUid);
        parcel.writeInt(this.lastUpdateUid);
        parcel.writeLong(this.blackListTimestamp);
        parcel.writeLong(this.lastConnectionFailure);
        parcel.writeInt(this.numConnectionFailures);
        parcel.writeInt(this.numIpConfigFailures);
        parcel.writeInt(this.numAuthFailures);
        parcel.writeInt(this.numScorerOverride);
        parcel.writeInt(this.numScorerOverrideAndSwitchedNetwork);
        parcel.writeInt(this.numAssociation);
        parcel.writeInt(this.numUserTriggeredWifiDisableLowRSSI);
        parcel.writeInt(this.numUserTriggeredWifiDisableBadRSSI);
        parcel.writeInt(this.numUserTriggeredWifiDisableNotHighRSSI);
        parcel.writeInt(this.numTicksAtLowRSSI);
        parcel.writeInt(this.numTicksAtBadRSSI);
        parcel.writeInt(this.numTicksAtNotHighRSSI);
        parcel.writeInt(this.numUserTriggeredJoinAttempts);
        parcel.writeInt(this.autoJoinUseAggressiveJoinAttemptThreshold);
        if (!this.autoJoinBailedDueToLowRssi) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeInt(this.channel);
    }

    public static class AuthAlgorithm {
        public static final int LEAP = 2;
        public static final int OPEN = 0;
        public static final int SHARED = 1;
        public static final String[] strings = new String[]{"OPEN", "SHARED", "LEAP"};
        public static final String varName = "auth_alg";

        private AuthAlgorithm() {
        }
    }

    public static class GroupCipher {
        public static final int CCMP = 3;
        public static final int TKIP = 2;
        public static final int WEP104 = 1;
        public static final int WEP40 = 0;
        public static final String[] strings = new String[]{"WEP40", "WEP104", "TKIP", "CCMP"};
        public static final String varName = "group";

        private GroupCipher() {
        }
    }

    public static class KeyMgmt {
        public static final int IEEE8021X = 3;
        public static final int NONE = 0;
        public static final int WAPI_CERT = 6;
        public static final int WAPI_PSK = 5;
        public static final int WPA2_PSK = 4;
        public static final int WPA_EAP = 2;
        public static final int WPA_PSK = 1;
        public static final String[] strings = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X", "WPA2_PSK", "WAPI_PSK", "WAPI_CERT"};
        public static final String varName = "key_mgmt";

        private KeyMgmt() {
        }
    }

    public static class PairwiseCipher {
        public static final int CCMP = 2;
        public static final int NONE = 0;
        public static final int TKIP = 1;
        public static final String[] strings = new String[]{"NONE", "TKIP", "CCMP"};
        public static final String varName = "pairwise";

        private PairwiseCipher() {
        }
    }

    public static class Protocol {
        public static final int RSN = 1;
        public static final int WAPI = 2;
        public static final int WPA = 0;
        public static final String[] strings = new String[]{"WPA", "RSN", "WAPI"};
        public static final String varName = "proto";

        private Protocol() {
        }
    }

    public static class Status {
        public static final int CURRENT = 0;
        public static final int DISABLED = 1;
        public static final int ENABLED = 2;
        public static final String[] strings = new String[]{"current", "disabled", "enabled"};

        private Status() {
        }
    }

    public final class Visibility {
        public String BSSID24;
        public String BSSID5;
        public long age24;
        public long age5;
        public int num24;
        public int num5;
        public int rssi24;
        public int rssi5;

        public Visibility() {
            this.rssi5 = INVALID_RSSI;
            this.rssi24 = INVALID_RSSI;
        }

        public Visibility(Visibility visibility) {
            this.rssi5 = visibility.rssi5;
            this.rssi24 = visibility.rssi24;
            this.age24 = visibility.age24;
            this.age5 = visibility.age5;
            this.num24 = visibility.num24;
            this.num5 = visibility.num5;
            this.BSSID5 = visibility.BSSID5;
            this.BSSID24 = visibility.BSSID24;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            if (this.rssi24 > INVALID_RSSI) {
                stringBuilder.append(Integer.toString(this.rssi24));
                stringBuilder.append(",");
                stringBuilder.append(Integer.toString(this.num24));
                if (this.BSSID24 != null) {
                    stringBuilder.append(",").append(this.BSSID24);
                }
            } else {
                stringBuilder.append("*");
            }
            stringBuilder.append(" - ");
            if (this.rssi5 > INVALID_RSSI) {
                stringBuilder.append(Integer.toString(this.rssi5));
                stringBuilder.append(",");
                stringBuilder.append(Integer.toString(this.num5));
                if (this.BSSID5 != null) {
                    stringBuilder.append(",").append(this.BSSID5);
                }
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

