/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;

public final class WifiActivityEnergyInfo
implements Parcelable {
    public static final Parcelable.Creator<WifiActivityEnergyInfo> CREATOR = new Parcelable.Creator<WifiActivityEnergyInfo>(){

        @Override
        public WifiActivityEnergyInfo createFromParcel(Parcel parcel) {
            return new WifiActivityEnergyInfo(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        public WifiActivityEnergyInfo[] newArray(int n) {
            return new WifiActivityEnergyInfo[n];
        }
    };
    public static final int STACK_STATE_INVALID = 0;
    public static final int STACK_STATE_STATE_ACTIVE = 1;
    public static final int STACK_STATE_STATE_IDLE = 3;
    public static final int STACK_STATE_STATE_SCANNING = 2;
    private final int mControllerEnergyUsed;
    private final int mControllerIdleTimeMs;
    private final int mControllerRxTimeMs;
    private final int mControllerTxTimeMs;
    private final int mStackState;
    private final long timestamp;

    public WifiActivityEnergyInfo(int n, int n2, int n3, int n4, int n5) {
        this.mStackState = n;
        this.mControllerTxTimeMs = n2;
        this.mControllerRxTimeMs = n3;
        this.mControllerIdleTimeMs = n4;
        this.mControllerEnergyUsed = n5;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getControllerEnergyUsed() {
        return this.mControllerEnergyUsed;
    }

    public int getControllerIdleTimeMillis() {
        return this.mControllerIdleTimeMs;
    }

    public int getControllerRxTimeMillis() {
        return this.mControllerRxTimeMs;
    }

    public int getControllerTxTimeMillis() {
        return this.mControllerTxTimeMs;
    }

    public int getStackState() {
        return this.mStackState;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean isValid() {
        return this.getControllerTxTimeMillis() != 0 || this.getControllerRxTimeMillis() != 0 || this.getControllerIdleTimeMillis() != 0;
    }

    public String toString() {
        return "WifiActivityEnergyInfo{ timestamp=" + this.timestamp + " mStackState=" + this.mStackState + " mControllerTxTimeMs=" + this.mControllerTxTimeMs + " mControllerRxTimeMs=" + this.mControllerRxTimeMs + " mControllerIdleTimeMs=" + this.mControllerIdleTimeMs + " mControllerEnergyUsed=" + this.mControllerEnergyUsed + " }";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mStackState);
        parcel.writeInt(this.mControllerTxTimeMs);
        parcel.writeInt(this.mControllerRxTimeMs);
        parcel.writeInt(this.mControllerIdleTimeMs);
        parcel.writeInt(this.mControllerEnergyUsed);
    }
}

