/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.CertificateChainValidator;
import android.net.http.Connection;
import android.net.http.Headers;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import com.android.org.conscrypt.FileClientSessionCache;
import com.android.org.conscrypt.OpenSSLContextImpl;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;

public class HttpsConnection
extends Connection {
    private static SSLSocketFactory mSslSocketFactory = null;
    private boolean mAborted = false;
    private HttpHost mProxyHost;
    private Object mSuspendLock = new Object();
    private boolean mSuspended = false;

    static {
        HttpsConnection.initializeEngine(null);
    }

    HttpsConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        super(context, httpHost, requestFeeder);
        this.mProxyHost = httpHost2;
    }

    private static SSLSocketFactory getSocketFactory() {
        synchronized (HttpsConnection.class) {
            SSLSocketFactory sSLSocketFactory = mSslSocketFactory;
            return sSLSocketFactory;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initializeEngine(File var0) {
        var1_1 = null;
        if (var0 == null) ** GOTO lbl7
        try {
            Log.d("HttpsConnection", "Caching SSL sessions in " + var0 + ".");
            var1_1 = FileClientSessionCache.usingDirectory((File)var0);
lbl7:
            // 2 sources

            var2_2 = new OpenSSLContextImpl();
            var5_3 = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            var2_2.engineInit(null, var5_3, null);
            var2_2.engineGetClientSessionContext().setPersistentCache(var1_1);
            synchronized (HttpsConnection.class) {
            }
        }
        catch (KeyManagementException var4_4) {
            throw new RuntimeException(var4_4);
        }
        catch (IOException var3_5) {
            throw new RuntimeException(var3_5);
        }
        {
            HttpsConnection.mSslSocketFactory = var2_2.engineGetSocketFactory();
            return;
        }
    }

    @Override
    void closeConnection() {
        if (this.mSuspended) {
            this.restartConnection(false);
        }
        try {
            if (this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen()) {
                this.mHttpClientConnection.close();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    String getScheme() {
        return "https";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    AndroidHttpClientConnection openConnection(Request var1_1) throws IOException {
        block38: {
            block40: {
                block37: {
                    var2_2 = null;
                    if (this.mProxyHost == null) break block40;
                    var19_3 = null;
                    var20_4 = new Socket(this.mProxyHost.getHostName(), this.mProxyHost.getPort());
                    var20_4.setSoTimeout(60000);
                    var24_5 = new AndroidHttpClientConnection();
                    var25_6 = new BasicHttpParams();
                    HttpConnectionParams.setSocketBufferSize(var25_6, 8192);
                    var24_5.bind(var20_4, var25_6);
                    var26_7 = new Headers();
                    var27_8 = new BasicHttpRequest("CONNECT", this.mHost.toHostString());
                    for (Header var40_12 : var1_1.mHttpRequest.getAllHeaders()) {
                        var41_13 = var40_12.getName().toLowerCase(Locale.ROOT);
                        if (!var41_13.startsWith("proxy") && !var41_13.equals("keep-alive") && !var41_13.equals("host")) continue;
                        var27_8.addHeader(var40_12);
                    }
                    catch (IOException var21_14) lbl-1000:
                    // 3 sources

                    {
                        while (true) {
                            if (var19_3 != null) {
                                var19_3.close();
                            }
                            if ((var22_18 = var21_15.getMessage()) == null) {
                                var22_18 = "failed to establish a connection to the proxy";
                            }
                            var23_19 = new IOException(var22_18);
                            throw var23_19;
                        }
                    }
                    catch (IOException var21_17) {
                        var19_3 = var24_5;
                        ** GOTO lbl-1000
                    }
                    catch (IOException var21_16) {
                        var19_3 = null;
                        ** continue;
                    }
                    catch (ParseException var34_26) {
                        var35_27 = var34_26.getMessage();
                        if (var35_27 == null) {
                            var35_27 = "failed to send a CONNECT request";
                        }
                        var36_28 = new IOException(var35_27);
                        throw var36_28;
                    }
                    catch (HttpException var31_29) {
                        var32_30 = var31_29.getMessage();
                        if (var32_30 == null) {
                            var32_30 = "failed to send a CONNECT request";
                        }
                        var33_31 = new IOException(var32_30);
                        throw var33_31;
                    }
                    catch (IOException var28_32) {
                        var29_33 = var28_32.getMessage();
                        if (var29_33 == null) {
                            var29_33 = "failed to send a CONNECT request";
                        }
                        var30_34 = new IOException(var29_33);
                        throw var30_34;
                    }
                    {
                        var24_5.sendRequestHeader(var27_8);
                        var24_5.flush();
                        while ((var43_21 = (var42_20 = var24_5.parseResponseHeader(var26_7)).getStatusCode()) < 200) {
                        }
                        if (var43_21 != 200) break block37;
                    }
                    {
                        var2_2 = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(var20_4, this.mHost.getHostName(), this.mHost.getPort(), true);
                        break block38;
                    }
                }
                var44_38 = var42_20.getProtocolVersion();
                var1_1.mEventHandler.status(var44_38.getMajor(), var44_38.getMinor(), var43_21, var42_20.getReasonPhrase());
                var1_1.mEventHandler.headers(var26_7);
                var1_1.mEventHandler.endData();
                var24_5.close();
                return null;
            }
            try {
                var2_2 = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(this.mHost.getHostName(), this.mHost.getPort());
                var2_2.setSoTimeout(60000);
            }
            catch (IOException var3_39) {
                if (var2_2 != null) {
                    var2_2.close();
                }
                if ((var4_40 = var3_39.getMessage()) == null) {
                    var4_40 = "failed to create an SSL socket";
                }
                var5_41 = new IOException(var4_40);
                throw var5_41;
            }
        }
        if ((var8_24 = (var6_22 = CertificateChainValidator.getInstance()).doHandshakeAndValidateServerCertificates(this, (SSLSocket)var2_2, var7_23 = this.mHost.getHostName())) == null) ** GOTO lbl103
        var12_25 = this.mSuspendLock;
        synchronized (var12_25) {
            this.mSuspended = true;
            ** if (var1_1.getEventHandler().handleSslErrorRequest((SslError)var8_24)) goto lbl87
        }
lbl-1000:
        // 1 sources

        {
            throw new IOException("failed to handle " + var8_24);
        }
lbl87:
        // 1 sources

        var14_42 = this.mSuspendLock;
        synchronized (var14_42) {
            block39: {
                var16_43 = this.mSuspended;
                if (var16_43) {
                    this.mSuspendLock.wait(600000L);
                    if (!this.mSuspended) break block39;
                    this.mSuspended = false;
                    this.mAborted = true;
                }
            }
lbl97:
            // 2 sources

            while (true) {
                if (this.mAborted) {
                    var2_2.close();
                    var17_44 = new SSLConnectionClosedByUserException("connection closed by the user");
                    throw var17_44;
                }
                // MONITOREXIT @DISABLED, blocks:[26, 13] lbl102 : MonitorExitStatement: MONITOREXIT : var14_42
lbl103:
                // 2 sources

                var9_45 = new AndroidHttpClientConnection();
                var10_46 = new BasicHttpParams();
                var10_46.setIntParameter("http.socket.buffer-size", 8192);
                var9_45.bind(var2_2, var10_46);
                return var9_45;
            }
            catch (InterruptedException var18_47) {
                ** continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restartConnection(boolean bl) {
        Object object = this.mSuspendLock;
        synchronized (object) {
            if (this.mSuspended) {
                this.mSuspended = false;
                boolean bl2 = false;
                if (!bl) {
                    bl2 = true;
                }
                this.mAborted = bl2;
                this.mSuspendLock.notify();
            }
            return;
        }
    }

    void setCertificate(SslCertificate sslCertificate) {
        this.mCertificate = sslCertificate;
    }
}

