/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public class UrlQuerySanitizer {
    private static final ValueSanitizer sAllButNulAndAngleBracketsLegal;
    private static final ValueSanitizer sAllButNulLegal;
    private static final ValueSanitizer sAllButWhitespaceLegal;
    private static final ValueSanitizer sAllIllegal;
    private static final ValueSanitizer sAmpAndSpaceLegal;
    private static final ValueSanitizer sAmpLegal;
    private static final ValueSanitizer sSpaceLegal;
    private static final ValueSanitizer sURLLegal;
    private static final ValueSanitizer sUrlAndSpaceLegal;
    private boolean mAllowUnregisteredParamaters;
    private final HashMap<String, String> mEntries;
    private final ArrayList<ParameterValuePair> mEntriesList;
    private boolean mPreferFirstRepeatedParameter;
    private final HashMap<String, ValueSanitizer> mSanitizers = new HashMap();
    private ValueSanitizer mUnregisteredParameterValueSanitizer;

    static {
        sAllIllegal = new IllegalCharacterValueSanitizer(0);
        sAllButNulLegal = new IllegalCharacterValueSanitizer(1535);
        sAllButWhitespaceLegal = new IllegalCharacterValueSanitizer(1532);
        sURLLegal = new IllegalCharacterValueSanitizer(404);
        sUrlAndSpaceLegal = new IllegalCharacterValueSanitizer(405);
        sAmpLegal = new IllegalCharacterValueSanitizer(128);
        sAmpAndSpaceLegal = new IllegalCharacterValueSanitizer(129);
        sSpaceLegal = new IllegalCharacterValueSanitizer(1);
        sAllButNulAndAngleBracketsLegal = new IllegalCharacterValueSanitizer(1439);
    }

    public UrlQuerySanitizer() {
        this.mEntries = new HashMap();
        this.mEntriesList = new ArrayList();
        this.mUnregisteredParameterValueSanitizer = UrlQuerySanitizer.getAllIllegal();
    }

    public UrlQuerySanitizer(String string2) {
        this.mEntries = new HashMap();
        this.mEntriesList = new ArrayList();
        this.mUnregisteredParameterValueSanitizer = UrlQuerySanitizer.getAllIllegal();
        this.setAllowUnregisteredParamaters(true);
        this.parseUrl(string2);
    }

    public static final ValueSanitizer getAllButNulAndAngleBracketsLegal() {
        return sAllButNulAndAngleBracketsLegal;
    }

    public static final ValueSanitizer getAllButNulLegal() {
        return sAllButNulLegal;
    }

    public static final ValueSanitizer getAllButWhitespaceLegal() {
        return sAllButWhitespaceLegal;
    }

    public static final ValueSanitizer getAllIllegal() {
        return sAllIllegal;
    }

    public static final ValueSanitizer getAmpAndSpaceLegal() {
        return sAmpAndSpaceLegal;
    }

    public static final ValueSanitizer getAmpLegal() {
        return sAmpLegal;
    }

    public static final ValueSanitizer getSpaceLegal() {
        return sSpaceLegal;
    }

    public static final ValueSanitizer getUrlAndSpaceLegal() {
        return sUrlAndSpaceLegal;
    }

    public static final ValueSanitizer getUrlLegal() {
        return sURLLegal;
    }

    protected void addSanitizedEntry(String string2, String string3) {
        this.mEntriesList.add(new ParameterValuePair(string2, string3));
        if (this.mPreferFirstRepeatedParameter && this.mEntries.containsKey(string2)) {
            return;
        }
        this.mEntries.put(string2, string3);
    }

    protected void clear() {
        this.mEntries.clear();
        this.mEntriesList.clear();
    }

    protected int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        return -1;
    }

    public boolean getAllowUnregisteredParamaters() {
        return this.mAllowUnregisteredParamaters;
    }

    public ValueSanitizer getEffectiveValueSanitizer(String string2) {
        ValueSanitizer valueSanitizer = this.getValueSanitizer(string2);
        if (valueSanitizer == null && this.mAllowUnregisteredParamaters) {
            valueSanitizer = this.getUnregisteredParameterValueSanitizer();
        }
        return valueSanitizer;
    }

    public List<ParameterValuePair> getParameterList() {
        return this.mEntriesList;
    }

    public Set<String> getParameterSet() {
        return this.mEntries.keySet();
    }

    public boolean getPreferFirstRepeatedParameter() {
        return this.mPreferFirstRepeatedParameter;
    }

    public ValueSanitizer getUnregisteredParameterValueSanitizer() {
        return this.mUnregisteredParameterValueSanitizer;
    }

    public String getValue(String string2) {
        return this.mEntries.get(string2);
    }

    public ValueSanitizer getValueSanitizer(String string2) {
        return this.mSanitizers.get(string2);
    }

    public boolean hasParameter(String string2) {
        return this.mEntries.containsKey(string2);
    }

    protected boolean isHexDigit(char c) {
        return this.decodeHexDigit(c) >= 0;
    }

    protected void parseEntry(String string2, String string3) {
        String string4 = this.unescape(string2);
        ValueSanitizer valueSanitizer = this.getEffectiveValueSanitizer(string4);
        if (valueSanitizer == null) {
            return;
        }
        this.addSanitizedEntry(string4, valueSanitizer.sanitize(this.unescape(string3)));
    }

    public void parseQuery(String string2) {
        this.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() <= 0) continue;
            int n = string3.indexOf(61);
            if (n < 0) {
                this.parseEntry(string3, "");
                continue;
            }
            this.parseEntry(string3.substring(0, n), string3.substring(n + 1));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseUrl(String string2) {
        int n = string2.indexOf(63);
        String string3 = n >= 0 ? string2.substring(n + 1) : "";
        this.parseQuery(string3);
    }

    public void registerParameter(String string2, ValueSanitizer valueSanitizer) {
        if (valueSanitizer == null) {
            this.mSanitizers.remove(string2);
        }
        this.mSanitizers.put(string2, valueSanitizer);
    }

    public void registerParameters(String[] stringArray, ValueSanitizer valueSanitizer) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.mSanitizers.put(stringArray[i], valueSanitizer);
        }
    }

    public void setAllowUnregisteredParamaters(boolean bl) {
        this.mAllowUnregisteredParamaters = bl;
    }

    public void setPreferFirstRepeatedParameter(boolean bl) {
        this.mPreferFirstRepeatedParameter = bl;
    }

    public void setUnregisteredParameterValueSanitizer(ValueSanitizer valueSanitizer) {
        this.mUnregisteredParameterValueSanitizer = valueSanitizer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unescape(String string2) {
        int n = string2.indexOf(37);
        if (n < 0 && (n = string2.indexOf(43)) < 0) {
            return string2;
        }
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2.substring(0, n));
        int n3 = n;
        while (n3 < n2) {
            char c = string2.charAt(n3);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && n3 + 2 < n2) {
                char c2 = string2.charAt(n3 + 1);
                char c3 = string2.charAt(n3 + 2);
                if (this.isHexDigit(c2) && this.isHexDigit(c3)) {
                    c = (char)(16 * this.decodeHexDigit(c2) + this.decodeHexDigit(c3));
                    n3 += 2;
                }
            }
            stringBuilder.append(c);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static class IllegalCharacterValueSanitizer
    implements ValueSanitizer {
        public static final int ALL_BUT_NUL_AND_ANGLE_BRACKETS_LEGAL = 1439;
        public static final int ALL_BUT_NUL_LEGAL = 1535;
        public static final int ALL_BUT_WHITESPACE_LEGAL = 1532;
        public static final int ALL_ILLEGAL = 0;
        public static final int ALL_OK = 2047;
        public static final int ALL_WHITESPACE_OK = 3;
        public static final int AMP_AND_SPACE_LEGAL = 129;
        public static final int AMP_LEGAL = 128;
        public static final int AMP_OK = 128;
        public static final int DQUOTE_OK = 8;
        public static final int GT_OK = 64;
        private static final String JAVASCRIPT_PREFIX = "javascript:";
        public static final int LT_OK = 32;
        private static final int MIN_SCRIPT_PREFIX_LENGTH = 0;
        public static final int NON_7_BIT_ASCII_OK = 4;
        public static final int NUL_OK = 512;
        public static final int OTHER_WHITESPACE_OK = 2;
        public static final int PCT_OK = 256;
        public static final int SCRIPT_URL_OK = 1024;
        public static final int SPACE_LEGAL = 1;
        public static final int SPACE_OK = 1;
        public static final int SQUOTE_OK = 16;
        public static final int URL_AND_SPACE_LEGAL = 405;
        public static final int URL_LEGAL = 404;
        private static final String VBSCRIPT_PREFIX = "vbscript:";
        private int mFlags;

        static {
            MIN_SCRIPT_PREFIX_LENGTH = Math.min(JAVASCRIPT_PREFIX.length(), VBSCRIPT_PREFIX.length());
        }

        public IllegalCharacterValueSanitizer(int n) {
            this.mFlags = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean characterIsLegal(char c) {
            switch (c) {
                default: {
                    if ((c < ' ' || c >= '\u007f') && (c < '\u0080' || (4 & this.mFlags) == 0)) return false;
                    return true;
                }
                case ' ': {
                    if ((1 & this.mFlags) != 0) return true;
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    if ((2 & this.mFlags) != 0) return true;
                    return false;
                }
                case '\"': {
                    if ((8 & this.mFlags) != 0) return true;
                    return false;
                }
                case '\'': {
                    if ((0x10 & this.mFlags) != 0) return true;
                    return false;
                }
                case '<': {
                    if ((0x20 & this.mFlags) != 0) return true;
                    return false;
                }
                case '>': {
                    if ((0x40 & this.mFlags) != 0) return true;
                    return false;
                }
                case '&': {
                    if ((0x80 & this.mFlags) != 0) return true;
                    return false;
                }
                case '%': {
                    if ((0x100 & this.mFlags) != 0) return true;
                    return false;
                }
                case '\u0000': {
                    if ((0x200 & this.mFlags) == 0) return false;
                }
            }
            return true;
        }

        private boolean isWhitespace(char c) {
            switch (c) {
                default: {
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
            }
            return true;
        }

        private String trimWhitespace(String string2) {
            int n;
            int n2;
            int n3 = n2 = -1 + string2.length();
            for (n = 0; n <= n3 && this.isWhitespace(string2.charAt(n)); ++n) {
            }
            while (n3 >= n && this.isWhitespace(string2.charAt(n3))) {
                --n3;
            }
            if (n == 0 && n3 == n2) {
                return string2;
            }
            return string2.substring(n, n3 + 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String sanitize(String string2) {
            String string3;
            if (string2 == null) {
                return null;
            }
            int n = string2.length();
            if ((0x400 & this.mFlags) != 0 && n >= MIN_SCRIPT_PREFIX_LENGTH && ((string3 = string2.toLowerCase(Locale.ROOT)).startsWith(JAVASCRIPT_PREFIX) || string3.startsWith(VBSCRIPT_PREFIX))) {
                return "";
            }
            if ((3 & this.mFlags) == 0) {
                string2 = this.trimWhitespace(string2);
                n = string2.length();
            }
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = string2.charAt(n2);
                if (!this.characterIsLegal((char)n3)) {
                    n3 = (1 & this.mFlags) != 0 ? 32 : 95;
                }
                stringBuilder.append((char)n3);
                ++n2;
            }
            return stringBuilder.toString();
        }
    }

    public class ParameterValuePair {
        public String mParameter;
        public String mValue;

        public ParameterValuePair(String string2, String string3) {
            this.mParameter = string2;
            this.mValue = string3;
        }
    }

    public static interface ValueSanitizer {
        public String sanitize(String var1);
    }
}

