/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class RssiCurve
implements Parcelable {
    public static final Parcelable.Creator<RssiCurve> CREATOR = new Parcelable.Creator<RssiCurve>(){

        @Override
        public RssiCurve createFromParcel(Parcel parcel) {
            return new RssiCurve(parcel);
        }

        public RssiCurve[] newArray(int n) {
            return new RssiCurve[n];
        }
    };
    public final int bucketWidth;
    public final byte[] rssiBuckets;
    public final int start;

    public RssiCurve(int n, int n2, byte[] byArray) {
        this.start = n;
        this.bucketWidth = n2;
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("rssiBuckets must be at least one element large.");
        }
        this.rssiBuckets = byArray;
    }

    private RssiCurve(Parcel parcel) {
        this.start = parcel.readInt();
        this.bucketWidth = parcel.readInt();
        this.rssiBuckets = new byte[parcel.readInt()];
        parcel.readByteArray(this.rssiBuckets);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                RssiCurve rssiCurve = (RssiCurve)object;
                if (this.start != rssiCurve.start || this.bucketWidth != rssiCurve.bucketWidth || !Arrays.equals(this.rssiBuckets, rssiCurve.rssiBuckets)) break block5;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.start, this.bucketWidth, this.rssiBuckets};
        return Objects.hash(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte lookupScore(int n) {
        int n2 = (n - this.start) / this.bucketWidth;
        if (n2 < 0) {
            n2 = 0;
            return this.rssiBuckets[n2];
        }
        if (n2 <= -1 + this.rssiBuckets.length) return this.rssiBuckets[n2];
        n2 = -1 + this.rssiBuckets.length;
        return this.rssiBuckets[n2];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RssiCurve[start=").append(this.start).append(",bucketWidth=").append(this.bucketWidth);
        stringBuilder.append(",buckets=");
        for (int i = 0; i < this.rssiBuckets.length; ++i) {
            stringBuilder.append(this.rssiBuckets[i]);
            if (i >= -1 + this.rssiBuckets.length) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.start);
        parcel.writeInt(this.bucketWidth);
        parcel.writeInt(this.rssiBuckets.length);
        parcel.writeByteArray(this.rssiBuckets);
    }
}

