/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Proxy;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Locale;

public class ProxyInfo
implements Parcelable {
    public static final Parcelable.Creator<ProxyInfo> CREATOR = new Parcelable.Creator<ProxyInfo>(){

        @Override
        public ProxyInfo createFromParcel(Parcel parcel) {
            if (parcel.readByte() != 0) {
                return new ProxyInfo(Uri.CREATOR.createFromParcel(parcel), parcel.readInt());
            }
            byte by = parcel.readByte();
            String string2 = null;
            int n = 0;
            if (by != 0) {
                string2 = parcel.readString();
                n = parcel.readInt();
            }
            return new ProxyInfo(string2, n, parcel.readString(), parcel.readStringArray());
        }

        public ProxyInfo[] newArray(int n) {
            return new ProxyInfo[n];
        }
    };
    public static final String LOCAL_EXCL_LIST = "";
    public static final String LOCAL_HOST = "localhost";
    public static final int LOCAL_PORT = -1;
    private String mExclusionList;
    private String mHost;
    private Uri mPacFileUrl;
    private String[] mParsedExclusionList;
    private int mPort;

    public ProxyInfo(ProxyInfo proxyInfo) {
        if (proxyInfo != null) {
            this.mHost = proxyInfo.getHost();
            this.mPort = proxyInfo.getPort();
            this.mPacFileUrl = proxyInfo.mPacFileUrl;
            this.mExclusionList = proxyInfo.getExclusionListAsString();
            this.mParsedExclusionList = proxyInfo.mParsedExclusionList;
            return;
        }
        this.mPacFileUrl = Uri.EMPTY;
    }

    public ProxyInfo(Uri uri) {
        this.mHost = LOCAL_HOST;
        this.mPort = -1;
        this.setExclusionList(LOCAL_EXCL_LIST);
        if (uri == null) {
            throw new NullPointerException();
        }
        this.mPacFileUrl = uri;
    }

    public ProxyInfo(Uri uri, int n) {
        this.mHost = LOCAL_HOST;
        this.mPort = n;
        this.setExclusionList(LOCAL_EXCL_LIST);
        if (uri == null) {
            throw new NullPointerException();
        }
        this.mPacFileUrl = uri;
    }

    public ProxyInfo(String string2) {
        this.mHost = LOCAL_HOST;
        this.mPort = -1;
        this.setExclusionList(LOCAL_EXCL_LIST);
        this.mPacFileUrl = Uri.parse(string2);
    }

    public ProxyInfo(String string2, int n, String string3) {
        this.mHost = string2;
        this.mPort = n;
        this.setExclusionList(string3);
        this.mPacFileUrl = Uri.EMPTY;
    }

    private ProxyInfo(String string2, int n, String string3, String[] stringArray) {
        this.mHost = string2;
        this.mPort = n;
        this.mExclusionList = string3;
        this.mParsedExclusionList = stringArray;
        this.mPacFileUrl = Uri.EMPTY;
    }

    public static ProxyInfo buildDirectProxy(String string2, int n) {
        return new ProxyInfo(string2, n, null);
    }

    public static ProxyInfo buildDirectProxy(String string2, int n, List<String> list) {
        Object[] objectArray = list.toArray(new String[list.size()]);
        return new ProxyInfo(string2, n, TextUtils.join((CharSequence)",", objectArray), (String[])objectArray);
    }

    public static ProxyInfo buildPacProxy(Uri uri) {
        return new ProxyInfo(uri);
    }

    private void setExclusionList(String string2) {
        this.mExclusionList = string2;
        if (this.mExclusionList == null) {
            this.mParsedExclusionList = new String[0];
            return;
        }
        this.mParsedExclusionList = string2.toLowerCase(Locale.ROOT).split(",");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof ProxyInfo)) {
            return false;
        }
        ProxyInfo proxyInfo = (ProxyInfo)object;
        if (!Uri.EMPTY.equals(this.mPacFileUrl)) {
            if (!this.mPacFileUrl.equals(proxyInfo.getPacFileUrl())) return false;
            if (this.mPort != proxyInfo.mPort) return false;
            return bl;
        }
        if (!Uri.EMPTY.equals(proxyInfo.mPacFileUrl)) return false;
        if (this.mExclusionList != null) {
            if (!this.mExclusionList.equals(proxyInfo.getExclusionListAsString())) return false;
        }
        if (this.mHost != null && proxyInfo.getHost() != null) {
            if (!this.mHost.equals(proxyInfo.getHost())) return false;
        }
        if (this.mHost != null) {
            if (proxyInfo.mHost == null) return false;
        }
        if (this.mHost == null) {
            if (proxyInfo.mHost != null) return false;
        }
        if (this.mPort != proxyInfo.mPort) return false;
        return bl;
    }

    public String[] getExclusionList() {
        return this.mParsedExclusionList;
    }

    public String getExclusionListAsString() {
        return this.mExclusionList;
    }

    public String getHost() {
        return this.mHost;
    }

    public Uri getPacFileUrl() {
        return this.mPacFileUrl;
    }

    public int getPort() {
        return this.mPort;
    }

    public InetSocketAddress getSocketAddress() {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.mHost, this.mPort);
            return inetSocketAddress;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.mHost == null ? 0 : this.mHost.hashCode();
        String string2 = this.mExclusionList;
        int n2 = 0;
        if (string2 == null) {
            return n + n2 + this.mPort;
        }
        n2 = this.mExclusionList.hashCode();
        return n + n2 + this.mPort;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isValid() {
        if (!Uri.EMPTY.equals(this.mPacFileUrl)) {
            return true;
        }
        String string2 = this.mHost == null ? LOCAL_EXCL_LIST : this.mHost;
        String string3 = this.mPort == 0 ? LOCAL_EXCL_LIST : Integer.toString(this.mPort);
        String string4 = this.mExclusionList == null ? LOCAL_EXCL_LIST : this.mExclusionList;
        if (Proxy.validate(string2, string3, string4) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.net.Proxy makeProxy() {
        java.net.Proxy proxy = java.net.Proxy.NO_PROXY;
        if (this.mHost == null) return proxy;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.mHost, this.mPort);
            java.net.Proxy proxy2 = new java.net.Proxy(Proxy.Type.HTTP, inetSocketAddress);
            return proxy2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return proxy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.EMPTY.equals(this.mPacFileUrl)) {
            stringBuilder.append("PAC Script: ");
            stringBuilder.append(this.mPacFileUrl);
            return stringBuilder.toString();
        }
        if (this.mHost != null) {
            stringBuilder.append("[");
            stringBuilder.append(this.mHost);
            stringBuilder.append("] ");
            stringBuilder.append(Integer.toString(this.mPort));
            if (this.mExclusionList == null) return stringBuilder.toString();
            stringBuilder.append(" xl=").append(this.mExclusionList);
            return stringBuilder.toString();
        }
        stringBuilder.append("[ProxyProperties.mHost == null]");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (!Uri.EMPTY.equals(this.mPacFileUrl)) {
            parcel.writeByte((byte)1);
            this.mPacFileUrl.writeToParcel(parcel, 0);
            parcel.writeInt(this.mPort);
            return;
        }
        parcel.writeByte((byte)0);
        if (this.mHost != null) {
            parcel.writeByte((byte)1);
            parcel.writeString(this.mHost);
            parcel.writeInt(this.mPort);
        } else {
            parcel.writeByte((byte)0);
        }
        parcel.writeString(this.mExclusionList);
        parcel.writeStringArray(this.mParsedExclusionList);
    }
}

