/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyDataTracker
extends BaseNetworkStateTracker {
    private static final String ACTION_PROXY_STATUS_CHANGE = "com.android.net.PROXY_STATUS_CHANGE";
    private static final String DNS1 = "8.8.8.8";
    private static final String DNS2 = "8.8.4.4";
    private static final String INTERFACE_NAME = "ifb0";
    private static final String KEY_IS_PROXY_AVAILABLE = "is_proxy_available";
    private static final String KEY_REPLY_TO_MESSENGER_BINDER = "reply_to_messenger_binder";
    private static final String KEY_REPLY_TO_MESSENGER_BINDER_BUNDLE = "reply_to_messenger_binder_bundle";
    private static final int MSG_SETUP_REQUEST = 2;
    private static final int MSG_TEAR_DOWN_REQUEST = 1;
    private static final String NETWORK_TYPE = "PROXY";
    private static final String PERMISSION_PROXY_STATUS_SENDER = "android.permission.ACCESS_NETWORK_CONDITIONS";
    private static final String REASON_DISABLED = "disabled";
    private static final String REASON_ENABLED = "enabled";
    private static final String REASON_PROXY_DOWN = "proxy_down";
    private static final String TAG = "ProxyDataTracker";
    private final AtomicInteger mDefaultGatewayAddr;
    private AtomicBoolean mIsProxyAvailable;
    private Messenger mProxyStatusService;
    private final BroadcastReceiver mProxyStatusServiceListener;
    private AtomicBoolean mReconnectRequested = new AtomicBoolean(false);
    private Handler mTarget;

    public ProxyDataTracker() {
        this.mIsProxyAvailable = new AtomicBoolean(false);
        this.mDefaultGatewayAddr = new AtomicInteger(0);
        this.mProxyStatusServiceListener = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (!intent.getAction().equals(ProxyDataTracker.ACTION_PROXY_STATUS_CHANGE)) {
                    Log.d(ProxyDataTracker.TAG, "Unrecognized broadcast intent");
                    return;
                }
                ProxyDataTracker.this.mIsProxyAvailable.set(intent.getBooleanExtra(ProxyDataTracker.KEY_IS_PROXY_AVAILABLE, false));
                if (!ProxyDataTracker.this.mIsProxyAvailable.get()) {
                    ProxyDataTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, ProxyDataTracker.REASON_PROXY_DOWN, null);
                    return;
                }
                Bundle bundle = intent.getBundleExtra(ProxyDataTracker.KEY_REPLY_TO_MESSENGER_BINDER_BUNDLE);
                if (bundle == null || bundle.getBinder(ProxyDataTracker.KEY_REPLY_TO_MESSENGER_BINDER) == null) {
                    Log.e(ProxyDataTracker.TAG, "no messenger binder in the intent to send future requests");
                    ProxyDataTracker.this.mIsProxyAvailable.set(false);
                    return;
                } else {
                    ProxyDataTracker.access$102(ProxyDataTracker.this, new Messenger(bundle.getBinder(ProxyDataTracker.KEY_REPLY_TO_MESSENGER_BINDER)));
                    if (!ProxyDataTracker.this.mReconnectRequested.get()) return;
                    ProxyDataTracker.this.reconnect();
                    return;
                }
            }
        };
        this.mNetworkInfo = new NetworkInfo(16, 0, NETWORK_TYPE, "");
        this.mLinkProperties = new LinkProperties();
        this.mNetworkCapabilities = new NetworkCapabilities();
        this.mNetworkInfo.setIsAvailable(true);
        try {
            this.mLinkProperties.addDnsServer(InetAddress.getByName(DNS1));
            this.mLinkProperties.addDnsServer(InetAddress.getByName(DNS2));
            this.mLinkProperties.setInterfaceName(INTERFACE_NAME);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            Log.e(TAG, "Could not add DNS address", unknownHostException);
            return;
        }
    }

    static /* synthetic */ Messenger access$102(ProxyDataTracker proxyDataTracker, Messenger messenger) {
        proxyDataTracker.mProxyStatusService = messenger;
        return messenger;
    }

    private void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        this.mNetworkInfo.setDetailedState(detailedState, string2, string3);
        this.mTarget.obtainMessage(458752, this.mNetworkInfo).sendToTarget();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    @Override
    public boolean reconnect() {
        this.mReconnectRequested.set(true);
        this.setTeardownRequested(false);
        if (!this.mIsProxyAvailable.get()) {
            Log.w(TAG, "Reconnect requested even though proxy service is not up. Bailing.");
            return false;
        }
        this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, REASON_ENABLED, null);
        try {
            this.mProxyStatusService.send(Message.obtain(null, 2));
            this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, REASON_ENABLED, null);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to connect to proxy status service", remoteException);
            this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, REASON_PROXY_DOWN, null);
            return false;
        }
    }

    @Override
    public void startMonitoring(Context context, Handler handler) {
        this.mContext = context;
        this.mTarget = handler;
        this.mContext.registerReceiver(this.mProxyStatusServiceListener, new IntentFilter(ACTION_PROXY_STATUS_CHANGE), PERMISSION_PROXY_STATUS_SENDER, null);
    }

    @Override
    public boolean teardown() {
        this.setTeardownRequested(true);
        this.mReconnectRequested.set(false);
        try {
            if (this.mIsProxyAvailable.get() && this.mProxyStatusService != null) {
                this.mProxyStatusService.send(Message.obtain(null, 1));
            }
            this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, REASON_DISABLED, null);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to connect to proxy status service", remoteException);
            return false;
        }
    }
}

