/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkUtils;
import android.net.PacProxySelector;
import android.net.ProxyInfo;
import android.net.Uri;
import android.text.TextUtils;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;

public final class Proxy {
    private static final boolean DEBUG = false;
    private static final Pattern EXCLLIST_PATTERN;
    private static final String EXCLLIST_REGEXP = "^$|^[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*(,[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*)*$";
    private static final String EXCL_REGEX = "[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*(\\.[a-zA-Z0-9*]+(\\-[a-zA-Z0-9*]+)*)*";
    public static final String EXTRA_PROXY_INFO = "android.intent.extra.PROXY_INFO";
    private static final Pattern HOSTNAME_PATTERN;
    private static final String HOSTNAME_REGEXP = "^$|^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$";
    private static final String NAME_IP_REGEX = "[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*";
    public static final String PROXY_CHANGE_ACTION = "android.intent.action.PROXY_CHANGE";
    public static final int PROXY_EXCLLIST_INVALID = 5;
    public static final int PROXY_HOSTNAME_EMPTY = 1;
    public static final int PROXY_HOSTNAME_INVALID = 2;
    public static final int PROXY_PORT_EMPTY = 3;
    public static final int PROXY_PORT_INVALID = 4;
    public static final int PROXY_VALID = 0;
    private static final String TAG = "Proxy";
    private static ConnectivityManager sConnectivityManager;
    private static final ProxySelector sDefaultProxySelector;

    static {
        sConnectivityManager = null;
        HOSTNAME_PATTERN = Pattern.compile(HOSTNAME_REGEXP);
        EXCLLIST_PATTERN = Pattern.compile(EXCLLIST_REGEXP);
        sDefaultProxySelector = ProxySelector.getDefault();
    }

    public static final String getDefaultHost() {
        String string2 = System.getProperty("http.proxyHost");
        if (TextUtils.isEmpty(string2)) {
            string2 = null;
        }
        return string2;
    }

    public static final int getDefaultPort() {
        if (Proxy.getDefaultHost() == null) {
            return -1;
        }
        try {
            int n = Integer.parseInt(System.getProperty("http.proxyPort"));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static final String getHost(Context context) {
        java.net.Proxy proxy = Proxy.getProxy(context, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return null;
        }
        try {
            String string2 = ((InetSocketAddress)proxy.address()).getHostName();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final int getPort(Context context) {
        java.net.Proxy proxy = Proxy.getProxy(context, null);
        if (proxy == java.net.Proxy.NO_PROXY) {
            return -1;
        }
        try {
            int n = ((InetSocketAddress)proxy.address()).getPort();
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static final HttpHost getPreferredHttpHost(Context context, String string2) {
        java.net.Proxy proxy = Proxy.getProxy(context, string2);
        if (proxy.equals(java.net.Proxy.NO_PROXY)) {
            return null;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
        return new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort(), "http");
    }

    public static final java.net.Proxy getProxy(Context context, String string2) {
        if (string2 != null && !Proxy.isLocalHost("")) {
            URI uRI = URI.create(string2);
            List<java.net.Proxy> list = ProxySelector.getDefault().select(uRI);
            if (list.size() > 0) {
                return list.get(0);
            }
        }
        return java.net.Proxy.NO_PROXY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isLocalHost(String string2) {
        if (string2 == null || string2 == null) return false;
        try {
            if (string2.equalsIgnoreCase("localhost")) {
                return true;
            }
            boolean bl = NetworkUtils.numericToInetAddress(string2).isLoopbackAddress();
            if (!bl) return false;
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static final void setHttpProxySystemProperty(ProxyInfo proxyInfo) {
        Uri uri = Uri.EMPTY;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (proxyInfo != null) {
            string3 = proxyInfo.getHost();
            string4 = Integer.toString(proxyInfo.getPort());
            string2 = proxyInfo.getExclusionListAsString();
            uri = proxyInfo.getPacFileUrl();
        }
        Proxy.setHttpProxySystemProperty(string3, string4, string2, uri);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void setHttpProxySystemProperty(String string2, String string3, String string4, Uri uri) {
        if (string4 != null) {
            string4 = string4.replace(",", "|");
        }
        if (string2 != null) {
            System.setProperty("http.proxyHost", string2);
            System.setProperty("https.proxyHost", string2);
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("https.proxyHost");
        }
        if (string3 != null) {
            System.setProperty("http.proxyPort", string3);
            System.setProperty("https.proxyPort", string3);
        } else {
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyPort");
        }
        if (string4 != null) {
            System.setProperty("http.nonProxyHosts", string4);
            System.setProperty("https.nonProxyHosts", string4);
        } else {
            System.clearProperty("http.nonProxyHosts");
            System.clearProperty("https.nonProxyHosts");
        }
        if (!Uri.EMPTY.equals(uri)) {
            ProxySelector.setDefault(new PacProxySelector());
            return;
        }
        ProxySelector.setDefault(sDefaultProxySelector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int validate(String string2, String string3, String string4) {
        int n = 4;
        Matcher matcher = HOSTNAME_PATTERN.matcher(string2);
        Matcher matcher2 = EXCLLIST_PATTERN.matcher(string4);
        if (!matcher.matches()) {
            return 2;
        }
        if (!matcher2.matches()) {
            return 5;
        }
        if (string2.length() > 0 && string3.length() == 0) {
            return 3;
        }
        if (string3.length() <= 0) return 0;
        if (string2.length() == 0) {
            return 1;
        }
        try {
            int n2 = Integer.parseInt(string3);
            if (n2 <= 0) return n;
            if (n2 > 65535) return n;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return 0;
    }
}

