/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpResults;
import android.os.Parcel;
import android.util.Log;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;

public class NetworkUtils {
    public static final int RESET_ALL_ADDRESSES = 3;
    public static final int RESET_IPV4_ADDRESSES = 1;
    public static final int RESET_IPV6_ADDRESSES = 2;
    private static final String TAG = "NetworkUtils";

    public static boolean addressTypeMatches(InetAddress inetAddress, InetAddress inetAddress2) {
        return inetAddress instanceof Inet4Address && inetAddress2 instanceof Inet4Address || inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet6Address;
    }

    public static native boolean bindProcessToNetwork(int var0);

    public static native boolean bindProcessToNetworkForHostResolution(int var0);

    public static native int bindSocketToNetwork(int var0, int var1);

    public static native String getDhcpError();

    public static native int getNetworkBoundToProcess();

    public static InetAddress getNetworkPart(InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress.getAddress();
        NetworkUtils.maskRawAddress(byArray, n);
        try {
            InetAddress inetAddress2 = InetAddress.getByAddress(byArray);
            return inetAddress2;
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("getNetworkPart error - " + unknownHostException.toString());
        }
    }

    public static InetAddress hexToInet6Address(String string2) throws IllegalArgumentException {
        try {
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{string2.substring(0, 4), string2.substring(4, 8), string2.substring(8, 12), string2.substring(12, 16), string2.substring(16, 20), string2.substring(20, 24), string2.substring(24, 28), string2.substring(28, 32)};
            InetAddress inetAddress = NetworkUtils.numericToInetAddress(String.format(locale, "%s:%s:%s:%s:%s:%s:%s:%s", objectArray));
            return inetAddress;
        }
        catch (Exception exception) {
            Log.e(TAG, "error in hexToInet6Address(" + string2 + "): " + exception);
            throw new IllegalArgumentException(exception);
        }
    }

    public static int inetAddressToInt(Inet4Address inet4Address) throws IllegalArgumentException {
        byte[] byArray = inet4Address.getAddress();
        return (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0];
    }

    public static InetAddress intToInetAddress(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24)};
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            return inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    public static String[] makeStrings(Collection<InetAddress> collection) {
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (InetAddress inetAddress : collection) {
            int n2 = n + 1;
            stringArray[n] = inetAddress.getHostAddress();
            n = n2;
        }
        return stringArray;
    }

    public static void maskRawAddress(byte[] byArray, int n) {
        if (n < 0 || n > 8 * byArray.length) {
            throw new RuntimeException("IP address with " + byArray.length + " bytes has invalid prefix length " + n);
        }
        int n2 = n / 8;
        byte by = (byte)(255 << 8 - n % 8);
        if (n2 < byArray.length) {
            byArray[n2] = (byte)(by & byArray[n2]);
        }
        for (int i = n2 + 1; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public static int netmaskIntToPrefixLength(int n) {
        return Integer.bitCount(n);
    }

    public static InetAddress numericToInetAddress(String string2) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress((String)string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void parcelInetAddress(Parcel parcel, InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress != null ? inetAddress.getAddress() : null;
        parcel.writeByteArray(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<InetAddress, Integer> parseIpAndMask(String string2) {
        InetAddress inetAddress;
        int n = -1;
        try {
            InetAddress inetAddress2;
            String[] stringArray = string2.split("/", 2);
            n = Integer.parseInt(stringArray[1]);
            inetAddress = inetAddress2 = InetAddress.parseNumericAddress((String)stringArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            inetAddress = null;
        }
        catch (NumberFormatException numberFormatException) {
            inetAddress = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            inetAddress = null;
        }
        catch (NullPointerException nullPointerException) {
            inetAddress = null;
        }
        if (inetAddress == null || n == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + string2);
        }
        return new Pair<Object, Integer>(inetAddress, n);
    }

    public static int prefixLengthToNetmaskInt(int n) throws IllegalArgumentException {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException("Invalid prefix length (0 <= prefix <= 32)");
        }
        return Integer.reverseBytes(-1 << 32 - n);
    }

    public static native boolean protectFromVpn(int var0);

    public static native boolean releaseDhcpLease(String var0);

    public static native int resetConnections(String var0, int var1);

    public static native boolean runDhcp(String var0, DhcpResults var1);

    public static native boolean runDhcpRenew(String var0, DhcpResults var1);

    public static native boolean stopDhcp(String var0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String trimV4AddrZeros(String string2) {
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray.length != 4) return string2;
        StringBuilder stringBuilder = new StringBuilder(16);
        int n = 0;
        while (true) {
            block5: {
                if (n >= 4) {
                    return stringBuilder.toString();
                }
                try {
                    if (stringArray[n].length() > 3) return string2;
                    stringBuilder.append(Integer.parseInt(stringArray[n]));
                    if (n >= 3) break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    return string2;
                }
                stringBuilder.append('.');
            }
            ++n;
        }
    }

    protected static InetAddress unparcelInetAddress(Parcel parcel) {
        byte[] byArray = parcel.createByteArray();
        if (byArray == null) {
            return null;
        }
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            return inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }
}

