/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class NetworkScorerAppManager {
    private static final Intent SCORE_INTENT = new Intent("android.net.scoring.SCORE_NETWORKS");
    private static final String TAG = "NetworkScorerAppManager";

    private NetworkScorerAppManager() {
    }

    public static NetworkScorerAppData getActiveScorer(Context context) {
        return NetworkScorerAppManager.getScorer(context, Settings.Global.getString(context.getContentResolver(), "network_scorer_app"));
    }

    public static Collection<NetworkScorerAppData> getAllValidScorers(Context context) {
        ArrayList<NetworkScorerAppData> arrayList = new ArrayList<NetworkScorerAppData>();
        PackageManager packageManager = context.getPackageManager();
        Iterator<ResolveInfo> iterator = packageManager.queryBroadcastReceivers(SCORE_INTENT, 0, 0).iterator();
        while (iterator.hasNext()) {
            ActivityInfo activityInfo = iterator.next().activityInfo;
            if (activityInfo == null || !"android.permission.BROADCAST_SCORE_NETWORKS".equals(activityInfo.permission) || packageManager.checkPermission("android.permission.SCORE_NETWORKS", activityInfo.packageName) != 0) continue;
            Intent intent = new Intent("android.net.scoring.CUSTOM_ENABLE");
            intent.setPackage(activityInfo.packageName);
            List<ResolveInfo> list = packageManager.queryIntentActivities(intent, 0);
            boolean bl = list.isEmpty();
            String string2 = null;
            if (!bl) {
                ActivityInfo activityInfo2 = list.get((int)0).activityInfo;
                string2 = null;
                if (activityInfo2 != null) {
                    string2 = activityInfo2.name;
                }
            }
            arrayList.add(new NetworkScorerAppData(activityInfo.packageName, activityInfo.loadLabel(packageManager), string2));
        }
        return arrayList;
    }

    public static NetworkScorerAppData getScorer(Context context, String string2) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        for (NetworkScorerAppData networkScorerAppData : NetworkScorerAppManager.getAllValidScorers(context)) {
            if (!string2.equals(networkScorerAppData.mPackageName)) continue;
            return networkScorerAppData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCallerActiveScorer(Context context, int n) {
        block5: {
            block4: {
                NetworkScorerAppData networkScorerAppData = NetworkScorerAppManager.getActiveScorer(context);
                if (networkScorerAppData == null) break block4;
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                try {
                    appOpsManager.checkPackage(n, networkScorerAppData.mPackageName);
                }
                catch (SecurityException securityException) {
                    return false;
                }
                if (context.checkCallingPermission("android.permission.SCORE_NETWORKS") == 0) break block5;
            }
            return false;
        }
        return true;
    }

    public static boolean setActiveScorer(Context context, String string2) {
        String string3 = Settings.Global.getString(context.getContentResolver(), "network_scorer_app");
        if (TextUtils.equals(string3, string2)) {
            return true;
        }
        Log.i(TAG, "Changing network scorer from " + string3 + " to " + string2);
        if (string2 == null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", null);
            return true;
        }
        if (NetworkScorerAppManager.getScorer(context, string2) != null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", string2);
            return true;
        }
        Log.w(TAG, "Requested network scorer is not valid: " + string2);
        return false;
    }

    public static class NetworkScorerAppData {
        public final String mConfigurationActivityClassName;
        public final String mPackageName;
        public final CharSequence mScorerName;

        public NetworkScorerAppData(String string2, CharSequence charSequence, String string3) {
            this.mScorerName = charSequence;
            this.mPackageName = string2;
            this.mConfigurationActivityClassName = string3;
        }
    }
}

