/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;

public class NetworkFactory
extends Handler {
    private static final int BASE = 536576;
    public static final int CMD_CANCEL_REQUEST = 536577;
    public static final int CMD_REQUEST_NETWORK = 536576;
    private static final int CMD_SET_FILTER = 536579;
    private static final int CMD_SET_SCORE = 536578;
    private static final boolean DBG = true;
    private static final boolean VDBG;
    private final String LOG_TAG;
    private NetworkCapabilities mCapabilityFilter;
    private final Context mContext;
    private Messenger mMessenger = null;
    private final SparseArray<NetworkRequestInfo> mNetworkRequests = new SparseArray();
    private int mRefCount = 0;
    private int mScore;

    public NetworkFactory(Looper looper, Context context, String string2, NetworkCapabilities networkCapabilities) {
        super(looper);
        this.LOG_TAG = string2;
        this.mContext = context;
        this.mCapabilityFilter = networkCapabilities;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void evalRequest(NetworkRequestInfo networkRequestInfo) {
        if (!networkRequestInfo.requested && networkRequestInfo.score < this.mScore && networkRequestInfo.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(networkRequestInfo.request, networkRequestInfo.score)) {
            this.needNetworkFor(networkRequestInfo.request, networkRequestInfo.score);
            networkRequestInfo.requested = true;
            return;
        } else {
            if (!networkRequestInfo.requested || networkRequestInfo.score <= this.mScore && networkRequestInfo.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(networkRequestInfo.request, networkRequestInfo.score)) return;
            this.releaseNetworkFor(networkRequestInfo.request);
            networkRequestInfo.requested = false;
            return;
        }
    }

    private void evalRequests() {
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            this.evalRequest(this.mNetworkRequests.valueAt(i));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleAddRequest(NetworkRequest networkRequest, int n) {
        NetworkRequestInfo networkRequestInfo = this.mNetworkRequests.get(networkRequest.requestId);
        if (networkRequestInfo == null) {
            this.log("got request " + networkRequest + " with score " + n);
            networkRequestInfo = new NetworkRequestInfo(networkRequest, n);
            this.mNetworkRequests.put(networkRequestInfo.request.requestId, networkRequestInfo);
        } else {
            networkRequestInfo.score = n;
        }
        this.evalRequest(networkRequestInfo);
    }

    private void handleRemoveRequest(NetworkRequest networkRequest) {
        NetworkRequestInfo networkRequestInfo = this.mNetworkRequests.get(networkRequest.requestId);
        if (networkRequestInfo != null && networkRequestInfo.requested) {
            this.mNetworkRequests.remove(networkRequest.requestId);
            this.releaseNetworkFor(networkRequestInfo.request);
        }
    }

    private void handleSetFilter(NetworkCapabilities networkCapabilities) {
        this.mCapabilityFilter = networkCapabilities;
        this.evalRequests();
    }

    private void handleSetScore(int n) {
        this.mScore = n;
        this.evalRequests();
    }

    public boolean acceptRequest(NetworkRequest networkRequest, int n) {
        return true;
    }

    public void addNetworkRequest(NetworkRequest networkRequest, int n) {
        this.sendMessage(this.obtainMessage(536576, new NetworkRequestInfo(networkRequest, n)));
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 536576: {
                this.handleAddRequest((NetworkRequest)message.obj, message.arg1);
                return;
            }
            case 536577: {
                this.handleRemoveRequest((NetworkRequest)message.obj);
                return;
            }
            case 536578: {
                this.handleSetScore(message.arg1);
                return;
            }
            case 536579: 
        }
        this.handleSetFilter((NetworkCapabilities)message.obj);
    }

    protected void log(String string2) {
        Log.d(this.LOG_TAG, string2);
    }

    protected void needNetworkFor(NetworkRequest networkRequest, int n) {
        int n2;
        this.mRefCount = n2 = 1 + this.mRefCount;
        if (n2 == 1) {
            this.startNetwork();
        }
    }

    public void register() {
        this.log("Registering NetworkFactory");
        if (this.mMessenger == null) {
            this.mMessenger = new Messenger(this);
            ConnectivityManager.from(this.mContext).registerNetworkFactory(this.mMessenger, this.LOG_TAG);
        }
    }

    protected void releaseNetworkFor(NetworkRequest networkRequest) {
        int n;
        this.mRefCount = n = -1 + this.mRefCount;
        if (n == 0) {
            this.stopNetwork();
        }
    }

    public void removeNetworkRequest(NetworkRequest networkRequest) {
        this.sendMessage(this.obtainMessage(536577, networkRequest));
    }

    public void setCapabilityFilter(NetworkCapabilities networkCapabilities) {
        this.sendMessage(this.obtainMessage(536579, new NetworkCapabilities(networkCapabilities)));
    }

    public void setScoreFilter(int n) {
        this.sendMessage(this.obtainMessage(536578, n, 0));
    }

    protected void startNetwork() {
    }

    protected void stopNetwork() {
    }

    public void unregister() {
        this.log("Unregistering NetworkFactory");
        if (this.mMessenger != null) {
            ConnectivityManager.from(this.mContext).unregisterNetworkFactory(this.mMessenger);
            this.mMessenger = null;
        }
    }

    private class NetworkRequestInfo {
        public final NetworkRequest request;
        public boolean requested;
        public int score;

        public NetworkRequestInfo(NetworkRequest networkRequest, int n) {
            this.request = networkRequest;
            this.score = n;
            this.requested = false;
        }
    }
}

