/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;

public interface IConnectivityManager
extends IInterface {
    public boolean addVpnAddress(String var1, int var2) throws RemoteException;

    public void captivePortalCheckCompleted(NetworkInfo var1, boolean var2) throws RemoteException;

    public int checkMobileProvisioning(int var1) throws RemoteException;

    public ParcelFileDescriptor establishVpn(VpnConfig var1) throws RemoteException;

    public int findConnectionTypeForIface(String var1) throws RemoteException;

    public LinkProperties getActiveLinkProperties() throws RemoteException;

    public LinkQualityInfo getActiveLinkQualityInfo() throws RemoteException;

    public NetworkInfo getActiveNetworkInfo() throws RemoteException;

    public NetworkInfo getActiveNetworkInfoForUid(int var1) throws RemoteException;

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() throws RemoteException;

    public LinkQualityInfo[] getAllLinkQualityInfo() throws RemoteException;

    public NetworkInfo[] getAllNetworkInfo() throws RemoteException;

    public NetworkState[] getAllNetworkState() throws RemoteException;

    public Network[] getAllNetworks() throws RemoteException;

    public ProxyInfo getGlobalProxy() throws RemoteException;

    public int getLastTetherError(String var1) throws RemoteException;

    public LegacyVpnInfo getLegacyVpnInfo() throws RemoteException;

    public LinkProperties getLinkProperties(Network var1) throws RemoteException;

    public LinkProperties getLinkPropertiesForType(int var1) throws RemoteException;

    public LinkQualityInfo getLinkQualityInfo(int var1) throws RemoteException;

    public String getMobileProvisioningUrl() throws RemoteException;

    public String getMobileRedirectedProvisioningUrl() throws RemoteException;

    public NetworkCapabilities getNetworkCapabilities(Network var1) throws RemoteException;

    public Network getNetworkForType(int var1) throws RemoteException;

    public NetworkInfo getNetworkInfo(int var1) throws RemoteException;

    public NetworkInfo getNetworkInfoForNetwork(Network var1) throws RemoteException;

    public NetworkInfo getProvisioningOrActiveNetworkInfo() throws RemoteException;

    public ProxyInfo getProxy() throws RemoteException;

    public int getRestoreDefaultNetworkDelay(int var1) throws RemoteException;

    public String[] getTetherableBluetoothRegexs() throws RemoteException;

    public String[] getTetherableIfaces() throws RemoteException;

    public String[] getTetherableUsbRegexs() throws RemoteException;

    public String[] getTetherableWifiRegexs() throws RemoteException;

    public String[] getTetheredDhcpRanges() throws RemoteException;

    public String[] getTetheredIfaces() throws RemoteException;

    public String[] getTetheringErroredIfaces() throws RemoteException;

    public VpnConfig getVpnConfig() throws RemoteException;

    public boolean isActiveNetworkMetered() throws RemoteException;

    public boolean isNetworkSupported(int var1) throws RemoteException;

    public boolean isTetheringSupported() throws RemoteException;

    public NetworkRequest listenForNetwork(NetworkCapabilities var1, Messenger var2, IBinder var3) throws RemoteException;

    public void pendingListenForNetwork(NetworkCapabilities var1, PendingIntent var2) throws RemoteException;

    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities var1, PendingIntent var2) throws RemoteException;

    public boolean prepareVpn(String var1, String var2) throws RemoteException;

    public void registerNetworkAgent(Messenger var1, NetworkInfo var2, LinkProperties var3, NetworkCapabilities var4, int var5, NetworkMisc var6) throws RemoteException;

    public void registerNetworkFactory(Messenger var1, String var2) throws RemoteException;

    public void releaseNetworkRequest(NetworkRequest var1) throws RemoteException;

    public boolean removeVpnAddress(String var1, int var2) throws RemoteException;

    public void reportBadNetwork(Network var1) throws RemoteException;

    public void reportInetCondition(int var1, int var2) throws RemoteException;

    public NetworkRequest requestNetwork(NetworkCapabilities var1, Messenger var2, int var3, IBinder var4, int var5) throws RemoteException;

    public boolean requestRouteToHostAddress(int var1, byte[] var2) throws RemoteException;

    public void setAirplaneMode(boolean var1) throws RemoteException;

    public void setDataDependency(int var1, boolean var2) throws RemoteException;

    public void setGlobalProxy(ProxyInfo var1) throws RemoteException;

    public void setPolicyDataEnable(int var1, boolean var2) throws RemoteException;

    public void setProvisioningNotificationVisible(boolean var1, int var2, String var3) throws RemoteException;

    public int setUsbTethering(boolean var1) throws RemoteException;

    public void setVpnPackageAuthorization(boolean var1) throws RemoteException;

    public void startLegacyVpn(VpnProfile var1) throws RemoteException;

    public void supplyMessenger(int var1, Messenger var2) throws RemoteException;

    public int tether(String var1) throws RemoteException;

    public void unregisterNetworkFactory(Messenger var1) throws RemoteException;

    public int untether(String var1) throws RemoteException;

    public boolean updateLockdownVpn() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectivityManager {
        private static final String DESCRIPTOR = "android.net.IConnectivityManager";
        static final int TRANSACTION_addVpnAddress = 64;
        static final int TRANSACTION_captivePortalCheckCompleted = 44;
        static final int TRANSACTION_checkMobileProvisioning = 47;
        static final int TRANSACTION_establishVpn = 39;
        static final int TRANSACTION_findConnectionTypeForIface = 46;
        static final int TRANSACTION_getActiveLinkProperties = 10;
        static final int TRANSACTION_getActiveLinkQualityInfo = 51;
        static final int TRANSACTION_getActiveNetworkInfo = 1;
        static final int TRANSACTION_getActiveNetworkInfoForUid = 2;
        static final int TRANSACTION_getActiveNetworkQuotaInfo = 15;
        static final int TRANSACTION_getAllLinkQualityInfo = 52;
        static final int TRANSACTION_getAllNetworkInfo = 5;
        static final int TRANSACTION_getAllNetworkState = 14;
        static final int TRANSACTION_getAllNetworks = 7;
        static final int TRANSACTION_getGlobalProxy = 33;
        static final int TRANSACTION_getLastTetherError = 21;
        static final int TRANSACTION_getLegacyVpnInfo = 42;
        static final int TRANSACTION_getLinkProperties = 12;
        static final int TRANSACTION_getLinkPropertiesForType = 11;
        static final int TRANSACTION_getLinkQualityInfo = 50;
        static final int TRANSACTION_getMobileProvisioningUrl = 48;
        static final int TRANSACTION_getMobileRedirectedProvisioningUrl = 49;
        static final int TRANSACTION_getNetworkCapabilities = 13;
        static final int TRANSACTION_getNetworkForType = 6;
        static final int TRANSACTION_getNetworkInfo = 3;
        static final int TRANSACTION_getNetworkInfoForNetwork = 4;
        static final int TRANSACTION_getProvisioningOrActiveNetworkInfo = 8;
        static final int TRANSACTION_getProxy = 35;
        static final int TRANSACTION_getRestoreDefaultNetworkDelay = 63;
        static final int TRANSACTION_getTetherableBluetoothRegexs = 29;
        static final int TRANSACTION_getTetherableIfaces = 23;
        static final int TRANSACTION_getTetherableUsbRegexs = 27;
        static final int TRANSACTION_getTetherableWifiRegexs = 28;
        static final int TRANSACTION_getTetheredDhcpRanges = 26;
        static final int TRANSACTION_getTetheredIfaces = 24;
        static final int TRANSACTION_getTetheringErroredIfaces = 25;
        static final int TRANSACTION_getVpnConfig = 40;
        static final int TRANSACTION_isActiveNetworkMetered = 16;
        static final int TRANSACTION_isNetworkSupported = 9;
        static final int TRANSACTION_isTetheringSupported = 22;
        static final int TRANSACTION_listenForNetwork = 60;
        static final int TRANSACTION_pendingListenForNetwork = 61;
        static final int TRANSACTION_pendingRequestForNetwork = 59;
        static final int TRANSACTION_prepareVpn = 37;
        static final int TRANSACTION_registerNetworkAgent = 57;
        static final int TRANSACTION_registerNetworkFactory = 55;
        static final int TRANSACTION_releaseNetworkRequest = 62;
        static final int TRANSACTION_removeVpnAddress = 65;
        static final int TRANSACTION_reportBadNetwork = 32;
        static final int TRANSACTION_reportInetCondition = 31;
        static final int TRANSACTION_requestNetwork = 58;
        static final int TRANSACTION_requestRouteToHostAddress = 17;
        static final int TRANSACTION_setAirplaneMode = 54;
        static final int TRANSACTION_setDataDependency = 36;
        static final int TRANSACTION_setGlobalProxy = 34;
        static final int TRANSACTION_setPolicyDataEnable = 18;
        static final int TRANSACTION_setProvisioningNotificationVisible = 53;
        static final int TRANSACTION_setUsbTethering = 30;
        static final int TRANSACTION_setVpnPackageAuthorization = 38;
        static final int TRANSACTION_startLegacyVpn = 41;
        static final int TRANSACTION_supplyMessenger = 45;
        static final int TRANSACTION_tether = 19;
        static final int TRANSACTION_unregisterNetworkFactory = 56;
        static final int TRANSACTION_untether = 20;
        static final int TRANSACTION_updateLockdownVpn = 43;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectivityManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IConnectivityManager) {
                return (IConnectivityManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkInfo networkInfo = this.getActiveNetworkInfo();
                    parcel2.writeNoException();
                    if (networkInfo != null) {
                        parcel2.writeInt(1);
                        networkInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkInfo networkInfo = this.getActiveNetworkInfoForUid(parcel.readInt());
                    parcel2.writeNoException();
                    if (networkInfo != null) {
                        parcel2.writeInt(1);
                        networkInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkInfo networkInfo = this.getNetworkInfo(parcel.readInt());
                    parcel2.writeNoException();
                    if (networkInfo != null) {
                        parcel2.writeInt(1);
                        networkInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = parcel.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel) : null;
                    NetworkInfo networkInfo = this.getNetworkInfoForNetwork(network);
                    parcel2.writeNoException();
                    if (networkInfo != null) {
                        parcel2.writeInt(1);
                        networkInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAllNetworkInfo();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = this.getNetworkForType(parcel.readInt());
                    parcel2.writeNoException();
                    if (network != null) {
                        parcel2.writeInt(1);
                        network.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAllNetworks();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkInfo networkInfo = this.getProvisioningOrActiveNetworkInfo();
                    parcel2.writeNoException();
                    if (networkInfo != null) {
                        parcel2.writeInt(1);
                        networkInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isNetworkSupported(parcel.readInt());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    LinkProperties linkProperties = this.getActiveLinkProperties();
                    parcel2.writeNoException();
                    if (linkProperties != null) {
                        parcel2.writeInt(1);
                        linkProperties.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    LinkProperties linkProperties = this.getLinkPropertiesForType(parcel.readInt());
                    parcel2.writeNoException();
                    if (linkProperties != null) {
                        parcel2.writeInt(1);
                        linkProperties.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = parcel.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel) : null;
                    LinkProperties linkProperties = this.getLinkProperties(network);
                    parcel2.writeNoException();
                    if (linkProperties != null) {
                        parcel2.writeInt(1);
                        linkProperties.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = parcel.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel) : null;
                    NetworkCapabilities networkCapabilities = this.getNetworkCapabilities(network);
                    parcel2.writeNoException();
                    if (networkCapabilities != null) {
                        parcel2.writeInt(1);
                        networkCapabilities.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAllNetworkState();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkQuotaInfo networkQuotaInfo = this.getActiveNetworkQuotaInfo();
                    parcel2.writeNoException();
                    if (networkQuotaInfo != null) {
                        parcel2.writeInt(1);
                        networkQuotaInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isActiveNetworkMetered();
                    parcel2.writeNoException();
                    int n4 = 0;
                    if (bl) {
                        n4 = 1;
                    }
                    parcel2.writeInt(n4);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.requestRouteToHostAddress(parcel.readInt(), parcel.createByteArray());
                    parcel2.writeNoException();
                    int n5 = 0;
                    if (bl) {
                        n5 = 1;
                    }
                    parcel2.writeInt(n5);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setPolicyDataEnable(n6, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.tether(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.untether(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.getLastTetherError(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isTetheringSupported();
                    parcel2.writeNoException();
                    int n10 = 0;
                    if (bl) {
                        n10 = 1;
                    }
                    parcel2.writeInt(n10);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetherableIfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetheredIfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetheringErroredIfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetheredDhcpRanges();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetherableUsbRegexs();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetherableWifiRegexs();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getTetherableBluetoothRegexs();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    int n11 = this.setUsbTethering(bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reportInetCondition(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Network network = parcel.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel) : null;
                    this.reportBadNetwork(network);
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ProxyInfo proxyInfo = this.getGlobalProxy();
                    parcel2.writeNoException();
                    if (proxyInfo != null) {
                        parcel2.writeInt(1);
                        proxyInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ProxyInfo proxyInfo = parcel.readInt() != 0 ? ProxyInfo.CREATOR.createFromParcel(parcel) : null;
                    this.setGlobalProxy(proxyInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ProxyInfo proxyInfo = this.getProxy();
                    parcel2.writeNoException();
                    if (proxyInfo != null) {
                        parcel2.writeInt(1);
                        proxyInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setDataDependency(n12, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.prepareVpn(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    int n13 = 0;
                    if (bl) {
                        n13 = 1;
                    }
                    parcel2.writeInt(n13);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setVpnPackageAuthorization(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    VpnConfig vpnConfig = parcel.readInt() != 0 ? VpnConfig.CREATOR.createFromParcel(parcel) : null;
                    ParcelFileDescriptor parcelFileDescriptor = this.establishVpn(vpnConfig);
                    parcel2.writeNoException();
                    if (parcelFileDescriptor != null) {
                        parcel2.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    VpnConfig vpnConfig = this.getVpnConfig();
                    parcel2.writeNoException();
                    if (vpnConfig != null) {
                        parcel2.writeInt(1);
                        vpnConfig.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    VpnProfile vpnProfile = parcel.readInt() != 0 ? VpnProfile.CREATOR.createFromParcel(parcel) : null;
                    this.startLegacyVpn(vpnProfile);
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    LegacyVpnInfo legacyVpnInfo = this.getLegacyVpnInfo();
                    parcel2.writeNoException();
                    if (legacyVpnInfo != null) {
                        parcel2.writeInt(1);
                        legacyVpnInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.updateLockdownVpn();
                    parcel2.writeNoException();
                    int n14 = 0;
                    if (bl) {
                        n14 = 1;
                    }
                    parcel2.writeInt(n14);
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkInfo networkInfo = parcel.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.captivePortalCheckCompleted(networkInfo, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = parcel.readInt();
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    this.supplyMessenger(n15, messenger);
                    parcel2.writeNoException();
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n16 = this.findConnectionTypeForIface(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = this.checkMobileProvisioning(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getMobileProvisioningUrl();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.getMobileRedirectedProvisioningUrl();
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    LinkQualityInfo linkQualityInfo = this.getLinkQualityInfo(parcel.readInt());
                    parcel2.writeNoException();
                    if (linkQualityInfo != null) {
                        parcel2.writeInt(1);
                        linkQualityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    LinkQualityInfo linkQualityInfo = this.getActiveLinkQualityInfo();
                    parcel2.writeNoException();
                    if (linkQualityInfo != null) {
                        parcel2.writeInt(1);
                        linkQualityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getAllLinkQualityInfo();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setProvisioningNotificationVisible(bl, parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setAirplaneMode(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    this.registerNetworkFactory(messenger, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    this.unregisterNetworkFactory(messenger);
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    NetworkInfo networkInfo = parcel.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel) : null;
                    LinkProperties linkProperties = parcel.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel) : null;
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    int n18 = parcel.readInt();
                    NetworkMisc networkMisc = parcel.readInt() != 0 ? NetworkMisc.CREATOR.createFromParcel(parcel) : null;
                    this.registerNetworkAgent(messenger, networkInfo, linkProperties, networkCapabilities, n18, networkMisc);
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    NetworkRequest networkRequest = this.requestNetwork(networkCapabilities, messenger, parcel.readInt(), parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    if (networkRequest != null) {
                        parcel2.writeInt(1);
                        networkRequest.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    NetworkRequest networkRequest = this.pendingRequestForNetwork(networkCapabilities, pendingIntent);
                    parcel2.writeNoException();
                    if (networkRequest != null) {
                        parcel2.writeInt(1);
                        networkRequest.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    Messenger messenger = parcel.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel) : null;
                    NetworkRequest networkRequest = this.listenForNetwork(networkCapabilities, messenger, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    if (networkRequest != null) {
                        parcel2.writeInt(1);
                        networkRequest.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.pendingListenForNetwork(networkCapabilities, pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkRequest networkRequest = parcel.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(parcel) : null;
                    this.releaseNetworkRequest(networkRequest);
                    parcel2.writeNoException();
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n19 = this.getRestoreDefaultNetworkDelay(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n19);
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.addVpnAddress(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n20 = 0;
                    if (bl) {
                        n20 = 1;
                    }
                    parcel2.writeInt(n20);
                    return true;
                }
                case 65: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.removeVpnAddress(parcel.readString(), parcel.readInt());
            parcel2.writeNoException();
            int n21 = 0;
            if (bl) {
                n21 = 1;
            }
            parcel2.writeInt(n21);
            return true;
        }

        private static class Proxy
        implements IConnectivityManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public boolean addVpnAddress(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void captivePortalCheckCompleted(NetworkInfo networkInfo, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n;
                block5: {
                    n = 1;
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        if (networkInfo != null) {
                            parcel2.writeInt(1);
                            networkInfo.writeToParcel(parcel2, 0);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                if (!bl) {
                    n = 0;
                }
                parcel2.writeInt(n);
                this.mRemote.transact(44, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            @Override
            public int checkMobileProvisioning(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParcelFileDescriptor establishVpn(VpnConfig vpnConfig) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (vpnConfig != null) {
                        parcel.writeInt(1);
                        vpnConfig.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelFileDescriptor parcelFileDescriptor = parcel2.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel2) : null;
                    return parcelFileDescriptor;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int findConnectionTypeForIface(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LinkProperties getActiveLinkProperties() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkProperties linkProperties = parcel2.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel2) : null;
                    return linkProperties;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LinkQualityInfo getActiveLinkQualityInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkQualityInfo linkQualityInfo = parcel2.readInt() != 0 ? LinkQualityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return linkQualityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkInfo getActiveNetworkInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo networkInfo = parcel2.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkInfo getActiveNetworkInfoForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo networkInfo = parcel2.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkQuotaInfo getActiveNetworkQuotaInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkQuotaInfo networkQuotaInfo = parcel2.readInt() != 0 ? NetworkQuotaInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkQuotaInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public LinkQualityInfo[] getAllLinkQualityInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkQualityInfo[] linkQualityInfoArray = parcel2.createTypedArray(LinkQualityInfo.CREATOR);
                    return linkQualityInfoArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public NetworkInfo[] getAllNetworkInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo[] networkInfoArray = parcel2.createTypedArray(NetworkInfo.CREATOR);
                    return networkInfoArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public NetworkState[] getAllNetworkState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkState[] networkStateArray = parcel2.createTypedArray(NetworkState.CREATOR);
                    return networkStateArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public Network[] getAllNetworks() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    Network[] networkArray = parcel2.createTypedArray(Network.CREATOR);
                    return networkArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProxyInfo getGlobalProxy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    ProxyInfo proxyInfo = parcel2.readInt() != 0 ? ProxyInfo.CREATOR.createFromParcel(parcel2) : null;
                    return proxyInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getLastTetherError(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LegacyVpnInfo getLegacyVpnInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    LegacyVpnInfo legacyVpnInfo = parcel2.readInt() != 0 ? LegacyVpnInfo.CREATOR.createFromParcel(parcel2) : null;
                    return legacyVpnInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LinkProperties getLinkProperties(Network network) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        parcel.writeInt(1);
                        network.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkProperties linkProperties = parcel2.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel2) : null;
                    return linkProperties;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LinkProperties getLinkPropertiesForType(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkProperties linkProperties = parcel2.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel2) : null;
                    return linkProperties;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LinkQualityInfo getLinkQualityInfo(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    LinkQualityInfo linkQualityInfo = parcel2.readInt() != 0 ? LinkQualityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return linkQualityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getMobileProvisioningUrl() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getMobileRedirectedProvisioningUrl() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkCapabilities getNetworkCapabilities(Network network) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        parcel.writeInt(1);
                        network.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkCapabilities networkCapabilities = parcel2.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel2) : null;
                    return networkCapabilities;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Network getNetworkForType(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    Network network = parcel2.readInt() != 0 ? Network.CREATOR.createFromParcel(parcel2) : null;
                    return network;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkInfo getNetworkInfo(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo networkInfo = parcel2.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkInfo getNetworkInfoForNetwork(Network network) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        parcel.writeInt(1);
                        network.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo networkInfo = parcel2.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkInfo getProvisioningOrActiveNetworkInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkInfo networkInfo = parcel2.readInt() != 0 ? NetworkInfo.CREATOR.createFromParcel(parcel2) : null;
                    return networkInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProxyInfo getProxy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    ProxyInfo proxyInfo = parcel2.readInt() != 0 ? ProxyInfo.CREATOR.createFromParcel(parcel2) : null;
                    return proxyInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getRestoreDefaultNetworkDelay(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetherableBluetoothRegexs() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetherableIfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetherableUsbRegexs() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetherableWifiRegexs() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetheredDhcpRanges() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetheredIfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getTetheringErroredIfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VpnConfig getVpnConfig() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    VpnConfig vpnConfig = parcel2.readInt() != 0 ? VpnConfig.CREATOR.createFromParcel(parcel2) : null;
                    return vpnConfig;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isActiveNetworkMetered() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isNetworkSupported(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isTetheringSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkRequest networkRequest = parcel2.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(parcel2) : null;
                    return networkRequest;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkRequest networkRequest = parcel2.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(parcel2) : null;
                    return networkRequest;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean prepareVpn(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n, NetworkMisc networkMisc) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (networkInfo != null) {
                        parcel.writeInt(1);
                        networkInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (linkProperties != null) {
                        parcel.writeInt(1);
                        linkProperties.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    if (networkMisc != null) {
                        parcel.writeInt(1);
                        networkMisc.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerNetworkFactory(Messenger messenger, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void releaseNetworkRequest(NetworkRequest networkRequest) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkRequest != null) {
                        parcel.writeInt(1);
                        networkRequest.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean removeVpnAddress(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void reportBadNetwork(Network network) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        parcel.writeInt(1);
                        network.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void reportInetCondition(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkRequest requestNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, int n, IBinder iBinder, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n2);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkRequest networkRequest = parcel2.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(parcel2) : null;
                    return networkRequest;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean requestRouteToHostAddress(int n, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setAirplaneMode(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(54, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setDataDependency(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(36, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setGlobalProxy(ProxyInfo proxyInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (proxyInfo != null) {
                        parcel.writeInt(1);
                        proxyInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setPolicyDataEnable(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(18, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setProvisioningNotificationVisible(boolean bl, int n, String string2) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    this.mRemote.transact(53, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int setUsbTethering(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(30, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setVpnPackageAuthorization(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(38, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startLegacyVpn(VpnProfile vpnProfile) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (vpnProfile != null) {
                        parcel.writeInt(1);
                        vpnProfile.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void supplyMessenger(int n, Messenger messenger) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int tether(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterNetworkFactory(Messenger messenger) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (messenger != null) {
                        parcel.writeInt(1);
                        messenger.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int untether(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean updateLockdownVpn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

