/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Rect;
import android.media.tv.ITvInputSession;
import android.media.tv.TvInputService;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.Surface;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;

public class ITvInputSessionWrapper
extends ITvInputSession.Stub
implements HandlerCaller.Callback {
    private static final int DO_APP_PRIVATE_COMMAND = 9;
    private static final int DO_CREATE_OVERLAY_VIEW = 10;
    private static final int DO_DISPATCH_SURFACE_CHANGED = 4;
    private static final int DO_RELAYOUT_OVERLAY_VIEW = 11;
    private static final int DO_RELEASE = 1;
    private static final int DO_REMOVE_OVERLAY_VIEW = 12;
    private static final int DO_REQUEST_UNBLOCK_CONTENT = 13;
    private static final int DO_SELECT_TRACK = 8;
    private static final int DO_SET_CAPTION_ENABLED = 7;
    private static final int DO_SET_MAIN = 2;
    private static final int DO_SET_STREAM_VOLUME = 5;
    private static final int DO_SET_SURFACE = 3;
    private static final int DO_TUNE = 6;
    private static final int MESSAGE_HANDLING_DURATION_THRESHOLD_MILLIS = 50;
    private static final String TAG = "TvInputSessionWrapper";
    private final HandlerCaller mCaller;
    private InputChannel mChannel;
    private TvInputEventReceiver mReceiver;
    private TvInputService.Session mTvInputSessionImpl;

    public ITvInputSessionWrapper(Context context, TvInputService.Session session, InputChannel inputChannel) {
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mTvInputSessionImpl = session;
        this.mChannel = inputChannel;
        if (inputChannel != null) {
            this.mReceiver = new TvInputEventReceiver(inputChannel, context.getMainLooper());
        }
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(9, string2, bundle));
    }

    @Override
    public void createOverlayView(IBinder iBinder, Rect rect) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(10, iBinder, rect));
    }

    @Override
    public void dispatchSurfaceChanged(int n, int n2, int n3) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIII(4, n, n2, n3, 0));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void executeMessage(Message message) {
        long l;
        block20: {
            block19: {
                if (this.mTvInputSessionImpl == null) break block19;
                long l2 = System.currentTimeMillis();
                switch (message.what) {
                    default: {
                        Log.w(TAG, "Unhandled message code: " + message.what);
                        break;
                    }
                    case 1: {
                        this.mTvInputSessionImpl.release();
                        this.mTvInputSessionImpl = null;
                        if (this.mReceiver != null) {
                            this.mReceiver.dispose();
                            this.mReceiver = null;
                        }
                        if (this.mChannel == null) break;
                        this.mChannel.dispose();
                        this.mChannel = null;
                        break;
                    }
                    case 2: {
                        this.mTvInputSessionImpl.setMain((Boolean)message.obj);
                        break;
                    }
                    case 3: {
                        this.mTvInputSessionImpl.setSurface((Surface)message.obj);
                        break;
                    }
                    case 4: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        this.mTvInputSessionImpl.dispatchSurfaceChanged(someArgs.argi1, someArgs.argi2, someArgs.argi3);
                        someArgs.recycle();
                        break;
                    }
                    case 5: {
                        this.mTvInputSessionImpl.setStreamVolume(((Float)message.obj).floatValue());
                        break;
                    }
                    case 6: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        this.mTvInputSessionImpl.tune((Uri)someArgs.arg1, (Bundle)someArgs.arg2);
                        someArgs.recycle();
                        break;
                    }
                    case 7: {
                        this.mTvInputSessionImpl.setCaptionEnabled((Boolean)message.obj);
                        break;
                    }
                    case 8: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        this.mTvInputSessionImpl.selectTrack((Integer)someArgs.arg1, (String)someArgs.arg2);
                        someArgs.recycle();
                        break;
                    }
                    case 9: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        this.mTvInputSessionImpl.appPrivateCommand((String)someArgs.arg1, (Bundle)someArgs.arg2);
                        someArgs.recycle();
                        break;
                    }
                    case 10: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        this.mTvInputSessionImpl.createOverlayView((IBinder)someArgs.arg1, (Rect)someArgs.arg2);
                        someArgs.recycle();
                        break;
                    }
                    case 11: {
                        this.mTvInputSessionImpl.relayoutOverlayView((Rect)message.obj);
                        break;
                    }
                    case 12: {
                        this.mTvInputSessionImpl.removeOverlayView(true);
                        break;
                    }
                    case 13: {
                        this.mTvInputSessionImpl.unblockContent((String)message.obj);
                    }
                }
                if ((l = System.currentTimeMillis() - l2) > 50L) break block20;
            }
            return;
        }
        Log.w(TAG, "Handling message (" + message.what + ") took too long time (duration=" + l + "ms)");
    }

    @Override
    public void relayoutOverlayView(Rect rect) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(11, rect));
    }

    @Override
    public void release() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(1));
    }

    @Override
    public void removeOverlayView() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(12));
    }

    @Override
    public void requestUnblockContent(String string2) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(13, string2));
    }

    @Override
    public void selectTrack(int n, String string2) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(8, n, string2));
    }

    @Override
    public void setCaptionEnabled(boolean bl) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(7, bl));
    }

    @Override
    public void setMain(boolean bl) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(2, bl));
    }

    @Override
    public void setSurface(Surface surface) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(3, surface));
    }

    @Override
    public final void setVolume(float f) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(5, Float.valueOf(f)));
    }

    @Override
    public void tune(Uri uri, Bundle bundle) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(6, uri, bundle));
    }

    private final class TvInputEventReceiver
    extends InputEventReceiver {
        public TvInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onInputEvent(InputEvent inputEvent) {
            int n = 1;
            if (ITvInputSessionWrapper.this.mTvInputSessionImpl == null) {
                this.finishInputEvent(inputEvent, false);
                return;
            } else {
                int n2 = ITvInputSessionWrapper.this.mTvInputSessionImpl.dispatchInputEvent(inputEvent, this);
                if (n2 == -1) return;
                if (n2 != n) {
                    n = 0;
                }
                this.finishInputEvent(inputEvent, n != 0);
                return;
            }
        }
    }
}

