/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface ITvInputSession
extends IInterface {
    public void appPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void createOverlayView(IBinder var1, Rect var2) throws RemoteException;

    public void dispatchSurfaceChanged(int var1, int var2, int var3) throws RemoteException;

    public void relayoutOverlayView(Rect var1) throws RemoteException;

    public void release() throws RemoteException;

    public void removeOverlayView() throws RemoteException;

    public void requestUnblockContent(String var1) throws RemoteException;

    public void selectTrack(int var1, String var2) throws RemoteException;

    public void setCaptionEnabled(boolean var1) throws RemoteException;

    public void setMain(boolean var1) throws RemoteException;

    public void setSurface(Surface var1) throws RemoteException;

    public void setVolume(float var1) throws RemoteException;

    public void tune(Uri var1, Bundle var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputSession {
        private static final String DESCRIPTOR = "android.media.tv.ITvInputSession";
        static final int TRANSACTION_appPrivateCommand = 9;
        static final int TRANSACTION_createOverlayView = 10;
        static final int TRANSACTION_dispatchSurfaceChanged = 4;
        static final int TRANSACTION_relayoutOverlayView = 11;
        static final int TRANSACTION_release = 1;
        static final int TRANSACTION_removeOverlayView = 12;
        static final int TRANSACTION_requestUnblockContent = 13;
        static final int TRANSACTION_selectTrack = 8;
        static final int TRANSACTION_setCaptionEnabled = 7;
        static final int TRANSACTION_setMain = 2;
        static final int TRANSACTION_setSurface = 3;
        static final int TRANSACTION_setVolume = 5;
        static final int TRANSACTION_tune = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputSession asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITvInputSession) {
                return (ITvInputSession)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.release();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    this.setMain(bl);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Surface surface = parcel.readInt() != 0 ? Surface.CREATOR.createFromParcel(parcel) : null;
                    this.setSurface(surface);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dispatchSurfaceChanged(parcel.readInt(), parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setVolume(parcel.readFloat());
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.tune(uri, bundle);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    this.setCaptionEnabled(bl);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.selectTrack(parcel.readInt(), parcel.readString());
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.appPrivateCommand(string2, bundle);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    this.createOverlayView(iBinder, rect);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    this.relayoutOverlayView(rect);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeOverlayView();
                    return true;
                }
                case 13: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.requestUnblockContent(parcel.readString());
            return true;
        }

        private static class Proxy
        implements ITvInputSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void appPrivateCommand(String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createOverlayView(IBinder iBinder, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void dispatchSurfaceChanged(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void relayoutOverlayView(Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void release() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void removeOverlayView() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void requestUnblockContent(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void selectTrack(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setCaptionEnabled(boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setMain(boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setSurface(Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface != null) {
                        parcel.writeInt(1);
                        surface.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setVolume(float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeFloat(f);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void tune(Uri uri, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

