/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.content.ComponentName;
import android.content.Context;
import android.media.IRemoteVolumeController;
import android.media.session.IActiveSessionsListener;
import android.media.session.ISession;
import android.media.session.ISessionController;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public final class MediaSessionManager {
    private static final String TAG = "SessionManager";
    private Context mContext;
    private final ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners = new ArrayMap();
    private final Object mLock = new Object();
    private final ISessionManager mService;

    public MediaSessionManager(Context context) {
        this.mContext = context;
        this.mService = ISessionManager.Stub.asInterface(ServiceManager.getService("media_session"));
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName) {
        this.addOnActiveSessionsChangedListener(onActiveSessionsChangedListener, componentName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, int n, Handler handler) {
        if (onActiveSessionsChangedListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(onActiveSessionsChangedListener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper sessionsChangedWrapper = new SessionsChangedWrapper(onActiveSessionsChangedListener, handler);
            try {
                this.mService.addSessionsListener(sessionsChangedWrapper.mStub, componentName, n);
                this.mListeners.put(onActiveSessionsChangedListener, sessionsChangedWrapper);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error in addOnActiveSessionsChangedListener.", remoteException);
            }
            return;
        }
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, Handler handler) {
        this.addOnActiveSessionsChangedListener(onActiveSessionsChangedListener, componentName, UserHandle.myUserId(), handler);
    }

    public ISession createSession(MediaSession.CallbackStub callbackStub, String string2, int n) throws RemoteException {
        return this.mService.createSession(this.mContext.getPackageName(), callbackStub, string2, n);
    }

    public void dispatchAdjustVolume(int n, int n2, int n3) {
        try {
            this.mService.dispatchAdjustVolume(n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to send adjust volume.", remoteException);
            return;
        }
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.dispatchMediaKeyEvent(keyEvent, false);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        try {
            this.mService.dispatchMediaKeyEvent(keyEvent, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to send key event.", remoteException);
            return;
        }
    }

    public List<MediaController> getActiveSessions(ComponentName componentName) {
        return this.getActiveSessionsForUser(componentName, UserHandle.myUserId());
    }

    public List<MediaController> getActiveSessionsForUser(ComponentName componentName, int n) {
        ArrayList<MediaController> arrayList = new ArrayList<MediaController>();
        List<IBinder> list = this.mService.getSessions(componentName, n);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            try {
                arrayList.add(new MediaController(this.mContext, ISessionController.Stub.asInterface(list.get(i))));
                continue;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Failed to get active sessions: ", remoteException);
                break;
            }
        }
        return arrayList;
    }

    public boolean isGlobalPriorityActive() {
        try {
            boolean bl = this.mService.isGlobalPriorityActive();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to check if the global priority is active.", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener) {
        if (onActiveSessionsChangedListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper sessionsChangedWrapper = this.mListeners.remove(onActiveSessionsChangedListener);
            if (sessionsChangedWrapper != null) {
                try {
                    this.mService.removeSessionsListener(sessionsChangedWrapper.mStub);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Error in removeOnActiveSessionsChangedListener.", remoteException);
                }
            }
            return;
        }
    }

    public void setRemoteVolumeController(IRemoteVolumeController iRemoteVolumeController) {
        try {
            this.mService.setRemoteVolumeController(iRemoteVolumeController);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in setRemoteVolumeController.", remoteException);
            return;
        }
    }

    public static interface OnActiveSessionsChangedListener {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }

    private final class SessionsChangedWrapper {
        private final Handler mHandler;
        private final OnActiveSessionsChangedListener mListener;
        private final IActiveSessionsListener.Stub mStub = new IActiveSessionsListener.Stub(){

            @Override
            public void onActiveSessionsChanged(final List<MediaSession.Token> list) {
                if (SessionsChangedWrapper.this.mHandler != null) {
                    SessionsChangedWrapper.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<MediaController> arrayList = new ArrayList<MediaController>();
                            int n = list.size();
                            for (int i = 0; i < n; ++i) {
                                arrayList.add(new MediaController(MediaSessionManager.this.mContext, (MediaSession.Token)list.get(i)));
                            }
                            SessionsChangedWrapper.this.mListener.onActiveSessionsChanged(arrayList);
                        }
                    });
                }
            }
        };

        public SessionsChangedWrapper(OnActiveSessionsChangedListener onActiveSessionsChangedListener, Handler handler) {
            this.mListener = onActiveSessionsChangedListener;
            this.mHandler = handler;
        }
    }
}

