/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.IBinder;
import java.util.ArrayList;

public class AudioPolicy {
    public static final int POLICY_STATUS_INVALID = 0;
    public static final int POLICY_STATUS_REGISTERED = 2;
    public static final int POLICY_STATUS_UNREGISTERED = 1;
    private static final String TAG = "AudioPolicy";
    private AudioPolicyConfig mConfig;
    private int mStatus;
    private AudioPolicyStatusListener mStatusListener = null;
    private final IBinder mToken = new Binder();

    private AudioPolicy(AudioPolicyConfig audioPolicyConfig) {
        this.mConfig = audioPolicyConfig;
        if (this.mConfig.mMixes.isEmpty()) {
            this.mStatus = 0;
            return;
        }
        this.mStatus = 1;
    }

    public AudioPolicyConfig getConfig() {
        return this.mConfig;
    }

    public int getStatus() {
        return this.mStatus;
    }

    void setStatusListener(AudioPolicyStatusListener audioPolicyStatusListener) {
        this.mStatusListener = audioPolicyStatusListener;
    }

    public String toString() {
        String string2 = new String("android.media.audiopolicy.AudioPolicy:\n");
        return string2 + "config=" + this.mConfig.toString();
    }

    public IBinder token() {
        return this.mToken;
    }

    public static abstract class AudioPolicyStatusListener {
        void onMixStateUpdate(AudioMix audioMix) {
        }

        void onStatusChange() {
        }
    }

    public static class Builder {
        private ArrayList<AudioMix> mMixes = new ArrayList();

        public Builder addMix(AudioMix audioMix) throws IllegalArgumentException {
            if (audioMix == null) {
                throw new IllegalArgumentException("Illegal null AudioMix argument");
            }
            this.mMixes.add(audioMix);
            return this;
        }

        public AudioPolicy build() {
            return new AudioPolicy(new AudioPolicyConfig(this.mMixes));
        }
    }
}

