/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.AudioDevice;
import android.media.AudioFormat;
import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringTokenizer;

public class Virtualizer
extends AudioEffect {
    private static final boolean DEBUG = false;
    public static final int PARAM_FORCE_VIRTUALIZATION_MODE = 3;
    public static final int PARAM_STRENGTH = 1;
    public static final int PARAM_STRENGTH_SUPPORTED = 0;
    public static final int PARAM_VIRTUALIZATION_MODE = 4;
    public static final int PARAM_VIRTUAL_SPEAKER_ANGLES = 2;
    private static final String TAG = "Virtualizer";
    public static final int VIRTUALIZATION_MODE_AUTO = 1;
    public static final int VIRTUALIZATION_MODE_BINAURAL = 2;
    public static final int VIRTUALIZATION_MODE_OFF = 0;
    public static final int VIRTUALIZATION_MODE_TRANSAURAL = 3;
    private BaseParameterListener mBaseParamListener;
    private OnParameterChangeListener mParamListener;
    private final Object mParamListenerLock;
    private boolean mStrengthSupported;

    /*
     * Enabled aggressive block sorting
     */
    public Virtualizer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        int n3 = 1;
        super(EFFECT_TYPE_VIRTUALIZER, EFFECT_TYPE_NULL, n, n2);
        this.mStrengthSupported = false;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = new Object();
        if (n2 == 0) {
            Log.w(TAG, "WARNING: attaching a Virtualizer to global output mix is deprecated!");
        }
        int[] nArray = new int[n3];
        this.checkStatus(this.getParameter(0, nArray));
        if (nArray[0] == 0) {
            n3 = 0;
        }
        this.mStrengthSupported = n3;
    }

    private static int deviceToMode(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                return 2;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
        }
        return 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getAnglesInt(int n, int n2, int[] nArray) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (n == 0) {
            throw new IllegalArgumentException("Virtualizer: illegal CHANNEL_INVALID channel mask");
        }
        int n3 = n == 1 ? 12 : n;
        int n4 = AudioFormat.channelCountFromOutChannelMask(n3);
        if (nArray != null && nArray.length < n4 * 3) {
            Log.e(TAG, "Size of array for angles cannot accomodate number of channels in mask (" + n4 + ")");
            throw new IllegalArgumentException("Virtualizer: array for channel / angle pairs is too small: is " + nArray.length + ", should be " + n4 * 3);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(2);
        byteBuffer.putInt(AudioFormat.convertChannelOutMaskToNativeMask(n3));
        byteBuffer.putInt(AudioDevice.convertDeviceTypeToInternalDevice(n2));
        byte[] byArray = new byte[3 * (n4 * 4)];
        int n5 = this.getParameter(byteBuffer.array(), byArray);
        if (n5 >= 0) {
            if (nArray != null) {
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
                byteBuffer2.order(ByteOrder.nativeOrder());
                for (int i = 0; i < n4; ++i) {
                    nArray[i * 3] = AudioFormat.convertNativeChannelMaskToOutMask(byteBuffer2.getInt(3 * (i * 4)));
                    nArray[1 + i * 3] = byteBuffer2.getInt(4 + 3 * (i * 4));
                    nArray[2 + i * 3] = byteBuffer2.getInt(8 + 3 * (i * 4));
                }
            }
            return true;
        }
        if (n5 == -4) {
            return false;
        }
        this.checkStatus(n5);
        Log.e(TAG, "unexpected status code " + n5 + " after getParameter(PARAM_VIRTUAL_SPEAKER_ANGLES)");
        return false;
    }

    private static int getDeviceForModeForce(int n) throws IllegalArgumentException {
        if (n == 1) {
            return 0;
        }
        return Virtualizer.getDeviceForModeQuery(n);
    }

    private static int getDeviceForModeQuery(int n) throws IllegalArgumentException {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Virtualizer: illegal virtualization mode " + n);
            }
            case 2: {
                return 4;
            }
            case 3: 
        }
        return 2;
    }

    public boolean canVirtualize(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return this.getAnglesInt(n, Virtualizer.getDeviceForModeQuery(n2), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean forceVirtualizationMode(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int n2 = this.setParameter(3, AudioDevice.convertDeviceTypeToInternalDevice(Virtualizer.getDeviceForModeForce(n)));
        if (n2 >= 0) {
            return true;
        }
        boolean bl = false;
        if (n2 == -4) return bl;
        this.checkStatus(n2);
        Log.e(TAG, "unexpected status code " + n2 + " after setParameter(PARAM_FORCE_VIRTUALIZATION_MODE)");
        return false;
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(1, sArray));
        settings.strength = sArray[0];
        return settings;
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(1, sArray));
        return sArray[0];
    }

    public boolean getSpeakerAngles(int n, int n2, int[] nArray) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (nArray == null) {
            throw new IllegalArgumentException("Virtualizer: illegal null channel / angle array");
        }
        return this.getAnglesInt(n, Virtualizer.getDeviceForModeQuery(n2), nArray);
    }

    public boolean getStrengthSupported() {
        return this.mStrengthSupported;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getVirtualizationMode() throws IllegalStateException, UnsupportedOperationException {
        int[] nArray = new int[1];
        int n = this.getParameter(4, nArray);
        if (n >= 0) {
            return Virtualizer.deviceToMode(AudioDevice.convertInternalDeviceToDeviceType(nArray[0]));
        }
        int n2 = 0;
        if (n == -4) return n2;
        this.checkStatus(n);
        Log.e(TAG, "unexpected status code " + n + " after getParameter(PARAM_VIRTUALIZATION_MODE)");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = onParameterChangeListener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, settings.strength));
    }

    public void setStrength(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, s));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            Object object = Virtualizer.this.mParamListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = Virtualizer.this.mParamListener;
            OnParameterChangeListener onParameterChangeListener2 = null;
            if (onParameterChangeListener != null) {
                onParameterChangeListener2 = Virtualizer.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener2 == null) return;
            int n2 = -1;
            short s = -1;
            if (byArray.length == 4) {
                n2 = AudioEffect.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                s = AudioEffect.byteArrayToShort(byArray2, 0);
            }
            if (n2 == -1) return;
            if (s == -1) return;
            onParameterChangeListener2.onParameterChange(Virtualizer.this, n, n2, s);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Virtualizer var1, int var2, int var3, short var4);
    }

    public static class Settings {
        public short strength;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(Virtualizer.TAG)) {
                throw new IllegalArgumentException("invalid settings for Virtualizer: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("strength")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.strength = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            return new String("Virtualizer;strength=" + Short.toString(this.strength));
        }
    }
}

