/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TextTrackCue;
import android.media.TextTrackRegion;
import android.media.WebVttCueListener;
import android.util.Log;
import java.util.Vector;

class WebVttParser {
    private static final String TAG = "WebVttParser";
    private String mBuffer = "";
    private TextTrackCue mCue;
    private Vector<String> mCueTexts;
    private WebVttCueListener mListener;
    private final Phase mParseCueId;
    private final Phase mParseCueText;
    private final Phase mParseCueTime;
    private final Phase mParseHeader;
    private final Phase mParseStart;
    private Phase mPhase;
    private final Phase mSkipRest = new Phase(){

        @Override
        public void parse(String string2) {
        }
    };

    WebVttParser(WebVttCueListener webVttCueListener) {
        this.mParseStart = new Phase(){

            @Override
            public void parse(String string2) {
                if (string2.startsWith("\ufeff")) {
                    string2 = string2.substring(1);
                }
                if (!(string2.equals("WEBVTT") || string2.startsWith("WEBVTT ") || string2.startsWith("WEBVTT\t"))) {
                    WebVttParser.this.log_warning("Not a WEBVTT header", string2);
                    WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mSkipRest);
                    return;
                }
                WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseHeader);
            }
        };
        this.mParseHeader = new Phase(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * Enabled aggressive block sorting
             */
            static {
                boolean bl = !WebVttParser.class.desiredAssertionStatus();
                $assertionsDisabled = bl;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void parse(String string2) {
                if (string2.length() == 0) {
                    WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueId);
                    return;
                } else {
                    if (string2.contains("-->")) {
                        WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueTime);
                        WebVttParser.this.mPhase.parse(string2);
                        return;
                    }
                    int n = string2.indexOf(58);
                    if (n <= 0 || n >= -1 + string2.length()) {
                        WebVttParser.this.log_warning("meta data header has invalid format", string2);
                    }
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    if (!string3.equals("Region")) return;
                    TextTrackRegion textTrackRegion = this.parseRegion(string4);
                    WebVttParser.this.mListener.onRegionParsed(textTrackRegion);
                    return;
                }
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            TextTrackRegion parseRegion(String string2) {
                TextTrackRegion textTrackRegion = new TextTrackRegion();
                String[] stringArray = string2.split(" +");
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    block16: {
                        String string3;
                        String string4;
                        block20: {
                            float f;
                            float f2;
                            block22: {
                                int n3;
                                block21: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                if (n2 >= n) {
                                                    return textTrackRegion;
                                                }
                                                String string5 = stringArray[n2];
                                                int n4 = string5.indexOf(61);
                                                if (n4 <= 0 || n4 == -1 + string5.length()) break block16;
                                                string4 = string5.substring(0, n4);
                                                string3 = string5.substring(n4 + 1);
                                                if (!string4.equals("id")) break block17;
                                                textTrackRegion.mId = string3;
                                                break block16;
                                            }
                                            if (!string4.equals("width")) break block18;
                                            try {
                                                textTrackRegion.mWidth = WebVttParser.parseFloatPercentage(string3);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                WebVttParser.this.log_warning("region setting", string4, "has invalid value", numberFormatException.getMessage(), string3);
                                            }
                                            break block16;
                                        }
                                        if (!string4.equals("lines")) break block19;
                                        if (string3.matches(".*[^0-9].*")) {
                                            WebVttParser.this.log_warning("lines", string4, "contains an invalid character", string3);
                                            break block16;
                                        } else {
                                            try {
                                                textTrackRegion.mLines = Integer.parseInt(string3);
                                                if (!$assertionsDisabled && textTrackRegion.mLines < 0) {
                                                    throw new AssertionError();
                                                }
                                                break block16;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                WebVttParser.this.log_warning("region setting", string4, "is not numeric", string3);
                                            }
                                        }
                                        break block16;
                                    }
                                    if (!string4.equals("regionanchor") && !string4.equals("viewportanchor")) break block20;
                                    n3 = string3.indexOf(",");
                                    if (n3 >= 0) break block21;
                                    WebVttParser.this.log_warning("region setting", string4, "contains no comma", string3);
                                    break block16;
                                }
                                String string6 = string3.substring(0, n3);
                                String string7 = string3.substring(n3 + 1);
                                f2 = WebVttParser.parseFloatPercentage(string6);
                                try {
                                    f = WebVttParser.parseFloatPercentage(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    WebVttParser.this.log_warning("region setting", string4, "has invalid y component", numberFormatException.getMessage(), string7);
                                    break block16;
                                }
                                if (string4.charAt(0) != 'r') break block22;
                                textTrackRegion.mAnchorPointX = f2;
                                textTrackRegion.mAnchorPointY = f;
                                break block16;
                                catch (NumberFormatException numberFormatException) {
                                    WebVttParser.this.log_warning("region setting", string4, "has invalid x component", numberFormatException.getMessage(), string6);
                                    break block16;
                                }
                            }
                            textTrackRegion.mViewportAnchorPointX = f2;
                            textTrackRegion.mViewportAnchorPointY = f;
                            break block16;
                        }
                        if (string4.equals("scroll")) {
                            if (string3.equals("up")) {
                                textTrackRegion.mScrollValue = 301;
                            } else {
                                WebVttParser.this.log_warning("region setting", string4, "has invalid value", string3);
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        this.mParseCueId = new Phase(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * Enabled aggressive block sorting
             */
            static {
                boolean bl = !WebVttParser.class.desiredAssertionStatus();
                $assertionsDisabled = bl;
            }

            @Override
            public void parse(String string2) {
                if (string2.length() == 0) {
                    return;
                }
                if (!$assertionsDisabled && WebVttParser.this.mCue != null) {
                    throw new AssertionError();
                }
                if (string2.equals("NOTE") || string2.startsWith("NOTE ")) {
                    WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueText);
                }
                WebVttParser.access$902(WebVttParser.this, new TextTrackCue());
                WebVttParser.this.mCueTexts.clear();
                WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueTime);
                if (string2.contains("-->")) {
                    WebVttParser.this.mPhase.parse(string2);
                    return;
                }
                ((WebVttParser)WebVttParser.this).mCue.mId = string2;
            }
        };
        this.mParseCueTime = new Phase(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * Enabled aggressive block sorting
             */
            static {
                boolean bl = !WebVttParser.class.desiredAssertionStatus();
                $assertionsDisabled = bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void parse(String string2) {
                int n = string2.indexOf("-->");
                if (n < 0) {
                    WebVttParser.access$902(WebVttParser.this, null);
                    WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueId);
                    return;
                }
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 3).replaceFirst("^\\s+", "").replaceFirst("\\s+", " ");
                int n2 = string4.indexOf(32);
                String string5 = n2 > 0 ? string4.substring(0, n2) : string4;
                String string6 = n2 > 0 ? string4.substring(n2 + 1) : "";
                ((WebVttParser)WebVttParser.this).mCue.mStartTimeMs = WebVttParser.parseTimestampMs(string3);
                ((WebVttParser)WebVttParser.this).mCue.mEndTimeMs = WebVttParser.parseTimestampMs(string5);
                for (String string7 : string6.split(" +")) {
                    int n3 = string7.indexOf(58);
                    if (n3 <= 0 || n3 == -1 + string7.length()) continue;
                    String string8 = string7.substring(0, n3);
                    String string9 = string7.substring(n3 + 1);
                    if (string8.equals("region")) {
                        ((WebVttParser)WebVttParser.this).mCue.mRegionId = string9;
                        continue;
                    }
                    if (string8.equals("vertical")) {
                        if (string9.equals("rl")) {
                            ((WebVttParser)WebVttParser.this).mCue.mWritingDirection = 101;
                            continue;
                        }
                        if (string9.equals("lr")) {
                            ((WebVttParser)WebVttParser.this).mCue.mWritingDirection = 102;
                            continue;
                        }
                        WebVttParser.this.log_warning("cue setting", string8, "has invalid value", string9);
                        continue;
                    }
                    if (string8.equals("line")) {
                        block25: {
                            try {
                                if (!$assertionsDisabled && string9.indexOf(32) >= 0) {
                                    throw new AssertionError();
                                }
                                if (string9.endsWith("%")) {
                                    ((WebVttParser)WebVttParser.this).mCue.mSnapToLines = false;
                                    ((WebVttParser)WebVttParser.this).mCue.mLinePosition = WebVttParser.parseIntPercentage(string9);
                                }
                                break block25;
                            }
                            catch (NumberFormatException numberFormatException) {
                                WebVttParser.this.log_warning("cue setting", string8, "is not numeric or percentage", string9);
                            }
                            continue;
                        }
                        if (string9.matches(".*[^0-9].*")) {
                            WebVttParser.this.log_warning("cue setting", string8, "contains an invalid character", string9);
                            continue;
                        }
                        ((WebVttParser)WebVttParser.this).mCue.mSnapToLines = true;
                        ((WebVttParser)WebVttParser.this).mCue.mLinePosition = Integer.parseInt(string9);
                        continue;
                    }
                    if (string8.equals("position")) {
                        try {
                            ((WebVttParser)WebVttParser.this).mCue.mTextPosition = WebVttParser.parseIntPercentage(string9);
                        }
                        catch (NumberFormatException numberFormatException) {
                            WebVttParser.this.log_warning("cue setting", string8, "is not numeric or percentage", string9);
                        }
                        continue;
                    }
                    if (string8.equals("size")) {
                        try {
                            ((WebVttParser)WebVttParser.this).mCue.mSize = WebVttParser.parseIntPercentage(string9);
                        }
                        catch (NumberFormatException numberFormatException) {
                            WebVttParser.this.log_warning("cue setting", string8, "is not numeric or percentage", string9);
                        }
                        continue;
                    }
                    if (!string8.equals("align")) continue;
                    if (string9.equals("start")) {
                        ((WebVttParser)WebVttParser.this).mCue.mAlignment = 201;
                        continue;
                    }
                    if (string9.equals("middle")) {
                        ((WebVttParser)WebVttParser.this).mCue.mAlignment = 200;
                        continue;
                    }
                    if (string9.equals("end")) {
                        ((WebVttParser)WebVttParser.this).mCue.mAlignment = 202;
                        continue;
                    }
                    if (string9.equals("left")) {
                        ((WebVttParser)WebVttParser.this).mCue.mAlignment = 203;
                        continue;
                    }
                    if (string9.equals("right")) {
                        ((WebVttParser)WebVttParser.this).mCue.mAlignment = 204;
                        continue;
                    }
                    WebVttParser.this.log_warning("cue setting", string8, "has invalid value", string9);
                }
                if (((WebVttParser)WebVttParser.this).mCue.mLinePosition != null || ((WebVttParser)WebVttParser.this).mCue.mSize != 100 || ((WebVttParser)WebVttParser.this).mCue.mWritingDirection != 100) {
                    ((WebVttParser)WebVttParser.this).mCue.mRegionId = "";
                }
                WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueText);
            }
        };
        this.mParseCueText = new Phase(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void parse(String string2) {
                if (string2.length() == 0) {
                    WebVttParser.this.yieldCue();
                    WebVttParser.access$102(WebVttParser.this, WebVttParser.this.mParseCueId);
                    return;
                } else {
                    if (WebVttParser.this.mCue == null) return;
                    WebVttParser.this.mCueTexts.add(string2);
                    return;
                }
            }
        };
        this.mPhase = this.mParseStart;
        this.mListener = webVttCueListener;
        this.mCueTexts = new Vector();
    }

    static /* synthetic */ Phase access$102(WebVttParser webVttParser, Phase phase) {
        webVttParser.mPhase = phase;
        return phase;
    }

    static /* synthetic */ TextTrackCue access$902(WebVttParser webVttParser, TextTrackCue textTrackCue) {
        webVttParser.mCue = textTrackCue;
        return textTrackCue;
    }

    private void log_warning(String string2, String string3) {
        Log.w(this.getClass().getName(), string2 + " ('" + string3 + "')");
    }

    private void log_warning(String string2, String string3, String string4, String string5) {
        Log.w(this.getClass().getName(), string2 + " '" + string3 + "' " + string4 + " ('" + string5 + "')");
    }

    private void log_warning(String string2, String string3, String string4, String string5, String string6) {
        Log.w(this.getClass().getName(), string2 + " '" + string3 + "' " + string4 + " ('" + string6 + "' " + string5 + ")");
    }

    public static float parseFloatPercentage(String string2) throws NumberFormatException {
        float f;
        block5: {
            if (!string2.endsWith("%")) {
                throw new NumberFormatException("does not end in %");
            }
            String string3 = string2.substring(0, -1 + string2.length());
            if (string3.matches(".*[^0-9.].*")) {
                throw new NumberFormatException("contains an invalid character");
            }
            try {
                f = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("is not a number");
            }
            if (!(f < 0.0f) && !(f > 100.0f)) break block5;
            throw new NumberFormatException("is out of range");
        }
        return f;
    }

    public static int parseIntPercentage(String string2) throws NumberFormatException {
        int n;
        block5: {
            if (!string2.endsWith("%")) {
                throw new NumberFormatException("does not end in %");
            }
            String string3 = string2.substring(0, -1 + string2.length());
            if (string3.matches(".*[^0-9].*")) {
                throw new NumberFormatException("contains an invalid character");
            }
            try {
                n = Integer.parseInt(string3);
                if (n >= 0 && n <= 100) break block5;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("is not a number");
            }
            throw new NumberFormatException("is out of range");
        }
        return n;
    }

    public static long parseTimestampMs(String string2) throws NumberFormatException {
        if (!string2.matches("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}")) {
            throw new NumberFormatException("has invalid format");
        }
        String[] stringArray = string2.split("\\.", 2);
        long l = 0L;
        for (String string3 : stringArray[0].split(":")) {
            l = 60L * l + Long.parseLong(string3);
        }
        return 1000L * l + Long.parseLong(stringArray[1]);
    }

    public static String timeToString(long l) {
        Object[] objectArray = new Object[]{l / 3600000L, l / 60000L % 60L, l / 1000L % 60L, l % 1000L};
        return String.format("%d:%02d:%02d.%03d", objectArray);
    }

    public void eos() {
        if (this.mBuffer.endsWith("\r")) {
            this.mBuffer = this.mBuffer.substring(0, -1 + this.mBuffer.length());
        }
        this.mPhase.parse(this.mBuffer);
        this.mBuffer = "";
        this.yieldCue();
        this.mPhase = this.mParseStart;
    }

    public void parse(String string2) {
        this.mBuffer = (this.mBuffer + string2.replace("\u0000", "\ufffd")).replace("\r\n", "\n");
        boolean bl = this.mBuffer.endsWith("\r");
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
            this.mBuffer = this.mBuffer.substring(0, -1 + this.mBuffer.length());
        }
        String[] stringArray = this.mBuffer.split("[\r\n]");
        for (int i = 0; i < -1 + stringArray.length; ++i) {
            this.mPhase.parse(stringArray[i]);
        }
        this.mBuffer = stringArray[-1 + stringArray.length];
        if (bl2) {
            this.mBuffer = this.mBuffer + "\r";
        }
    }

    public void yieldCue() {
        if (this.mCue != null && this.mCueTexts.size() > 0) {
            this.mCue.mStrings = new String[this.mCueTexts.size()];
            this.mCueTexts.toArray(this.mCue.mStrings);
            this.mCueTexts.clear();
            this.mListener.onCueParsed(this.mCue);
        }
        this.mCue = null;
    }

    static interface Phase {
        public void parse(String var1);
    }
}

