/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public final class Rating
implements Parcelable {
    public static final Parcelable.Creator<Rating> CREATOR = new Parcelable.Creator<Rating>(){

        @Override
        public Rating createFromParcel(Parcel parcel) {
            return new Rating(parcel.readInt(), parcel.readFloat());
        }

        public Rating[] newArray(int n) {
            return new Rating[n];
        }
    };
    public static final int RATING_3_STARS = 3;
    public static final int RATING_4_STARS = 4;
    public static final int RATING_5_STARS = 5;
    public static final int RATING_HEART = 1;
    public static final int RATING_NONE = 0;
    private static final float RATING_NOT_RATED = -1.0f;
    public static final int RATING_PERCENTAGE = 6;
    public static final int RATING_THUMB_UP_DOWN = 2;
    private static final String TAG = "Rating";
    private final int mRatingStyle;
    private final float mRatingValue;

    private Rating(int n, float f) {
        this.mRatingStyle = n;
        this.mRatingValue = f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rating newHeartRating(boolean bl) {
        float f;
        if (bl) {
            f = 1.0f;
            return new Rating(1, f);
        }
        f = 0.0f;
        return new Rating(1, f);
    }

    public static Rating newPercentageRating(float f) {
        if (f < 0.0f || f > 100.0f) {
            Log.e(TAG, "Invalid percentage-based rating value");
            return null;
        }
        return new Rating(6, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Rating newStarRating(int n, float f) {
        float f2;
        switch (n) {
            default: {
                Log.e(TAG, "Invalid rating style (" + n + ") for a star rating");
                return null;
            }
            case 3: {
                f2 = 3.0f;
                break;
            }
            case 4: {
                f2 = 4.0f;
                break;
            }
            case 5: {
                f2 = 5.0f;
            }
        }
        if (f < 0.0f || f > f2) {
            Log.e(TAG, "Trying to set out of range star-based rating");
            return null;
        }
        return new Rating(n, f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rating newThumbRating(boolean bl) {
        float f;
        if (bl) {
            f = 1.0f;
            return new Rating(2, f);
        }
        f = 0.0f;
        return new Rating(2, f);
    }

    public static Rating newUnratedRating(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return new Rating(n, -1.0f);
    }

    @Override
    public int describeContents() {
        return this.mRatingStyle;
    }

    public float getPercentRating() {
        if (this.mRatingStyle != 6 || !this.isRated()) {
            return -1.0f;
        }
        return this.mRatingValue;
    }

    public int getRatingStyle() {
        return this.mRatingStyle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getStarRating() {
        switch (this.mRatingStyle) {
            default: {
                return -1.0f;
            }
            case 3: 
            case 4: 
            case 5: {
                if (!this.isRated()) return -1.0f;
                return this.mRatingValue;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasHeart() {
        int n = 1;
        if (this.mRatingStyle != n) {
            return false;
        }
        if (this.mRatingValue != 1.0f) return 0;
        return n;
    }

    public boolean isRated() {
        return this.mRatingValue >= 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isThumbUp() {
        return this.mRatingStyle == 2 && this.mRatingValue == 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("Rating:style=").append(this.mRatingStyle).append(" rating=");
        if (this.mRatingValue < 0.0f) {
            string2 = "unrated";
            return stringBuilder.append(string2).toString();
        }
        string2 = String.valueOf(this.mRatingValue);
        return stringBuilder.append(string2).toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mRatingStyle);
        parcel.writeFloat(this.mRatingValue);
    }
}

