/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Map;

public final class MediaMuxer {
    private static final int MUXER_STATE_INITIALIZED = 0;
    private static final int MUXER_STATE_STARTED = 1;
    private static final int MUXER_STATE_STOPPED = 2;
    private static final int MUXER_STATE_UNINITIALIZED = -1;
    private final CloseGuard mCloseGuard;
    private int mLastTrackIndex;
    private long mNativeObject;
    private int mState;

    static {
        System.loadLibrary("media_jni");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaMuxer(String string2, int n) throws IOException {
        RandomAccessFile randomAccessFile;
        block7: {
            RandomAccessFile randomAccessFile2;
            this.mState = -1;
            this.mCloseGuard = CloseGuard.get();
            this.mLastTrackIndex = -1;
            if (string2 == null) {
                throw new IllegalArgumentException("path must not be null");
            }
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException("format is invalid");
            }
            randomAccessFile = null;
            try {
                randomAccessFile2 = new RandomAccessFile(string2, "rws");
            }
            catch (Throwable throwable) {}
            try {
                this.mNativeObject = MediaMuxer.nativeSetup(randomAccessFile2.getFD(), n);
                this.mState = 0;
                this.mCloseGuard.open("release");
                if (randomAccessFile2 == null) break block7;
            }
            catch (Throwable throwable) {
                randomAccessFile = randomAccessFile2;
            }
            randomAccessFile2.close();
        }
        return;
        {
            void var5_6;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw var5_6;
        }
    }

    private static native int nativeAddTrack(long var0, String[] var2, Object[] var3);

    private static native void nativeRelease(long var0);

    private static native void nativeSetLocation(long var0, int var2, int var3);

    private static native void nativeSetOrientationHint(long var0, int var2);

    private static native long nativeSetup(FileDescriptor var0, int var1);

    private static native void nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeWriteSampleData(long var0, int var2, ByteBuffer var3, int var4, int var5, long var6, int var8);

    public int addTrack(MediaFormat mediaFormat) {
        int n;
        if (mediaFormat == null) {
            throw new IllegalArgumentException("format must not be null.");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Muxer is not initialized.");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        Map<String, Object> map = mediaFormat.getMap();
        int n2 = map.size();
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringArray[n3] = entry.getKey();
                objectArray[n3] = entry.getValue();
                ++n3;
            }
            n = MediaMuxer.nativeAddTrack(this.mNativeObject, stringArray, objectArray);
            if (this.mLastTrackIndex >= n) {
                throw new IllegalArgumentException("Invalid format.");
            }
        } else {
            throw new IllegalArgumentException("format must not be empty.");
        }
        this.mLastTrackIndex = n;
        return n;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                MediaMuxer.nativeRelease(this.mNativeObject);
                this.mNativeObject = 0L;
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        if (this.mState == 1) {
            this.stop();
        }
        if (this.mNativeObject != 0L) {
            MediaMuxer.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
            this.mCloseGuard.close();
        }
        this.mState = -1;
    }

    public void setLocation(float f, float f2) {
        int n = (int)(0.5 + (double)(f * 10000.0f));
        int n2 = (int)(0.5 + (double)(f2 * 10000.0f));
        if (n > 900000 || n < -900000) {
            throw new IllegalArgumentException("Latitude: " + f + " out of range.");
        }
        if (n2 > 1800000 || n2 < -1800000) {
            throw new IllegalArgumentException("Longitude: " + f2 + " out of range");
        }
        if (this.mState == 0 && this.mNativeObject != 0L) {
            MediaMuxer.nativeSetLocation(this.mNativeObject, n, n2);
            return;
        }
        throw new IllegalStateException("Can't set location due to wrong state.");
    }

    public void setOrientationHint(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + n);
        }
        if (this.mState == 0) {
            MediaMuxer.nativeSetOrientationHint(this.mNativeObject, n);
            return;
        }
        throw new IllegalStateException("Can't set rotation degrees due to wrong state.");
    }

    public void start() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState == 0) {
            MediaMuxer.nativeStart(this.mNativeObject);
            this.mState = 1;
            return;
        }
        throw new IllegalStateException("Can't start due to wrong state.");
    }

    public void stop() {
        if (this.mState == 1) {
            MediaMuxer.nativeStop(this.mNativeObject);
            this.mState = 2;
            return;
        }
        throw new IllegalStateException("Can't stop due to wrong state.");
    }

    public void writeSampleData(int n, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        if (n < 0 || n > this.mLastTrackIndex) {
            throw new IllegalArgumentException("trackIndex is invalid");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("byteBuffer must not be null");
        }
        if (bufferInfo == null) {
            throw new IllegalArgumentException("bufferInfo must not be null");
        }
        if (bufferInfo.size < 0 || bufferInfo.offset < 0 || bufferInfo.offset + bufferInfo.size > byteBuffer.capacity() || bufferInfo.presentationTimeUs < 0L) {
            throw new IllegalArgumentException("bufferInfo must specify a valid buffer offset, size and presentation time");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState != 1) {
            throw new IllegalStateException("Can't write, muxer is not started");
        }
        MediaMuxer.nativeWriteSampleData(this.mNativeObject, n, byteBuffer, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
    }

    public static final class OutputFormat {
        public static final int MUXER_OUTPUT_MPEG_4 = 0;
        public static final int MUXER_OUTPUT_WEBM = 1;

        private OutputFormat() {
        }
    }
}

