/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.Utils;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class MediaCodecInfo {
    private static final int ERROR_NONE_SUPPORTED = 4;
    private static final int ERROR_UNRECOGNIZED = 1;
    private static final int ERROR_UNSUPPORTED = 2;
    private static final Range<Integer> FRAME_RATE_RANGE;
    private static final Range<Integer> POSITIVE_INTEGERS;
    private static final Range<Long> POSITIVE_LONGS;
    private static final Range<Rational> POSITIVE_RATIONALS;
    private static final Range<Integer> SIZE_RANGE;
    private Map<String, CodecCapabilities> mCaps;
    private boolean mIsEncoder;
    private String mName;

    static {
        POSITIVE_INTEGERS = Range.create(1, Integer.MAX_VALUE);
        POSITIVE_LONGS = Range.create(1L, Long.MAX_VALUE);
        POSITIVE_RATIONALS = Range.create(new Rational(1, Integer.MAX_VALUE), new Rational(Integer.MAX_VALUE, 1));
        SIZE_RANGE = Range.create(1, 32768);
        FRAME_RATE_RANGE = Range.create(0, 960);
    }

    MediaCodecInfo(String string2, boolean bl, CodecCapabilities[] codecCapabilitiesArray) {
        this.mName = string2;
        this.mIsEncoder = bl;
        this.mCaps = new HashMap<String, CodecCapabilities>();
        for (CodecCapabilities codecCapabilities : codecCapabilitiesArray) {
            this.mCaps.put(codecCapabilities.getMimeType(), codecCapabilities);
        }
    }

    private static int checkPowerOfTwo(int n, String string2) {
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException(string2);
        }
        return n;
    }

    public final CodecCapabilities getCapabilitiesForType(String string2) {
        CodecCapabilities codecCapabilities = this.mCaps.get(string2);
        if (codecCapabilities == null) {
            throw new IllegalArgumentException("codec does not support type");
        }
        return codecCapabilities.dup();
    }

    public final String getName() {
        return this.mName;
    }

    public final String[] getSupportedTypes() {
        Set<String> set = this.mCaps.keySet();
        Object[] objectArray = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public final boolean isEncoder() {
        return this.mIsEncoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MediaCodecInfo makeRegular() {
        ArrayList<CodecCapabilities> arrayList = new ArrayList<CodecCapabilities>();
        for (CodecCapabilities codecCapabilities : this.mCaps.values()) {
            if (!codecCapabilities.isRegular()) continue;
            arrayList.add(codecCapabilities);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == this.mCaps.size()) return this;
        return new MediaCodecInfo(this.mName, this.mIsEncoder, arrayList.toArray(new CodecCapabilities[arrayList.size()]));
    }

    public static final class AudioCapabilities {
        private static final int MAX_INPUT_CHANNEL_COUNT = 30;
        private static final String TAG = "AudioCapabilities";
        private Range<Integer> mBitrateRange;
        private int mMaxInputChannelCount;
        private CodecCapabilities mParent;
        private Range<Integer>[] mSampleRateRanges;
        private int[] mSampleRates;

        private AudioCapabilities() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void applyLevelLimits() {
            int n;
            Range<Integer> range;
            int[] nArray;
            Range<Integer> range2 = null;
            String string2 = this.mParent.getMimeType();
            if (string2.equalsIgnoreCase("audio/mpeg")) {
                nArray = new int[]{8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000};
                range = Range.create(8000, 320000);
                n = 2;
            } else if (string2.equalsIgnoreCase("audio/3gpp")) {
                nArray = new int[]{8000};
                range = Range.create(4750, 12200);
                n = 1;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/amr-wb")) {
                nArray = new int[]{16000};
                range = Range.create(6600, 23850);
                n = 1;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/mp4a-latm")) {
                nArray = new int[]{7350, 8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 64000, 88200, 96000};
                range = Range.create(8000, 510000);
                n = 48;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/vorbis")) {
                range = Range.create(32000, 500000);
                nArray = new int[]{8000, 12000, 16000, 24000, 48000, 192000};
                n = 255;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/opus")) {
                range = Range.create(6000, 510000);
                nArray = new int[]{8000, 12000, 16000, 24000, 48000};
                n = 255;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/raw")) {
                range2 = Range.create(1, 96000);
                range = Range.create(1, 10000000);
                n = 8;
                nArray = null;
            } else if (string2.equalsIgnoreCase("audio/flac")) {
                range2 = Range.create(1, 655350);
                n = 255;
                range = null;
                nArray = null;
            } else if (string2.equalsIgnoreCase("audio/g711-alaw") || string2.equalsIgnoreCase("audio/g711-mlaw")) {
                nArray = new int[]{8000};
                range = Range.create(64000, 64000);
                n = 0;
                range2 = null;
            } else if (string2.equalsIgnoreCase("audio/gsm")) {
                nArray = new int[]{8000};
                range = Range.create(13000, 13000);
                n = 1;
                range2 = null;
            } else {
                Log.w(TAG, "Unsupported mime " + string2);
                CodecCapabilities codecCapabilities = this.mParent;
                codecCapabilities.mError = 2 | codecCapabilities.mError;
                range = null;
                n = 0;
                range2 = null;
                nArray = null;
            }
            if (nArray != null) {
                this.limitSampleRates(nArray);
            } else if (range2 != null) {
                this.limitSampleRates(new Range[]{range2});
            }
            this.applyLimits(n, range);
        }

        private void applyLimits(int n, Range<Integer> range) {
            this.mMaxInputChannelCount = Range.create(1, this.mMaxInputChannelCount).clamp(n);
            if (range != null) {
                this.mBitrateRange = this.mBitrateRange.intersect(range);
            }
        }

        public static AudioCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            AudioCapabilities audioCapabilities = new AudioCapabilities();
            audioCapabilities.init(mediaFormat, codecCapabilities);
            return audioCapabilities;
        }

        private void createDiscreteSampleRates() {
            this.mSampleRates = new int[this.mSampleRateRanges.length];
            for (int i = 0; i < this.mSampleRateRanges.length; ++i) {
                this.mSampleRates[i] = this.mSampleRateRanges[i].getLower();
            }
        }

        private void initWithPlatformLimits() {
            this.mBitrateRange = Range.create(0, Integer.MAX_VALUE);
            this.mMaxInputChannelCount = 30;
            Range[] rangeArray = new Range[]{Range.create(8000, 96000)};
            this.mSampleRateRanges = rangeArray;
            this.mSampleRates = null;
        }

        private void limitSampleRates(int[] nArray) {
            Arrays.sort(nArray);
            ArrayList<Range<Integer>> arrayList = new ArrayList<Range<Integer>>();
            for (int n : nArray) {
                if (!this.supports(n, null)) continue;
                arrayList.add(Range.create(n, n));
            }
            this.mSampleRateRanges = arrayList.toArray(new Range[arrayList.size()]);
            this.createDiscreteSampleRates();
        }

        private void limitSampleRates(Range<Integer>[] rangeArray) {
            Utils.sortDistinctRanges(rangeArray);
            for (Range<Integer> range : this.mSampleRateRanges = Utils.intersectSortedDistinctRanges(this.mSampleRateRanges, rangeArray)) {
                if (range.getLower().equals(range.getUpper())) continue;
                this.mSampleRates = null;
                return;
            }
            this.createDiscreteSampleRates();
        }

        private void parseFromInfo(MediaFormat mediaFormat) {
            int n = 30;
            Range<Integer> range = POSITIVE_INTEGERS;
            if (mediaFormat.containsKey("sample-rate-ranges")) {
                String[] stringArray = mediaFormat.getString("sample-rate-ranges").split(",");
                Range[] rangeArray = new Range[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    rangeArray[i] = Utils.parseIntRange(stringArray[i], null);
                }
                this.limitSampleRates(rangeArray);
            }
            if (mediaFormat.containsKey("max-channel-count")) {
                n = Utils.parseIntSafely(mediaFormat.getString("max-channel-count"), n);
            }
            if (mediaFormat.containsKey("bitrate-range")) {
                range = range.intersect(Utils.parseIntRange(mediaFormat.getString("bitrate"), range));
            }
            this.applyLimits(n, range);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean supports(Integer n, Integer n2) {
            return (n2 == null || n2 >= 1 && n2 <= this.mMaxInputChannelCount) && (n == null || Utils.binarySearchDistinctRanges(this.mSampleRateRanges, n) >= 0);
        }

        public Range<Integer> getBitrateRange() {
            return this.mBitrateRange;
        }

        public int getMaxInputChannelCount() {
            return this.mMaxInputChannelCount;
        }

        public Range<Integer>[] getSupportedSampleRateRanges() {
            return Arrays.copyOf(this.mSampleRateRanges, this.mSampleRateRanges.length);
        }

        public int[] getSupportedSampleRates() {
            return Arrays.copyOf(this.mSampleRates, this.mSampleRates.length);
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            this.mParent = codecCapabilities;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(mediaFormat);
        }

        public boolean isSampleRateSupported(int n) {
            return this.supports(n, null);
        }

        public void setDefaultFormat(MediaFormat mediaFormat) {
            if (this.mBitrateRange.getLower().equals(this.mBitrateRange.getUpper())) {
                mediaFormat.setInteger("bitrate", this.mBitrateRange.getLower());
            }
            if (this.mMaxInputChannelCount == 1) {
                mediaFormat.setInteger("channel-count", 1);
            }
            if (this.mSampleRates != null && this.mSampleRates.length == 1) {
                mediaFormat.setInteger("sample-rate", this.mSampleRates[0]);
            }
        }

        public boolean supportsFormat(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            return this.supports((Integer)map.get("sample-rate"), (Integer)map.get("channel-count"));
        }
    }

    public static final class CodecCapabilities {
        public static final int COLOR_Format12bitRGB444 = 3;
        public static final int COLOR_Format16bitARGB1555 = 5;
        public static final int COLOR_Format16bitARGB4444 = 4;
        public static final int COLOR_Format16bitBGR565 = 7;
        public static final int COLOR_Format16bitRGB565 = 6;
        public static final int COLOR_Format18BitBGR666 = 41;
        public static final int COLOR_Format18bitARGB1665 = 9;
        public static final int COLOR_Format18bitRGB666 = 8;
        public static final int COLOR_Format19bitARGB1666 = 10;
        public static final int COLOR_Format24BitABGR6666 = 43;
        public static final int COLOR_Format24BitARGB6666 = 42;
        public static final int COLOR_Format24bitARGB1887 = 13;
        public static final int COLOR_Format24bitBGR888 = 12;
        public static final int COLOR_Format24bitRGB888 = 11;
        public static final int COLOR_Format25bitARGB1888 = 14;
        public static final int COLOR_Format32bitARGB8888 = 16;
        public static final int COLOR_Format32bitBGRA8888 = 15;
        public static final int COLOR_Format8bitRGB332 = 2;
        public static final int COLOR_FormatCbYCrY = 27;
        public static final int COLOR_FormatCrYCbY = 28;
        public static final int COLOR_FormatL16 = 36;
        public static final int COLOR_FormatL2 = 33;
        public static final int COLOR_FormatL24 = 37;
        public static final int COLOR_FormatL32 = 38;
        public static final int COLOR_FormatL4 = 34;
        public static final int COLOR_FormatL8 = 35;
        public static final int COLOR_FormatMonochrome = 1;
        public static final int COLOR_FormatRawBayer10bit = 31;
        public static final int COLOR_FormatRawBayer8bit = 30;
        public static final int COLOR_FormatRawBayer8bitcompressed = 32;
        public static final int COLOR_FormatSurface = 2130708361;
        public static final int COLOR_FormatYCbYCr = 25;
        public static final int COLOR_FormatYCrYCb = 26;
        public static final int COLOR_FormatYUV411PackedPlanar = 18;
        public static final int COLOR_FormatYUV411Planar = 17;
        public static final int COLOR_FormatYUV420Flexible = 2135033992;
        public static final int COLOR_FormatYUV420PackedPlanar = 20;
        public static final int COLOR_FormatYUV420PackedSemiPlanar = 39;
        public static final int COLOR_FormatYUV420Planar = 19;
        public static final int COLOR_FormatYUV420SemiPlanar = 21;
        public static final int COLOR_FormatYUV422PackedPlanar = 23;
        public static final int COLOR_FormatYUV422PackedSemiPlanar = 40;
        public static final int COLOR_FormatYUV422Planar = 22;
        public static final int COLOR_FormatYUV422SemiPlanar = 24;
        public static final int COLOR_FormatYUV444Interleaved = 29;
        public static final int COLOR_QCOM_FormatYUV420SemiPlanar = 2141391872;
        public static final int COLOR_TI_FormatYUV420PackedSemiPlanar = 2130706688;
        public static final String FEATURE_AdaptivePlayback = "adaptive-playback";
        public static final String FEATURE_SecurePlayback = "secure-playback";
        public static final String FEATURE_TunneledPlayback = "tunneled-playback";
        private static final String TAG = "CodecCapabilities";
        private static final Feature[] decoderFeatures;
        public int[] colorFormats;
        private AudioCapabilities mAudioCaps;
        private MediaFormat mCapabilitiesInfo;
        private MediaFormat mDefaultFormat;
        private EncoderCapabilities mEncoderCaps;
        int mError;
        private int mFlagsRequired;
        private int mFlagsSupported;
        private int mFlagsVerified;
        private String mMime;
        private VideoCapabilities mVideoCaps;
        public CodecProfileLevel[] profileLevels;

        static {
            Feature[] featureArray = new Feature[]{new Feature(FEATURE_AdaptivePlayback, 1, true), new Feature(FEATURE_SecurePlayback, 2, false), new Feature(FEATURE_TunneledPlayback, 4, false)};
            decoderFeatures = featureArray;
        }

        public CodecCapabilities() {
        }

        /*
         * Enabled aggressive block sorting
         */
        CodecCapabilities(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, MediaFormat mediaFormat, MediaFormat mediaFormat2) {
            Map<String, Object> map = mediaFormat2.getMap();
            this.profileLevels = codecProfileLevelArray;
            this.colorFormats = nArray;
            this.mFlagsVerified = n;
            this.mDefaultFormat = mediaFormat;
            this.mCapabilitiesInfo = mediaFormat2;
            this.mMime = this.mDefaultFormat.getString("mime");
            if (this.mMime.toLowerCase().startsWith("audio/")) {
                this.mAudioCaps = AudioCapabilities.create(mediaFormat2, this);
                this.mAudioCaps.setDefaultFormat(this.mDefaultFormat);
            } else if (this.mMime.toLowerCase().startsWith("video/")) {
                this.mVideoCaps = VideoCapabilities.create(mediaFormat2, this);
            }
            if (bl) {
                this.mEncoderCaps = EncoderCapabilities.create(mediaFormat2, this);
                this.mEncoderCaps.setDefaultFormat(this.mDefaultFormat);
            }
            Feature[] featureArray = this.getValidFeatures();
            int n2 = featureArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Feature feature = featureArray[n3];
                String string2 = "feature-" + feature.mName;
                Integer n4 = (Integer)map.get(string2);
                if (n4 != null) {
                    if (n4 > 0) {
                        this.mFlagsRequired |= feature.mValue;
                    }
                    this.mFlagsSupported |= feature.mValue;
                    this.mDefaultFormat.setInteger(string2, 1);
                }
                ++n3;
            }
            return;
        }

        CodecCapabilities(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, Map<String, Object> map, Map<String, Object> map2) {
            this(codecProfileLevelArray, nArray, bl, n, new MediaFormat(map), new MediaFormat(map2));
        }

        private boolean checkFeature(String string2, int n) {
            Feature[] featureArray = this.getValidFeatures();
            int n2 = featureArray.length;
            int n3 = 0;
            while (true) {
                block6: {
                    boolean bl;
                    block5: {
                        bl = false;
                        if (n3 >= n2) break block5;
                        Feature feature = featureArray[n3];
                        if (!feature.mName.equals(string2)) break block6;
                        int n4 = n & feature.mValue;
                        bl = false;
                        if (n4 != 0) {
                            bl = true;
                        }
                    }
                    return bl;
                }
                ++n3;
            }
        }

        public static CodecCapabilities createFromProfileLevel(String string2, int n, int n2) {
            CodecProfileLevel codecProfileLevel = new CodecProfileLevel();
            codecProfileLevel.profile = n;
            codecProfileLevel.level = n2;
            MediaFormat mediaFormat = new MediaFormat();
            mediaFormat.setString("mime", string2);
            CodecCapabilities codecCapabilities = new CodecCapabilities(new CodecProfileLevel[]{codecProfileLevel}, new int[0], true, 0, mediaFormat, new MediaFormat());
            if (codecCapabilities.mError != 0) {
                codecCapabilities = null;
            }
            return codecCapabilities;
        }

        private Feature[] getValidFeatures() {
            if (!this.isEncoder()) {
                return decoderFeatures;
            }
            return new Feature[0];
        }

        private boolean isAudio() {
            return this.mAudioCaps != null;
        }

        private boolean isEncoder() {
            return this.mEncoderCaps != null;
        }

        private boolean isVideo() {
            return this.mVideoCaps != null;
        }

        public CodecCapabilities dup() {
            return new CodecCapabilities(Arrays.copyOf(this.profileLevels, this.profileLevels.length), Arrays.copyOf(this.colorFormats, this.colorFormats.length), this.isEncoder(), this.mFlagsVerified, this.mDefaultFormat, this.mCapabilitiesInfo);
        }

        public AudioCapabilities getAudioCapabilities() {
            return this.mAudioCaps;
        }

        public MediaFormat getDefaultFormat() {
            return this.mDefaultFormat;
        }

        public EncoderCapabilities getEncoderCapabilities() {
            return this.mEncoderCaps;
        }

        public String getMimeType() {
            return this.mMime;
        }

        public VideoCapabilities getVideoCapabilities() {
            return this.mVideoCaps;
        }

        public final boolean isFeatureRequired(String string2) {
            return this.checkFeature(string2, this.mFlagsRequired);
        }

        public final boolean isFeatureSupported(String string2) {
            return this.checkFeature(string2, this.mFlagsSupported);
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean isFormatSupported(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            String string2 = (String)map.get("mime");
            if (string2 != null && !this.mMime.equalsIgnoreCase(string2)) return false;
            for (Feature feature : this.getValidFeatures()) {
                Integer n = (Integer)map.get("feature-" + feature.mName);
                if (n == null) continue;
                if (n == 1 && !this.isFeatureSupported(feature.mName)) return false;
                if (n != 0 || !this.isFeatureRequired(feature.mName)) continue;
                return false;
            }
            if (!(this.mAudioCaps != null && !this.mAudioCaps.supportsFormat(mediaFormat) || this.mVideoCaps != null && !this.mVideoCaps.supportsFormat(mediaFormat)) && (this.mEncoderCaps == null || this.mEncoderCaps.supportsFormat(mediaFormat))) return true;
            return false;
        }

        public boolean isRegular() {
            for (Feature feature : this.getValidFeatures()) {
                if (feature.mDefault || !this.isFeatureRequired(feature.mName)) continue;
                return false;
            }
            return true;
        }

        public String[] validFeatures() {
            Feature[] featureArray = this.getValidFeatures();
            String[] stringArray = new String[featureArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = featureArray[i].mName;
            }
            return stringArray;
        }
    }

    public static final class CodecProfileLevel {
        public static final int AACObjectELD = 39;
        public static final int AACObjectERLC = 17;
        public static final int AACObjectHE = 5;
        public static final int AACObjectHE_PS = 29;
        public static final int AACObjectLC = 2;
        public static final int AACObjectLD = 23;
        public static final int AACObjectLTP = 4;
        public static final int AACObjectMain = 1;
        public static final int AACObjectSSR = 3;
        public static final int AACObjectScalable = 6;
        public static final int AVCLevel1 = 1;
        public static final int AVCLevel11 = 4;
        public static final int AVCLevel12 = 8;
        public static final int AVCLevel13 = 16;
        public static final int AVCLevel1b = 2;
        public static final int AVCLevel2 = 32;
        public static final int AVCLevel21 = 64;
        public static final int AVCLevel22 = 128;
        public static final int AVCLevel3 = 256;
        public static final int AVCLevel31 = 512;
        public static final int AVCLevel32 = 1024;
        public static final int AVCLevel4 = 2048;
        public static final int AVCLevel41 = 4096;
        public static final int AVCLevel42 = 8192;
        public static final int AVCLevel5 = 16384;
        public static final int AVCLevel51 = 32768;
        public static final int AVCLevel52 = 65536;
        public static final int AVCProfileBaseline = 1;
        public static final int AVCProfileExtended = 4;
        public static final int AVCProfileHigh = 8;
        public static final int AVCProfileHigh10 = 16;
        public static final int AVCProfileHigh422 = 32;
        public static final int AVCProfileHigh444 = 64;
        public static final int AVCProfileMain = 2;
        public static final int H263Level10 = 1;
        public static final int H263Level20 = 2;
        public static final int H263Level30 = 4;
        public static final int H263Level40 = 8;
        public static final int H263Level45 = 16;
        public static final int H263Level50 = 32;
        public static final int H263Level60 = 64;
        public static final int H263Level70 = 128;
        public static final int H263ProfileBackwardCompatible = 4;
        public static final int H263ProfileBaseline = 1;
        public static final int H263ProfileH320Coding = 2;
        public static final int H263ProfileHighCompression = 32;
        public static final int H263ProfileHighLatency = 256;
        public static final int H263ProfileISWV2 = 8;
        public static final int H263ProfileISWV3 = 16;
        public static final int H263ProfileInterlace = 128;
        public static final int H263ProfileInternet = 64;
        public static final int HEVCHighTierLevel1 = 2;
        public static final int HEVCHighTierLevel2 = 8;
        public static final int HEVCHighTierLevel21 = 32;
        public static final int HEVCHighTierLevel3 = 128;
        public static final int HEVCHighTierLevel31 = 512;
        public static final int HEVCHighTierLevel4 = 2048;
        public static final int HEVCHighTierLevel41 = 8192;
        public static final int HEVCHighTierLevel5 = 32768;
        public static final int HEVCHighTierLevel51 = 131072;
        public static final int HEVCHighTierLevel52 = 524288;
        public static final int HEVCHighTierLevel6 = 0x200000;
        public static final int HEVCHighTierLevel61 = 0x800000;
        public static final int HEVCHighTierLevel62 = 0x2000000;
        public static final int HEVCMainTierLevel1 = 1;
        public static final int HEVCMainTierLevel2 = 4;
        public static final int HEVCMainTierLevel21 = 16;
        public static final int HEVCMainTierLevel3 = 64;
        public static final int HEVCMainTierLevel31 = 256;
        public static final int HEVCMainTierLevel4 = 1024;
        public static final int HEVCMainTierLevel41 = 4096;
        public static final int HEVCMainTierLevel5 = 16384;
        public static final int HEVCMainTierLevel51 = 65536;
        public static final int HEVCMainTierLevel52 = 262144;
        public static final int HEVCMainTierLevel6 = 0x100000;
        public static final int HEVCMainTierLevel61 = 0x400000;
        public static final int HEVCMainTierLevel62 = 0x1000000;
        public static final int HEVCProfileMain = 1;
        public static final int HEVCProfileMain10 = 2;
        public static final int MPEG4Level0 = 1;
        public static final int MPEG4Level0b = 2;
        public static final int MPEG4Level1 = 4;
        public static final int MPEG4Level2 = 8;
        public static final int MPEG4Level3 = 16;
        public static final int MPEG4Level4 = 32;
        public static final int MPEG4Level4a = 64;
        public static final int MPEG4Level5 = 128;
        public static final int MPEG4ProfileAdvancedCoding = 4096;
        public static final int MPEG4ProfileAdvancedCore = 8192;
        public static final int MPEG4ProfileAdvancedRealTime = 1024;
        public static final int MPEG4ProfileAdvancedScalable = 16384;
        public static final int MPEG4ProfileAdvancedSimple = 32768;
        public static final int MPEG4ProfileBasicAnimated = 256;
        public static final int MPEG4ProfileCore = 4;
        public static final int MPEG4ProfileCoreScalable = 2048;
        public static final int MPEG4ProfileHybrid = 512;
        public static final int MPEG4ProfileMain = 8;
        public static final int MPEG4ProfileNbit = 16;
        public static final int MPEG4ProfileScalableTexture = 32;
        public static final int MPEG4ProfileSimple = 1;
        public static final int MPEG4ProfileSimpleFBA = 128;
        public static final int MPEG4ProfileSimpleFace = 64;
        public static final int MPEG4ProfileSimpleScalable = 2;
        public static final int VP8Level_Version0 = 1;
        public static final int VP8Level_Version1 = 2;
        public static final int VP8Level_Version2 = 4;
        public static final int VP8Level_Version3 = 8;
        public static final int VP8ProfileMain = 1;
        public int level;
        public int profile;
    }

    public static final class EncoderCapabilities {
        public static final int BITRATE_MODE_CBR = 2;
        public static final int BITRATE_MODE_CQ = 0;
        public static final int BITRATE_MODE_VBR = 1;
        private static final Feature[] bitrates;
        private int mBitControl;
        private Range<Integer> mComplexityRange;
        private Integer mDefaultComplexity;
        private Integer mDefaultQuality;
        private CodecCapabilities mParent;
        private Range<Integer> mQualityRange;
        private String mQualityScale;

        static {
            Feature[] featureArray = new Feature[]{new Feature("VBR", 1, true), new Feature("CBR", 2, false), new Feature("CQ", 0, false)};
            bitrates = featureArray;
        }

        private EncoderCapabilities() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void applyLevelLimits() {
            String string2 = this.mParent.getMimeType();
            if (string2.equalsIgnoreCase("audio/flac")) {
                this.mComplexityRange = Range.create(0, 8);
                this.mBitControl = 1;
                return;
            } else {
                if (!string2.equalsIgnoreCase("audio/3gpp") && !string2.equalsIgnoreCase("audio/amr-wb") && !string2.equalsIgnoreCase("audio/g711-alaw") && !string2.equalsIgnoreCase("audio/g711-mlaw") && !string2.equalsIgnoreCase("audio/gsm")) return;
                this.mBitControl = 4;
                return;
            }
        }

        public static EncoderCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            EncoderCapabilities encoderCapabilities = new EncoderCapabilities();
            encoderCapabilities.init(mediaFormat, codecCapabilities);
            return encoderCapabilities;
        }

        private static int parseBitrateMode(String string2) {
            for (Feature feature : bitrates) {
                if (!feature.mName.equalsIgnoreCase(string2)) continue;
                return feature.mValue;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void parseFromInfo(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            if (mediaFormat.containsKey("complexity-range")) {
                this.mComplexityRange = Utils.parseIntRange(mediaFormat.getString("complexity-range"), this.mComplexityRange);
            }
            if (mediaFormat.containsKey("quality-range")) {
                this.mQualityRange = Utils.parseIntRange(mediaFormat.getString("quality-range"), this.mQualityRange);
            }
            if (mediaFormat.containsKey("feature-bitrate-control")) {
                String string2;
                String[] stringArray = mediaFormat.getString("feature-bitrate-control").split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; this.mBitControl |= EncoderCapabilities.parseBitrateMode(string2), ++i) {
                    string2 = stringArray[i];
                }
            }
            try {
                this.mDefaultComplexity = Integer.parseInt((String)map.get("complexity-default"));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.mDefaultQuality = Integer.parseInt((String)map.get("quality-default"));
            }
            catch (NumberFormatException numberFormatException) {}
            this.mQualityScale = (String)map.get("quality-scale");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean supports(Integer n, Integer n2, Integer n3) {
            boolean bl = true;
            if (bl && n != null) {
                bl = this.mComplexityRange.contains(n);
            }
            if (bl && n2 != null) {
                bl = this.mQualityRange.contains(n2);
            }
            if (!bl) return bl;
            if (n3 == null) return bl;
            CodecProfileLevel[] codecProfileLevelArray = this.mParent.profileLevels;
            int n4 = codecProfileLevelArray.length;
            int n5 = 0;
            while (true) {
                if (n5 < n4) {
                    if (codecProfileLevelArray[n5].profile == n3) {
                        return true;
                    }
                } else {
                    if (n3 != null) return false;
                    return true;
                }
                ++n5;
            }
        }

        public Range<Integer> getComplexityRange() {
            return this.mComplexityRange;
        }

        public Range<Integer> getQualityRange() {
            return this.mQualityRange;
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            this.mParent = codecCapabilities;
            this.mComplexityRange = Range.create(0, 0);
            this.mQualityRange = Range.create(0, 0);
            this.mBitControl = 2;
            this.applyLevelLimits();
            this.parseFromInfo(mediaFormat);
        }

        public boolean isBitrateModeSupported(int n) {
            Feature[] featureArray = bitrates;
            int n2 = featureArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n != featureArray[i].mValue) continue;
                return (this.mBitControl & 1 << n) != 0;
            }
            return false;
        }

        public void setDefaultFormat(MediaFormat mediaFormat) {
            if (!this.mQualityRange.getUpper().equals(this.mQualityRange.getLower()) && this.mDefaultQuality != null) {
                mediaFormat.setInteger("quality", this.mDefaultQuality);
            }
            if (!this.mComplexityRange.getUpper().equals(this.mComplexityRange.getLower()) && this.mDefaultComplexity != null) {
                mediaFormat.setInteger("complexity", this.mDefaultComplexity);
            }
            Feature[] featureArray = bitrates;
            int n = featureArray.length;
            int n2 = 0;
            while (true) {
                block7: {
                    block6: {
                        if (n2 >= n) break block6;
                        Feature feature = featureArray[n2];
                        if ((this.mBitControl & 1 << feature.mValue) == 0) break block7;
                        mediaFormat.setInteger("bitrate-mode", feature.mValue);
                    }
                    return;
                }
                ++n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean supportsFormat(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            String string2 = this.mParent.getMimeType();
            Integer n = (Integer)map.get("bitrate-mode");
            if (n != null && !this.isBitrateModeSupported(n)) {
                return false;
            }
            Integer n2 = (Integer)map.get("complexity");
            if ("audio/flac".equalsIgnoreCase(string2)) {
                Integer n3 = (Integer)map.get("flac-compression-level");
                if (n2 == null) {
                    n2 = n3;
                } else if (n3 != null && n2 != n3) {
                    throw new IllegalArgumentException("conflicting values for complexity and flac-compression-level");
                }
            }
            Integer n4 = (Integer)map.get("profile");
            if (!"audio/mp4a-latm".equalsIgnoreCase(string2)) return this.supports(n2, (Integer)map.get("quality"), n4);
            Integer n5 = (Integer)map.get("aac-profile");
            if (n4 == null) {
                n4 = n5;
                return this.supports(n2, (Integer)map.get("quality"), n4);
            } else {
                if (n5 == null || n5 == n4) return this.supports(n2, (Integer)map.get("quality"), n4);
                throw new IllegalArgumentException("conflicting values for profile and aac-profile");
            }
        }
    }

    private static class Feature {
        public boolean mDefault;
        public String mName;
        public int mValue;

        public Feature(String string2, int n, boolean bl) {
            this.mName = string2;
            this.mValue = n;
            this.mDefault = bl;
        }
    }

    public static final class VideoCapabilities {
        private static final String TAG = "VideoCapabilities";
        private Range<Rational> mAspectRatioRange;
        private Range<Integer> mBitrateRange;
        private Range<Rational> mBlockAspectRatioRange;
        private Range<Integer> mBlockCountRange;
        private int mBlockHeight;
        private int mBlockWidth;
        private Range<Long> mBlocksPerSecondRange;
        private Range<Integer> mFrameRateRange;
        private int mHeightAlignment;
        private Range<Integer> mHeightRange;
        private Range<Integer> mHorizontalBlockRange;
        private CodecCapabilities mParent;
        private int mSmallerDimensionUpperLimit;
        private Range<Integer> mVerticalBlockRange;
        private int mWidthAlignment;
        private Range<Integer> mWidthRange;

        private VideoCapabilities() {
        }

        private void applyAlignment(int n, int n2) {
            MediaCodecInfo.checkPowerOfTwo(n, "widthAlignment must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(n2, "heightAlignment must be a power of two");
            if (n > this.mBlockWidth || n2 > this.mBlockHeight) {
                this.applyBlockLimits(Math.max(n, this.mBlockWidth), Math.max(n2, this.mBlockHeight), POSITIVE_INTEGERS, POSITIVE_LONGS, POSITIVE_RATIONALS);
            }
            this.mWidthAlignment = Math.max(n, this.mWidthAlignment);
            this.mHeightAlignment = Math.max(n2, this.mHeightAlignment);
            this.mWidthRange = Utils.alignRange(this.mWidthRange, this.mWidthAlignment);
            this.mHeightRange = Utils.alignRange(this.mHeightRange, this.mHeightAlignment);
        }

        private void applyBlockLimits(int n, int n2, Range<Integer> range, Range<Long> range2, Range<Rational> range3) {
            int n3;
            MediaCodecInfo.checkPowerOfTwo(n, "blockWidth must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(n2, "blockHeight must be a power of two");
            int n4 = Math.max(n, this.mBlockWidth);
            int n5 = Math.max(n2, this.mBlockHeight);
            int n6 = n4 * n5 / this.mBlockWidth / this.mBlockHeight;
            if (n6 != 1) {
                this.mBlockCountRange = Utils.factorRange(this.mBlockCountRange, n6);
                this.mBlocksPerSecondRange = Utils.factorRange(this.mBlocksPerSecondRange, (long)n6);
                this.mBlockAspectRatioRange = Utils.scaleRange(this.mBlockAspectRatioRange, n5 / this.mBlockHeight, n4 / this.mBlockWidth);
                this.mHorizontalBlockRange = Utils.factorRange(this.mHorizontalBlockRange, n4 / this.mBlockWidth);
                this.mVerticalBlockRange = Utils.factorRange(this.mVerticalBlockRange, n5 / this.mBlockHeight);
            }
            if ((n3 = n4 * n5 / n / n2) != 1) {
                range = Utils.factorRange(range, n3);
                range2 = Utils.factorRange(range2, (long)n3);
                range3 = Utils.scaleRange(range3, n5 / n2, n4 / n);
            }
            this.mBlockCountRange = this.mBlockCountRange.intersect(range);
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(range2);
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(range3);
            this.mBlockWidth = n4;
            this.mBlockHeight = n5;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private void applyLevelLimits() {
            block107: {
                block105: {
                    block103: {
                        block101: {
                            block108: {
                                block99: {
                                    block106: {
                                        block104: {
                                            block102: {
                                                block100: {
                                                    block98: {
                                                        var1_1 = 4;
                                                        var2_2 = this.mParent.profileLevels;
                                                        var3_3 = this.mParent.getMimeType();
                                                        if (!var3_3.equalsIgnoreCase("video/avc")) break block98;
                                                        var66_4 = 99;
                                                        var67_5 = 1485;
                                                        var4_6 = 64000;
                                                        var68_7 = 396;
                                                        var69_8 = var2_2.length;
                                                        break block99;
                                                    }
                                                    if (!var3_3.equalsIgnoreCase("video/mp4v-es")) break block100;
                                                    var45_19 = 11;
                                                    var46_20 = 9;
                                                    var47_21 = 15;
                                                    var48_22 = 99;
                                                    var49_23 = 1485;
                                                    var4_6 = 64000;
                                                    var50_24 = var2_2.length;
                                                    break block101;
                                                }
                                                if (!var3_3.equalsIgnoreCase("video/3gpp")) break block102;
                                                var28_35 = 11;
                                                var29_36 = 9;
                                                var30_37 = 15;
                                                var31_38 = 99;
                                                var32_39 = 1485;
                                                var4_6 = 64000;
                                                var33_40 = var2_2.length;
                                                break block103;
                                            }
                                            if (!var3_3.equalsIgnoreCase("video/x-vnd.on2.vp8") && !var3_3.equalsIgnoreCase("video/x-vnd.on2.vp9")) break block104;
                                            var4_6 = 100000000;
                                            var5_49 = var2_2.length;
                                            break block105;
                                        }
                                        if (!var3_3.equalsIgnoreCase("video/hevc")) break block106;
                                        var13_53 = 36864;
                                        var14_54 = var13_53 * 15;
                                        var4_6 = 128000;
                                        var15_55 = var2_2.length;
                                        break block107;
                                    }
                                    Log.w("VideoCapabilities", "Unsupported mime " + var3_3);
                                    var4_6 = 64000;
                                    var1_1 |= 2;
                                    break block108;
                                }
                                for (var70_9 = 0; var70_9 < var69_8; ++var70_9) {
                                    block109: {
                                        var72_10 = var2_2[var70_9];
                                        var73_11 = 0;
                                        var74_12 = 0;
                                        var75_13 = 0;
                                        var76_14 = 0;
                                        var77_15 = true;
                                        switch (var72_10.level) {
                                            default: {
                                                Log.w("VideoCapabilities", "Unrecognized level " + var72_10.level + " for " + var3_3);
                                                var1_1 |= 1;
                                                break;
                                            }
                                            case 1: {
                                                var73_11 = 1485;
                                                var74_12 = 99;
                                                var75_13 = 64;
                                                var76_14 = 396;
                                                break;
                                            }
                                            case 2: {
                                                var73_11 = 1485;
                                                var74_12 = 99;
                                                var75_13 = 128;
                                                var76_14 = 396;
                                                break;
                                            }
                                            case 4: {
                                                var73_11 = 3000;
                                                var74_12 = 396;
                                                var75_13 = 192;
                                                var76_14 = 900;
                                                break;
                                            }
                                            case 8: {
                                                var73_11 = 6000;
                                                var74_12 = 396;
                                                var75_13 = 384;
                                                var76_14 = 2376;
                                                break;
                                            }
                                            case 16: {
                                                var73_11 = 11880;
                                                var74_12 = 396;
                                                var75_13 = 768;
                                                var76_14 = 2376;
                                                break;
                                            }
                                            case 32: {
                                                var73_11 = 11880;
                                                var74_12 = 396;
                                                var75_13 = 2000;
                                                var76_14 = 2376;
                                                break;
                                            }
                                            case 64: {
                                                var73_11 = 19800;
                                                var74_12 = 792;
                                                var75_13 = 4000;
                                                var76_14 = 4752;
                                                break;
                                            }
                                            case 128: {
                                                var73_11 = 20250;
                                                var74_12 = 1620;
                                                var75_13 = 4000;
                                                var76_14 = 8100;
                                                break;
                                            }
                                            case 256: {
                                                var73_11 = 40500;
                                                var74_12 = 1620;
                                                var75_13 = 10000;
                                                var76_14 = 8100;
                                                break;
                                            }
                                            case 512: {
                                                var73_11 = 108000;
                                                var74_12 = 3600;
                                                var75_13 = 14000;
                                                var76_14 = 18000;
                                                break;
                                            }
                                            case 1024: {
                                                var73_11 = 216000;
                                                var74_12 = 5120;
                                                var75_13 = 20000;
                                                var76_14 = 20480;
                                                break;
                                            }
                                            case 2048: {
                                                var73_11 = 245760;
                                                var74_12 = 8192;
                                                var75_13 = 20000;
                                                var76_14 = 32768;
                                                break;
                                            }
                                            case 4096: {
                                                var73_11 = 245760;
                                                var74_12 = 8192;
                                                var75_13 = 50000;
                                                var76_14 = 32768;
                                                break;
                                            }
                                            case 8192: {
                                                var73_11 = 522240;
                                                var74_12 = 8704;
                                                var75_13 = 50000;
                                                var76_14 = 34816;
                                                break;
                                            }
                                            case 16384: {
                                                var73_11 = 589824;
                                                var74_12 = 22080;
                                                var75_13 = 135000;
                                                var76_14 = 110400;
                                                break;
                                            }
                                            case 32768: {
                                                var73_11 = 983040;
                                                var74_12 = 36864;
                                                var75_13 = 240000;
                                                var76_14 = 184320;
                                                break;
                                            }
                                            case 65536: {
                                                var73_11 = 2073600;
                                                var74_12 = 36864;
                                                var75_13 = 240000;
                                                var76_14 = 184320;
                                            }
                                        }
                                        switch (var72_10.profile) {
                                            default: {
                                                Log.w("VideoCapabilities", "Unrecognized profile " + var72_10.profile + " for " + var3_3);
                                                var1_1 |= 1;
                                                var78_16 = 1000 * var75_13;
                                                break block109;
                                            }
                                            case 8: {
                                                var78_16 = 1250 * var75_13;
                                                break block109;
                                            }
                                            case 16: {
                                                var78_16 = 3000 * var75_13;
                                                break block109;
                                            }
                                            case 4: 
                                            case 32: 
                                            case 64: {
                                                Log.w("VideoCapabilities", "Unsupported profile " + var72_10.profile + " for " + var3_3);
                                                var1_1 |= 2;
                                                var77_15 = false;
                                                break;
                                            }
                                            case 1: 
                                            case 2: 
                                        }
                                        var78_16 = 1000 * var75_13;
                                    }
                                    if (var77_15) {
                                        var1_1 &= -5;
                                    }
                                    var67_5 = Math.max(var73_11, var67_5);
                                    var66_4 = Math.max(var74_12, var66_4);
                                    var4_6 = Math.max(var78_16, var4_6);
                                    var68_7 = Math.max(var68_7, var76_14);
                                }
                                var71_17 = (int)Math.sqrt(var66_4 * 8);
                                this.applyMacroBlockLimits(var71_17, var71_17, var66_4, var67_5, 16, 16, 1, 1);
                            }
lbl196:
                            // 5 sources

                            while (true) {
                                this.mBitrateRange = Range.create(1, var4_6);
                                var8_18 = this.mParent;
                                var8_18.mError = var1_1 | var8_18.mError;
                                return;
                            }
                        }
                        for (var51_25 = 0; var51_25 < var50_24; ++var51_25) {
                            var54_26 = var2_2[var51_25];
                            var55_27 = 0;
                            var56_28 = 0;
                            var57_29 = 0;
                            var58_30 = 0;
                            var59_31 = 0;
                            var60_32 = 0;
                            var61_33 = true;
                            block25 : switch (var54_26.profile) {
                                default: {
                                    Log.w("VideoCapabilities", "Unrecognized profile " + var54_26.profile + " for " + var3_3);
                                    var1_1 |= 1;
                                    break;
                                }
                                case 1: {
                                    switch (var54_26.level) {
                                        default: {
                                            Log.w("VideoCapabilities", "Unrecognized profile/level " + var54_26.profile + "/" + var54_26.level + " for " + var3_3);
                                            var1_1 |= 1;
                                            var57_29 = 0;
                                            var58_30 = 0;
                                            var56_28 = 0;
                                            var60_32 = 0;
                                            var55_27 = 0;
                                            var59_31 = 0;
                                            break block25;
                                        }
                                        case 1: {
                                            var58_30 = 15;
                                            var59_31 = 11;
                                            var60_32 = 9;
                                            var55_27 = 1485;
                                            var56_28 = 99;
                                            var57_29 = 64;
                                            break block25;
                                        }
                                        case 4: {
                                            var58_30 = 30;
                                            var59_31 = 11;
                                            var60_32 = 9;
                                            var55_27 = 1485;
                                            var56_28 = 99;
                                            var57_29 = 64;
                                            break block25;
                                        }
                                        case 2: {
                                            var58_30 = 30;
                                            var59_31 = 11;
                                            var60_32 = 9;
                                            var55_27 = 1485;
                                            var56_28 = 99;
                                            var57_29 = 128;
                                            break block25;
                                        }
                                        case 8: {
                                            var58_30 = 30;
                                            var59_31 = 22;
                                            var60_32 = 18;
                                            var55_27 = 5940;
                                            var56_28 = 396;
                                            var57_29 = 128;
                                            break block25;
                                        }
                                        case 16: {
                                            var58_30 = 30;
                                            var59_31 = 22;
                                            var60_32 = 18;
                                            var55_27 = 11880;
                                            var56_28 = 396;
                                            var57_29 = 384;
                                            break block25;
                                        }
                                        case 32: 
                                        case 64: 
                                        case 128: 
                                    }
                                    var58_30 = 30;
                                    var59_31 = 22;
                                    var60_32 = 18;
                                    var55_27 = 11880;
                                    var56_28 = 396;
                                    var57_29 = 384;
                                    var61_33 = false;
                                    break;
                                }
                                case 32768: {
                                    switch (var54_26.level) {
                                        default: {
                                            Log.w("VideoCapabilities", "Unrecognized profile/level " + var54_26.profile + "/" + var54_26.level + " for " + var3_3);
                                            var1_1 |= 1;
                                            var57_29 = 0;
                                            var58_30 = 0;
                                            var56_28 = 0;
                                            var60_32 = 0;
                                            var55_27 = 0;
                                            var59_31 = 0;
                                            break block25;
                                        }
                                        case 1: 
                                        case 4: {
                                            var58_30 = 30;
                                            var59_31 = 11;
                                            var60_32 = 9;
                                            var55_27 = 2970;
                                            var56_28 = 99;
                                            var57_29 = 128;
                                            break block25;
                                        }
                                        case 8: {
                                            var58_30 = 30;
                                            var59_31 = 22;
                                            var60_32 = 18;
                                            var55_27 = 5940;
                                            var56_28 = 396;
                                            var57_29 = 384;
                                            break block25;
                                        }
                                        case 16: {
                                            var58_30 = 30;
                                            var59_31 = 22;
                                            var60_32 = 18;
                                            var55_27 = 11880;
                                            var56_28 = 396;
                                            var57_29 = 768;
                                            break block25;
                                        }
                                        case 32: 
                                        case 64: {
                                            var58_30 = 30;
                                            var59_31 = 44;
                                            var60_32 = 36;
                                            var55_27 = 23760;
                                            var56_28 = 792;
                                            var57_29 = 3000;
                                            break block25;
                                        }
                                        case 128: 
                                    }
                                    var58_30 = 30;
                                    var59_31 = 45;
                                    var60_32 = 36;
                                    var55_27 = 48600;
                                    var56_28 = 1620;
                                    var57_29 = 8000;
                                    break;
                                }
                                case 2: 
                                case 4: 
                                case 8: 
                                case 16: 
                                case 32: 
                                case 64: 
                                case 128: 
                                case 256: 
                                case 512: 
                                case 1024: 
                                case 2048: 
                                case 4096: 
                                case 8192: 
                                case 16384: {
                                    Log.i("VideoCapabilities", "Unsupported profile " + var54_26.profile + " for " + var3_3);
                                    var1_1 |= 2;
                                    var57_29 = 0;
                                    var58_30 = 0;
                                    var56_28 = 0;
                                    var60_32 = 0;
                                    var55_27 = 0;
                                    var59_31 = 0;
                                    var61_33 = false;
                                }
                            }
                            if (var61_33) {
                                var1_1 &= -5;
                            }
                            var49_23 = Math.max(var55_27, var49_23);
                            var48_22 = Math.max(var56_28, var48_22);
                            var4_6 = Math.max(1000 * var57_29, var4_6);
                            var45_19 = Math.max(var59_31, var45_19);
                            var46_20 = Math.max(var60_32, var46_20);
                            var47_21 = Math.max(var58_30, var47_21);
                        }
                        var52_34 = var49_23;
                        this.applyMacroBlockLimits(var45_19, var46_20, var48_22, var52_34, 16, 16, 1, 1);
                        this.mFrameRateRange = this.mFrameRateRange.intersect(12, var47_21);
                        ** GOTO lbl196
                    }
                    for (var34_41 = 0; var34_41 < var33_40; var1_1 &= -5, ++var34_41) {
                        var37_42 = var2_2[var34_41];
                        var38_43 = 0;
                        var39_44 = 0;
                        var40_45 = 0;
                        var41_46 = 0;
                        var42_47 = 0;
                        switch (var37_42.level) {
                            default: {
                                Log.w("VideoCapabilities", "Unrecognized profile/level " + var37_42.profile + "/" + var37_42.level + " for " + var3_3);
                                var1_1 |= 1;
                                break;
                            }
                            case 1: {
                                var40_45 = 15;
                                var41_46 = 11;
                                var42_47 = 9;
                                var39_44 = 1;
                                var38_43 = var40_45 * 99;
                                break;
                            }
                            case 2: {
                                var40_45 = 30;
                                var41_46 = 22;
                                var42_47 = 18;
                                var39_44 = 2;
                                var38_43 = 396 * var40_45;
                                break;
                            }
                            case 4: {
                                var40_45 = 30;
                                var41_46 = 22;
                                var42_47 = 18;
                                var39_44 = 6;
                                var38_43 = 396 * var40_45;
                                break;
                            }
                            case 8: {
                                var40_45 = 30;
                                var41_46 = 22;
                                var42_47 = 18;
                                var39_44 = 32;
                                var38_43 = 396 * var40_45;
                                break;
                            }
                            case 16: {
                                var40_45 = 30;
                                var41_46 = 11;
                                var42_47 = 9;
                                var39_44 = 2;
                                var38_43 = var40_45 * 99;
                                break;
                            }
                            case 32: {
                                var40_45 = 60;
                                var41_46 = 22;
                                var42_47 = 18;
                                var39_44 = 64;
                                var38_43 = 396 * 50;
                                break;
                            }
                            case 64: {
                                var40_45 = 60;
                                var41_46 = 45;
                                var42_47 = 18;
                                var39_44 = 128;
                                var38_43 = 810 * 50;
                                break;
                            }
                            case 128: {
                                var40_45 = 60;
                                var41_46 = 45;
                                var42_47 = 36;
                                var39_44 = 256;
                                var38_43 = 1620 * 50;
                            }
                        }
                        switch (var37_42.profile) {
                            default: {
                                Log.w("VideoCapabilities", "Unrecognized profile " + var37_42.profile + " for " + var3_3);
                                var1_1 |= 1;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 4: 
                            case 8: 
                            case 16: 
                            case 32: 
                            case 64: 
                            case 128: 
                            case 256: 
                        }
                        var32_39 = Math.max(var38_43, var32_39);
                        var31_38 = Math.max(var41_46 * var42_47, var31_38);
                        var4_6 = Math.max(64000 * var39_44, var4_6);
                        var28_35 = Math.max(var41_46, var28_35);
                        var29_36 = Math.max(var42_47, var29_36);
                        var30_37 = Math.max(var40_45, var30_37);
                    }
                    var35_48 = var32_39;
                    this.applyMacroBlockLimits(var28_35, var29_36, var31_38, var35_48, 16, 16, 1, 1);
                    this.mFrameRateRange = Range.create(1, var30_37);
                    ** GOTO lbl196
                }
                block94: for (var6_50 = 0; var6_50 < var5_49; var1_1 &= -5, ++var6_50) {
                    var9_51 = var2_2[var6_50];
                    switch (var9_51.level) {
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized level " + var9_51.level + " for " + var3_3);
                            var1_1 |= 1;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                    }
                    switch (var9_51.profile) {
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + var9_51.profile + " for " + var3_3);
                            var1_1 |= 1;
                            continue block94;
                        }
                        case 1: 
                    }
                }
                var7_52 = var3_3.equalsIgnoreCase("video/x-vnd.on2.vp8") != false ? 16 : 8;
                this.applyMacroBlockLimits(32767, 32767, 0x7FFFFFFF, 0x7FFFFFFF, var7_52, var7_52, 1, 1);
                ** GOTO lbl196
            }
            for (var16_56 = 0; var16_56 < var15_55; var1_1 &= -5, ++var16_56) {
                var21_57 = var2_2[var16_56];
                var22_58 = 0.0;
                var24_59 = 0;
                var25_60 = 0;
                switch (var21_57.level) {
                    default: {
                        Log.w("VideoCapabilities", "Unrecognized level " + var21_57.level + " for " + var3_3);
                        var1_1 |= 1;
                        break;
                    }
                    case 1: 
                    case 2: {
                        var22_58 = 15.0;
                        var24_59 = 36864;
                        var25_60 = 128;
                        break;
                    }
                    case 4: 
                    case 8: {
                        var22_58 = 30.0;
                        var24_59 = 122880;
                        var25_60 = 1500;
                        break;
                    }
                    case 16: 
                    case 32: {
                        var22_58 = 30.0;
                        var24_59 = 245760;
                        var25_60 = 3000;
                        break;
                    }
                    case 64: 
                    case 128: {
                        var22_58 = 30.0;
                        var24_59 = 552960;
                        var25_60 = 6000;
                        break;
                    }
                    case 256: 
                    case 512: {
                        var22_58 = 33.75;
                        var24_59 = 983040;
                        var25_60 = 10000;
                        break;
                    }
                    case 1024: {
                        var22_58 = 30.0;
                        var24_59 = 0x220000;
                        var25_60 = 12000;
                        break;
                    }
                    case 2048: {
                        var22_58 = 30.0;
                        var24_59 = 0x220000;
                        var25_60 = 30000;
                        break;
                    }
                    case 4096: {
                        var22_58 = 60.0;
                        var24_59 = 0x220000;
                        var25_60 = 20000;
                        break;
                    }
                    case 8192: {
                        var22_58 = 60.0;
                        var24_59 = 0x220000;
                        var25_60 = 50000;
                        break;
                    }
                    case 16384: {
                        var22_58 = 30.0;
                        var24_59 = 0x880000;
                        var25_60 = 25000;
                        break;
                    }
                    case 32768: {
                        var22_58 = 30.0;
                        var24_59 = 0x880000;
                        var25_60 = 100000;
                        break;
                    }
                    case 65536: {
                        var22_58 = 60.0;
                        var24_59 = 0x880000;
                        var25_60 = 40000;
                        break;
                    }
                    case 131072: {
                        var22_58 = 60.0;
                        var24_59 = 0x880000;
                        var25_60 = 160000;
                        break;
                    }
                    case 262144: {
                        var22_58 = 120.0;
                        var24_59 = 0x880000;
                        var25_60 = 60000;
                        break;
                    }
                    case 524288: {
                        var22_58 = 120.0;
                        var24_59 = 0x880000;
                        var25_60 = 240000;
                        break;
                    }
                    case 0x100000: {
                        var22_58 = 30.0;
                        var24_59 = 0x2200000;
                        var25_60 = 60000;
                        break;
                    }
                    case 0x200000: {
                        var22_58 = 30.0;
                        var24_59 = 0x2200000;
                        var25_60 = 240000;
                        break;
                    }
                    case 0x400000: {
                        var22_58 = 60.0;
                        var24_59 = 0x2200000;
                        var25_60 = 120000;
                        break;
                    }
                    case 0x800000: {
                        var22_58 = 60.0;
                        var24_59 = 0x2200000;
                        var25_60 = 480000;
                        break;
                    }
                    case 0x1000000: {
                        var22_58 = 120.0;
                        var24_59 = 0x2200000;
                        var25_60 = 240000;
                        break;
                    }
                    case 0x2000000: {
                        var22_58 = 120.0;
                        var24_59 = 0x2200000;
                        var25_60 = 800000;
                    }
                }
                switch (var21_57.profile) {
                    default: {
                        Log.w("VideoCapabilities", "Unrecognized profile " + var21_57.profile + " for " + var3_3);
                        var1_1 |= 1;
                        break;
                    }
                    case 1: 
                    case 2: 
                }
                var14_54 = Math.max((int)(var22_58 * (double)var24_59), var14_54);
                var13_53 = Math.max(var24_59, var13_53);
                var4_6 = Math.max(1000 * var25_60, var4_6);
            }
            var17_61 = (int)Math.sqrt(var13_53 * 8);
            var18_62 = Utils.divUp(var13_53, 64);
            var19_63 = Utils.divUp(var14_54, 64);
            var20_64 = Utils.divUp(var17_61, 8);
            this.applyMacroBlockLimits(var20_64, var20_64, var18_62, var19_63, 8, 8, 1, 1);
            ** while (true)
        }

        private void applyMacroBlockLimits(int n, int n2, int n3, long l, int n4, int n5, int n6, int n7) {
            this.applyAlignment(n6, n7);
            this.applyBlockLimits(n4, n5, Range.create(1, n3), Range.create(1L, l), Range.create(new Rational(1, n2), new Rational(n, 1)));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(1, n / (this.mBlockWidth / n4));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(1, n2 / (this.mBlockHeight / n5));
        }

        public static VideoCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            VideoCapabilities videoCapabilities = new VideoCapabilities();
            videoCapabilities.init(mediaFormat, codecCapabilities);
            return videoCapabilities;
        }

        private void initWithPlatformLimits() {
            this.mBitrateRange = Range.create(0, Integer.MAX_VALUE);
            this.mWidthRange = SIZE_RANGE;
            this.mHeightRange = SIZE_RANGE;
            this.mFrameRateRange = FRAME_RATE_RANGE;
            this.mHorizontalBlockRange = SIZE_RANGE;
            this.mVerticalBlockRange = SIZE_RANGE;
            this.mBlockCountRange = POSITIVE_INTEGERS;
            this.mBlocksPerSecondRange = POSITIVE_LONGS;
            this.mBlockAspectRatioRange = POSITIVE_RATIONALS;
            this.mAspectRatioRange = POSITIVE_RATIONALS;
            this.mWidthAlignment = 2;
            this.mHeightAlignment = 2;
            this.mBlockWidth = 2;
            this.mBlockHeight = 2;
            this.mSmallerDimensionUpperLimit = (Integer)SIZE_RANGE.getUpper();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void parseFromInfo(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            Size size = new Size(this.mBlockWidth, this.mBlockHeight);
            Size size2 = new Size(this.mWidthAlignment, this.mHeightAlignment);
            Size size3 = Utils.parseSize(map.get("block-size"), size);
            Size size4 = Utils.parseSize(map.get("alignment"), size2);
            Range<Integer> range = Utils.parseIntRange(map.get("block-count-range"), null);
            Range<Long> range2 = Utils.parseLongRange(map.get("blocks-per-second-range"), null);
            Object object = map.get("size-range");
            Pair<Size, Size> pair = Utils.parseSizeRange(object);
            Range<Integer> range3 = null;
            Range<Integer> range4 = null;
            if (pair != null) {
                try {
                    range4 = Range.create(((Size)pair.first).getWidth(), ((Size)pair.second).getWidth());
                    Range<Integer> range5 = Range.create(((Size)pair.first).getHeight(), ((Size)pair.second).getHeight());
                    range3 = range5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w(TAG, "could not parse size range '" + object + "'");
                    range3 = null;
                    range4 = null;
                }
            }
            if (Integer.valueOf(1).equals(map.get("feature-can-swap-width-height"))) {
                if (range4 != null) {
                    this.mSmallerDimensionUpperLimit = Math.min((Integer)range4.getUpper(), (Integer)range3.getUpper());
                    range3 = range4.extend((Integer)((Object)range3));
                    range4 = range3;
                } else {
                    Log.w(TAG, "feature can-swap-width-height is best used with size-range");
                    this.mSmallerDimensionUpperLimit = Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper());
                    Range<Range<Integer>> range6 = this.mWidthRange.extend((Integer)((Object)this.mHeightRange));
                    this.mHeightRange = range6;
                    this.mWidthRange = range6;
                }
            }
            Range<Rational> range7 = Utils.parseRationalRange(map.get("block-aspect-ratio-range"), null);
            Range<Rational> range8 = Utils.parseRationalRange(map.get("pixel-aspect-ratio-range"), null);
            Range<Integer> range9 = Utils.parseIntRange(map.get("frame-rate-range"), null);
            if (range9 != null) {
                try {
                    Range range10 = FRAME_RATE_RANGE;
                    Range<Integer> range11 = range9.intersect(range10);
                    range9 = range11;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w(TAG, "frame rate range (" + range9 + ") is out of limits: " + FRAME_RATE_RANGE);
                    range9 = null;
                }
            }
            MediaCodecInfo.checkPowerOfTwo(size3.getWidth(), "block-size width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(size3.getHeight(), "block-size height must be power of two");
            MediaCodecInfo.checkPowerOfTwo(size4.getWidth(), "alignment width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(size4.getHeight(), "alignment height must be power of two");
            this.applyMacroBlockLimits(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, size3.getWidth(), size3.getHeight(), size4.getWidth(), size4.getHeight());
            if ((2 & this.mParent.mError) != 0) {
                if (range4 != null) {
                    this.mWidthRange = SIZE_RANGE.intersect(range4);
                }
                if (range3 != null) {
                    this.mHeightRange = SIZE_RANGE.intersect(range3);
                }
                if (range != null) {
                    this.mBlockCountRange = POSITIVE_INTEGERS.intersect(Utils.factorRange(range, this.mBlockWidth * this.mBlockHeight / size3.getWidth() / size3.getHeight()));
                }
                if (range2 != null) {
                    this.mBlocksPerSecondRange = POSITIVE_LONGS.intersect(Utils.factorRange(range2, (long)(this.mBlockWidth * this.mBlockHeight / size3.getWidth() / size3.getHeight())));
                }
                if (range8 != null) {
                    this.mBlockAspectRatioRange = POSITIVE_RATIONALS.intersect(Utils.scaleRange(range8, this.mBlockHeight / size3.getHeight(), this.mBlockWidth / size3.getWidth()));
                }
                if (range7 != null) {
                    this.mAspectRatioRange = POSITIVE_RATIONALS.intersect(range7);
                }
                if (range9 != null) {
                    this.mFrameRateRange = FRAME_RATE_RANGE.intersect(range9);
                }
            } else {
                if (range4 != null) {
                    this.mWidthRange = this.mWidthRange.intersect(range4);
                }
                if (range3 != null) {
                    this.mHeightRange = this.mHeightRange.intersect(range3);
                }
                if (range != null) {
                    this.mBlockCountRange = this.mBlockCountRange.intersect(Utils.factorRange(range, this.mBlockWidth * this.mBlockHeight / size3.getWidth() / size3.getHeight()));
                }
                if (range2 != null) {
                    this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(Utils.factorRange(range2, (long)(this.mBlockWidth * this.mBlockHeight / size3.getWidth() / size3.getHeight())));
                }
                if (range8 != null) {
                    this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(Utils.scaleRange(range8, this.mBlockHeight / size3.getHeight(), this.mBlockWidth / size3.getWidth()));
                }
                if (range7 != null) {
                    this.mAspectRatioRange = this.mAspectRatioRange.intersect(range7);
                }
                if (range9 != null) {
                    this.mFrameRateRange = this.mFrameRateRange.intersect(range9);
                }
            }
            this.updateLimits();
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean supports(Integer n, Integer n2, Double d) {
            boolean bl = true;
            if (bl && n != null) {
                if (!this.mWidthRange.contains(n)) return false;
                if (n % this.mWidthAlignment != 0) return false;
                bl = true;
            }
            if (bl && n2 != null) {
                if (!this.mHeightRange.contains(n2)) return false;
                if (n2 % this.mHeightAlignment != 0) return false;
                bl = true;
            }
            if (bl && d != null) {
                bl = this.mFrameRateRange.contains((Integer)((Object)Utils.intRangeFor(d)));
            }
            if (!bl) return bl;
            if (n2 == null) return bl;
            if (n == null) return bl;
            boolean bl2 = Math.min(n2, n) <= this.mSmallerDimensionUpperLimit;
            int n3 = Utils.divUp(n, this.mBlockWidth);
            int n4 = Utils.divUp(n2, this.mBlockHeight);
            int n5 = n3 * n4;
            if (!bl2) return false;
            if (!this.mBlockCountRange.contains(n5)) return false;
            if (!this.mBlockAspectRatioRange.contains(new Rational(n3, n4))) return false;
            if (!this.mAspectRatioRange.contains(new Rational(n, n2))) return false;
            bl = true;
            if (!bl) return bl;
            if (d == null) return bl;
            double d2 = (double)n5 * d;
            return this.mBlocksPerSecondRange.contains((Long)((Object)Utils.longRangeFor(d2)));
        }

        private void updateLimits() {
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Utils.factorRange(this.mWidthRange, this.mBlockWidth));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mVerticalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mVerticalBlockRange.getLower()));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Utils.factorRange(this.mHeightRange, this.mBlockHeight));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mHorizontalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mHorizontalBlockRange.getLower()));
            this.mBlockCountRange = this.mBlockCountRange.intersect(Range.create(this.mHorizontalBlockRange.getLower() * this.mVerticalBlockRange.getLower(), this.mHorizontalBlockRange.getUpper() * this.mVerticalBlockRange.getUpper()));
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(new Rational(this.mHorizontalBlockRange.getLower(), this.mVerticalBlockRange.getUpper()), new Rational(this.mHorizontalBlockRange.getUpper(), this.mVerticalBlockRange.getLower()));
            this.mWidthRange = this.mWidthRange.intersect((-1 + this.mHorizontalBlockRange.getLower()) * this.mBlockWidth + this.mWidthAlignment, this.mHorizontalBlockRange.getUpper() * this.mBlockWidth);
            this.mHeightRange = this.mHeightRange.intersect((-1 + this.mVerticalBlockRange.getLower()) * this.mBlockHeight + this.mHeightAlignment, this.mVerticalBlockRange.getUpper() * this.mBlockHeight);
            this.mAspectRatioRange = this.mAspectRatioRange.intersect(new Rational(this.mWidthRange.getLower(), this.mHeightRange.getUpper()), new Rational(this.mWidthRange.getUpper(), this.mHeightRange.getLower()));
            this.mSmallerDimensionUpperLimit = Math.min(this.mSmallerDimensionUpperLimit, Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper()));
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect((long)this.mBlockCountRange.getLower().intValue() * (long)this.mFrameRateRange.getLower().intValue(), (long)this.mBlockCountRange.getUpper().intValue() * (long)this.mFrameRateRange.getUpper().intValue());
            this.mFrameRateRange = this.mFrameRateRange.intersect((int)(this.mBlocksPerSecondRange.getLower() / (long)this.mBlockCountRange.getUpper().intValue()), (int)((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)this.mBlockCountRange.getLower().intValue()));
        }

        public boolean areSizeAndRateSupported(int n, int n2, double d) {
            return this.supports(n, n2, d);
        }

        public Range<Rational> getAspectRatioRange(boolean bl) {
            if (bl) {
                return this.mBlockAspectRatioRange;
            }
            return this.mAspectRatioRange;
        }

        public Range<Integer> getBitrateRange() {
            return this.mBitrateRange;
        }

        public Range<Integer> getBlockCountRange() {
            return this.mBlockCountRange;
        }

        public Size getBlockSize() {
            return new Size(this.mBlockWidth, this.mBlockHeight);
        }

        public Range<Long> getBlocksPerSecondRange() {
            return this.mBlocksPerSecondRange;
        }

        public int getHeightAlignment() {
            return this.mHeightAlignment;
        }

        public int getSmallerDimensionUpperLimit() {
            return this.mSmallerDimensionUpperLimit;
        }

        public Range<Integer> getSupportedFrameRates() {
            return this.mFrameRateRange;
        }

        public Range<Double> getSupportedFrameRatesFor(int n, int n2) {
            if (!this.supports(n, n2, null)) {
                throw new IllegalArgumentException("unsupported size");
            }
            int n3 = Utils.divUp(n, this.mBlockWidth) * Utils.divUp(n2, this.mBlockHeight);
            return Range.create(Math.max((double)this.mBlocksPerSecondRange.getLower().longValue() / (double)n3, (double)this.mFrameRateRange.getLower().intValue()), Math.min((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)n3, (double)this.mFrameRateRange.getUpper().intValue()));
        }

        public Range<Integer> getSupportedHeights() {
            return this.mHeightRange;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Range<Integer> getSupportedHeightsFor(int n) {
            Range<Integer> range;
            try {
                range = this.mHeightRange;
                if (!this.mWidthRange.contains(n)) throw new IllegalArgumentException("unsupported width");
                if (n % this.mWidthAlignment != 0) {
                    throw new IllegalArgumentException("unsupported width");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w(TAG, "could not get supported heights for " + n, illegalArgumentException);
                throw new IllegalArgumentException("unsupported width");
            }
            {
                int n2 = Utils.divUp(n, this.mBlockWidth);
                int n3 = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), n2), (int)Math.ceil((double)n2 / this.mBlockAspectRatioRange.getUpper().doubleValue()));
                int n4 = Math.min(this.mBlockCountRange.getUpper() / n2, (int)((double)n2 / this.mBlockAspectRatioRange.getLower().doubleValue()));
                Range<Integer> range2 = range.intersect((n3 - 1) * this.mBlockHeight + this.mHeightAlignment, n4 * this.mBlockHeight);
                if (n <= this.mSmallerDimensionUpperLimit) return range2.intersect((int)Math.ceil((double)n / this.mAspectRatioRange.getUpper().doubleValue()), (int)((double)n / this.mAspectRatioRange.getLower().doubleValue()));
                range2 = range2.intersect(1, this.mSmallerDimensionUpperLimit);
                return range2.intersect((int)Math.ceil((double)n / this.mAspectRatioRange.getUpper().doubleValue()), (int)((double)n / this.mAspectRatioRange.getLower().doubleValue()));
            }
        }

        public Range<Integer> getSupportedWidths() {
            return this.mWidthRange;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Range<Integer> getSupportedWidthsFor(int n) {
            Range<Integer> range;
            try {
                range = this.mWidthRange;
                if (!this.mHeightRange.contains(n)) throw new IllegalArgumentException("unsupported height");
                if (n % this.mHeightAlignment != 0) {
                    throw new IllegalArgumentException("unsupported height");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w(TAG, "could not get supported widths for " + n, illegalArgumentException);
                throw new IllegalArgumentException("unsupported height");
            }
            {
                int n2 = Utils.divUp(n, this.mBlockHeight);
                int n3 = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), n2), (int)Math.ceil(this.mBlockAspectRatioRange.getLower().doubleValue() * (double)n2));
                int n4 = Math.min(this.mBlockCountRange.getUpper() / n2, (int)(this.mBlockAspectRatioRange.getUpper().doubleValue() * (double)n2));
                Range<Integer> range2 = range.intersect((n3 - 1) * this.mBlockWidth + this.mWidthAlignment, n4 * this.mBlockWidth);
                if (n <= this.mSmallerDimensionUpperLimit) return range2.intersect((int)Math.ceil(this.mAspectRatioRange.getLower().doubleValue() * (double)n), (int)(this.mAspectRatioRange.getUpper().doubleValue() * (double)n));
                range2 = range2.intersect(1, this.mSmallerDimensionUpperLimit);
                return range2.intersect((int)Math.ceil(this.mAspectRatioRange.getLower().doubleValue() * (double)n), (int)(this.mAspectRatioRange.getUpper().doubleValue() * (double)n));
            }
        }

        public int getWidthAlignment() {
            return this.mWidthAlignment;
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            this.mParent = codecCapabilities;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(mediaFormat);
            this.updateLimits();
        }

        public boolean isSizeSupported(int n, int n2) {
            return this.supports(n, n2, null);
        }

        public boolean supportsFormat(MediaFormat mediaFormat) {
            Map<String, Object> map = mediaFormat.getMap();
            return this.supports((Integer)map.get("width"), (Integer)map.get("height"), (Double)map.get("frame-rate"));
        }
    }
}

