/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import java.util.Arrays;
import java.util.HashMap;

public class CameraProfile {
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_LOW = 0;
    public static final int QUALITY_MEDIUM = 1;
    private static final HashMap<Integer, int[]> sCache = new HashMap();

    static {
        System.loadLibrary("media_jni");
        CameraProfile.native_init();
    }

    private static int[] getImageEncodingQualityLevels(int n) {
        int n2 = CameraProfile.native_get_num_image_encoding_quality_levels(n);
        if (n2 != 3) {
            throw new RuntimeException("Unexpected Jpeg encoding quality levels " + n2);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = CameraProfile.native_get_image_encoding_quality_level(n, i);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public static int getJpegEncodingQualityParameter(int n) {
        int n2 = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < n2; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CameraProfile.getJpegEncodingQualityParameter(i, n);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getJpegEncodingQualityParameter(int n, int n2) {
        if (n2 < 0) throw new IllegalArgumentException("Unsupported quality level: " + n2);
        if (n2 > 2) {
            throw new IllegalArgumentException("Unsupported quality level: " + n2);
        }
        HashMap<Integer, int[]> hashMap = sCache;
        synchronized (hashMap) {
            int[] nArray = sCache.get(n);
            if (nArray != null) return nArray[n2];
            nArray = CameraProfile.getImageEncodingQualityLevels(n);
            sCache.put(n, nArray);
            return nArray[n2];
        }
    }

    private static final native int native_get_image_encoding_quality_level(int var0, int var1);

    private static final native int native_get_num_image_encoding_quality_levels(int var0);

    private static final native void native_init();
}

