/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MutableBackgroundColorSpan;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.accessibility.CaptioningManager;
import java.util.ArrayList;
import java.util.Arrays;

class CCParser {
    private static final int AOF = 34;
    private static final int AON = 35;
    private static final int BS = 33;
    private static final int CR = 45;
    private static final boolean DEBUG = false;
    private static final int DER = 36;
    private static final int EDM = 44;
    private static final int ENM = 46;
    private static final int EOC = 47;
    private static final int FON = 40;
    private static final int INVALID = -1;
    public static final int MAX_COLS = 32;
    public static final int MAX_ROWS = 15;
    private static final int MODE_PAINT_ON = 1;
    private static final int MODE_POP_ON = 3;
    private static final int MODE_ROLL_UP = 2;
    private static final int MODE_TEXT = 4;
    private static final int MODE_UNKNOWN = 0;
    private static final int RCL = 32;
    private static final int RDC = 41;
    private static final int RTD = 43;
    private static final int RU2 = 37;
    private static final int RU3 = 38;
    private static final int RU4 = 39;
    private static final String TAG = "CCParser";
    private static final int TR = 42;
    private static final char TS = '\u00a0';
    private CCMemory mDisplay = new CCMemory();
    private final DisplayListener mListener;
    private int mMode = 1;
    private CCMemory mNonDisplay = new CCMemory();
    private int mRollUpSize = 4;
    private CCMemory mTextMem = new CCMemory();

    static {
        DEBUG = Log.isLoggable(TAG, 3);
    }

    CCParser(DisplayListener displayListener) {
        this.mListener = displayListener;
    }

    private CCMemory getMemory() {
        switch (this.mMode) {
            default: {
                Log.w(TAG, "unrecoginized mode: " + this.mMode);
                return this.mDisplay;
            }
            case 3: {
                return this.mNonDisplay;
            }
            case 4: {
                return this.mTextMem;
            }
            case 1: 
            case 2: 
        }
        return this.mDisplay;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleCtrlCode(CCData cCData) {
        boolean bl = true;
        int n = cCData.getCtrlCode();
        switch (n) {
            default: {
                return false;
            }
            case 32: {
                this.mMode = 3;
                return bl;
            }
            case 33: {
                this.getMemory().bs();
                return bl;
            }
            case 36: {
                this.getMemory().der();
                return bl;
            }
            case 37: 
            case 38: 
            case 39: {
                this.mRollUpSize = n - 35;
                if (this.mMode != 2) {
                    this.mDisplay.erase();
                    this.mNonDisplay.erase();
                }
                this.mMode = 2;
                return bl;
            }
            case 40: {
                Log.i(TAG, "Flash On");
                return bl;
            }
            case 41: {
                this.mMode = bl;
                return bl;
            }
            case 42: {
                this.mMode = 4;
                this.mTextMem.erase();
                return bl;
            }
            case 43: {
                this.mMode = 4;
                return bl;
            }
            case 44: {
                this.mDisplay.erase();
                this.updateDisplay();
                return bl;
            }
            case 45: {
                if (this.mMode == 2) {
                    this.getMemory().rollUp(this.mRollUpSize);
                } else {
                    this.getMemory().cr();
                }
                if (this.mMode != 2) return bl;
                this.updateDisplay();
                return bl;
            }
            case 46: {
                this.mNonDisplay.erase();
                return bl;
            }
            case 47: 
        }
        this.swapMemory();
        this.mMode = 3;
        this.updateDisplay();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleDisplayableChars(CCData cCData) {
        int n = 1;
        if (!cCData.isDisplayableChar()) {
            return 0;
        }
        if (cCData.isExtendedChar()) {
            this.getMemory().bs();
        }
        this.getMemory().writeText(cCData.getDisplayText());
        if (this.mMode != n) {
            if (this.mMode != 2) return n;
        }
        this.updateDisplay();
        return n;
    }

    private boolean handleMidRowCode(CCData cCData) {
        StyleCode styleCode = cCData.getMidRow();
        if (styleCode != null) {
            this.getMemory().writeMidRowCode(styleCode);
            return true;
        }
        return false;
    }

    private boolean handlePACCode(CCData cCData) {
        PAC pAC = cCData.getPAC();
        if (pAC != null) {
            if (this.mMode == 2) {
                this.getMemory().moveBaselineTo(pAC.getRow(), this.mRollUpSize);
            }
            this.getMemory().writePAC(pAC);
            return true;
        }
        return false;
    }

    private boolean handleTabOffsets(CCData cCData) {
        int n = cCData.getTabOffset();
        if (n > 0) {
            this.getMemory().tab(n);
            return true;
        }
        return false;
    }

    private void swapMemory() {
        CCMemory cCMemory = this.mDisplay;
        this.mDisplay = this.mNonDisplay;
        this.mNonDisplay = cCMemory;
    }

    private void updateDisplay() {
        if (this.mListener != null) {
            CaptioningManager.CaptionStyle captionStyle = this.mListener.getCaptionStyle();
            this.mListener.onDisplayChanged(this.mDisplay.getStyledText(captionStyle));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void parse(byte[] byArray) {
        CCData[] cCDataArray = CCData.fromByteArray(byArray);
        int n = 0;
        while (n < cCDataArray.length) {
            if (DEBUG) {
                Log.d(TAG, cCDataArray[n].toString());
            }
            if (!(this.handleCtrlCode(cCDataArray[n]) || this.handleTabOffsets(cCDataArray[n]) || this.handlePACCode(cCDataArray[n]) || this.handleMidRowCode(cCDataArray[n]))) {
                this.handleDisplayableChars(cCDataArray[n]);
            }
            ++n;
        }
        return;
    }

    private static class CCData {
        private static final String[] mCtrlCodeMap = new String[]{"RCL", "BS", "AOF", "AON", "DER", "RU2", "RU3", "RU4", "FON", "RDC", "TR", "RTD", "EDM", "CR", "ENM", "EOC"};
        private static final String[] mProtugueseCharMap;
        private static final String[] mSpanishCharMap;
        private static final String[] mSpecialCharMap;
        private final byte mData1;
        private final byte mData2;
        private final byte mType;

        static {
            mSpecialCharMap = new String[]{"\u00ae", "\u00b0", "\u00bd", "\u00bf", "\u2122", "\u00a2", "\u00a3", "\u266a", "\u00e0", "\u00a0", "\u00e8", "\u00e2", "\u00ea", "\u00ee", "\u00f4", "\u00fb"};
            mSpanishCharMap = new String[]{"\u00c1", "\u00c9", "\u00d3", "\u00da", "\u00dc", "\u00fc", "\u2018", "\u00a1", "*", "'", "\u2014", "\u00a9", "\u2120", "\u2022", "\u201c", "\u201d", "\u00c0", "\u00c2", "\u00c7", "\u00c8", "\u00ca", "\u00cb", "\u00eb", "\u00ce", "\u00cf", "\u00ef", "\u00d4", "\u00d9", "\u00f9", "\u00db", "\u00ab", "\u00bb"};
            mProtugueseCharMap = new String[]{"\u00c3", "\u00e3", "\u00cd", "\u00cc", "\u00ec", "\u00d2", "\u00f2", "\u00d5", "\u00f5", "{", "}", "\\", "^", "_", "|", "~", "\u00c4", "\u00e4", "\u00d6", "\u00f6", "\u00df", "\u00a5", "\u00a4", "\u2502", "\u00c5", "\u00e5", "\u00d8", "\u00f8", "\u250c", "\u2510", "\u2514", "\u2518"};
        }

        CCData(byte by, byte by2, byte by3) {
            this.mType = by;
            this.mData1 = by2;
            this.mData2 = by3;
        }

        private String ctrlCodeToString(int n) {
            return mCtrlCodeMap[n - 32];
        }

        static CCData[] fromByteArray(byte[] byArray) {
            CCData[] cCDataArray = new CCData[byArray.length / 3];
            for (int i = 0; i < cCDataArray.length; ++i) {
                cCDataArray[i] = new CCData(byArray[i * 3], byArray[1 + i * 3], byArray[2 + i * 3]);
            }
            return cCDataArray;
        }

        private char getBasicChar(byte by) {
            switch (by) {
                default: {
                    return (char)by;
                }
                case 42: {
                    return '\u00e1';
                }
                case 92: {
                    return '\u00e9';
                }
                case 94: {
                    return '\u00ed';
                }
                case 95: {
                    return '\u00f3';
                }
                case 96: {
                    return '\u00fa';
                }
                case 123: {
                    return '\u00e7';
                }
                case 124: {
                    return '\u00f7';
                }
                case 125: {
                    return '\u00d1';
                }
                case 126: {
                    return '\u00f1';
                }
                case 127: 
            }
            return '\u2588';
        }

        private String getBasicChars() {
            if (this.mData1 >= 32 && this.mData1 <= 127) {
                StringBuilder stringBuilder = new StringBuilder(2);
                stringBuilder.append(this.getBasicChar(this.mData1));
                if (this.mData2 >= 32 && this.mData2 <= 127) {
                    stringBuilder.append(this.getBasicChar(this.mData2));
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private String getExtendedChar() {
            if ((this.mData1 == 18 || this.mData1 == 26) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mSpanishCharMap[-32 + this.mData2];
            }
            if ((this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mProtugueseCharMap[-32 + this.mData2];
            }
            return null;
        }

        private String getSpecialChar() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63) {
                return mSpecialCharMap[-48 + this.mData2];
            }
            return null;
        }

        private boolean isBasicChar() {
            return this.mData1 >= 32 && this.mData1 <= 127;
        }

        private boolean isExtendedChar() {
            return (this.mData1 == 18 || this.mData1 == 26 || this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63;
        }

        private boolean isSpecialChar() {
            return (this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63;
        }

        int getCtrlCode() {
            if ((this.mData1 == 20 || this.mData1 == 28) && this.mData2 >= 32 && this.mData2 <= 47) {
                return this.mData2;
            }
            return -1;
        }

        String getDisplayText() {
            String string2 = this.getBasicChars();
            if (string2 == null && (string2 = this.getSpecialChar()) == null) {
                string2 = this.getExtendedChar();
            }
            return string2;
        }

        StyleCode getMidRow() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 32 && this.mData2 <= 47) {
                return StyleCode.fromByte(this.mData2);
            }
            return null;
        }

        PAC getPAC() {
            if ((0x70 & this.mData1) == 16 && (0x40 & this.mData2) == 64 && ((7 & this.mData1) != 0 || (0x20 & this.mData2) == 0)) {
                return PAC.fromBytes(this.mData1, this.mData2);
            }
            return null;
        }

        int getTabOffset() {
            if ((this.mData1 == 23 || this.mData1 == 31) && this.mData2 >= 33 && this.mData2 <= 35) {
                return 3 & this.mData2;
            }
            return 0;
        }

        boolean isDisplayableChar() {
            return this.isBasicChar() || this.isSpecialChar() || this.isExtendedChar();
        }

        public String toString() {
            if (this.mData1 < 16 && this.mData2 < 16) {
                Object[] objectArray = new Object[]{this.mType, this.mData1, this.mData2};
                return String.format("[%d]Null: %02x %02x", objectArray);
            }
            int n = this.getCtrlCode();
            if (n != -1) {
                Object[] objectArray = new Object[]{this.mType, this.ctrlCodeToString(n)};
                return String.format("[%d]%s", objectArray);
            }
            int n2 = this.getTabOffset();
            if (n2 > 0) {
                Object[] objectArray = new Object[]{this.mType, n2};
                return String.format("[%d]Tab%d", objectArray);
            }
            PAC pAC = this.getPAC();
            if (pAC != null) {
                Object[] objectArray = new Object[]{this.mType, pAC.toString()};
                return String.format("[%d]PAC: %s", objectArray);
            }
            StyleCode styleCode = this.getMidRow();
            if (styleCode != null) {
                Object[] objectArray = new Object[]{this.mType, styleCode.toString()};
                return String.format("[%d]Mid-row: %s", objectArray);
            }
            if (this.isDisplayableChar()) {
                Object[] objectArray = new Object[]{this.mType, this.getDisplayText(), this.mData1, this.mData2};
                return String.format("[%d]Displayable: %s (%02x %02x)", objectArray);
            }
            Object[] objectArray = new Object[]{this.mType, this.mData1, this.mData2};
            return String.format("[%d]Invalid: %02x %02x", objectArray);
        }
    }

    private static class CCLineBuilder {
        private final StringBuilder mDisplayChars;
        private final StyleCode[] mMidRowStyles;
        private final StyleCode[] mPACStyles;

        CCLineBuilder(String string2) {
            this.mDisplayChars = new StringBuilder(string2);
            this.mMidRowStyles = new StyleCode[this.mDisplayChars.length()];
            this.mPACStyles = new StyleCode[this.mDisplayChars.length()];
        }

        void applyStyleSpan(SpannableStringBuilder spannableStringBuilder, StyleCode styleCode, int n, int n2) {
            if (styleCode.isItalics()) {
                spannableStringBuilder.setSpan(new StyleSpan(2), n, n2, 33);
            }
            if (styleCode.isUnderline()) {
                spannableStringBuilder.setSpan(new UnderlineSpan(), n, n2, 33);
            }
        }

        char charAt(int n) {
            return this.mDisplayChars.charAt(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        SpannableStringBuilder getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(this.mDisplayChars);
            int n = -1;
            int n2 = 0;
            int n3 = -1;
            StyleCode styleCode = null;
            while (true) {
                StyleCode styleCode2;
                block15: {
                    block16: {
                        block14: {
                            if (n2 >= this.mDisplayChars.length()) {
                                return spannableStringBuilder;
                            }
                            if (this.mMidRowStyles[n2] == null) break block14;
                            styleCode2 = this.mMidRowStyles[n2];
                            break block15;
                        }
                        StyleCode styleCode3 = this.mPACStyles[n2];
                        styleCode2 = null;
                        if (styleCode3 == null) break block15;
                        if (n3 < 0) break block16;
                        styleCode2 = null;
                        if (n >= 0) break block15;
                    }
                    styleCode2 = this.mPACStyles[n2];
                }
                if (styleCode2 != null) {
                    styleCode = styleCode2;
                    if (n3 >= 0 && n >= 0) {
                        this.applyStyleSpan(spannableStringBuilder, styleCode2, n3, n2);
                    }
                    n3 = n2;
                }
                if (this.mDisplayChars.charAt(n2) != '\u00a0') {
                    if (n < 0) {
                        n = n2;
                    }
                } else if (n >= 0) {
                    int n4 = this.mDisplayChars.charAt(n) == ' ' ? n : n - 1;
                    int n5 = this.mDisplayChars.charAt(n2 - 1) == ' ' ? n2 : n2 + 1;
                    spannableStringBuilder.setSpan(new MutableBackgroundColorSpan(captionStyle.backgroundColor), n4, n5, 33);
                    if (n3 >= 0) {
                        this.applyStyleSpan(spannableStringBuilder, styleCode, n3, n5);
                    }
                    n = -1;
                }
                ++n2;
            }
        }

        int length() {
            return this.mDisplayChars.length();
        }

        void setCharAt(int n, char c) {
            this.mDisplayChars.setCharAt(n, c);
            this.mMidRowStyles[n] = null;
        }

        void setMidRowAt(int n, StyleCode styleCode) {
            this.mDisplayChars.setCharAt(n, ' ');
            this.mMidRowStyles[n] = styleCode;
        }

        void setPACAt(int n, PAC pAC) {
            this.mPACStyles[n] = pAC;
        }
    }

    private static class CCMemory {
        private final String mBlankLine;
        private int mCol;
        private final CCLineBuilder[] mLines = new CCLineBuilder[17];
        private int mRow;

        CCMemory() {
            char[] cArray = new char[34];
            Arrays.fill(cArray, '\u00a0');
            this.mBlankLine = new String(cArray);
        }

        private static int clamp(int n, int n2, int n3) {
            if (n < n2) {
                return n2;
            }
            if (n > n3) {
                return n3;
            }
            return n;
        }

        private CCLineBuilder getLineBuffer(int n) {
            if (this.mLines[n] == null) {
                this.mLines[n] = new CCLineBuilder(this.mBlankLine);
            }
            return this.mLines[n];
        }

        /*
         * Enabled aggressive block sorting
         */
        private void moveBaselineTo(int n, int n2) {
            if (this.mRow != n) {
                int n3 = n2;
                if (n < n3) {
                    n3 = n;
                }
                if (this.mRow < n3) {
                    n3 = this.mRow;
                }
                if (n < this.mRow) {
                    for (int i = n3 - 1; i >= 0; --i) {
                        this.mLines[n - i] = this.mLines[this.mRow - i];
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        this.mLines[n - i] = this.mLines[this.mRow - i];
                    }
                }
                for (int i = 0; i <= n - n2; ++i) {
                    this.mLines[i] = null;
                }
                for (int i = n + 1; i < this.mLines.length; ++i) {
                    this.mLines[i] = null;
                }
            }
        }

        private void moveCursorByCol(int n) {
            this.mCol = CCMemory.clamp(n + this.mCol, 1, 32);
        }

        private void moveCursorTo(int n, int n2) {
            this.mRow = CCMemory.clamp(n, 1, 15);
            this.mCol = CCMemory.clamp(n2, 1, 32);
        }

        private void moveCursorToRow(int n) {
            this.mRow = CCMemory.clamp(n, 1, 15);
        }

        void bs() {
            this.moveCursorByCol(-1);
            if (this.mLines[this.mRow] != null) {
                this.mLines[this.mRow].setCharAt(this.mCol, '\u00a0');
                if (this.mCol == 31) {
                    this.mLines[this.mRow].setCharAt(32, '\u00a0');
                }
            }
        }

        void cr() {
            this.moveCursorTo(1 + this.mRow, 1);
        }

        void der() {
            block3: {
                if (this.mLines[this.mRow] != null) {
                    for (int i = 0; i < this.mCol; ++i) {
                        if (this.mLines[this.mRow].charAt(i) == '\u00a0') continue;
                        for (int j = this.mCol; j < this.mLines[this.mRow].length(); ++j) {
                            this.mLines[j].setCharAt(j, '\u00a0');
                        }
                        break block3;
                    }
                    this.mLines[this.mRow] = null;
                }
            }
        }

        void erase() {
            for (int i = 0; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mRow = 15;
            this.mCol = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        SpannableStringBuilder[] getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            ArrayList<SpannableStringBuilder> arrayList = new ArrayList<SpannableStringBuilder>(15);
            int n = 1;
            while (n <= 15) {
                SpannableStringBuilder spannableStringBuilder = this.mLines[n] != null ? this.mLines[n].getStyledText(captionStyle) : null;
                arrayList.add(spannableStringBuilder);
                ++n;
            }
            return arrayList.toArray(new SpannableStringBuilder[15]);
        }

        void rollUp(int n) {
            for (int i = 0; i <= this.mRow - n; ++i) {
                this.mLines[i] = null;
            }
            int n2 = 1 + (this.mRow - n);
            if (n2 < 1) {
                n2 = 1;
            }
            for (int i = n2; i < this.mRow; ++i) {
                this.mLines[i] = this.mLines[i + 1];
            }
            for (int i = this.mRow; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mCol = 1;
        }

        void tab(int n) {
            this.moveCursorByCol(n);
        }

        void writeMidRowCode(StyleCode styleCode) {
            this.getLineBuffer(this.mRow).setMidRowAt(this.mCol, styleCode);
            this.moveCursorByCol(1);
        }

        /*
         * Enabled aggressive block sorting
         */
        void writePAC(PAC pAC) {
            if (pAC.isIndentPAC()) {
                this.moveCursorTo(pAC.getRow(), pAC.getCol());
            } else {
                this.moveCursorToRow(pAC.getRow());
            }
            this.getLineBuffer(this.mRow).setPACAt(this.mCol, pAC);
        }

        void writeText(String string2) {
            for (int i = 0; i < string2.length(); ++i) {
                this.getLineBuffer(this.mRow).setCharAt(this.mCol, string2.charAt(i));
                this.moveCursorByCol(1);
            }
        }
    }

    static interface DisplayListener {
        public CaptioningManager.CaptionStyle getCaptionStyle();

        public void onDisplayChanged(SpannableStringBuilder[] var1);
    }

    private static class PAC
    extends StyleCode {
        final int mCol;
        final int mRow;

        PAC(int n, int n2, int n3, int n4) {
            super(n3, n4);
            this.mRow = n;
            this.mCol = n2;
        }

        static PAC fromBytes(byte by, byte by2) {
            int n = (new int[]{11, 1, 3, 12, 14, 5, 7, 9})[by & 7] + ((by2 & 0x20) >> 5);
            int n2 = by2 & 1;
            int n3 = 0;
            if (n2 != 0) {
                n3 = 0 | 2;
            }
            if ((by2 & 0x10) != 0) {
                return new PAC(n, 4 * (7 & by2 >> 1), n3, 0);
            }
            int n4 = 7 & by2 >> 1;
            if (n4 == 7) {
                n4 = 0;
                n3 |= 1;
            }
            return new PAC(n, -1, n3, n4);
        }

        int getCol() {
            return this.mCol;
        }

        int getRow() {
            return this.mRow;
        }

        boolean isIndentPAC() {
            return this.mCol >= 0;
        }

        @Override
        public String toString() {
            Object[] objectArray = new Object[]{this.mRow, this.mCol, super.toString()};
            return String.format("{%d, %d}, %s", objectArray);
        }
    }

    private static class StyleCode {
        static final int COLOR_BLUE = 2;
        static final int COLOR_CYAN = 3;
        static final int COLOR_GREEN = 1;
        static final int COLOR_INVALID = 7;
        static final int COLOR_MAGENTA = 6;
        static final int COLOR_RED = 4;
        static final int COLOR_WHITE = 0;
        static final int COLOR_YELLOW = 5;
        static final int STYLE_ITALICS = 1;
        static final int STYLE_UNDERLINE = 2;
        static final String[] mColorMap = new String[]{"WHITE", "GREEN", "BLUE", "CYAN", "RED", "YELLOW", "MAGENTA", "INVALID"};
        final int mColor;
        final int mStyle;

        StyleCode(int n, int n2) {
            this.mStyle = n;
            this.mColor = n2;
        }

        static StyleCode fromByte(byte by) {
            int n = 7 & by >> 1;
            int n2 = by & 1;
            int n3 = 0;
            if (n2 != 0) {
                n3 = 0 | 2;
            }
            if (n == 7) {
                n = 0;
                n3 |= 1;
            }
            return new StyleCode(n3, n);
        }

        int getColor() {
            return this.mColor;
        }

        boolean isItalics() {
            return (1 & this.mStyle) != 0;
        }

        boolean isUnderline() {
            return (2 & this.mStyle) != 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append(mColorMap[this.mColor]);
            if ((1 & this.mStyle) != 0) {
                stringBuilder.append(", ITALICS");
            }
            if ((2 & this.mStyle) != 0) {
                stringBuilder.append(", UNDERLINE");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

