/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import java.util.LinkedList;

public class AsyncPlayer {
    private static final int PLAY = 1;
    private static final int STOP = 2;
    private static final boolean mDebug;
    private final LinkedList<Command> mCmdQueue = new LinkedList();
    private MediaPlayer mPlayer;
    private int mState = 2;
    private String mTag;
    private Thread mThread;
    private PowerManager.WakeLock mWakeLock;

    public AsyncPlayer(String string2) {
        if (string2 != null) {
            this.mTag = string2;
            return;
        }
        this.mTag = "AsyncPlayer";
    }

    static /* synthetic */ MediaPlayer access$302(AsyncPlayer asyncPlayer, MediaPlayer mediaPlayer) {
        asyncPlayer.mPlayer = mediaPlayer;
        return mediaPlayer;
    }

    static /* synthetic */ Thread access$402(AsyncPlayer asyncPlayer, Thread thread) {
        asyncPlayer.mThread = thread;
        return thread;
    }

    private void acquireWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.acquire();
        }
    }

    private void enqueueLocked(Command command) {
        this.mCmdQueue.add(command);
        if (this.mThread == null) {
            this.acquireWakeLock();
            this.mThread = new Thread();
            this.mThread.start();
        }
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startSound(Command command) {
        long l;
        try {
            MediaPlayer mediaPlayer = new MediaPlayer();
            mediaPlayer.setAudioStreamType(command.stream);
            mediaPlayer.setDataSource(command.context, command.uri);
            mediaPlayer.setLooping(command.looping);
            mediaPlayer.prepare();
            mediaPlayer.start();
            if (this.mPlayer != null) {
                this.mPlayer.release();
            }
            this.mPlayer = mediaPlayer;
            l = SystemClock.uptimeMillis() - command.requestTime;
            if (l <= 1000L) return;
        }
        catch (Exception exception) {
            Log.w(this.mTag, "error loading sound for " + command.uri, exception);
            return;
        }
        Log.w(this.mTag, "Notification sound delayed by " + l + "msecs");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play(Context context, Uri uri, boolean bl, int n) {
        Command command = new Command();
        command.requestTime = SystemClock.uptimeMillis();
        command.code = 1;
        command.context = context;
        command.uri = uri;
        command.looping = bl;
        command.stream = n;
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            this.enqueueLocked(command);
            this.mState = 1;
            return;
        }
    }

    public void setUsesWakeLock(Context context) {
        if (this.mWakeLock != null || this.mThread != null) {
            throw new RuntimeException("assertion failed mWakeLock=" + this.mWakeLock + " mThread=" + this.mThread);
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, this.mTag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            if (this.mState != 2) {
                Command command = new Command();
                command.requestTime = SystemClock.uptimeMillis();
                command.code = 2;
                this.enqueueLocked(command);
                this.mState = 2;
            }
            return;
        }
    }

    private static final class Command {
        int code;
        Context context;
        boolean looping;
        long requestTime;
        int stream;
        Uri uri;

        private Command() {
        }

        public String toString() {
            return "{ code=" + this.code + " looping=" + this.looping + " stream=" + this.stream + " uri=" + this.uri + " }";
        }
    }

    private final class Thread
    extends java.lang.Thread {
        Thread() {
            super("AsyncPlayer-" + AsyncPlayer.this.mTag);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                Command command;
                LinkedList linkedList = AsyncPlayer.this.mCmdQueue;
                synchronized (linkedList) {
                    command = (Command)AsyncPlayer.this.mCmdQueue.removeFirst();
                }
                switch (command.code) {
                    case 1: {
                        AsyncPlayer.this.startSound(command);
                        break;
                    }
                    case 2: {
                        if (AsyncPlayer.this.mPlayer != null) {
                            long l = SystemClock.uptimeMillis() - command.requestTime;
                            if (l > 1000L) {
                                Log.w(AsyncPlayer.this.mTag, "Notification stop delayed by " + l + "msecs");
                            }
                            AsyncPlayer.this.mPlayer.stop();
                            AsyncPlayer.this.mPlayer.release();
                            AsyncPlayer.access$302(AsyncPlayer.this, null);
                            break;
                        }
                        Log.w(AsyncPlayer.this.mTag, "STOP command without a player");
                    }
                }
                LinkedList linkedList2 = AsyncPlayer.this.mCmdQueue;
                synchronized (linkedList2) {
                    if (AsyncPlayer.this.mCmdQueue.size() == 0) {
                        AsyncPlayer.access$402(AsyncPlayer.this, null);
                        AsyncPlayer.this.releaseWakeLock();
                        return;
                    }
                }
            }
        }
    }
}

