/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

public abstract class SettingInjectorService
extends Service {
    public static final String ACTION_INJECTED_SETTING_CHANGED = "android.location.InjectedSettingChanged";
    public static final String ACTION_SERVICE_INTENT = "android.location.SettingInjectorService";
    public static final String ATTRIBUTES_NAME = "injected-location-setting";
    public static final String ENABLED_KEY = "enabled";
    public static final String MESSENGER_KEY = "messenger";
    public static final String META_DATA_NAME = "android.location.SettingInjectorService";
    private static final String TAG = "SettingInjectorService";
    private final String mName;

    public SettingInjectorService(String string2) {
        this.mName = string2;
    }

    private void onHandleIntent(Intent intent) {
        boolean bl;
        try {
            bl = this.onGetEnabled();
        }
        catch (RuntimeException runtimeException) {
            this.sendStatus(intent, true);
            throw runtimeException;
        }
        this.sendStatus(intent, bl);
    }

    private void sendStatus(Intent intent, boolean bl) {
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putBoolean(ENABLED_KEY, bl);
        message.setData(bundle);
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, this.mName + ": received " + intent + ", enabled=" + bl + ", sending message: " + message);
        }
        Messenger messenger = (Messenger)intent.getParcelableExtra(MESSENGER_KEY);
        try {
            messenger.send(message);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, this.mName + ": sending dynamic status failed", remoteException);
            return;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return null;
    }

    protected abstract boolean onGetEnabled();

    @Deprecated
    protected abstract String onGetSummary();

    @Override
    public final void onStart(Intent intent, int n) {
        super.onStart(intent, n);
    }

    @Override
    public final int onStartCommand(Intent intent, int n, int n2) {
        this.onHandleIntent(intent);
        this.stopSelf(n2);
        return 2;
    }
}

