/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GpsMeasurementListenerTransport;
import android.location.GpsMeasurementsEvent;
import android.location.GpsNavigationMessageEvent;
import android.location.GpsNavigationMessageListenerTransport;
import android.location.GpsStatus;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.location.ProviderProperties;
import com.asus.cta.CtaChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocationManager {
    public static final String EXTRA_GPS_ENABLED = "enabled";
    public static final String FUSED_PROVIDER = "fused";
    public static final String GPS_ENABLED_CHANGE_ACTION = "android.location.GPS_ENABLED_CHANGE";
    public static final String GPS_FIX_CHANGE_ACTION = "android.location.GPS_FIX_CHANGE";
    public static final String GPS_PROVIDER = "gps";
    public static final String HIGH_POWER_REQUEST_CHANGE_ACTION = "android.location.HIGH_POWER_REQUEST_CHANGE";
    public static final String KEY_LOCATION_CHANGED = "location";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String MODE_CHANGED_ACTION = "android.location.MODE_CHANGED";
    public static final String NETWORK_PROVIDER = "network";
    public static final String PASSIVE_PROVIDER = "passive";
    public static final String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    private static final String TAG = "LocationManager";
    private final Context mContext;
    private CtaChecker mCtaChecker;
    private final GpsMeasurementListenerTransport mGpsMeasurementListenerTransport;
    private final GpsNavigationMessageListenerTransport mGpsNavigationMessageListenerTransport;
    private final GpsStatus mGpsStatus;
    private final HashMap<GpsStatus.Listener, GpsStatusListenerTransport> mGpsStatusListeners = new HashMap();
    private HashMap<LocationListener, ListenerTransport> mListeners;
    private final HashMap<GpsStatus.NmeaListener, GpsStatusListenerTransport> mNmeaListeners = new HashMap();
    private final ILocationManager mService;

    public LocationManager(Context context, ILocationManager iLocationManager) {
        this.mGpsStatus = new GpsStatus();
        this.mListeners = new HashMap();
        this.mService = iLocationManager;
        this.mContext = context;
        this.mGpsMeasurementListenerTransport = new GpsMeasurementListenerTransport(this.mContext, this.mService);
        this.mGpsNavigationMessageListenerTransport = new GpsNavigationMessageListenerTransport(this.mContext, this.mService);
    }

    private static void checkCriteria(Criteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("invalid criteria: " + criteria);
        }
    }

    private static void checkGeofence(Geofence geofence) {
        if (geofence == null) {
            throw new IllegalArgumentException("invalid geofence: " + geofence);
        }
    }

    private static void checkListener(LocationListener locationListener) {
        if (locationListener == null) {
            throw new IllegalArgumentException("invalid listener: " + locationListener);
        }
    }

    private void checkPendingIntent(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + pendingIntent);
        }
        if (!pendingIntent.isTargetedToPackage()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pending intent must be targeted to package");
            if (this.mContext.getApplicationInfo().targetSdkVersion > 16) {
                throw illegalArgumentException;
            }
            Log.w(TAG, illegalArgumentException);
        }
    }

    private static void checkProvider(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("invalid provider: " + string2);
        }
    }

    private LocationProvider createProvider(String string2, ProviderProperties providerProperties) {
        return new LocationProvider(string2, providerProperties);
    }

    private void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper, PendingIntent pendingIntent) {
        String string2 = this.mContext.getPackageName();
        if (Build.CTA && Binder.getCallingPid() != 1000 && !this.showCtaDialog(string2)) {
            return;
        }
        ListenerTransport listenerTransport = this.wrapListener(locationListener, looper);
        try {
            this.mService.requestLocationUpdates(locationRequest, listenerTransport, pendingIntent, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    private boolean showCtaDialog(String string2) {
        if (this.mCtaChecker == null && this.mContext != null) {
            this.mCtaChecker = new CtaChecker(this.mContext);
        }
        if (this.mCtaChecker == null || string2 == null) {
            return false;
        }
        return this.mCtaChecker.checkPermission(10, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ListenerTransport wrapListener(LocationListener locationListener, Looper looper) {
        if (locationListener == null) {
            return null;
        }
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport listenerTransport = this.mListeners.get(locationListener);
            if (listenerTransport == null) {
                listenerTransport = new ListenerTransport(locationListener, looper);
            }
            this.mListeners.put(locationListener, listenerTransport);
            return listenerTransport;
        }
    }

    public void addGeofence(LocationRequest locationRequest, Geofence geofence, PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        LocationManager.checkGeofence(geofence);
        if (Build.CTA && Binder.getCallingPid() != 1000 && !this.showCtaDialog(this.mContext.getPackageName())) {
            return;
        }
        try {
            this.mService.requestGeofence(locationRequest, geofence, pendingIntent, this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public boolean addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return this.mGpsMeasurementListenerTransport.add(listener);
    }

    public boolean addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return this.mGpsNavigationMessageListenerTransport.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        boolean bl;
        GpsStatusListenerTransport gpsStatusListenerTransport;
        if (Build.CTA && Binder.getCallingPid() != 1000 && !this.showCtaDialog(this.mContext.getPackageName())) {
            return false;
        }
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            gpsStatusListenerTransport = new GpsStatusListenerTransport(listener);
            bl = this.mService.addGpsStatusListener(gpsStatusListenerTransport, this.mContext.getPackageName());
            if (!bl) return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", remoteException);
            return false;
        }
        this.mGpsStatusListeners.put(listener, gpsStatusListenerTransport);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        boolean bl;
        GpsStatusListenerTransport gpsStatusListenerTransport;
        if (this.mNmeaListeners.get(nmeaListener) != null) {
            return true;
        }
        try {
            gpsStatusListenerTransport = new GpsStatusListenerTransport(nmeaListener);
            bl = this.mService.addGpsStatusListener(gpsStatusListenerTransport, this.mContext.getPackageName());
            if (!bl) return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", remoteException);
            return false;
        }
        this.mNmeaListeners.put(nmeaListener, gpsStatusListenerTransport);
        return bl;
    }

    public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        if (Build.CTA && Binder.getCallingPid() != 1000 && !this.showCtaDialog(this.mContext.getPackageName())) {
            return;
        }
        Geofence geofence = Geofence.createCircle(d, d2, f);
        LocationRequest locationRequest = new LocationRequest().setExpireIn(l);
        try {
            this.mService.requestGeofence(locationRequest, geofence, pendingIntent, this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) {
        ProviderProperties providerProperties = new ProviderProperties(bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2);
        if (string2.matches("[^a-zA-Z0-9]")) {
            throw new IllegalArgumentException("provider name contains illegal character: " + string2);
        }
        try {
            this.mService.addTestProvider(string2, providerProperties);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderEnabled(String string2) {
        try {
            this.mService.clearTestProviderEnabled(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderLocation(String string2) {
        try {
            this.mService.clearTestProviderLocation(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderStatus(String string2) {
        try {
            this.mService.clearTestProviderStatus(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public List<String> getAllProviders() {
        try {
            List<String> list = this.mService.getAllProviders();
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public String getBestProvider(Criteria criteria, boolean bl) {
        LocationManager.checkCriteria(criteria);
        try {
            String string2 = this.mService.getBestProvider(criteria, bl);
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
        if (gpsStatus == null) {
            gpsStatus = new GpsStatus();
        }
        gpsStatus.setStatus(this.mGpsStatus);
        return gpsStatus;
    }

    public Location getLastKnownLocation(String string2) {
        LocationManager.checkProvider(string2);
        String string3 = this.mContext.getPackageName();
        LocationRequest locationRequest = LocationRequest.createFromDeprecatedProvider(string2, 0L, 0.0f, true);
        try {
            Location location = this.mService.getLastLocation(locationRequest, string3);
            return location;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public Location getLastLocation() {
        String string2 = this.mContext.getPackageName();
        if (Build.CTA && Binder.getCallingPid() != 1000 && !this.showCtaDialog(string2)) {
            return null;
        }
        try {
            Location location = this.mService.getLastLocation(null, string2);
            return location;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public LocationProvider getProvider(String string2) {
        ProviderProperties providerProperties;
        block3: {
            LocationManager.checkProvider(string2);
            try {
                providerProperties = this.mService.getProviderProperties(string2);
                if (providerProperties != null) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException", remoteException);
                return null;
            }
        }
        LocationProvider locationProvider = this.createProvider(string2, providerProperties);
        return locationProvider;
    }

    public List<String> getProviders(Criteria criteria, boolean bl) {
        LocationManager.checkCriteria(criteria);
        try {
            List<String> list = this.mService.getProviders(criteria, bl);
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public List<String> getProviders(boolean bl) {
        try {
            List<String> list = this.mService.getProviders(null, bl);
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return null;
        }
    }

    public boolean isProviderEnabled(String string2) {
        LocationManager.checkProvider(string2);
        try {
            boolean bl = this.mService.isProviderEnabled(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return false;
        }
    }

    public void removeAllGeofences(PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        String string2 = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, pendingIntent, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void removeGeofence(Geofence geofence, PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        LocationManager.checkGeofence(geofence);
        String string2 = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(geofence, pendingIntent, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        this.mGpsMeasurementListenerTransport.remove(listener);
    }

    public void removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        this.mGpsNavigationMessageListenerTransport.remove(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        GpsStatusListenerTransport gpsStatusListenerTransport;
        try {
            gpsStatusListenerTransport = this.mGpsStatusListeners.remove(listener);
            if (gpsStatusListenerTransport == null) return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", remoteException);
            return;
        }
        this.mService.removeGpsStatusListener(gpsStatusListenerTransport);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        GpsStatusListenerTransport gpsStatusListenerTransport;
        try {
            gpsStatusListenerTransport = this.mNmeaListeners.remove(nmeaListener);
            if (gpsStatusListenerTransport == null) return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", remoteException);
            return;
        }
        this.mService.removeGpsStatusListener(gpsStatusListenerTransport);
    }

    public void removeProximityAlert(PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        String string2 = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, pendingIntent, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void removeTestProvider(String string2) {
        try {
            this.mService.removeTestProvider(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        String string2 = this.mContext.getPackageName();
        try {
            this.mService.removeUpdates(null, pendingIntent, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeUpdates(LocationListener locationListener) {
        LocationManager.checkListener(locationListener);
        String string2 = this.mContext.getPackageName();
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        // MONITORENTER : hashMap
        ListenerTransport listenerTransport = this.mListeners.remove(locationListener);
        // MONITOREXIT : hashMap
        if (listenerTransport == null) {
            return;
        }
        try {
            this.mService.removeUpdates(listenerTransport, null, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, PendingIntent pendingIntent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(pendingIntent);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedCriteria(criteria, l, f, false), null, null, pendingIntent);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, LocationListener locationListener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedCriteria(criteria, l, f, false), locationListener, looper, null);
    }

    public void requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        this.checkPendingIntent(pendingIntent);
        this.requestLocationUpdates(locationRequest, null, null, pendingIntent);
    }

    public void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(locationRequest, locationListener, looper, null);
    }

    public void requestLocationUpdates(String string2, long l, float f, PendingIntent pendingIntent) {
        LocationManager.checkProvider(string2);
        this.checkPendingIntent(pendingIntent);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedProvider(string2, l, f, false), null, null, pendingIntent);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener) {
        LocationManager.checkProvider(string2);
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedProvider(string2, l, f, false), locationListener, null, null);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener, Looper looper) {
        LocationManager.checkProvider(string2);
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedProvider(string2, l, f, false), locationListener, looper, null);
    }

    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(pendingIntent);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true), null, null, pendingIntent);
    }

    public void requestSingleUpdate(Criteria criteria, LocationListener locationListener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true), locationListener, looper, null);
    }

    public void requestSingleUpdate(String string2, PendingIntent pendingIntent) {
        LocationManager.checkProvider(string2);
        this.checkPendingIntent(pendingIntent);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedProvider(string2, 0L, 0.0f, true), null, null, pendingIntent);
    }

    public void requestSingleUpdate(String string2, LocationListener locationListener, Looper looper) {
        LocationManager.checkProvider(string2);
        LocationManager.checkListener(locationListener);
        this.requestLocationUpdates(LocationRequest.createFromDeprecatedProvider(string2, 0L, 0.0f, true), locationListener, looper, null);
    }

    public boolean sendExtraCommand(String string2, String string3, Bundle bundle) {
        try {
            boolean bl = this.mService.sendExtraCommand(string2, string3, bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in sendExtraCommand: ", remoteException);
            return false;
        }
    }

    public boolean sendNiResponse(int n, int n2) {
        try {
            boolean bl = this.mService.sendNiResponse(n, n2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in sendNiResponse: ", remoteException);
            return false;
        }
    }

    public void setTestProviderEnabled(String string2, boolean bl) {
        try {
            this.mService.setTestProviderEnabled(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    public void setTestProviderLocation(String string2, Location location) {
        IllegalArgumentException illegalArgumentException;
        block5: {
            block4: {
                if (location.isComplete()) break block4;
                illegalArgumentException = new IllegalArgumentException("Incomplete location object, missing timestamp or accuracy? " + location);
                if (this.mContext.getApplicationInfo().targetSdkVersion > 16) break block5;
                Log.w(TAG, illegalArgumentException);
                location.makeComplete();
            }
            try {
                this.mService.setTestProviderLocation(string2, location);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException", remoteException);
                return;
            }
        }
        throw illegalArgumentException;
    }

    public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) {
        try {
            this.mService.setTestProviderStatus(string2, n, bundle, l);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException", remoteException);
            return;
        }
    }

    private class GpsStatusListenerTransport
    extends IGpsStatusListener.Stub {
        private static final int NMEA_RECEIVED = 1000;
        private final Handler mGpsHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                if (message.what != 1000) {
                    GpsStatus gpsStatus = LocationManager.this.mGpsStatus;
                    synchronized (gpsStatus) {
                        GpsStatusListenerTransport.this.mListener.onGpsStatusChanged(message.what);
                        return;
                    }
                }
                ArrayList arrayList = GpsStatusListenerTransport.this.mNmeaBuffer;
                synchronized (arrayList) {
                    int n = GpsStatusListenerTransport.this.mNmeaBuffer.size();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            GpsStatusListenerTransport.this.mNmeaBuffer.clear();
                            return;
                        }
                        Nmea nmea = (Nmea)GpsStatusListenerTransport.this.mNmeaBuffer.get(n2);
                        GpsStatusListenerTransport.this.mNmeaListener.onNmeaReceived(nmea.mTimestamp, nmea.mNmea);
                        ++n2;
                    }
                }
            }
        };
        private final GpsStatus.Listener mListener;
        private ArrayList<Nmea> mNmeaBuffer;
        private final GpsStatus.NmeaListener mNmeaListener;

        GpsStatusListenerTransport(GpsStatus.Listener listener) {
            this.mListener = listener;
            this.mNmeaListener = null;
        }

        GpsStatusListenerTransport(GpsStatus.NmeaListener nmeaListener) {
            this.mNmeaListener = nmeaListener;
            this.mListener = null;
            this.mNmeaBuffer = new ArrayList();
        }

        @Override
        public void onFirstFix(int n) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setTimeToFirstFix(n);
                Message message = Message.obtain();
                message.what = 3;
                this.mGpsHandler.sendMessage(message);
            }
        }

        @Override
        public void onGpsStarted() {
            if (this.mListener != null) {
                Message message = Message.obtain();
                message.what = 1;
                this.mGpsHandler.sendMessage(message);
            }
        }

        @Override
        public void onGpsStopped() {
            if (this.mListener != null) {
                Message message = Message.obtain();
                message.what = 2;
                this.mGpsHandler.sendMessage(message);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNmeaReceived(long l, String string2) {
            if (this.mNmeaListener != null) {
                ArrayList<Nmea> arrayList = this.mNmeaBuffer;
                synchronized (arrayList) {
                    this.mNmeaBuffer.add(new Nmea(l, string2));
                }
                Message message = Message.obtain();
                message.what = 1000;
                this.mGpsHandler.removeMessages(1000);
                this.mGpsHandler.sendMessage(message);
            }
        }

        @Override
        public void onSvStatusChanged(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setStatus(n, nArray, fArray, fArray2, fArray3, n2, n3, n4);
                Message message = Message.obtain();
                message.what = 4;
                this.mGpsHandler.removeMessages(4);
                this.mGpsHandler.sendMessage(message);
            }
        }

        private class Nmea {
            String mNmea;
            long mTimestamp;

            Nmea(long l, String string2) {
                this.mTimestamp = l;
                this.mNmea = string2;
            }
        }
    }

    private class ListenerTransport
    extends ILocationListener.Stub {
        private static final int TYPE_LOCATION_CHANGED = 1;
        private static final int TYPE_PROVIDER_DISABLED = 4;
        private static final int TYPE_PROVIDER_ENABLED = 3;
        private static final int TYPE_STATUS_CHANGED = 2;
        private LocationListener mListener;
        private final Handler mListenerHandler;

        ListenerTransport(LocationListener locationListener, Looper looper) {
            this.mListener = locationListener;
            if (looper == null) {
                this.mListenerHandler = new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        ListenerTransport.this._handleMessage(message);
                    }
                };
                return;
            }
            this.mListenerHandler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    ListenerTransport.this._handleMessage(message);
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void _handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Location location = new Location((Location)message.obj);
                    this.mListener.onLocationChanged(location);
                    break;
                }
                case 2: {
                    Bundle bundle = (Bundle)message.obj;
                    String string2 = bundle.getString("provider");
                    int n = bundle.getInt(LocationManager.KEY_STATUS_CHANGED);
                    Bundle bundle2 = bundle.getBundle("extras");
                    this.mListener.onStatusChanged(string2, n, bundle2);
                    break;
                }
                case 3: {
                    this.mListener.onProviderEnabled((String)message.obj);
                    break;
                }
                case 4: {
                    this.mListener.onProviderDisabled((String)message.obj);
                    break;
                }
            }
            try {
                LocationManager.this.mService.locationCallbackFinished(this);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(LocationManager.TAG, "locationCallbackFinished: RemoteException", remoteException);
                return;
            }
        }

        @Override
        public void onLocationChanged(Location location) {
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onProviderDisabled(String string2) {
            Message message = Message.obtain();
            message.what = 4;
            message.obj = string2;
            this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onProviderEnabled(String string2) {
            Message message = Message.obtain();
            message.what = 3;
            message.obj = string2;
            this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onStatusChanged(String string2, int n, Bundle bundle) {
            Message message = Message.obtain();
            message.what = 2;
            Bundle bundle2 = new Bundle();
            bundle2.putString("provider", string2);
            bundle2.putInt(LocationManager.KEY_STATUS_CHANGED, n);
            if (bundle != null) {
                bundle2.putBundle("extras", bundle);
            }
            message.obj = bundle2;
            this.mListenerHandler.sendMessage(message);
        }
    }
}

