/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

abstract class LocalListenerHelper<TListener> {
    private final HashSet<TListener> mListeners = new HashSet();
    private final String mTag;

    protected LocalListenerHelper(String string2) {
        Preconditions.checkNotNull(string2);
        this.mTag = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(TListener TListener) {
        Preconditions.checkNotNull(TListener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            block7: {
                boolean bl = this.mListeners.isEmpty();
                if (bl) {
                    try {
                        boolean bl2 = this.registerWithServer();
                        if (bl2) break block7;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(this.mTag, "Error handling first listener.", remoteException);
                        return false;
                    }
                    Log.e(this.mTag, "Unable to register listener transport.");
                    return false;
                }
            }
            if (this.mListeners.contains(TListener)) {
                return true;
            }
            this.mListeners.add(TListener);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void foreach(ListenerOperation listenerOperation) {
        ArrayList<TListener> arrayList;
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            arrayList = new ArrayList<TListener>(this.mListeners);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                listenerOperation.execute(e);
            }
            catch (RemoteException remoteException) {
                Log.e(this.mTag, "Error in monitored listener.", remoteException);
                continue;
            }
            break;
        }
        return;
    }

    protected abstract boolean registerWithServer() throws RemoteException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(TListener TListener) {
        Preconditions.checkNotNull(TListener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            if (!this.mListeners.remove(TListener)) return;
            boolean bl = this.mListeners.isEmpty();
            if (!bl) return;
            boolean bl2 = true;
            if (!bl2) return;
            try {
                this.unregisterFromServer();
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    protected abstract void unregisterFromServer() throws RemoteException;

    protected static interface ListenerOperation<TListener> {
        public void execute(TListener var1) throws RemoteException;
    }
}

