/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditLayout;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.SoftInputWindow;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class InputMethodService
extends AbstractInputMethodService {
    public static final int BACK_DISPOSITION_DEFAULT = 0;
    public static final int BACK_DISPOSITION_WILL_DISMISS = 2;
    public static final int BACK_DISPOSITION_WILL_NOT_DISMISS = 1;
    static final boolean DEBUG = false;
    public static final int IME_ACTIVE = 1;
    public static final int IME_VISIBLE = 2;
    static final int MOVEMENT_DOWN = -1;
    static final int MOVEMENT_UP = -2;
    static final String TAG = "InputMethodService";
    final View.OnClickListener mActionClickListener;
    int mBackDisposition;
    FrameLayout mCandidatesFrame;
    boolean mCandidatesViewStarted;
    int mCandidatesVisibility;
    CompletionInfo[] mCurCompletions;
    ViewGroup mExtractAccessories;
    Button mExtractAction;
    ExtractEditText mExtractEditText;
    FrameLayout mExtractFrame;
    View mExtractView;
    boolean mExtractViewHidden;
    ExtractedText mExtractedText;
    int mExtractedToken;
    boolean mFullscreenApplied;
    ViewGroup mFullscreenArea;
    boolean mHardwareAccelerated = false;
    InputMethodManager mImm;
    boolean mInShowWindow;
    LayoutInflater mInflater;
    boolean mInitialized;
    InputBinding mInputBinding;
    InputConnection mInputConnection;
    EditorInfo mInputEditorInfo;
    FrameLayout mInputFrame;
    boolean mInputStarted;
    View mInputView;
    boolean mInputViewStarted;
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer;
    boolean mIsFullscreen;
    boolean mIsInputViewShown;
    boolean mLastShowInputRequested;
    View mRootView;
    int mShowInputFlags;
    boolean mShowInputForced;
    boolean mShowInputRequested;
    InputConnection mStartedInputConnection;
    int mStatusIcon;
    int mTheme = 0;
    TypedArray mThemeAttrs;
    final Insets mTmpInsets = new Insets();
    final int[] mTmpLocation = new int[2];
    IBinder mToken;
    SoftInputWindow mWindow;
    boolean mWindowAdded;
    boolean mWindowCreated;
    boolean mWindowVisible;
    boolean mWindowWasVisible;

    public InputMethodService() {
        this.mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

            @Override
            public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo internalInsetsInfo) {
                if (InputMethodService.this.isExtractViewShown()) {
                    int n;
                    View view = InputMethodService.this.getWindow().getWindow().getDecorView();
                    Rect rect = internalInsetsInfo.contentInsets;
                    Rect rect2 = internalInsetsInfo.visibleInsets;
                    rect2.top = n = view.getHeight();
                    rect.top = n;
                    internalInsetsInfo.touchableRegion.setEmpty();
                    internalInsetsInfo.setTouchableInsets(0);
                    return;
                }
                InputMethodService.this.onComputeInsets(InputMethodService.this.mTmpInsets);
                internalInsetsInfo.contentInsets.top = InputMethodService.this.mTmpInsets.contentTopInsets;
                internalInsetsInfo.visibleInsets.top = InputMethodService.this.mTmpInsets.visibleTopInsets;
                internalInsetsInfo.touchableRegion.set(InputMethodService.this.mTmpInsets.touchableRegion);
                internalInsetsInfo.setTouchableInsets(InputMethodService.this.mTmpInsets.touchableInsets);
            }
        };
        this.mActionClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view) {
                EditorInfo editorInfo = InputMethodService.this.getCurrentInputEditorInfo();
                InputConnection inputConnection = InputMethodService.this.getCurrentInputConnection();
                if (editorInfo == null || inputConnection == null) return;
                if (editorInfo.actionId != 0) {
                    inputConnection.performEditorAction(editorInfo.actionId);
                    return;
                } else {
                    if ((0xFF & editorInfo.imeOptions) == 1) return;
                    inputConnection.performEditorAction(0xFF & editorInfo.imeOptions);
                    return;
                }
            }
        };
    }

    private void doHideWindow() {
        this.mImm.setImeWindowStatus(this.mToken, 0, this.mBackDisposition);
        this.hideWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finishViews() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(false);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(false);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleBack(boolean bl) {
        if (this.mShowInputRequested) {
            ExtractEditLayout extractEditLayout;
            if (this.isExtractViewShown() && this.mExtractView instanceof ExtractEditLayout && (extractEditLayout = (ExtractEditLayout)this.mExtractView).isActionModeStarted()) {
                if (!bl) return true;
                extractEditLayout.finishActionMode();
                return true;
            }
            if (!bl) return true;
            this.requestHideSelf(0);
            return true;
        }
        if (!this.mWindowVisible) {
            return false;
        }
        if (this.mCandidatesVisibility == 0) {
            if (!bl) return true;
            this.setCandidatesViewShown(false);
            return true;
        } else {
            if (!bl) return true;
            this.doHideWindow();
            return true;
        }
    }

    private void onToggleSoftInput(int n, int n2) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(n2);
            return;
        }
        this.requestShowSelf(n);
    }

    private void requestShowSelf(int n) {
        this.mImm.showSoftInputFromInputMethod(this.mToken, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void doFinishInput() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(true);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(true);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean doMovementKey(int n, KeyEvent keyEvent, int n2) {
        ExtractEditText extractEditText = this.mExtractEditText;
        if (!this.isExtractViewShown()) return false;
        if (!this.isInputViewShown()) return false;
        if (extractEditText == null) return false;
        MovementMethod movementMethod = extractEditText.getMovementMethod();
        Layout layout2 = extractEditText.getLayout();
        if (movementMethod != null && layout2 != null) {
            if (n2 == -1) {
                if (movementMethod.onKeyDown(extractEditText, extractEditText.getText(), n, keyEvent)) {
                    this.reportExtractedMovement(n, 1);
                    return true;
                }
            } else if (n2 == -2) {
                if (movementMethod.onKeyUp(extractEditText, extractEditText.getText(), n, keyEvent)) return true;
            } else if (movementMethod.onKeyOther(extractEditText, extractEditText.getText(), keyEvent)) {
                this.reportExtractedMovement(n, n2);
            } else {
                KeyEvent keyEvent2 = KeyEvent.changeAction(keyEvent, 0);
                if (movementMethod.onKeyDown(extractEditText, extractEditText.getText(), n, keyEvent2)) {
                    KeyEvent keyEvent3 = KeyEvent.changeAction(keyEvent, 1);
                    movementMethod.onKeyUp(extractEditText, extractEditText.getText(), n, keyEvent3);
                    while (--n2 > 0) {
                        movementMethod.onKeyDown(extractEditText, extractEditText.getText(), n, keyEvent2);
                        movementMethod.onKeyUp(extractEditText, extractEditText.getText(), n, keyEvent3);
                    }
                    this.reportExtractedMovement(n, n2);
                }
            }
        }
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void doStartInput(InputConnection inputConnection, EditorInfo editorInfo, boolean bl) {
        if (!bl) {
            this.doFinishInput();
        }
        this.mInputStarted = true;
        this.mStartedInputConnection = inputConnection;
        this.mInputEditorInfo = editorInfo;
        this.initialize();
        this.onStartInput(editorInfo, bl);
        if (!this.mWindowVisible) return;
        if (this.mShowInputRequested) {
            this.mInputViewStarted = true;
            this.onStartInputView(this.mInputEditorInfo, bl);
            this.startExtractingText(true);
            return;
        } else {
            if (this.mCandidatesVisibility != 0) return;
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, bl);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        PrintWriterPrinter printWriterPrinter = new PrintWriterPrinter(printWriter);
        printWriterPrinter.println("Input method service state for " + this + ":");
        printWriterPrinter.println("  mWindowCreated=" + this.mWindowCreated + " mWindowAdded=" + this.mWindowAdded);
        printWriterPrinter.println("  mWindowVisible=" + this.mWindowVisible + " mWindowWasVisible=" + this.mWindowWasVisible + " mInShowWindow=" + this.mInShowWindow);
        printWriterPrinter.println("  Configuration=" + this.getResources().getConfiguration());
        printWriterPrinter.println("  mToken=" + this.mToken);
        printWriterPrinter.println("  mInputBinding=" + this.mInputBinding);
        printWriterPrinter.println("  mInputConnection=" + this.mInputConnection);
        printWriterPrinter.println("  mStartedInputConnection=" + this.mStartedInputConnection);
        printWriterPrinter.println("  mInputStarted=" + this.mInputStarted + " mInputViewStarted=" + this.mInputViewStarted + " mCandidatesViewStarted=" + this.mCandidatesViewStarted);
        if (this.mInputEditorInfo != null) {
            printWriterPrinter.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(printWriterPrinter, "    ");
        } else {
            printWriterPrinter.println("  mInputEditorInfo: null");
        }
        printWriterPrinter.println("  mShowInputRequested=" + this.mShowInputRequested + " mLastShowInputRequested=" + this.mLastShowInputRequested + " mShowInputForced=" + this.mShowInputForced + " mShowInputFlags=0x" + Integer.toHexString(this.mShowInputFlags));
        printWriterPrinter.println("  mCandidatesVisibility=" + this.mCandidatesVisibility + " mFullscreenApplied=" + this.mFullscreenApplied + " mIsFullscreen=" + this.mIsFullscreen + " mExtractViewHidden=" + this.mExtractViewHidden);
        if (this.mExtractedText != null) {
            printWriterPrinter.println("  mExtractedText:");
            printWriterPrinter.println("    text=" + this.mExtractedText.text.length() + " chars" + " startOffset=" + this.mExtractedText.startOffset);
            printWriterPrinter.println("    selectionStart=" + this.mExtractedText.selectionStart + " selectionEnd=" + this.mExtractedText.selectionEnd + " flags=0x" + Integer.toHexString(this.mExtractedText.flags));
        } else {
            printWriterPrinter.println("  mExtractedText: null");
        }
        printWriterPrinter.println("  mExtractedToken=" + this.mExtractedToken);
        printWriterPrinter.println("  mIsInputViewShown=" + this.mIsInputViewShown + " mStatusIcon=" + this.mStatusIcon);
        printWriterPrinter.println("Last computed insets:");
        printWriterPrinter.println("  contentTopInsets=" + this.mTmpInsets.contentTopInsets + " visibleTopInsets=" + this.mTmpInsets.visibleTopInsets + " touchableInsets=" + this.mTmpInsets.touchableInsets + " touchableRegion=" + this.mTmpInsets.touchableRegion);
    }

    public boolean enableHardwareAcceleration() {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        if (ActivityManager.isHighEndGfx()) {
            this.mHardwareAccelerated = true;
            return true;
        }
        return false;
    }

    public int getBackDisposition() {
        return this.mBackDisposition;
    }

    public int getCandidatesHiddenVisibility() {
        if (this.isExtractViewShown()) {
            return 8;
        }
        return 4;
    }

    public InputBinding getCurrentInputBinding() {
        return this.mInputBinding;
    }

    public InputConnection getCurrentInputConnection() {
        InputConnection inputConnection = this.mStartedInputConnection;
        if (inputConnection != null) {
            return inputConnection;
        }
        return this.mInputConnection;
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    public boolean getCurrentInputStarted() {
        return this.mInputStarted;
    }

    public int getInputMethodWindowRecommendedHeight() {
        return this.mImm.getInputMethodWindowVisibleHeight();
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public int getMaxWidth() {
        return ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public CharSequence getTextForImeAction(int n) {
        switch (n & 0xFF) {
            default: {
                return this.getText(17040682);
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17040676);
            }
            case 3: {
                return this.getText(17040677);
            }
            case 4: {
                return this.getText(17040678);
            }
            case 5: {
                return this.getText(17040679);
            }
            case 6: {
                return this.getText(17040680);
            }
            case 7: 
        }
        return this.getText(17040681);
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void hideStatusIcon() {
        this.mStatusIcon = 0;
        this.mImm.hideStatusIcon(this.mToken);
    }

    public void hideWindow() {
        this.finishViews();
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
            this.onWindowHidden();
            this.mWindowWasVisible = false;
        }
    }

    void initViews() {
        this.mInitialized = false;
        this.mWindowCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputForced = false;
        this.mThemeAttrs = this.obtainStyledAttributes(R.styleable.InputMethodService);
        this.mRootView = this.mInflater.inflate(17367158, null);
        this.mRootView.setSystemUiVisibility(768);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        if (Settings.Global.getInt(this.getContentResolver(), "fancy_ime_animations", 0) != 0) {
            this.mWindow.getWindow().setWindowAnimations(16974559);
        }
        this.mFullscreenArea = (ViewGroup)this.mRootView.findViewById(16909137);
        this.mExtractViewHidden = false;
        this.mExtractFrame = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = this.getCandidatesHiddenVisibility();
        this.mCandidatesFrame.setVisibility(this.mCandidatesVisibility);
        this.mInputFrame.setVisibility(8);
    }

    void initialize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.onInitializeInterface();
        }
    }

    public boolean isExtractViewShown() {
        return this.mIsFullscreen && !this.mExtractViewHidden;
    }

    public boolean isFullscreenMode() {
        return this.mIsFullscreen;
    }

    public boolean isInputViewShown() {
        return this.mIsInputViewShown && this.mWindowVisible;
    }

    public boolean isShowInputRequested() {
        return this.mShowInputRequested;
    }

    public void onAppPrivateCommand(String string2, Bundle bundle) {
    }

    public void onBindInput() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onComputeInsets(Insets insets) {
        int[] nArray = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(nArray);
        } else {
            nArray[1] = this.getWindow().getWindow().getDecorView().getHeight();
        }
        insets.contentTopInsets = this.isFullscreenMode() ? this.getWindow().getWindow().getDecorView().getHeight() : nArray[1];
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(nArray);
        }
        insets.visibleTopInsets = nArray[1];
        insets.touchableInsets = 2;
        insets.touchableRegion.setEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onConfigurationChanged(Configuration configuration) {
        block7: {
            block9: {
                block8: {
                    super.onConfigurationChanged(configuration);
                    boolean bl = this.mWindowVisible;
                    int n = this.mShowInputFlags;
                    boolean bl2 = this.mShowInputRequested;
                    CompletionInfo[] completionInfoArray = this.mCurCompletions;
                    this.initViews();
                    this.mInputViewStarted = false;
                    this.mCandidatesViewStarted = false;
                    if (this.mInputStarted) {
                        this.doStartInput(this.getCurrentInputConnection(), this.getCurrentInputEditorInfo(), true);
                    }
                    if (!bl) break block7;
                    if (!bl2) break block8;
                    if (this.onShowInputRequested(n, true)) {
                        this.showWindow(true);
                        if (completionInfoArray != null) {
                            this.mCurCompletions = completionInfoArray;
                            this.onDisplayCompletions(completionInfoArray);
                        }
                        break block9;
                    } else {
                        this.doHideWindow();
                    }
                    break block9;
                }
                if (this.mCandidatesVisibility == 0) {
                    this.showWindow(false);
                } else {
                    this.doHideWindow();
                }
            }
            boolean bl = this.onEvaluateInputViewShown();
            InputMethodManager inputMethodManager = this.mImm;
            IBinder iBinder = this.mToken;
            int n = 0;
            if (bl) {
                n = 2;
            }
            inputMethodManager.setImeWindowStatus(iBinder, n | 1, this.mBackDisposition);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onConfigureWindow(Window window, boolean bl, boolean bl2) {
        int n = this.mWindow.getWindow().getAttributes().height;
        int n2 = bl ? -1 : -2;
        if (this.mIsInputViewShown && n != n2) {
            Log.w(TAG, "Window size has been changed. This may cause jankiness of resizing window: " + n + " -> " + n2);
        }
        this.mWindow.getWindow().setLayout(-1, n2);
    }

    @Override
    public void onCreate() {
        this.mTheme = Resources.selectSystemTheme(this.mTheme, this.getApplicationInfo().targetSdkVersion, 16973908, 16973951, 16974142, 16974142);
        super.setTheme(this.mTheme);
        super.onCreate();
        this.mImm = (InputMethodManager)this.getSystemService("input_method");
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this, "InputMethod", this.mTheme, null, null, this.mDispatcherState, 2011, 80, false);
        if (this.mHardwareAccelerated) {
            this.mWindow.getWindow().addFlags(0x1000000);
        }
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
    }

    public View onCreateCandidatesView() {
        return null;
    }

    public View onCreateExtractTextView() {
        return this.mInflater.inflate(17367159, null);
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return new InputMethodImpl();
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl();
    }

    public View onCreateInputView() {
        return null;
    }

    protected void onCurrentInputMethodSubtypeChanged(InputMethodSubtype inputMethodSubtype) {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.doFinishInput();
        if (this.mWindowAdded) {
            this.mWindow.getWindow().setWindowAnimations(0);
            this.mWindow.dismiss();
        }
    }

    public void onDisplayCompletions(CompletionInfo[] completionInfoArray) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onEvaluateFullscreenMode() {
        return this.getResources().getConfiguration().orientation == 2 && (this.mInputEditorInfo == null || (0x2000000 & this.mInputEditorInfo.imeOptions) == 0);
    }

    public boolean onEvaluateInputViewShown() {
        Configuration configuration = this.getResources().getConfiguration();
        return configuration.keyboard == 1 || configuration.hardKeyboardHidden == 2;
    }

    public boolean onExtractTextContextMenuItem(int n) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            inputConnection.performContextMenuAction(n);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onExtractedCursorMovement(int n, int n2) {
        if (this.mExtractEditText == null || n2 == 0 || !this.mExtractEditText.hasVerticalScrollBar()) {
            return;
        }
        this.setCandidatesViewShown(false);
    }

    public void onExtractedDeleteText(int n, int n2) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            inputConnection.setSelection(n, n);
            inputConnection.deleteSurroundingText(0, n2 - n);
        }
    }

    public void onExtractedReplaceText(int n, int n2, CharSequence charSequence) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            inputConnection.setComposingRegion(n, n2);
            inputConnection.commitText(charSequence, 1);
        }
    }

    public void onExtractedSelectionChanged(int n, int n2) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            inputConnection.setSelection(n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onExtractedSetSpan(Object object, int n, int n2, int n3) {
        CharSequence charSequence;
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null || !inputConnection.setSelection(n, n2) || !((charSequence = inputConnection.getSelectedText(1)) instanceof Spannable)) {
            return;
        }
        ((Spannable)charSequence).setSpan(object, 0, charSequence.length(), n3);
        inputConnection.setComposingRegion(n, n2);
        inputConnection.commitText(charSequence, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onExtractedTextClicked() {
        if (this.mExtractEditText == null || !this.mExtractEditText.hasVerticalScrollBar()) {
            return;
        }
        this.setCandidatesViewShown(false);
    }

    public void onExtractingInputChanged(EditorInfo editorInfo) {
        if (editorInfo.inputType == 0) {
            this.requestHideSelf(2);
        }
    }

    public void onFinishCandidatesView(boolean bl) {
        InputConnection inputConnection;
        if (!bl && (inputConnection = this.getCurrentInputConnection()) != null) {
            inputConnection.finishComposingText();
        }
    }

    public void onFinishInput() {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            inputConnection.finishComposingText();
        }
    }

    public void onFinishInputView(boolean bl) {
        InputConnection inputConnection;
        if (!bl && (inputConnection = this.getCurrentInputConnection()) != null) {
            inputConnection.finishComposingText();
        }
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return false;
    }

    public void onInitializeInterface() {
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 4) {
            boolean bl = this.handleBack(false);
            boolean bl2 = false;
            if (bl) {
                keyEvent.startTracking();
                bl2 = true;
            }
            return bl2;
        }
        return this.doMovementKey(n, keyEvent, -1);
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.doMovementKey(n, keyEvent, n2);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 4 && keyEvent.isTracking() && !keyEvent.isCanceled()) {
            return this.handleBack(true);
        }
        return this.doMovementKey(n, keyEvent, -2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onShowInputRequested(int n, boolean bl) {
        if (!this.onEvaluateInputViewShown() || (n & 1) == 0 && (!bl && this.onEvaluateFullscreenMode() || this.getResources().getConfiguration().keyboard != 1)) {
            return false;
        }
        if ((n & 2) != 0) {
            this.mShowInputForced = true;
        }
        return true;
    }

    public void onStartCandidatesView(EditorInfo editorInfo, boolean bl) {
    }

    public void onStartInput(EditorInfo editorInfo, boolean bl) {
    }

    public void onStartInputView(EditorInfo editorInfo, boolean bl) {
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    public void onUnbindInput() {
    }

    @Deprecated
    public void onUpdateCursor(Rect rect) {
    }

    public void onUpdateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdateExtractedText(int n, ExtractedText extractedText) {
        if (this.mExtractedToken != n || extractedText == null || this.mExtractEditText == null) {
            return;
        }
        this.mExtractedText = extractedText;
        this.mExtractEditText.setExtractedText(extractedText);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdateExtractingViews(EditorInfo editorInfo) {
        int n = 1;
        if (!this.isExtractViewShown() || this.mExtractAccessories == null) return;
        if (editorInfo.actionLabel == null && ((0xFF & editorInfo.imeOptions) == n || (0x20000000 & editorInfo.imeOptions) != 0 || editorInfo.inputType == 0)) {
            n = 0;
        }
        if (n != 0) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction == null) return;
            if (editorInfo.actionLabel != null) {
                this.mExtractAction.setText(editorInfo.actionLabel);
            } else {
                this.mExtractAction.setText(this.getTextForImeAction(editorInfo.imeOptions));
            }
            this.mExtractAction.setOnClickListener(this.mActionClickListener);
            return;
        }
        this.mExtractAccessories.setVisibility(8);
        if (this.mExtractAction == null) {
            return;
        }
        this.mExtractAction.setOnClickListener(null);
    }

    public void onUpdateExtractingVisibility(EditorInfo editorInfo) {
        if (editorInfo.inputType == 0 || (0x10000000 & editorInfo.imeOptions) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        ExtractEditText extractEditText = this.mExtractEditText;
        if (extractEditText != null && this.isFullscreenMode() && this.mExtractedText != null) {
            int n7 = this.mExtractedText.startOffset;
            extractEditText.startInternalChanges();
            int n8 = n3 - n7;
            int n9 = n4 - n7;
            int n10 = extractEditText.getText().length();
            if (n8 < 0) {
                n8 = 0;
            } else if (n8 > n10) {
                n8 = n10;
            }
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 > n10) {
                n9 = n10;
            }
            extractEditText.setSelection(n8, n9);
            extractEditText.finishInternalChanges();
        }
    }

    public void onViewClicked(boolean bl) {
    }

    public void onWindowHidden() {
    }

    public void onWindowShown() {
    }

    /*
     * Enabled aggressive block sorting
     */
    void reportExtractedMovement(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 21: {
                n3 = -n2;
                n4 = 0;
                break;
            }
            case 22: {
                n3 = n2;
                n4 = 0;
                break;
            }
            case 19: {
                n4 = -n2;
                n3 = 0;
                break;
            }
            case 20: {
                n4 = n2;
                n3 = 0;
                break;
            }
        }
        this.onExtractedCursorMovement(n3, n4);
    }

    public void requestHideSelf(int n) {
        this.mImm.hideSoftInputFromInputMethod(this.mToken, n);
    }

    public boolean sendDefaultEditorAction(boolean bl) {
        EditorInfo editorInfo = this.getCurrentInputEditorInfo();
        if (!(editorInfo == null || bl && (0x40000000 & editorInfo.imeOptions) != 0 || (0xFF & editorInfo.imeOptions) == 1)) {
            InputConnection inputConnection = this.getCurrentInputConnection();
            if (inputConnection != null) {
                inputConnection.performEditorAction(0xFF & editorInfo.imeOptions);
            }
            return true;
        }
        return false;
    }

    public void sendDownUpKeyEvents(int n) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        long l = SystemClock.uptimeMillis();
        inputConnection.sendKeyEvent(new KeyEvent(l, l, 0, n, 0, 0, -1, 0, 6));
        inputConnection.sendKeyEvent(new KeyEvent(l, SystemClock.uptimeMillis(), 1, n, 0, 0, -1, 0, 6));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendKeyChar(char c) {
        switch (c) {
            default: {
                if (c < '0' || c > '9') break;
                this.sendDownUpKeyEvents(7 + (c - 48));
                return;
            }
            case '\n': {
                if (this.sendDefaultEditorAction(true)) return;
                this.sendDownUpKeyEvents(66);
                return;
            }
        }
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) return;
        inputConnection.commitText(String.valueOf(c), 1);
    }

    public void setBackDisposition(int n) {
        this.mBackDisposition = n;
    }

    public void setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        this.mCandidatesFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setCandidatesViewShown(boolean bl) {
        block3: {
            block2: {
                this.updateCandidatesVisibility(bl);
                if (this.mShowInputRequested || this.mWindowVisible == bl) break block2;
                if (!bl) break block3;
                this.showWindow(false);
            }
            return;
        }
        this.doHideWindow();
    }

    public void setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        this.mExtractFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mExtractView = view;
        if (view != null) {
            this.mExtractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = (Button)view.findViewById(16909139);
            if (this.mExtractAction != null) {
                this.mExtractAccessories = (ViewGroup)view.findViewById(16909138);
            }
            this.startExtractingText(false);
            return;
        }
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtractViewShown(boolean bl) {
        if (this.mExtractViewHidden == bl) {
            boolean bl2 = !bl;
            this.mExtractViewHidden = bl2;
            this.updateExtractFrameVisibility();
        }
    }

    public void setInputView(View view) {
        this.mInputFrame.removeAllViews();
        this.mInputFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
        this.mInputView = view;
    }

    @Override
    public void setTheme(int n) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = n;
    }

    public void showStatusIcon(int n) {
        this.mStatusIcon = n;
        this.mImm.showStatusIcon(this.mToken, this.getPackageName(), n);
    }

    public void showWindow(boolean bl) {
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mWindowWasVisible = this.mWindowVisible;
            this.mInShowWindow = true;
            this.showWindowInner(bl);
            return;
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void showWindowInner(boolean bl) {
        boolean bl2;
        boolean bl3;
        block11: {
            block10: {
                bl3 = this.mWindowVisible;
                this.mWindowVisible = true;
                if (this.mShowInputRequested) break block10;
                boolean bl4 = this.mInputStarted;
                bl2 = false;
                if (bl4) {
                    bl2 = false;
                    if (bl) {
                        bl2 = true;
                        this.mShowInputRequested = true;
                    }
                }
                break block11;
            }
            bl2 = false;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mWindowAdded || !this.mWindowCreated) {
            this.mWindowAdded = true;
            this.mWindowCreated = true;
            this.initialize();
            View view = this.onCreateCandidatesView();
            if (view != null) {
                this.setCandidatesView(view);
            }
        }
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, false);
        }
        if (bl2) {
            this.startExtractingText(false);
        }
        if (!bl3) {
            this.mImm.setImeWindowStatus(this.mToken, 1, this.mBackDisposition);
            this.onWindowShown();
            this.mWindow.show();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startExtractingText(boolean bl) {
        ExtractEditText extractEditText;
        block9: {
            extractEditText = this.mExtractEditText;
            if (extractEditText != null && this.getCurrentInputStarted() && this.isFullscreenMode()) {
                this.mExtractedToken = 1 + this.mExtractedToken;
                ExtractedTextRequest extractedTextRequest = new ExtractedTextRequest();
                extractedTextRequest.token = this.mExtractedToken;
                extractedTextRequest.flags = 1;
                extractedTextRequest.hintMaxLines = 10;
                extractedTextRequest.hintMaxChars = 10000;
                InputConnection inputConnection = this.getCurrentInputConnection();
                ExtractedText extractedText = inputConnection == null ? null : inputConnection.getExtractedText(extractedTextRequest, 1);
                this.mExtractedText = extractedText;
                if (this.mExtractedText == null || inputConnection == null) {
                    Log.e(TAG, "Unexpected null in startExtractingText : mExtractedText = " + this.mExtractedText + ", input connection = " + inputConnection);
                }
                EditorInfo editorInfo = this.getCurrentInputEditorInfo();
                extractEditText.startInternalChanges();
                this.onUpdateExtractingVisibility(editorInfo);
                this.onUpdateExtractingViews(editorInfo);
                int n = editorInfo.inputType;
                if ((n & 0xF) == 1 && (0x40000 & n) != 0) {
                    n |= 0x20000;
                }
                extractEditText.setInputType(n);
                extractEditText.setHint(editorInfo.hintText);
                if (this.mExtractedText != null) {
                    extractEditText.setEnabled(true);
                    extractEditText.setExtractedText(this.mExtractedText);
                } else {
                    extractEditText.setEnabled(false);
                    extractEditText.setText("");
                }
                if (!bl) break block9;
                this.onExtractingInputChanged(editorInfo);
            }
        }
        return;
        finally {
            extractEditText.finishInternalChanges();
        }
    }

    public void switchInputMethod(String string2) {
        this.mImm.setInputMethod(this.mToken, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateCandidatesVisibility(boolean bl) {
        int n = bl ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != n) {
            this.mCandidatesFrame.setVisibility(n);
            this.mCandidatesVisibility = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateExtractFrameVisibility() {
        int n;
        int n2 = 1;
        if (this.isFullscreenMode()) {
            n = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(n);
        } else {
            this.mExtractFrame.setVisibility(8);
            n = 0;
        }
        int n3 = this.mCandidatesVisibility == 0 ? n2 : 0;
        this.updateCandidatesVisibility(n3 != 0);
        if (this.mWindowWasVisible && this.mFullscreenArea.getVisibility() != n) {
            int n4;
            TypedArray typedArray = this.mThemeAttrs;
            if (n != 0) {
                n2 = 2;
            }
            if ((n4 = typedArray.getResourceId(n2, 0)) != 0) {
                this.mFullscreenArea.startAnimation(AnimationUtils.loadAnimation(this, n4));
            }
        }
        this.mFullscreenArea.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateFullscreenMode() {
        boolean bl = true;
        boolean bl2 = this.mShowInputRequested && this.onEvaluateFullscreenMode() ? bl : false;
        boolean bl3 = this.mLastShowInputRequested != this.mShowInputRequested ? bl : false;
        if (this.mIsFullscreen != bl2 || !this.mFullscreenApplied) {
            bl3 = true;
            this.mIsFullscreen = bl2;
            InputConnection inputConnection = this.getCurrentInputConnection();
            if (inputConnection != null) {
                inputConnection.reportFullscreenMode(bl2);
            }
            this.mFullscreenApplied = bl;
            this.initialize();
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (bl2) {
                this.mFullscreenArea.setBackgroundDrawable(this.mThemeAttrs.getDrawable(0));
                layoutParams.height = 0;
                layoutParams.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                layoutParams.height = -2;
                layoutParams.weight = 0.0f;
            }
            ((ViewGroup)this.mFullscreenArea.getParent()).updateViewLayout(this.mFullscreenArea, layoutParams);
            if (bl2) {
                View view;
                if (this.mExtractView == null && (view = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(view);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (bl3) {
            Window window = this.mWindow.getWindow();
            if (this.mShowInputRequested) {
                bl = false;
            }
            this.onConfigureWindow(window, bl2, bl);
            this.mLastShowInputRequested = this.mShowInputRequested;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateInputViewShown() {
        boolean bl = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != bl && this.mWindowVisible) {
            this.mIsInputViewShown = bl;
            FrameLayout frameLayout = this.mInputFrame;
            int n = 0;
            if (!bl) {
                n = 8;
            }
            frameLayout.setVisibility(n);
            if (this.mInputView == null) {
                this.initialize();
                View view = this.onCreateInputView();
                if (view != null) {
                    this.setInputView(view);
                }
            }
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl {
        @Override
        public void attachToken(IBinder iBinder) {
            if (InputMethodService.this.mToken == null) {
                InputMethodService.this.mToken = iBinder;
                InputMethodService.this.mWindow.setToken(iBinder);
            }
        }

        @Override
        public void bindInput(InputBinding inputBinding) {
            InputMethodService.this.mInputBinding = inputBinding;
            InputMethodService.this.mInputConnection = inputBinding.getConnection();
            InputConnection inputConnection = InputMethodService.this.getCurrentInputConnection();
            if (inputConnection != null) {
                inputConnection.reportFullscreenMode(InputMethodService.this.mIsFullscreen);
            }
            InputMethodService.this.initialize();
            InputMethodService.this.onBindInput();
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
            InputMethodService.this.onCurrentInputMethodSubtypeChanged(inputMethodSubtype);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void hideSoftInput(int n, ResultReceiver resultReceiver) {
            boolean bl = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.mShowInputForced = false;
            InputMethodService.this.doHideWindow();
            if (resultReceiver != null) {
                int n2;
                if (bl != InputMethodService.this.isInputViewShown()) {
                    n2 = 3;
                } else {
                    n2 = 0;
                    if (!bl) {
                        n2 = 1;
                    }
                }
                resultReceiver.send(n2, null);
            }
        }

        @Override
        public void restartInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InputMethodService.this.doStartInput(inputConnection, editorInfo, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void showSoftInput(int n, ResultReceiver resultReceiver) {
            int n2 = 2;
            boolean bl = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            if (InputMethodService.this.onShowInputRequested(n, false)) {
                try {
                    InputMethodService.this.showWindow(true);
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    InputMethodService.this.mWindowVisible = false;
                    InputMethodService.this.mWindowAdded = false;
                }
            }
            boolean bl2 = InputMethodService.this.isInputViewShown();
            InputMethodManager inputMethodManager = InputMethodService.this.mImm;
            IBinder iBinder = InputMethodService.this.mToken;
            int n3 = bl2 ? n2 : 0;
            inputMethodManager.setImeWindowStatus(iBinder, n3 | 1, InputMethodService.this.mBackDisposition);
            if (resultReceiver != null) {
                if (bl == InputMethodService.this.isInputViewShown()) {
                    n2 = bl ? 0 : 1;
                }
                resultReceiver.send(n2, null);
            }
        }

        @Override
        public void startInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InputMethodService.this.doStartInput(inputConnection, editorInfo, false);
        }

        @Override
        public void unbindInput() {
            InputMethodService.this.onUnbindInput();
            InputMethodService.this.mInputBinding = null;
            InputMethodService.this.mInputConnection = null;
        }
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl {
        @Override
        public void appPrivateCommand(String string2, Bundle bundle) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onAppPrivateCommand(string2, bundle);
        }

        @Override
        public void displayCompletions(CompletionInfo[] completionInfoArray) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.mCurCompletions = completionInfoArray;
            InputMethodService.this.onDisplayCompletions(completionInfoArray);
        }

        @Override
        public void finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.doFinishInput();
        }

        @Override
        public void toggleSoftInput(int n, int n2) {
            InputMethodService.this.onToggleSoftInput(n, n2);
        }

        @Override
        public void updateCursor(Rect rect) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursor(rect);
        }

        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursorAnchorInfo(cursorAnchorInfo);
        }

        @Override
        public void updateExtractedText(int n, ExtractedText extractedText) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateExtractedText(n, extractedText);
        }

        @Override
        public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateSelection(n, n2, n3, n4, n5, n6);
        }

        @Override
        public void viewClicked(boolean bl) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onViewClicked(bl);
        }
    }

    public static final class Insets {
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public int contentTopInsets;
        public int touchableInsets;
        public final Region touchableRegion = new Region();
        public int visibleTopInsets;
    }
}

