/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import java.nio.ByteBuffer;

public class UsbRequest {
    private static final String TAG = "UsbRequest";
    private ByteBuffer mBuffer;
    private Object mClientData;
    private UsbEndpoint mEndpoint;
    private int mLength;
    private long mNativeContext;

    private native boolean native_cancel();

    private native void native_close();

    private native int native_dequeue_array(byte[] var1, int var2, boolean var3);

    private native int native_dequeue_direct();

    private native boolean native_init(UsbDeviceConnection var1, int var2, int var3, int var4, int var5);

    private native boolean native_queue_array(byte[] var1, int var2, boolean var3);

    private native boolean native_queue_direct(ByteBuffer var1, int var2, boolean var3);

    public boolean cancel() {
        return this.native_cancel();
    }

    public void close() {
        this.mEndpoint = null;
        this.native_close();
    }

    /*
     * Enabled aggressive block sorting
     */
    void dequeue() {
        boolean bl = this.mEndpoint.getDirection() == 0;
        int n = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, bl);
        if (n >= 0) {
            this.mBuffer.position(Math.min(n, this.mLength));
        }
        this.mBuffer = null;
        this.mLength = 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEndpoint != null) {
                Log.v(TAG, "endpoint still open in finalize(): " + this);
                this.close();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public boolean initialize(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint) {
        this.mEndpoint = usbEndpoint;
        return this.native_init(usbDeviceConnection, usbEndpoint.getAddress(), usbEndpoint.getAttributes(), usbEndpoint.getMaxPacketSize(), usbEndpoint.getInterval());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean queue(ByteBuffer byteBuffer, int n) {
        boolean bl;
        boolean bl2 = this.mEndpoint.getDirection() == 0;
        if (byteBuffer.isDirect()) {
            bl = this.native_queue_direct(byteBuffer, n, bl2);
        } else {
            if (!byteBuffer.hasArray()) {
                throw new IllegalArgumentException("buffer is not direct and has no array");
            }
            bl = this.native_queue_array(byteBuffer.array(), n, bl2);
        }
        if (bl) {
            this.mBuffer = byteBuffer;
            this.mLength = n;
        }
        return bl;
    }

    public void setClientData(Object object) {
        this.mClientData = object;
    }
}

