/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.display.UsbDisplay;
import android.os.Parcel;
import android.os.Parcelable;

public final class UsbDisplayStatus
implements Parcelable {
    public static final Parcelable.Creator<UsbDisplayStatus> CREATOR = new Parcelable.Creator<UsbDisplayStatus>(){

        @Override
        public UsbDisplayStatus createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            UsbDisplay usbDisplay = null;
            if (n2 != 0) {
                usbDisplay = UsbDisplay.CREATOR.createFromParcel(parcel);
            }
            return new UsbDisplayStatus(n, usbDisplay);
        }

        public UsbDisplayStatus[] newArray(int n) {
            return new UsbDisplayStatus[n];
        }
    };
    public static final int DISPLAY_STATE_CONNECTED = 2;
    public static final int DISPLAY_STATE_CONNECTING = 1;
    public static final int DISPLAY_STATE_DISCONNECTING = 3;
    public static final int DISPLAY_STATE_NOT_CONNECTED;
    private final UsbDisplay mActiveDisplay;
    private final int mActiveDisplayState;

    public UsbDisplayStatus() {
        this(0, null);
    }

    public UsbDisplayStatus(int n, UsbDisplay usbDisplay) {
        this.mActiveDisplayState = n;
        this.mActiveDisplay = usbDisplay;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public UsbDisplay getActiveDisplay() {
        return this.mActiveDisplay;
    }

    public int getActiveDisplayState() {
        return this.mActiveDisplayState;
    }

    public String toString() {
        return "UsbDisplayStatus{activeDisplayState=" + this.mActiveDisplayState + ", activeDisplay=" + this.mActiveDisplay + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mActiveDisplayState);
        if (this.mActiveDisplay != null) {
            parcel.writeInt(1);
            this.mActiveDisplay.writeToParcel(parcel, n);
            return;
        }
        parcel.writeInt(0);
    }
}

