/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.SensorManager;
import android.os.Handler;
import android.view.Display;
import android.view.DisplayInfo;

public abstract class DisplayManagerInternal {
    public abstract void disableBacklightPowerSaving();

    public abstract void enableBacklightPowerSaving(int var1);

    public abstract DisplayInfo getDisplayInfo(int var1);

    public abstract int getTransformPolicy();

    public abstract void initPowerManagement(DisplayPowerCallbacks var1, Handler var2, SensorManager var3);

    public abstract boolean isProximitySensorAvailable();

    public abstract void performTraversalInTransactionFromWindowManager();

    public abstract void registerDisplayTransactionListener(DisplayTransactionListener var1);

    public abstract boolean requestPowerState(DisplayPowerRequest var1, boolean var2);

    public abstract void setAnimatorStrtegy(int var1);

    public abstract void setDebugLightSensor(boolean var1);

    public abstract void setDisplayInfoOverrideFromWindowManager(int var1, DisplayInfo var2);

    public abstract void setDisplayProperties(int var1, boolean var2, boolean var3, float var4, boolean var5);

    public abstract void setPowerModeForBuiltInDisplay(int var1);

    public abstract void unregisterDisplayTransactionListener(DisplayTransactionListener var1);

    public static interface DisplayPowerCallbacks {
        public void acquireSuspendBlocker();

        public void onDisplayStateChange(int var1);

        public void onProximityNegative();

        public void onProximityPositive();

        public void onStateChanged();

        public void releaseSuspendBlocker();
    }

    public static final class DisplayPowerRequest {
        public static final int POLICY_BRIGHT = 3;
        public static final int POLICY_DIM = 2;
        public static final int POLICY_DOZE = 1;
        public static final int POLICY_OFF;
        public boolean blockScreenOn;
        public boolean brightnessOverride;
        public int dozeScreenBrightness;
        public int dozeScreenState;
        public boolean lowPowerMode;
        public int policy;
        public float screenAutoBrightnessAdjustment;
        public int screenBrightness;
        public int transformPolicy;
        public boolean useAutoBrightness;
        public boolean useProximitySensor;

        public DisplayPowerRequest() {
            this.policy = 3;
            this.useProximitySensor = false;
            this.screenBrightness = 255;
            this.screenAutoBrightnessAdjustment = 0.0f;
            this.useAutoBrightness = false;
            this.blockScreenOn = false;
            this.dozeScreenBrightness = -1;
            this.dozeScreenState = 0;
            this.brightnessOverride = false;
        }

        public DisplayPowerRequest(DisplayPowerRequest displayPowerRequest) {
            this.copyFrom(displayPowerRequest);
        }

        public static String policyToString(int n) {
            switch (n) {
                default: {
                    return Integer.toString(n);
                }
                case 0: {
                    return "OFF";
                }
                case 1: {
                    return "DOZE";
                }
                case 2: {
                    return "DIM";
                }
                case 3: 
            }
            return "BRIGHT";
        }

        public void copyFrom(DisplayPowerRequest displayPowerRequest) {
            this.policy = displayPowerRequest.policy;
            this.useProximitySensor = displayPowerRequest.useProximitySensor;
            this.screenBrightness = displayPowerRequest.screenBrightness;
            this.screenAutoBrightnessAdjustment = displayPowerRequest.screenAutoBrightnessAdjustment;
            this.useAutoBrightness = displayPowerRequest.useAutoBrightness;
            this.blockScreenOn = displayPowerRequest.blockScreenOn;
            this.lowPowerMode = displayPowerRequest.lowPowerMode;
            this.dozeScreenBrightness = displayPowerRequest.dozeScreenBrightness;
            this.dozeScreenState = displayPowerRequest.dozeScreenState;
            this.transformPolicy = displayPowerRequest.transformPolicy;
            this.brightnessOverride = displayPowerRequest.brightnessOverride;
        }

        public boolean equals(DisplayPowerRequest displayPowerRequest) {
            return displayPowerRequest != null && this.policy == displayPowerRequest.policy && this.useProximitySensor == displayPowerRequest.useProximitySensor && this.screenBrightness == displayPowerRequest.screenBrightness && this.screenAutoBrightnessAdjustment == displayPowerRequest.screenAutoBrightnessAdjustment && this.useAutoBrightness == displayPowerRequest.useAutoBrightness && this.blockScreenOn == displayPowerRequest.blockScreenOn && this.lowPowerMode == displayPowerRequest.lowPowerMode && this.dozeScreenBrightness == displayPowerRequest.dozeScreenBrightness && this.dozeScreenState == displayPowerRequest.dozeScreenState && this.transformPolicy == displayPowerRequest.transformPolicy && this.brightnessOverride == displayPowerRequest.brightnessOverride;
        }

        public boolean equals(Object object) {
            return object instanceof DisplayPowerRequest && this.equals((DisplayPowerRequest)object);
        }

        public int hashCode() {
            return 0;
        }

        public boolean isBrightOrDim() {
            return this.policy == 3 || this.policy == 2;
        }

        public String toString() {
            return "policy=" + DisplayPowerRequest.policyToString(this.policy) + ", useProximitySensor=" + this.useProximitySensor + ", screenBrightness=" + this.screenBrightness + ", screenAutoBrightnessAdjustment=" + this.screenAutoBrightnessAdjustment + ", useAutoBrightness=" + this.useAutoBrightness + ", blockScreenOn=" + this.blockScreenOn + ", lowPowerMode=" + this.lowPowerMode + ", dozeScreenBrightness=" + this.dozeScreenBrightness + ", dozeScreenState=" + Display.stateToString(this.dozeScreenState) + ", transformPolicy=" + this.transformPolicy + ", brightnessOverride=" + this.brightnessOverride;
        }
    }

    public static interface DisplayTransactionListener {
        public void onDisplayTransaction();
    }
}

