/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.UsbDisplayStatus;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Handler;
import android.util.SparseArray;
import android.view.Display;
import android.view.Surface;
import java.util.ArrayList;

public final class DisplayManager {
    public static final String ACTION_DISPLAY_UNBLANKED = "android.hardware.display.action.ACTION_DISPLAY_UNBLANKED";
    public static final String ACTION_MIRACAST_DISPLAY_CONNECTED = "android.hardware.display.action.MIRACAST_DISPLAY_CONNECTED";
    public static final String ACTION_MIRACAST_DISPLAY_DISCONNECTED = "android.hardware.display.action.MIRACAST_DISPLAY_DISCONNECTED";
    public static final String ACTION_USB_DISPLAY_CONNECTED = "android.hardware.display.action.USB_DISPLAY_CONNECTED";
    public static final String ACTION_USB_DISPLAY_DISCONNECTED = "android.hardware.display.action.USB_DISPLAY_DISCONNECTED";
    public static final String ACTION_WIFI_DISPLAY_STATUS_CHANGED = "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED";
    public static final String ACTION_WIRELESS_DISPLAY_CONNECTED = "android.hardware.display.action.WIRELESS_DISPLAY_CONNECTED";
    public static final String ACTION_WIRELESS_DISPLAY_DISCONNECTED = "android.hardware.display.action.WIRELESS_DISPLAY_DISCONNECTED";
    private static final boolean DEBUG = false;
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    public static final String EXTRA_WIFI_DISPLAY_STATUS = "android.hardware.display.extra.WIFI_DISPLAY_STATUS";
    public static final String PLAYTO_PACKAGE_NAME = "com.asus.playto";
    private static final String TAG = "DisplayManager";
    public static final int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;
    public static final int VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;
    public static final int VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;
    public static final int VIRTUAL_DISPLAY_FLAG_SECURE = 4;
    private final Context mContext;
    private final SparseArray<Display> mDisplays;
    private final DisplayManagerGlobal mGlobal;
    private final Object mLock = new Object();
    private final ArrayList<Display> mTempDisplays;

    public DisplayManager(Context context) {
        this.mDisplays = new SparseArray();
        this.mTempDisplays = new ArrayList();
        this.mContext = context;
        this.mGlobal = DisplayManagerGlobal.getInstance();
    }

    private void addAllDisplaysLocked(ArrayList<Display> arrayList, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(nArray[i], true);
            if (display == null) continue;
            arrayList.add(display);
        }
    }

    private void addPresentationDisplaysLocked(ArrayList<Display> arrayList, int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(nArray[i], true);
            if (display == null || (8 & display.getFlags()) == 0 || display.getType() != n) continue;
            arrayList.add(display);
        }
    }

    public static boolean callingFromPlayTo(Context context) {
        return PLAYTO_PACKAGE_NAME.equals(context.getPackageManager().getNameForUid(Binder.getCallingUid()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Display getOrCreateDisplayLocked(int n, boolean bl) {
        Display display = this.mDisplays.get(n);
        if (display == null) {
            display = this.mGlobal.getCompatibleDisplay(n, this.mContext.getDisplayAdjustments(n));
            if (display == null) return display;
            this.mDisplays.put(n, display);
            return display;
        }
        if (bl || display.isValid()) return display;
        return null;
    }

    public static boolean isPlayToExist(Context context) {
        boolean bl;
        block3: {
            ApplicationInfo applicationInfo;
            try {
                applicationInfo = context.getPackageManager().getApplicationInfo(PLAYTO_PACKAGE_NAME, 0);
                boolean bl2 = applicationInfo.enabled;
                bl = false;
                if (!bl2) break block3;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            int n = applicationInfo.flags;
            int n2 = n & 1;
            bl = false;
            if (n2 == 0) break block3;
            bl = true;
        }
        return bl;
    }

    public void connectUsbDisplay(String string2) {
        this.mGlobal.disconnectWifiDisplay();
        this.mGlobal.connectUsbDisplay(string2);
    }

    public void connectWifiDisplay(String string2) {
        this.mGlobal.disconnectUsbDisplay();
        this.mGlobal.connectWifiDisplay(string2);
    }

    public VirtualDisplay createVirtualDisplay(MediaProjection mediaProjection, String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler) {
        return this.mGlobal.createVirtualDisplay(this.mContext, mediaProjection, string2, n, n2, n3, surface, n4, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, Surface surface, int n4) {
        return this.createVirtualDisplay(string2, n, n2, n3, surface, n4, null, null);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler) {
        return this.createVirtualDisplay(null, string2, n, n2, n3, surface, n4, callback, handler);
    }

    public void disconnectUsbDisplay() {
        this.mGlobal.disconnectUsbDisplay();
    }

    public void disconnectWifiDisplay() {
        this.mGlobal.disconnectWifiDisplay();
    }

    public void forgetWifiDisplay(String string2) {
        this.mGlobal.forgetWifiDisplay(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Display getDisplay(int n) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDisplayLocked(n, false);
        }
    }

    public Display[] getDisplays() {
        return this.getDisplays(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Display[] getDisplays(String var1_1) {
        var2_2 = this.mGlobal.getDisplayIds();
        var3_3 = this.mLock;
        synchronized (var3_3) {
            if (var1_1 != null) ** GOTO lbl8
            try {
                block8: {
                    this.addAllDisplaysLocked(this.mTempDisplays, var2_2);
                    break block8;
lbl8:
                    // 1 sources

                    if (var1_1.equals("android.hardware.display.category.PRESENTATION")) {
                        this.addPresentationDisplaysLocked(this.mTempDisplays, var2_2, 3);
                        this.addPresentationDisplaysLocked(this.mTempDisplays, var2_2, 2);
                        this.addPresentationDisplaysLocked(this.mTempDisplays, var2_2, 4);
                        this.addPresentationDisplaysLocked(this.mTempDisplays, var2_2, 5);
                        this.addPresentationDisplaysLocked(this.mTempDisplays, var2_2, 6);
                    }
                }
                var6_4 = this.mTempDisplays.toArray(new Display[this.mTempDisplays.size()]);
                return var6_4;
            }
            finally {
                this.mTempDisplays.clear();
            }
        }
    }

    public UsbDisplayStatus getUsbDisplayStatus() {
        return this.mGlobal.getUsbDisplayStatus();
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        return this.mGlobal.getWifiDisplayStatus();
    }

    public void pauseWifiDisplay() {
        this.mGlobal.pauseWifiDisplay();
    }

    public void reconnectWifiDisplay() {
        this.mGlobal.reconnectWifiDisplay();
    }

    public void registerDisplayListener(DisplayListener displayListener, Handler handler) {
        this.mGlobal.registerDisplayListener(displayListener, handler);
    }

    public void renameWifiDisplay(String string2, String string3) {
        this.mGlobal.renameWifiDisplay(string2, string3);
    }

    public void resumeWifiDisplay() {
        this.mGlobal.resumeWifiDisplay();
    }

    public void startWifiDisplayScan() {
        this.mGlobal.startWifiDisplayScan();
    }

    public void stopWifiDisplayScan() {
        this.mGlobal.stopWifiDisplayScan();
    }

    public void unregisterDisplayListener(DisplayListener displayListener) {
        this.mGlobal.unregisterDisplayListener(displayListener);
    }

    public void updateBuiltInDisplayBlanking(boolean bl) {
        this.mGlobal.updateBuiltInDisplayBlanking(bl);
    }

    public static interface DisplayListener {
        public void onDisplayAdded(int var1);

        public void onDisplayChanged(int var1);

        public void onDisplayRemoved(int var1);
    }
}

