/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Size;
import com.android.internal.util.Preconditions;

public final class StreamConfigurationDuration {
    private final long mDurationNs;
    private final int mFormat;
    private final int mHeight;
    private final int mWidth;

    public StreamConfigurationDuration(int n, int n2, int n3, long l) {
        this.mFormat = StreamConfigurationMap.checkArgumentFormatInternal(n);
        this.mWidth = Preconditions.checkArgumentPositive(n2, "width must be positive");
        this.mHeight = Preconditions.checkArgumentPositive(n3, "height must be positive");
        this.mDurationNs = Preconditions.checkArgumentNonnegative(l, "durationNs must be non-negative");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof StreamConfigurationDuration)) return false;
        StreamConfigurationDuration streamConfigurationDuration = (StreamConfigurationDuration)object;
        if (this.mFormat != streamConfigurationDuration.mFormat) return false;
        if (this.mWidth != streamConfigurationDuration.mWidth) return false;
        if (this.mHeight != streamConfigurationDuration.mHeight) return false;
        if (this.mDurationNs != streamConfigurationDuration.mDurationNs) return false;
        return bl;
    }

    public long getDuration() {
        return this.mDurationNs;
    }

    public final int getFormat() {
        return this.mFormat;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Size getSize() {
        return new Size(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mFormat, this.mWidth, this.mHeight, (int)this.mDurationNs, (int)(this.mDurationNs >>> 32));
    }
}

