/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Size;
import com.android.internal.util.Preconditions;

public final class StreamConfiguration {
    private final int mFormat;
    private final int mHeight;
    private final boolean mInput;
    private final int mWidth;

    public StreamConfiguration(int n, int n2, int n3, boolean bl) {
        this.mFormat = StreamConfigurationMap.checkArgumentFormatInternal(n);
        this.mWidth = Preconditions.checkArgumentPositive(n2, "width must be positive");
        this.mHeight = Preconditions.checkArgumentPositive(n3, "height must be positive");
        this.mInput = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof StreamConfiguration)) return false;
        StreamConfiguration streamConfiguration = (StreamConfiguration)object;
        if (this.mFormat != streamConfiguration.mFormat) return false;
        if (this.mWidth != streamConfiguration.mWidth) return false;
        if (this.mHeight != streamConfiguration.mHeight) return false;
        if (this.mInput != streamConfiguration.mInput) return false;
        return bl;
    }

    public final int getFormat() {
        return this.mFormat;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Size getSize() {
        return new Size(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = this.mFormat;
        int n3 = this.mWidth;
        int n4 = this.mHeight;
        if (this.mInput) {
            n = 1;
            return HashCodeHelpers.hashCode(n2, n3, n4, n);
        }
        n = 0;
        return HashCodeHelpers.hashCode(n2, n3, n4, n);
    }

    public boolean isInput() {
        return this.mInput;
    }

    public boolean isOutput() {
        return !this.mInput;
    }
}

