/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Rational;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class ColorSpaceTransform {
    private static final int COLUMNS = 3;
    private static final int COUNT = 9;
    private static final int COUNT_INT = 18;
    private static final int OFFSET_DENOMINATOR = 1;
    private static final int OFFSET_NUMERATOR = 0;
    private static final int RATIONAL_SIZE = 2;
    private static final int ROWS = 3;
    private final int[] mElements;

    public ColorSpaceTransform(int[] nArray) {
        Preconditions.checkNotNull(nArray, "elements must not be null");
        if (nArray.length != 18) {
            throw new IllegalArgumentException("elements must be 18 length");
        }
        for (int i = 0; i < nArray.length; ++i) {
            Preconditions.checkNotNull(nArray, "element " + i + " must not be null");
        }
        this.mElements = Arrays.copyOf(nArray, nArray.length);
    }

    public ColorSpaceTransform(Rational[] rationalArray) {
        Preconditions.checkNotNull(rationalArray, "elements must not be null");
        if (rationalArray.length != 9) {
            throw new IllegalArgumentException("elements must be 9 length");
        }
        this.mElements = new int[18];
        for (int i = 0; i < rationalArray.length; ++i) {
            Preconditions.checkNotNull(rationalArray, "element[" + i + "] must not be null");
            this.mElements[0 + i * 2] = rationalArray[i].getNumerator();
            this.mElements[1 + i * 2] = rationalArray[i].getDenominator();
        }
    }

    private String toShortString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            stringBuilder.append("[");
            int n2 = 0;
            while (n2 < 3) {
                int n3 = this.mElements[n + 0];
                int n4 = this.mElements[n + 1];
                stringBuilder.append(n3);
                stringBuilder.append("/");
                stringBuilder.append(n4);
                if (n2 < 2) {
                    stringBuilder.append(", ");
                }
                ++n2;
                n += 2;
            }
            stringBuilder.append("]");
            if (i >= 2) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void copyElements(int[] nArray, int n) {
        Preconditions.checkArgumentNonnegative(n, "offset must not be negative");
        Preconditions.checkNotNull(nArray, "destination must not be null");
        if (nArray.length - n < 18) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        for (int i = 0; i < 18; ++i) {
            nArray[i + n] = this.mElements[i];
        }
    }

    public void copyElements(Rational[] rationalArray, int n) {
        Preconditions.checkArgumentNonnegative(n, "offset must not be negative");
        Preconditions.checkNotNull(rationalArray, "destination must not be null");
        if (rationalArray.length - n < 9) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < 9) {
            int n4 = this.mElements[n3 + 0];
            int n5 = this.mElements[n3 + 1];
            rationalArray[n2 + n] = new Rational(n4, n5);
            ++n2;
            n3 += 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (object != null) {
            if (this == object) {
                return true;
            }
            if (object instanceof ColorSpaceTransform) {
                ColorSpaceTransform colorSpaceTransform = (ColorSpaceTransform)object;
                int n = 0;
                int n2 = 0;
                while (true) {
                    if (n >= 9) {
                        return true;
                    }
                    int n3 = this.mElements[n2 + 0];
                    int n4 = this.mElements[n2 + 1];
                    int n5 = colorSpaceTransform.mElements[n2 + 0];
                    int n6 = colorSpaceTransform.mElements[n2 + 1];
                    if (!new Rational(n3, n4).equals((Object)new Rational(n5, n6))) break;
                    ++n;
                    n2 += 2;
                }
            }
        }
        return false;
    }

    public Rational getElement(int n, int n2) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("column out of range");
        }
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("row out of range");
        }
        return new Rational(this.mElements[0 + 2 * (n + n2 * 3)], this.mElements[1 + 2 * (n + n2 * 3)]);
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mElements);
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.toShortString()};
        return String.format("ColorSpaceTransform%s", objectArray);
    }
}

