/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableBoolean
implements MarshalQueryable<Boolean> {
    @Override
    public Marshaler<Boolean> createMarshaler(TypeReference<Boolean> typeReference, int n) {
        return new MarshalerBoolean(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Boolean> typeReference, int n) {
        return (Boolean.class.equals((Object)typeReference.getType()) || Boolean.TYPE.equals(typeReference.getType())) && n == 0;
    }

    private class MarshalerBoolean
    extends Marshaler<Boolean> {
        protected MarshalerBoolean(TypeReference<Boolean> typeReference, int n) {
            super(MarshalQueryableBoolean.this, typeReference, n);
        }

        @Override
        public int getNativeSize() {
            return 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void marshal(Boolean bl, ByteBuffer byteBuffer) {
            boolean bl2 = bl != false;
            byteBuffer.put((byte)(bl2 ? 1 : 0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Boolean unmarshal(ByteBuffer byteBuffer) {
            boolean bl;
            if (byteBuffer.get() != 0) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
    }
}

