/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class LegacyFocusStateMapper {
    private static String TAG = "LegacyFocusStateMapper";
    private static final boolean VERBOSE = Log.isLoggable(TAG, 2);
    private String mAfModePrevious = null;
    private int mAfRun = 0;
    private int mAfState = 0;
    private int mAfStatePrevious = 0;
    private final Camera mCamera;
    private final Object mLock = new Object();

    public LegacyFocusStateMapper(Camera camera) {
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
    }

    static /* synthetic */ int access$402(LegacyFocusStateMapper legacyFocusStateMapper, int n) {
        legacyFocusStateMapper.mAfState = n;
        return n;
    }

    private static String afStateToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN(" + n + ")";
            }
            case 3: {
                return "ACTIVE_SCAN";
            }
            case 4: {
                return "FOCUSED_LOCKED";
            }
            case 0: {
                return "INACTIVE";
            }
            case 5: {
                return "NOT_FOCUSED_LOCKED";
            }
            case 2: {
                return "PASSIVE_FOCUSED";
            }
            case 1: {
                return "PASSIVE_SCAN";
            }
            case 6: 
        }
        return "PASSIVE_UNFOCUSED";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void mapResultTriggers(CameraMetadataNative cameraMetadataNative) {
        Preconditions.checkNotNull(cameraMetadataNative, "result must not be null");
        Object object = this.mLock;
        // MONITORENTER : object
        int n = this.mAfState;
        // MONITOREXIT : object
        if (VERBOSE && n != this.mAfStatePrevious) {
            String string2 = TAG;
            Object[] objectArray = new Object[]{LegacyFocusStateMapper.afStateToString(this.mAfStatePrevious), LegacyFocusStateMapper.afStateToString(n)};
            Log.v(string2, String.format("mapResultTriggers - afState changed from %s to %s", objectArray));
        }
        cameraMetadataNative.set(CaptureResult.CONTROL_AF_STATE, Integer.valueOf(n));
        this.mAfStatePrevious = n;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequestTriggers(CaptureRequest var1_1, Camera.Parameters var2_2) {
        Preconditions.checkNotNull(var1_1, "captureRequest must not be null");
        var4_3 = ParamsUtils.getOrDefault(var1_1, CaptureRequest.CONTROL_AF_TRIGGER, 0);
        var5_4 = var2_2.getFocusMode();
        if (!Objects.equals(this.mAfModePrevious, var5_4)) {
            if (LegacyFocusStateMapper.VERBOSE) {
                Log.v(LegacyFocusStateMapper.TAG, "processRequestTriggers - AF mode switched from " + this.mAfModePrevious + " to " + var5_4);
            }
            var24_5 = this.mLock;
            synchronized (var24_5) {
                this.mAfRun = 1 + this.mAfRun;
                this.mAfState = 0;
            }
            this.mCamera.cancelAutoFocus();
        }
        this.mAfModePrevious = var5_4;
        var6_6 = this.mLock;
        synchronized (var6_6) {
            var8_7 = this.mAfRun;
        }
        var9_8 = new Camera.AutoFocusMoveCallback(){

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onAutoFocusMoving(boolean bl, Camera camera) {
                Object object = LegacyFocusStateMapper.this.mLock;
                synchronized (object) {
                    int n = LegacyFocusStateMapper.this.mAfRun;
                    if (VERBOSE) {
                        Log.v(TAG, "onAutoFocusMoving - start " + bl + " latest AF run " + n + ", last AF run " + var8_7);
                    }
                    if (var8_7 != n) {
                        Log.d(TAG, "onAutoFocusMoving - ignoring move callbacks from old af run" + var8_7);
                        return;
                    }
                    int n2 = bl ? 1 : 2;
                    String string2 = var5_4;
                    int n3 = -1;
                    switch (string2.hashCode()) {
                        case 910005312: {
                            if (!string2.equals("continuous-picture")) break;
                            n3 = 0;
                            break;
                        }
                        case -194628547: {
                            boolean bl2 = string2.equals("continuous-video");
                            if (!bl2) break;
                            n3 = 1;
                            break;
                        }
                    }
                    switch (n3) {
                        default: {
                            Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + var5_4);
                            break;
                        }
                        case 0: 
                        case 1: 
                    }
                    LegacyFocusStateMapper.access$402(LegacyFocusStateMapper.this, n2);
                    return;
                }
            }
        };
        var10_9 = -1;
        switch (var5_4.hashCode()) {
            case 3005871: {
                if (!var5_4.equals("auto")) break;
                var10_9 = 0;
                break;
            }
            case 103652300: {
                if (!var5_4.equals("macro")) break;
                var10_9 = 1;
                break;
            }
            case 910005312: {
                if (!var5_4.equals("continuous-picture")) break;
                var10_9 = 2;
                break;
            }
            case -194628547: {
                if (!var5_4.equals("continuous-video")) break;
                var10_9 = 3;
                break;
            }
        }
        switch (var10_9) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mCamera.setAutoFocusMoveCallback(var9_8);
                break;
            }
        }
        cfr_temp_0 = -2147483648;
        block40: do {
            switch (cfr_temp_0 == -2147483648 ? var4_3 : cfr_temp_0) {
                default: {
                    Log.w(LegacyFocusStateMapper.TAG, "processRequestTriggers - ignoring unknown control.afTrigger = " + var4_3);
                    cfr_temp_0 = 0;
                    continue block40;
                }
                case 1: {
                    var17_10 = -1;
                    switch (var5_4.hashCode()) {
                        case 3005871: {
                            if (!var5_4.equals("auto")) break;
                            var17_10 = 0;
                            break;
                        }
                        case 103652300: {
                            if (!var5_4.equals("macro")) break;
                            var17_10 = 1;
                            break;
                        }
                        case 910005312: {
                            if (!var5_4.equals("continuous-picture")) break;
                            var17_10 = 2;
                            break;
                        }
                        case -194628547: {
                            if (!var5_4.equals("continuous-video")) break;
                            var17_10 = 3;
                            break;
                        }
                    }
                    switch (var17_10) {
                        default: {
                            var18_11 = 0;
                            break;
                        }
                        case 0: 
                        case 1: {
                            var18_11 = 3;
                            break;
                        }
                        case 2: 
                        case 3: {
                            var18_11 = 1;
                        }
                    }
                    var19_12 = this.mLock;
                    synchronized (var19_12) {
                        this.mAfRun = var21_13 = 1 + this.mAfRun;
                        this.mAfState = var18_11;
                        ** if (!LegacyFocusStateMapper.VERBOSE) goto lbl84
                    }
lbl-1000:
                    // 1 sources

                    {
                        Log.v(LegacyFocusStateMapper.TAG, "processRequestTriggers - got AF_TRIGGER_START, new AF run is " + var21_13);
                    }
lbl84:
                    // 2 sources

                    if (var18_11 != 0) {
                        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void onAutoFocus(boolean bl, Camera camera) {
                                Object object = LegacyFocusStateMapper.this.mLock;
                                synchronized (object) {
                                    int n;
                                    int n2;
                                    block14: {
                                        int n3 = LegacyFocusStateMapper.this.mAfRun;
                                        if (VERBOSE) {
                                            Log.v(TAG, "onAutoFocus - success " + bl + " latest AF run " + n3 + ", last AF run " + var21_13);
                                        }
                                        if (n3 != var21_13) {
                                            String string2 = TAG;
                                            Object[] objectArray = new Object[]{var21_13, n3};
                                            Log.d(string2, String.format("onAutoFocus - ignoring AF callback (old run %d, new run %d)", objectArray));
                                            return;
                                        }
                                        n2 = bl ? 4 : 5;
                                        String string3 = var5_4;
                                        switch (string3.hashCode()) {
                                            case 3005871: {
                                                if (!string3.equals("auto")) break;
                                                n = 0;
                                                break block14;
                                            }
                                            case 910005312: {
                                                if (!string3.equals("continuous-picture")) break;
                                                n = 1;
                                                break block14;
                                            }
                                            case -194628547: {
                                                if (!string3.equals("continuous-video")) break;
                                                n = 2;
                                                break block14;
                                            }
                                            case 103652300: {
                                                boolean bl2 = string3.equals("macro");
                                                if (!bl2) break;
                                                n = 3;
                                                break block14;
                                            }
                                        }
                                        n = -1;
                                    }
                                    switch (n) {
                                        default: {
                                            Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + var5_4);
                                            break;
                                        }
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                    }
                                    LegacyFocusStateMapper.access$402(LegacyFocusStateMapper.this, n2);
                                    return;
                                }
                            }
                        });
                        return;
                    }
                }
                case 0: {
                    return;
                }
                case 2: 
            }
            break;
        } while (true);
        var11_14 = this.mLock;
        synchronized (var11_14) {
            var13_15 = this.mLock;
            synchronized (var13_15) {
                this.mAfRun = var15_16 = 1 + this.mAfRun;
                this.mAfState = 0;
            }
            this.mCamera.cancelAutoFocus();
            if (LegacyFocusStateMapper.VERBOSE) {
                Log.v(LegacyFocusStateMapper.TAG, "processRequestTriggers - got AF_TRIGGER_CANCEL, new AF run is " + var15_16);
            }
            return;
        }
    }
}

