/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.dispatch.Dispatchable;
import android.hardware.camera2.dispatch.MethodNameInvoker;
import android.hardware.camera2.impl.CameraDeviceImpl;
import com.android.internal.util.Preconditions;

public class CallbackProxies {
    private CallbackProxies() {
        throw new AssertionError();
    }

    public static class DeviceCaptureCallbackProxy
    extends CameraDeviceImpl.CaptureCallback {
        private final MethodNameInvoker<CameraDeviceImpl.CaptureCallback> mProxy;

        public DeviceCaptureCallbackProxy(Dispatchable<CameraDeviceImpl.CaptureCallback> dispatchable) {
            this.mProxy = new MethodNameInvoker<CameraDeviceImpl.CaptureCallback>(Preconditions.checkNotNull(dispatchable, "dispatchTarget must not be null"), CameraDeviceImpl.CaptureCallback.class);
        }

        @Override
        public void onCaptureCompleted(CameraDevice cameraDevice, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.mProxy.invoke("onCaptureCompleted", cameraDevice, captureRequest, totalCaptureResult);
        }

        @Override
        public void onCaptureFailed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            this.mProxy.invoke("onCaptureFailed", cameraDevice, captureRequest, captureFailure);
        }

        @Override
        public void onCapturePartial(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.mProxy.invoke("onCapturePartial", cameraDevice, captureRequest, captureResult);
        }

        @Override
        public void onCaptureProgressed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.mProxy.invoke("onCaptureProgressed", cameraDevice, captureRequest, captureResult);
        }

        @Override
        public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
            MethodNameInvoker<CameraDeviceImpl.CaptureCallback> methodNameInvoker = this.mProxy;
            Object[] objectArray = new Object[]{cameraDevice, n};
            methodNameInvoker.invoke("onCaptureSequenceAborted", objectArray);
        }

        @Override
        public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
            MethodNameInvoker<CameraDeviceImpl.CaptureCallback> methodNameInvoker = this.mProxy;
            Object[] objectArray = new Object[]{cameraDevice, n, l};
            methodNameInvoker.invoke("onCaptureSequenceCompleted", objectArray);
        }

        @Override
        public void onCaptureStarted(CameraDevice cameraDevice, CaptureRequest captureRequest, long l, long l2) {
            MethodNameInvoker<CameraDeviceImpl.CaptureCallback> methodNameInvoker = this.mProxy;
            Object[] objectArray = new Object[]{cameraDevice, captureRequest, l, l2};
            methodNameInvoker.invoke("onCaptureStarted", objectArray);
        }
    }

    public static class DeviceStateCallbackProxy
    extends CameraDeviceImpl.StateCallbackKK {
        private final MethodNameInvoker<CameraDeviceImpl.StateCallbackKK> mProxy;

        public DeviceStateCallbackProxy(Dispatchable<CameraDeviceImpl.StateCallbackKK> dispatchable) {
            this.mProxy = new MethodNameInvoker<CameraDeviceImpl.StateCallbackKK>(Preconditions.checkNotNull(dispatchable, "dispatchTarget must not be null"), CameraDeviceImpl.StateCallbackKK.class);
        }

        @Override
        public void onActive(CameraDevice cameraDevice) {
            this.mProxy.invoke("onActive", cameraDevice);
        }

        @Override
        public void onBusy(CameraDevice cameraDevice) {
            this.mProxy.invoke("onBusy", cameraDevice);
        }

        @Override
        public void onClosed(CameraDevice cameraDevice) {
            this.mProxy.invoke("onClosed", cameraDevice);
        }

        @Override
        public void onDisconnected(CameraDevice cameraDevice) {
            this.mProxy.invoke("onDisconnected", cameraDevice);
        }

        @Override
        public void onError(CameraDevice cameraDevice, int n) {
            MethodNameInvoker<CameraDeviceImpl.StateCallbackKK> methodNameInvoker = this.mProxy;
            Object[] objectArray = new Object[]{cameraDevice, n};
            methodNameInvoker.invoke("onError", objectArray);
        }

        @Override
        public void onIdle(CameraDevice cameraDevice) {
            this.mProxy.invoke("onIdle", cameraDevice);
        }

        @Override
        public void onOpened(CameraDevice cameraDevice) {
            this.mProxy.invoke("onOpened", cameraDevice);
        }

        @Override
        public void onUnconfigured(CameraDevice cameraDevice) {
            this.mProxy.invoke("onUnconfigured", cameraDevice);
        }
    }

    public static class SessionStateCallbackProxy
    extends CameraCaptureSession.StateCallback {
        private final MethodNameInvoker<CameraCaptureSession.StateCallback> mProxy;

        public SessionStateCallbackProxy(Dispatchable<CameraCaptureSession.StateCallback> dispatchable) {
            this.mProxy = new MethodNameInvoker<CameraCaptureSession.StateCallback>(Preconditions.checkNotNull(dispatchable, "dispatchTarget must not be null"), CameraCaptureSession.StateCallback.class);
        }

        @Override
        public void onActive(CameraCaptureSession cameraCaptureSession) {
            this.mProxy.invoke("onActive", cameraCaptureSession);
        }

        @Override
        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            this.mProxy.invoke("onClosed", cameraCaptureSession);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            this.mProxy.invoke("onConfigureFailed", cameraCaptureSession);
        }

        @Override
        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            this.mProxy.invoke("onConfigured", cameraCaptureSession);
        }

        @Override
        public void onReady(CameraCaptureSession cameraCaptureSession) {
            this.mProxy.invoke("onReady", cameraCaptureSession);
        }
    }
}

