/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Rect;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PublicKey;
import android.hardware.camera2.impl.SyntheticKey;
import android.hardware.camera2.params.BlackLevelPattern;
import android.hardware.camera2.params.ColorSpaceTransform;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.TypeReference;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.util.SizeF;
import java.util.Collections;
import java.util.List;

public final class CameraCharacteristics
extends CameraMetadata<Key<?>> {
    @PublicKey
    public static final Key<int[]> COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES = new Key<int[]>("android.colorCorrection.availableAberrationModes", int[].class);
    @PublicKey
    public static final Key<int[]> CONTROL_AE_AVAILABLE_ANTIBANDING_MODES = new Key<int[]>("android.control.aeAvailableAntibandingModes", int[].class);
    @PublicKey
    public static final Key<int[]> CONTROL_AE_AVAILABLE_MODES = new Key<int[]>("android.control.aeAvailableModes", int[].class);
    @PublicKey
    public static final Key<Range<Integer>[]> CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES = new Key<Range<Integer>[]>("android.control.aeAvailableTargetFpsRanges", new TypeReference<Range<Integer>[]>(){});
    @PublicKey
    public static final Key<Range<Integer>> CONTROL_AE_COMPENSATION_RANGE = new Key<Range<Integer>>("android.control.aeCompensationRange", new TypeReference<Range<Integer>>(){});
    @PublicKey
    public static final Key<Rational> CONTROL_AE_COMPENSATION_STEP = new Key<Rational>("android.control.aeCompensationStep", Rational.class);
    @PublicKey
    public static final Key<int[]> CONTROL_AF_AVAILABLE_MODES = new Key<int[]>("android.control.afAvailableModes", int[].class);
    @PublicKey
    public static final Key<int[]> CONTROL_AVAILABLE_EFFECTS = new Key<int[]>("android.control.availableEffects", int[].class);
    public static final Key<HighSpeedVideoConfiguration[]> CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS;
    @PublicKey
    public static final Key<int[]> CONTROL_AVAILABLE_SCENE_MODES;
    @PublicKey
    public static final Key<int[]> CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES;
    @PublicKey
    public static final Key<int[]> CONTROL_AWB_AVAILABLE_MODES;
    public static final Key<int[]> CONTROL_MAX_REGIONS;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> CONTROL_MAX_REGIONS_AE;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> CONTROL_MAX_REGIONS_AF;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> CONTROL_MAX_REGIONS_AWB;
    @PublicKey
    public static final Key<int[]> EDGE_AVAILABLE_EDGE_MODES;
    @PublicKey
    public static final Key<Boolean> FLASH_INFO_AVAILABLE;
    @PublicKey
    public static final Key<int[]> HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES;
    @PublicKey
    public static final Key<Integer> INFO_SUPPORTED_HARDWARE_LEVEL;
    @PublicKey
    public static final Key<Size[]> JPEG_AVAILABLE_THUMBNAIL_SIZES;
    public static final Key<int[]> LED_AVAILABLE_LEDS;
    @PublicKey
    public static final Key<Integer> LENS_FACING;
    @PublicKey
    public static final Key<float[]> LENS_INFO_AVAILABLE_APERTURES;
    @PublicKey
    public static final Key<float[]> LENS_INFO_AVAILABLE_FILTER_DENSITIES;
    @PublicKey
    public static final Key<float[]> LENS_INFO_AVAILABLE_FOCAL_LENGTHS;
    @PublicKey
    public static final Key<int[]> LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION;
    @PublicKey
    public static final Key<Integer> LENS_INFO_FOCUS_DISTANCE_CALIBRATION;
    @PublicKey
    public static final Key<Float> LENS_INFO_HYPERFOCAL_DISTANCE;
    @PublicKey
    public static final Key<Float> LENS_INFO_MINIMUM_FOCUS_DISTANCE;
    public static final Key<Size> LENS_INFO_SHADING_MAP_SIZE;
    @PublicKey
    public static final Key<int[]> NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES;
    @Deprecated
    public static final Key<Byte> QUIRKS_USE_PARTIAL_RESULT;
    @PublicKey
    public static final Key<int[]> REQUEST_AVAILABLE_CAPABILITIES;
    public static final Key<int[]> REQUEST_AVAILABLE_CHARACTERISTICS_KEYS;
    public static final Key<int[]> REQUEST_AVAILABLE_REQUEST_KEYS;
    public static final Key<int[]> REQUEST_AVAILABLE_RESULT_KEYS;
    public static final Key<Integer> REQUEST_MAX_NUM_INPUT_STREAMS;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> REQUEST_MAX_NUM_OUTPUT_PROC;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> REQUEST_MAX_NUM_OUTPUT_PROC_STALLING;
    @PublicKey
    @SyntheticKey
    public static final Key<Integer> REQUEST_MAX_NUM_OUTPUT_RAW;
    public static final Key<int[]> REQUEST_MAX_NUM_OUTPUT_STREAMS;
    @PublicKey
    public static final Key<Integer> REQUEST_PARTIAL_RESULT_COUNT;
    @PublicKey
    public static final Key<Byte> REQUEST_PIPELINE_MAX_DEPTH;
    @Deprecated
    public static final Key<int[]> SCALER_AVAILABLE_FORMATS;
    public static final Key<int[]> SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP;
    @Deprecated
    public static final Key<long[]> SCALER_AVAILABLE_JPEG_MIN_DURATIONS;
    @Deprecated
    public static final Key<Size[]> SCALER_AVAILABLE_JPEG_SIZES;
    @PublicKey
    public static final Key<Float> SCALER_AVAILABLE_MAX_DIGITAL_ZOOM;
    public static final Key<StreamConfigurationDuration[]> SCALER_AVAILABLE_MIN_FRAME_DURATIONS;
    @Deprecated
    public static final Key<long[]> SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS;
    @Deprecated
    public static final Key<Size[]> SCALER_AVAILABLE_PROCESSED_SIZES;
    public static final Key<StreamConfigurationDuration[]> SCALER_AVAILABLE_STALL_DURATIONS;
    public static final Key<StreamConfiguration[]> SCALER_AVAILABLE_STREAM_CONFIGURATIONS;
    @PublicKey
    public static final Key<Integer> SCALER_CROPPING_TYPE;
    @PublicKey
    @SyntheticKey
    public static final Key<StreamConfigurationMap> SCALER_STREAM_CONFIGURATION_MAP;
    @PublicKey
    public static final Key<int[]> SENSOR_AVAILABLE_TEST_PATTERN_MODES;
    @PublicKey
    public static final Key<BlackLevelPattern> SENSOR_BLACK_LEVEL_PATTERN;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_CALIBRATION_TRANSFORM1;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_CALIBRATION_TRANSFORM2;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_COLOR_TRANSFORM1;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_COLOR_TRANSFORM2;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_FORWARD_MATRIX1;
    @PublicKey
    public static final Key<ColorSpaceTransform> SENSOR_FORWARD_MATRIX2;
    @PublicKey
    public static final Key<Rect> SENSOR_INFO_ACTIVE_ARRAY_SIZE;
    @PublicKey
    public static final Key<Integer> SENSOR_INFO_COLOR_FILTER_ARRANGEMENT;
    @PublicKey
    public static final Key<Range<Long>> SENSOR_INFO_EXPOSURE_TIME_RANGE;
    @PublicKey
    public static final Key<Long> SENSOR_INFO_MAX_FRAME_DURATION;
    @PublicKey
    public static final Key<SizeF> SENSOR_INFO_PHYSICAL_SIZE;
    @PublicKey
    public static final Key<Size> SENSOR_INFO_PIXEL_ARRAY_SIZE;
    @PublicKey
    public static final Key<Range<Integer>> SENSOR_INFO_SENSITIVITY_RANGE;
    @PublicKey
    public static final Key<Integer> SENSOR_INFO_TIMESTAMP_SOURCE;
    @PublicKey
    public static final Key<Integer> SENSOR_INFO_WHITE_LEVEL;
    @PublicKey
    public static final Key<Integer> SENSOR_MAX_ANALOG_SENSITIVITY;
    @PublicKey
    public static final Key<Integer> SENSOR_ORIENTATION;
    @PublicKey
    public static final Key<Integer> SENSOR_REFERENCE_ILLUMINANT1;
    @PublicKey
    public static final Key<Byte> SENSOR_REFERENCE_ILLUMINANT2;
    @PublicKey
    public static final Key<int[]> STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES;
    @PublicKey
    public static final Key<boolean[]> STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES;
    @PublicKey
    public static final Key<Integer> STATISTICS_INFO_MAX_FACE_COUNT;
    @PublicKey
    public static final Key<Integer> SYNC_MAX_LATENCY;
    @PublicKey
    public static final Key<int[]> TONEMAP_AVAILABLE_TONE_MAP_MODES;
    @PublicKey
    public static final Key<Integer> TONEMAP_MAX_CURVE_POINTS;
    private List<CaptureRequest.Key<?>> mAvailableRequestKeys;
    private List<CaptureResult.Key<?>> mAvailableResultKeys;
    private List<Key<?>> mKeys;
    private final CameraMetadataNative mProperties;

    static {
        CONTROL_AVAILABLE_SCENE_MODES = new Key<int[]>("android.control.availableSceneModes", int[].class);
        CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES = new Key<int[]>("android.control.availableVideoStabilizationModes", int[].class);
        CONTROL_AWB_AVAILABLE_MODES = new Key<int[]>("android.control.awbAvailableModes", int[].class);
        CONTROL_MAX_REGIONS = new Key<int[]>("android.control.maxRegions", int[].class);
        CONTROL_MAX_REGIONS_AE = new Key<Integer>("android.control.maxRegionsAe", Integer.TYPE);
        CONTROL_MAX_REGIONS_AWB = new Key<Integer>("android.control.maxRegionsAwb", Integer.TYPE);
        CONTROL_MAX_REGIONS_AF = new Key<Integer>("android.control.maxRegionsAf", Integer.TYPE);
        CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS = new Key<HighSpeedVideoConfiguration[]>("android.control.availableHighSpeedVideoConfigurations", HighSpeedVideoConfiguration[].class);
        EDGE_AVAILABLE_EDGE_MODES = new Key<int[]>("android.edge.availableEdgeModes", int[].class);
        FLASH_INFO_AVAILABLE = new Key<Boolean>("android.flash.info.available", Boolean.TYPE);
        HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES = new Key<int[]>("android.hotPixel.availableHotPixelModes", int[].class);
        JPEG_AVAILABLE_THUMBNAIL_SIZES = new Key<Size[]>("android.jpeg.availableThumbnailSizes", Size[].class);
        LENS_INFO_AVAILABLE_APERTURES = new Key<float[]>("android.lens.info.availableApertures", float[].class);
        LENS_INFO_AVAILABLE_FILTER_DENSITIES = new Key<float[]>("android.lens.info.availableFilterDensities", float[].class);
        LENS_INFO_AVAILABLE_FOCAL_LENGTHS = new Key<float[]>("android.lens.info.availableFocalLengths", float[].class);
        LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION = new Key<int[]>("android.lens.info.availableOpticalStabilization", int[].class);
        LENS_INFO_HYPERFOCAL_DISTANCE = new Key<Float>("android.lens.info.hyperfocalDistance", Float.TYPE);
        LENS_INFO_MINIMUM_FOCUS_DISTANCE = new Key<Float>("android.lens.info.minimumFocusDistance", Float.TYPE);
        LENS_INFO_SHADING_MAP_SIZE = new Key<Size>("android.lens.info.shadingMapSize", Size.class);
        LENS_INFO_FOCUS_DISTANCE_CALIBRATION = new Key<Integer>("android.lens.info.focusDistanceCalibration", Integer.TYPE);
        LENS_FACING = new Key<Integer>("android.lens.facing", Integer.TYPE);
        NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES = new Key<int[]>("android.noiseReduction.availableNoiseReductionModes", int[].class);
        QUIRKS_USE_PARTIAL_RESULT = new Key<Byte>("android.quirks.usePartialResult", Byte.TYPE);
        REQUEST_MAX_NUM_OUTPUT_STREAMS = new Key<int[]>("android.request.maxNumOutputStreams", int[].class);
        REQUEST_MAX_NUM_OUTPUT_RAW = new Key<Integer>("android.request.maxNumOutputRaw", Integer.TYPE);
        REQUEST_MAX_NUM_OUTPUT_PROC = new Key<Integer>("android.request.maxNumOutputProc", Integer.TYPE);
        REQUEST_MAX_NUM_OUTPUT_PROC_STALLING = new Key<Integer>("android.request.maxNumOutputProcStalling", Integer.TYPE);
        REQUEST_MAX_NUM_INPUT_STREAMS = new Key<Integer>("android.request.maxNumInputStreams", Integer.TYPE);
        REQUEST_PIPELINE_MAX_DEPTH = new Key<Byte>("android.request.pipelineMaxDepth", Byte.TYPE);
        REQUEST_PARTIAL_RESULT_COUNT = new Key<Integer>("android.request.partialResultCount", Integer.TYPE);
        REQUEST_AVAILABLE_CAPABILITIES = new Key<int[]>("android.request.availableCapabilities", int[].class);
        REQUEST_AVAILABLE_REQUEST_KEYS = new Key<int[]>("android.request.availableRequestKeys", int[].class);
        REQUEST_AVAILABLE_RESULT_KEYS = new Key<int[]>("android.request.availableResultKeys", int[].class);
        REQUEST_AVAILABLE_CHARACTERISTICS_KEYS = new Key<int[]>("android.request.availableCharacteristicsKeys", int[].class);
        SCALER_AVAILABLE_FORMATS = new Key<int[]>("android.scaler.availableFormats", int[].class);
        SCALER_AVAILABLE_JPEG_MIN_DURATIONS = new Key<long[]>("android.scaler.availableJpegMinDurations", long[].class);
        SCALER_AVAILABLE_JPEG_SIZES = new Key<Size[]>("android.scaler.availableJpegSizes", Size[].class);
        SCALER_AVAILABLE_MAX_DIGITAL_ZOOM = new Key<Float>("android.scaler.availableMaxDigitalZoom", Float.TYPE);
        SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS = new Key<long[]>("android.scaler.availableProcessedMinDurations", long[].class);
        SCALER_AVAILABLE_PROCESSED_SIZES = new Key<Size[]>("android.scaler.availableProcessedSizes", Size[].class);
        SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP = new Key<int[]>("android.scaler.availableInputOutputFormatsMap", int[].class);
        SCALER_AVAILABLE_STREAM_CONFIGURATIONS = new Key<StreamConfiguration[]>("android.scaler.availableStreamConfigurations", StreamConfiguration[].class);
        SCALER_AVAILABLE_MIN_FRAME_DURATIONS = new Key<StreamConfigurationDuration[]>("android.scaler.availableMinFrameDurations", StreamConfigurationDuration[].class);
        SCALER_AVAILABLE_STALL_DURATIONS = new Key<StreamConfigurationDuration[]>("android.scaler.availableStallDurations", StreamConfigurationDuration[].class);
        SCALER_STREAM_CONFIGURATION_MAP = new Key<StreamConfigurationMap>("android.scaler.streamConfigurationMap", StreamConfigurationMap.class);
        SCALER_CROPPING_TYPE = new Key<Integer>("android.scaler.croppingType", Integer.TYPE);
        SENSOR_INFO_ACTIVE_ARRAY_SIZE = new Key<Rect>("android.sensor.info.activeArraySize", Rect.class);
        SENSOR_INFO_SENSITIVITY_RANGE = new Key<Range<Integer>>("android.sensor.info.sensitivityRange", new TypeReference<Range<Integer>>(){});
        SENSOR_INFO_COLOR_FILTER_ARRANGEMENT = new Key<Integer>("android.sensor.info.colorFilterArrangement", Integer.TYPE);
        SENSOR_INFO_EXPOSURE_TIME_RANGE = new Key<Range<Long>>("android.sensor.info.exposureTimeRange", new TypeReference<Range<Long>>(){});
        SENSOR_INFO_MAX_FRAME_DURATION = new Key<Long>("android.sensor.info.maxFrameDuration", Long.TYPE);
        SENSOR_INFO_PHYSICAL_SIZE = new Key<SizeF>("android.sensor.info.physicalSize", SizeF.class);
        SENSOR_INFO_PIXEL_ARRAY_SIZE = new Key<Size>("android.sensor.info.pixelArraySize", Size.class);
        SENSOR_INFO_WHITE_LEVEL = new Key<Integer>("android.sensor.info.whiteLevel", Integer.TYPE);
        SENSOR_INFO_TIMESTAMP_SOURCE = new Key<Integer>("android.sensor.info.timestampSource", Integer.TYPE);
        SENSOR_REFERENCE_ILLUMINANT1 = new Key<Integer>("android.sensor.referenceIlluminant1", Integer.TYPE);
        SENSOR_REFERENCE_ILLUMINANT2 = new Key<Byte>("android.sensor.referenceIlluminant2", Byte.TYPE);
        SENSOR_CALIBRATION_TRANSFORM1 = new Key<ColorSpaceTransform>("android.sensor.calibrationTransform1", ColorSpaceTransform.class);
        SENSOR_CALIBRATION_TRANSFORM2 = new Key<ColorSpaceTransform>("android.sensor.calibrationTransform2", ColorSpaceTransform.class);
        SENSOR_COLOR_TRANSFORM1 = new Key<ColorSpaceTransform>("android.sensor.colorTransform1", ColorSpaceTransform.class);
        SENSOR_COLOR_TRANSFORM2 = new Key<ColorSpaceTransform>("android.sensor.colorTransform2", ColorSpaceTransform.class);
        SENSOR_FORWARD_MATRIX1 = new Key<ColorSpaceTransform>("android.sensor.forwardMatrix1", ColorSpaceTransform.class);
        SENSOR_FORWARD_MATRIX2 = new Key<ColorSpaceTransform>("android.sensor.forwardMatrix2", ColorSpaceTransform.class);
        SENSOR_BLACK_LEVEL_PATTERN = new Key<BlackLevelPattern>("android.sensor.blackLevelPattern", BlackLevelPattern.class);
        SENSOR_MAX_ANALOG_SENSITIVITY = new Key<Integer>("android.sensor.maxAnalogSensitivity", Integer.TYPE);
        SENSOR_ORIENTATION = new Key<Integer>("android.sensor.orientation", Integer.TYPE);
        SENSOR_AVAILABLE_TEST_PATTERN_MODES = new Key<int[]>("android.sensor.availableTestPatternModes", int[].class);
        STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES = new Key<int[]>("android.statistics.info.availableFaceDetectModes", int[].class);
        STATISTICS_INFO_MAX_FACE_COUNT = new Key<Integer>("android.statistics.info.maxFaceCount", Integer.TYPE);
        STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES = new Key<boolean[]>("android.statistics.info.availableHotPixelMapModes", boolean[].class);
        TONEMAP_MAX_CURVE_POINTS = new Key<Integer>("android.tonemap.maxCurvePoints", Integer.TYPE);
        TONEMAP_AVAILABLE_TONE_MAP_MODES = new Key<int[]>("android.tonemap.availableToneMapModes", int[].class);
        LED_AVAILABLE_LEDS = new Key<int[]>("android.led.availableLeds", int[].class);
        INFO_SUPPORTED_HARDWARE_LEVEL = new Key<Integer>("android.info.supportedHardwareLevel", Integer.TYPE);
        SYNC_MAX_LATENCY = new Key<Integer>("android.sync.maxLatency", Integer.TYPE);
    }

    public CameraCharacteristics(CameraMetadataNative cameraMetadataNative) {
        this.mProperties = CameraMetadataNative.move(cameraMetadataNative);
    }

    private <TKey> List<TKey> getAvailableKeyList(Class<?> clazz, Class<TKey> clazz2, int[] nArray) {
        if (clazz.equals(CameraMetadata.class)) {
            throw new AssertionError((Object)"metadataClass must be a strict subclass of CameraMetadata");
        }
        if (!CameraMetadata.class.isAssignableFrom(clazz)) {
            throw new AssertionError((Object)"metadataClass must be a subclass of CameraMetadata");
        }
        return Collections.unmodifiableList(CameraCharacteristics.getKeysStatic(clazz, clazz2, null, nArray));
    }

    public <T> T get(Key<T> key) {
        return this.mProperties.get(key);
    }

    public List<CaptureRequest.Key<?>> getAvailableCaptureRequestKeys() {
        if (this.mAvailableRequestKeys == null) {
            Class<CaptureRequest.Key> clazz = CaptureRequest.Key.class;
            int[] nArray = this.get(REQUEST_AVAILABLE_REQUEST_KEYS);
            if (nArray == null) {
                throw new AssertionError((Object)"android.request.availableRequestKeys must be non-null in the characteristics");
            }
            this.mAvailableRequestKeys = this.getAvailableKeyList(CaptureRequest.class, clazz, nArray);
        }
        return this.mAvailableRequestKeys;
    }

    public List<CaptureResult.Key<?>> getAvailableCaptureResultKeys() {
        if (this.mAvailableResultKeys == null) {
            Class<CaptureResult.Key> clazz = CaptureResult.Key.class;
            int[] nArray = this.get(REQUEST_AVAILABLE_RESULT_KEYS);
            if (nArray == null) {
                throw new AssertionError((Object)"android.request.availableResultKeys must be non-null in the characteristics");
            }
            this.mAvailableResultKeys = this.getAvailableKeyList(CaptureResult.class, clazz, nArray);
        }
        return this.mAvailableResultKeys;
    }

    @Override
    protected Class<Key<?>> getKeyClass() {
        return Key.class;
    }

    @Override
    public List<Key<?>> getKeys() {
        if (this.mKeys != null) {
            return this.mKeys;
        }
        int[] nArray = this.get(REQUEST_AVAILABLE_CHARACTERISTICS_KEYS);
        if (nArray == null) {
            throw new AssertionError((Object)"android.request.availableCharacteristicsKeys must be non-null in the characteristics");
        }
        this.mKeys = Collections.unmodifiableList(CameraCharacteristics.getKeysStatic(this.getClass(), this.getKeyClass(), this, nArray));
        return this.mKeys;
    }

    public CameraMetadataNative getNativeCopy() {
        return new CameraMetadataNative(this.mProperties);
    }

    @Override
    protected <T> T getProtected(Key<?> key) {
        return (T)this.mProperties.get(key);
    }

    public static final class Key<T> {
        private final CameraMetadataNative.Key<T> mKey;

        private Key(CameraMetadataNative.Key<?> key) {
            this.mKey = key;
        }

        public Key(String string2, TypeReference<T> typeReference) {
            this.mKey = new CameraMetadataNative.Key<T>(string2, typeReference);
        }

        public Key(String string2, Class<T> clazz) {
            this.mKey = new CameraMetadataNative.Key<T>(string2, clazz);
        }

        public final boolean equals(Object object) {
            return object instanceof Key && ((Key)object).mKey.equals(this.mKey);
        }

        public String getName() {
            return this.mKey.getName();
        }

        public CameraMetadataNative.Key<T> getNativeKey() {
            return this.mKey;
        }

        public final int hashCode() {
            return this.mKey.hashCode();
        }
    }
}

