/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import dalvik.system.CloseGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SystemSensorManager
extends SensorManager {
    private static final ArrayList<Sensor> sFullSensorsList;
    private static final SparseArray<Sensor> sHandleToSensor;
    private static boolean sSensorModuleInitialized;
    private static final Object sSensorModuleLock;
    private final Looper mMainLooper;
    private final HashMap<SensorEventListener, SensorEventQueue> mSensorListeners = new HashMap();
    private final int mTargetSdkLevel;
    private final HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners = new HashMap();

    static {
        sSensorModuleInitialized = false;
        sSensorModuleLock = new Object();
        sFullSensorsList = new ArrayList();
        sHandleToSensor = new SparseArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SystemSensorManager(Context context, Looper looper) {
        this.mMainLooper = looper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        Object object = sSensorModuleLock;
        synchronized (object) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SystemSensorManager.nativeClassInit();
                ArrayList<Sensor> arrayList = sFullSensorsList;
                int n = 0;
                do {
                    Sensor sensor;
                    if ((n = SystemSensorManager.nativeGetNextSensor(sensor = new Sensor(), n)) < 0) continue;
                    arrayList.add(sensor);
                    sHandleToSensor.append(sensor.getHandle(), sensor);
                } while (n > 0);
            }
            return;
        }
    }

    private static native void nativeClassInit();

    private static native int nativeGetNextSensor(Sensor var0, int var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor, boolean bl) {
        if (sensor != null && sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue triggerEventQueue = this.mTriggerListeners.get(triggerEventListener);
            if (triggerEventQueue == null) {
                return false;
            }
            boolean bl2 = sensor == null ? triggerEventQueue.removeAllSensors() : triggerEventQueue.removeSensor(sensor, bl);
            if (bl2 && !triggerEventQueue.hasSensors()) {
                this.mTriggerListeners.remove(triggerEventListener);
                triggerEventQueue.dispose();
            }
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean flushImpl(SensorEventListener sensorEventListener) {
        if (sensorEventListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue sensorEventQueue = this.mSensorListeners.get(sensorEventListener);
            if (sensorEventQueue == null) {
                return false;
            }
            int n = sensorEventQueue.flush();
            boolean bl = false;
            if (n != 0) return bl;
            return true;
        }
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return sFullSensorsList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean registerListenerImpl(SensorEventListener sensorEventListener, Sensor sensor, int n, Handler handler, int n2, int n3) {
        if (sensorEventListener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (n2 < 0 || n < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue sensorEventQueue = this.mSensorListeners.get(sensorEventListener);
            if (sensorEventQueue != null) {
                return sensorEventQueue.addSensor(sensor, n, n2, n3);
            }
            Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
            SensorEventQueue sensorEventQueue2 = new SensorEventQueue(sensorEventListener, looper, this);
            if (!sensorEventQueue2.addSensor(sensor, n, n2, n3)) {
                sensorEventQueue2.dispose();
                return false;
            }
            this.mSensorListeners.put(sensorEventListener, sensorEventQueue2);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue triggerEventQueue = this.mTriggerListeners.get(triggerEventListener);
            if (triggerEventQueue != null) {
                return triggerEventQueue.addSensor(sensor, 0, 0, 0);
            }
            TriggerEventQueue triggerEventQueue2 = new TriggerEventQueue(triggerEventListener, this.mMainLooper, this);
            if (!triggerEventQueue2.addSensor(sensor, 0, 0, 0)) {
                triggerEventQueue2.dispose();
                return false;
            }
            this.mTriggerListeners.put(triggerEventListener, triggerEventQueue2);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unregisterListenerImpl(SensorEventListener sensorEventListener, Sensor sensor) {
        if (sensor != null && sensor.getReportingMode() == 2) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean bl;
            boolean bl2;
            SensorEventQueue sensorEventQueue = this.mSensorListeners.get(sensorEventListener);
            if (sensorEventQueue != null && (bl2 = sensor == null ? sensorEventQueue.removeAllSensors() : (bl = sensorEventQueue.removeSensor(sensor, true))) && !sensorEventQueue.hasSensors()) {
                this.mSensorListeners.remove(sensorEventListener);
                sensorEventQueue.dispose();
            }
            return;
        }
    }

    private static abstract class BaseEventQueue {
        private final SparseBooleanArray mActiveSensors = new SparseBooleanArray();
        private final CloseGuard mCloseGuard;
        protected final SparseBooleanArray mFirstEvent;
        protected final SystemSensorManager mManager;
        private final float[] mScratch;
        protected final SparseIntArray mSensorAccuracies = new SparseIntArray();
        private long nSensorEventQueue;

        BaseEventQueue(Looper looper, SystemSensorManager systemSensorManager) {
            this.mFirstEvent = new SparseBooleanArray();
            this.mCloseGuard = CloseGuard.get();
            this.mScratch = new float[16];
            this.nSensorEventQueue = this.nativeInitBaseEventQueue(this, looper.getQueue(), this.mScratch);
            this.mCloseGuard.open("dispose");
            this.mManager = systemSensorManager;
        }

        private int disableSensor(Sensor sensor) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.nSensorEventQueue, sensor.getHandle());
        }

        private void dispose(boolean bl) {
            if (this.mCloseGuard != null) {
                if (bl) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.nSensorEventQueue != 0L) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.nSensorEventQueue);
                this.nSensorEventQueue = 0L;
            }
        }

        private int enableSensor(Sensor sensor, int n, int n2, int n3) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.nSensorEventQueue, sensor.getHandle(), n, n2, n3);
        }

        private static native void nativeDestroySensorEventQueue(long var0);

        private static native int nativeDisableSensor(long var0, int var2);

        private static native int nativeEnableSensor(long var0, int var2, int var3, int var4, int var5);

        private static native int nativeFlushSensor(long var0);

        private native long nativeInitBaseEventQueue(BaseEventQueue var1, MessageQueue var2, float[] var3);

        public boolean addSensor(Sensor sensor, int n, int n2, int n3) {
            int n4 = sensor.getHandle();
            if (this.mActiveSensors.get(n4)) {
                return false;
            }
            this.mActiveSensors.put(n4, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, n, n2, n3) != 0 && (n2 == 0 || n2 > 0 && this.enableSensor(sensor, n, 0, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        public void dispose() {
            this.dispose(false);
        }

        protected void finalize() throws Throwable {
            try {
                this.dispose(true);
                return;
            }
            finally {
                super.finalize();
            }
        }

        public int flush() {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.nSensorEventQueue);
        }

        public boolean hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        public boolean removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int n = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)sHandleToSensor.get(n);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(n, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        public boolean removeSensor(Sensor sensor, boolean bl) {
            int n = sensor.getHandle();
            boolean bl2 = this.mActiveSensors.get(n);
            boolean bl3 = false;
            if (bl2) {
                if (bl) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                bl3 = true;
            }
            return bl3;
        }

        protected abstract void removeSensorEvent(Sensor var1);
    }

    static final class SensorEventQueue
    extends BaseEventQueue {
        private final SensorEventListener mListener;
        private final SparseArray<SensorEvent> mSensorsEvents = new SparseArray();

        public SensorEventQueue(SensorEventListener sensorEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            super(looper, systemSensorManager);
            this.mListener = sensorEventListener;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            SensorEvent sensorEvent = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.put(sensor.getHandle(), sensorEvent);
                return;
            }
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)sHandleToSensor.get(n);
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            Sensor sensor = (Sensor)sHandleToSensor.get(n);
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            // MONITORENTER : sparseArray
            SensorEvent sensorEvent = this.mSensorsEvents.get(n);
            // MONITOREXIT : sparseArray
            if (sensorEvent == null) {
                return;
            }
            System.arraycopy((float[])fArray, (int)0, (float[])sensorEvent.values, (int)0, (int)sensorEvent.values.length);
            sensorEvent.timestamp = l;
            sensorEvent.accuracy = n2;
            sensorEvent.sensor = sensor;
            int n3 = this.mSensorAccuracies.get(n);
            if (sensorEvent.accuracy >= 0 && n3 != sensorEvent.accuracy) {
                this.mSensorAccuracies.put(n, sensorEvent.accuracy);
                this.mListener.onAccuracyChanged(sensorEvent.sensor, sensorEvent.accuracy);
            }
            this.mListener.onSensorChanged(sensorEvent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.delete(sensor.getHandle());
                return;
            }
        }
    }

    static final class TriggerEventQueue
    extends BaseEventQueue {
        private final TriggerEventListener mListener;
        private final SparseArray<TriggerEvent> mTriggerEvents = new SparseArray();

        public TriggerEventQueue(TriggerEventListener triggerEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            super(looper, systemSensorManager);
            this.mListener = triggerEventListener;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            TriggerEvent triggerEvent = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.put(sensor.getHandle(), triggerEvent);
                return;
            }
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            Sensor sensor = (Sensor)sHandleToSensor.get(n);
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            // MONITORENTER : sparseArray
            TriggerEvent triggerEvent = this.mTriggerEvents.get(n);
            // MONITOREXIT : sparseArray
            if (triggerEvent == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            System.arraycopy((float[])fArray, (int)0, (float[])triggerEvent.values, (int)0, (int)triggerEvent.values.length);
            triggerEvent.timestamp = l;
            triggerEvent.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(triggerEvent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.delete(sensor.getHandle());
                return;
            }
        }
    }
}

