/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.LegacySensorManager;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SensorManager {
    public static final int AXIS_MINUS_X = 129;
    public static final int AXIS_MINUS_Y = 130;
    public static final int AXIS_MINUS_Z = 131;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    @Deprecated
    public static final int DATA_X = 0;
    @Deprecated
    public static final int DATA_Y = 1;
    @Deprecated
    public static final int DATA_Z = 2;
    public static final float GRAVITY_DEATH_STAR_I = 3.5303614E-7f;
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final float GRAVITY_JUPITER = 23.12f;
    public static final float GRAVITY_MARS = 3.71f;
    public static final float GRAVITY_MERCURY = 3.7f;
    public static final float GRAVITY_MOON = 1.6f;
    public static final float GRAVITY_NEPTUNE = 11.0f;
    public static final float GRAVITY_PLUTO = 0.6f;
    public static final float GRAVITY_SATURN = 8.96f;
    public static final float GRAVITY_SUN = 275.0f;
    public static final float GRAVITY_THE_ISLAND = 4.815162f;
    public static final float GRAVITY_URANUS = 8.69f;
    public static final float GRAVITY_VENUS = 8.87f;
    public static final float LIGHT_CLOUDY = 100.0f;
    public static final float LIGHT_FULLMOON = 0.25f;
    public static final float LIGHT_NO_MOON = 0.001f;
    public static final float LIGHT_OVERCAST = 10000.0f;
    public static final float LIGHT_SHADE = 20000.0f;
    public static final float LIGHT_SUNLIGHT = 110000.0f;
    public static final float LIGHT_SUNLIGHT_MAX = 120000.0f;
    public static final float LIGHT_SUNRISE = 400.0f;
    public static final float MAGNETIC_FIELD_EARTH_MAX = 60.0f;
    public static final float MAGNETIC_FIELD_EARTH_MIN = 30.0f;
    public static final float PRESSURE_STANDARD_ATMOSPHERE = 1013.25f;
    @Deprecated
    public static final int RAW_DATA_INDEX = 3;
    @Deprecated
    public static final int RAW_DATA_X = 3;
    @Deprecated
    public static final int RAW_DATA_Y = 4;
    @Deprecated
    public static final int RAW_DATA_Z = 5;
    @Deprecated
    public static final int SENSOR_ACCELEROMETER = 2;
    @Deprecated
    public static final int SENSOR_ALL = 127;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_NOPOLL = 4;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_DELAY_UI = 2;
    @Deprecated
    public static final int SENSOR_LIGHT = 16;
    @Deprecated
    public static final int SENSOR_MAGNETIC_FIELD = 8;
    @Deprecated
    public static final int SENSOR_MAX = 64;
    @Deprecated
    public static final int SENSOR_MIN = 1;
    @Deprecated
    public static final int SENSOR_ORIENTATION = 1;
    @Deprecated
    public static final int SENSOR_ORIENTATION_RAW = 128;
    @Deprecated
    public static final int SENSOR_PROXIMITY = 32;
    public static final int SENSOR_STATUS_ACCURACY_HIGH = 3;
    public static final int SENSOR_STATUS_ACCURACY_LOW = 1;
    public static final int SENSOR_STATUS_ACCURACY_MEDIUM = 2;
    public static final int SENSOR_STATUS_NO_CONTACT = -1;
    public static final int SENSOR_STATUS_UNRELIABLE = 0;
    @Deprecated
    public static final int SENSOR_TEMPERATURE = 4;
    @Deprecated
    public static final int SENSOR_TRICORDER = 64;
    public static final float STANDARD_GRAVITY = 9.80665f;
    protected static final String TAG = "SensorManager";
    private static final float[] mTempMatrix = new float[16];
    private LegacySensorManager mLegacySensorManager;
    private final SparseArray<List<Sensor>> mSensorListByType = new SparseArray();

    public static float getAltitude(float f, float f2) {
        return 44330.0f * (1.0f - (float)Math.pow(f2 / f, 0.19029495120048523));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getAngleChange(float[] fArray, float[] fArray2, float[] fArray3) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        if (fArray2.length == 9) {
            f18 = fArray2[0];
            f17 = fArray2[1];
            f16 = fArray2[2];
            f15 = fArray2[3];
            f14 = fArray2[4];
            f13 = fArray2[5];
            f12 = fArray2[6];
            f11 = fArray2[7];
            f10 = fArray2[8];
        } else {
            int n = fArray2.length;
            f18 = 0.0f;
            f17 = 0.0f;
            f16 = 0.0f;
            f15 = 0.0f;
            f14 = 0.0f;
            f13 = 0.0f;
            f12 = 0.0f;
            f11 = 0.0f;
            f10 = 0.0f;
            if (n == 16) {
                f18 = fArray2[0];
                f17 = fArray2[1];
                f16 = fArray2[2];
                f15 = fArray2[4];
                f14 = fArray2[5];
                f13 = fArray2[6];
                f12 = fArray2[8];
                f11 = fArray2[9];
                f10 = fArray2[10];
            }
        }
        if (fArray3.length == 9) {
            f9 = fArray3[0];
            f8 = fArray3[1];
            f7 = fArray3[2];
            f6 = fArray3[3];
            f5 = fArray3[4];
            f4 = fArray3[5];
            f3 = fArray3[6];
            f2 = fArray3[7];
            f = fArray3[8];
        } else {
            int n = fArray3.length;
            f9 = 0.0f;
            f8 = 0.0f;
            f7 = 0.0f;
            f6 = 0.0f;
            f5 = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
            if (n == 16) {
                f9 = fArray3[0];
                f8 = fArray3[1];
                f7 = fArray3[2];
                f6 = fArray3[4];
                f5 = fArray3[5];
                f4 = fArray3[6];
                f3 = fArray3[8];
                f2 = fArray3[9];
                f = fArray3[10];
            }
        }
        float f19 = f9 * f17 + f6 * f14 + f3 * f11;
        float f20 = f8 * f17 + f5 * f14 + f2 * f11;
        float f21 = f7 * f18 + f4 * f15 + f * f12;
        float f22 = f7 * f17 + f4 * f14 + f * f11;
        float f23 = f7 * f16 + f4 * f13 + f * f10;
        fArray[0] = (float)Math.atan2(f19, f20);
        fArray[1] = (float)Math.asin(-f22);
        fArray[2] = (float)Math.atan2(-f21, f23);
    }

    private static int getDelay(int n) {
        switch (n) {
            default: {
                return n;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 20000;
            }
            case 2: {
                return 66667;
            }
            case 3: {
                return 200000;
            }
            case 4: 
        }
        return Integer.MAX_VALUE;
    }

    public static float getInclination(float[] fArray) {
        if (fArray.length == 9) {
            return (float)Math.atan2(fArray[5], fArray[4]);
        }
        return (float)Math.atan2(fArray[6], fArray[5]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LegacySensorManager getLegacySensorManager() {
        SparseArray<List<Sensor>> sparseArray = this.mSensorListByType;
        synchronized (sparseArray) {
            if (this.mLegacySensorManager != null) return this.mLegacySensorManager;
            Log.i(TAG, "This application is using deprecated SensorManager API which will be removed someday.  Please consider switching to the new API.");
            this.mLegacySensorManager = new LegacySensorManager(this);
            return this.mLegacySensorManager;
        }
    }

    public static float[] getOrientation(float[] fArray, float[] fArray2) {
        if (fArray.length == 9) {
            fArray2[0] = (float)Math.atan2(fArray[1], fArray[4]);
            fArray2[1] = (float)Math.asin(-fArray[7]);
            fArray2[2] = (float)Math.atan2(-fArray[6], fArray[8]);
            return fArray2;
        }
        fArray2[0] = (float)Math.atan2(fArray[1], fArray[5]);
        fArray2[1] = (float)Math.asin(-fArray[9]);
        fArray2[2] = (float)Math.atan2(-fArray[8], fArray[10]);
        return fArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getQuaternionFromVector(float[] fArray, float[] fArray2) {
        if (fArray2.length >= 4) {
            fArray[0] = fArray2[3];
        } else {
            fArray[0] = 1.0f - fArray2[0] * fArray2[0] - fArray2[1] * fArray2[1] - fArray2[2] * fArray2[2];
            float f = fArray[0] - 0.0f;
            float f2 = f == 0.0f ? (byte)0 : (f > 0.0f ? (byte)1 : -1);
            float f3 = 0.0f;
            if (f2 > 0) {
                f3 = (float)Math.sqrt(fArray[0]);
            }
            fArray[0] = f3;
        }
        fArray[1] = fArray2[0];
        fArray[2] = fArray2[1];
        fArray[3] = fArray2[2];
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean getRotationMatrix(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = fArray4[1];
        float f2 = fArray3[2];
        float f3 = fArray4[2];
        float f4 = fArray3[1];
        float f5 = f * f2 - f3 * f4;
        float f6 = fArray3[0];
        float f7 = fArray4[0];
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = (float)Math.sqrt(f5 * f5 + f8 * f8 + f9 * f9);
        if (f10 < 0.1f) {
            return false;
        }
        float f11 = 1.0f / f10;
        float f12 = f5 * f11;
        float f13 = f8 * f11;
        float f14 = f9 * f11;
        float f15 = 1.0f / (float)Math.sqrt(f6 * f6 + f4 * f4 + f2 * f2);
        float f16 = f6 * f15;
        float f17 = f4 * f15;
        float f18 = f2 * f15;
        float f19 = f17 * f14 - f18 * f13;
        float f20 = f18 * f12 - f16 * f14;
        float f21 = f16 * f13 - f17 * f12;
        if (fArray != null) {
            if (fArray.length == 9) {
                fArray[0] = f12;
                fArray[1] = f13;
                fArray[2] = f14;
                fArray[3] = f19;
                fArray[4] = f20;
                fArray[5] = f21;
                fArray[6] = f16;
                fArray[7] = f17;
                fArray[8] = f18;
            } else if (fArray.length == 16) {
                fArray[0] = f12;
                fArray[1] = f13;
                fArray[2] = f14;
                fArray[3] = 0.0f;
                fArray[4] = f19;
                fArray[5] = f20;
                fArray[6] = f21;
                fArray[7] = 0.0f;
                fArray[8] = f16;
                fArray[9] = f17;
                fArray[10] = f18;
                fArray[11] = 0.0f;
                fArray[12] = 0.0f;
                fArray[13] = 0.0f;
                fArray[14] = 0.0f;
                fArray[15] = 1.0f;
            }
        }
        if (fArray2 == null) return true;
        float f22 = 1.0f / (float)Math.sqrt(f7 * f7 + f * f + f3 * f3);
        float f23 = f22 * (f7 * f19 + f * f20 + f3 * f21);
        float f24 = f22 * (f7 * f16 + f * f17 + f3 * f18);
        if (fArray2.length == 9) {
            fArray2[0] = 1.0f;
            fArray2[1] = 0.0f;
            fArray2[2] = 0.0f;
            fArray2[3] = 0.0f;
            fArray2[4] = f23;
            fArray2[5] = f24;
            fArray2[6] = 0.0f;
            fArray2[7] = -f24;
            fArray2[8] = f23;
            return true;
        }
        if (fArray2.length != 16) return true;
        fArray2[0] = 1.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 0.0f;
        fArray2[4] = 0.0f;
        fArray2[5] = f23;
        fArray2[6] = f24;
        fArray2[8] = 0.0f;
        fArray2[9] = -f24;
        fArray2[10] = f23;
        fArray2[14] = 0.0f;
        fArray2[13] = 0.0f;
        fArray2[12] = 0.0f;
        fArray2[11] = 0.0f;
        fArray2[7] = 0.0f;
        fArray2[3] = 0.0f;
        fArray2[15] = 1.0f;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getRotationMatrixFromVector(float[] fArray, float[] fArray2) {
        float f;
        float f2 = fArray2[0];
        float f3 = fArray2[1];
        float f4 = fArray2[2];
        float f5 = fArray2.length >= 4 ? fArray2[3] : ((f = 1.0f - f2 * f2 - f3 * f3 - f4 * f4) > 0.0f ? (float)Math.sqrt(f) : 0.0f);
        float f6 = f2 * (2.0f * f2);
        float f7 = f3 * (2.0f * f3);
        float f8 = f4 * (2.0f * f4);
        float f9 = f3 * (2.0f * f2);
        float f10 = f5 * (2.0f * f4);
        float f11 = f4 * (2.0f * f2);
        float f12 = f5 * (2.0f * f3);
        float f13 = f4 * (2.0f * f3);
        float f14 = f5 * (2.0f * f2);
        if (fArray.length == 9) {
            fArray[0] = 1.0f - f7 - f8;
            fArray[1] = f9 - f10;
            fArray[2] = f11 + f12;
            fArray[3] = f9 + f10;
            fArray[4] = 1.0f - f6 - f8;
            fArray[5] = f13 - f14;
            fArray[6] = f11 - f12;
            fArray[7] = f13 + f14;
            fArray[8] = 1.0f - f6 - f7;
            return;
        } else {
            if (fArray.length != 16) return;
            fArray[0] = 1.0f - f7 - f8;
            fArray[1] = f9 - f10;
            fArray[2] = f11 + f12;
            fArray[3] = 0.0f;
            fArray[4] = f9 + f10;
            fArray[5] = 1.0f - f6 - f8;
            fArray[6] = f13 - f14;
            fArray[7] = 0.0f;
            fArray[8] = f11 - f12;
            fArray[9] = f13 + f14;
            fArray[10] = 1.0f - f6 - f7;
            fArray[11] = 0.0f;
            fArray[14] = 0.0f;
            fArray[13] = 0.0f;
            fArray[12] = 0.0f;
            fArray[15] = 1.0f;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean remapCoordinateSystem(float[] fArray, int n, int n2, float[] fArray2) {
        if (fArray == fArray2) {
            float[] fArray3 = mTempMatrix;
            synchronized (fArray3) {
                if (SensorManager.remapCoordinateSystemImpl(fArray, n, n2, fArray3)) {
                    int n3 = fArray2.length;
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n3) {
                            return true;
                        }
                        fArray2[n4] = fArray3[n4];
                        ++n4;
                    }
                }
            }
        }
        return SensorManager.remapCoordinateSystemImpl(fArray, n, n2, fArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean remapCoordinateSystemImpl(float[] fArray, int n, int n2, float[] fArray2) {
        int n3 = fArray2.length;
        if (fArray.length != n3) {
            return false;
        }
        if ((n & 0x7C) != 0 || (n2 & 0x7C) != 0) {
            return false;
        }
        if ((n & 3) == 0 || (n2 & 3) == 0) {
            return false;
        }
        if ((n & 3) == (n2 & 3)) {
            return false;
        }
        int n4 = -1 + (n & 3);
        int n5 = n ^ n2;
        int n6 = -1 + (n5 & 3);
        int n7 = (n6 + 1) % 3;
        int n8 = -1 + (n2 & 3);
        int n9 = (n6 + 2) % 3;
        if ((n4 ^ n7 | n8 ^ n9) != 0) {
            n5 ^= 0x80;
        }
        boolean bl = n >= 128;
        boolean bl2 = n2 >= 128;
        boolean bl3 = n5 >= 128;
        int n10 = n3 == 16 ? 4 : 3;
        int n11 = 0;
        while (true) {
            int n12;
            if (n11 < 3) {
                n12 = n11 * n10;
            } else {
                if (n3 == 16) {
                    fArray2[14] = 0.0f;
                    fArray2[13] = 0.0f;
                    fArray2[12] = 0.0f;
                    fArray2[11] = 0.0f;
                    fArray2[7] = 0.0f;
                    fArray2[3] = 0.0f;
                    fArray2[15] = 1.0f;
                }
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if (n4 == i) {
                    int n13 = n12 + i;
                    float f = bl ? -fArray[n12 + 0] : fArray[n12 + 0];
                    fArray2[n13] = f;
                }
                if (n8 == i) {
                    int n14 = n12 + i;
                    float f = bl2 ? -fArray[n12 + 1] : fArray[n12 + 1];
                    fArray2[n14] = f;
                }
                if (n6 != i) continue;
                int n15 = n12 + i;
                float f = bl3 ? -fArray[n12 + 2] : fArray[n12 + 2];
                fArray2[n15] = f;
            }
            ++n11;
        }
    }

    public boolean cancelTriggerSensor(TriggerEventListener triggerEventListener, Sensor sensor) {
        return this.cancelTriggerSensorImpl(triggerEventListener, sensor, true);
    }

    protected abstract boolean cancelTriggerSensorImpl(TriggerEventListener var1, Sensor var2, boolean var3);

    public boolean flush(SensorEventListener sensorEventListener) {
        return this.flushImpl(sensorEventListener);
    }

    protected abstract boolean flushImpl(SensorEventListener var1);

    public Sensor getDefaultSensor(int n) {
        boolean bl;
        List<Sensor> list;
        block4: {
            block3: {
                list = this.getSensorList(n);
                if (n == 8 || n == 17 || n == 22 || n == 23 || n == 24) break block3;
                bl = false;
                if (n != 25) break block4;
            }
            bl = true;
        }
        for (Sensor sensor : list) {
            if (sensor.isWakeUpSensor() != bl) continue;
            return sensor;
        }
        return null;
    }

    public Sensor getDefaultSensor(int n, boolean bl) {
        for (Sensor sensor : this.getSensorList(n)) {
            if (sensor.isWakeUpSensor() != bl) continue;
            return sensor;
        }
        return null;
    }

    protected abstract List<Sensor> getFullSensorList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Sensor> getSensorList(int n) {
        List<Sensor> list = this.getFullSensorList();
        SparseArray<List<Sensor>> sparseArray = this.mSensorListByType;
        synchronized (sparseArray) {
            List<Sensor> list2 = this.mSensorListByType.get(n);
            if (list2 == null) {
                List<Sensor> list3;
                if (n == -1) {
                    list3 = list;
                } else {
                    list3 = new ArrayList<Sensor>();
                    for (Sensor sensor : list) {
                        if (sensor.getType() != n) continue;
                        list3.add(sensor);
                    }
                }
                list2 = Collections.unmodifiableList(list3);
                this.mSensorListByType.append(n, list2);
            }
            return list2;
        }
    }

    @Deprecated
    public int getSensors() {
        return this.getLegacySensorManager().getSensors();
    }

    public boolean registerListener(SensorEventListener sensorEventListener, Sensor sensor, int n) {
        return this.registerListener(sensorEventListener, sensor, n, null);
    }

    public boolean registerListener(SensorEventListener sensorEventListener, Sensor sensor, int n, int n2) {
        return this.registerListenerImpl(sensorEventListener, sensor, SensorManager.getDelay(n), null, n2, 0);
    }

    public boolean registerListener(SensorEventListener sensorEventListener, Sensor sensor, int n, int n2, Handler handler) {
        return this.registerListenerImpl(sensorEventListener, sensor, SensorManager.getDelay(n), handler, n2, 0);
    }

    public boolean registerListener(SensorEventListener sensorEventListener, Sensor sensor, int n, Handler handler) {
        return this.registerListenerImpl(sensorEventListener, sensor, SensorManager.getDelay(n), handler, 0, 0);
    }

    @Deprecated
    public boolean registerListener(SensorListener sensorListener, int n) {
        return this.registerListener(sensorListener, n, 3);
    }

    @Deprecated
    public boolean registerListener(SensorListener sensorListener, int n, int n2) {
        return this.getLegacySensorManager().registerListener(sensorListener, n, n2);
    }

    protected abstract boolean registerListenerImpl(SensorEventListener var1, Sensor var2, int var3, Handler var4, int var5, int var6);

    public boolean requestTriggerSensor(TriggerEventListener triggerEventListener, Sensor sensor) {
        return this.requestTriggerSensorImpl(triggerEventListener, sensor);
    }

    protected abstract boolean requestTriggerSensorImpl(TriggerEventListener var1, Sensor var2);

    public void unregisterListener(SensorEventListener sensorEventListener) {
        if (sensorEventListener == null) {
            return;
        }
        this.unregisterListenerImpl(sensorEventListener, null);
    }

    public void unregisterListener(SensorEventListener sensorEventListener, Sensor sensor) {
        if (sensorEventListener == null || sensor == null) {
            return;
        }
        this.unregisterListenerImpl(sensorEventListener, sensor);
    }

    @Deprecated
    public void unregisterListener(SensorListener sensorListener) {
        this.unregisterListener(sensorListener, 255);
    }

    @Deprecated
    public void unregisterListener(SensorListener sensorListener, int n) {
        this.getLegacySensorManager().unregisterListener(sensorListener, n);
    }

    protected abstract void unregisterListenerImpl(SensorEventListener var1, Sensor var2);
}

