/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public final class PdfEditor {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private ParcelFileDescriptor mInput;
    private final long mNativeDocument;
    private int mPageCount;

    public PdfEditor(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        long l;
        if (parcelFileDescriptor == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(parcelFileDescriptor.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            l = Libcore.os.fstat((FileDescriptor)parcelFileDescriptor.getFileDescriptor()).st_size;
            this.mInput = parcelFileDescriptor;
        }
        catch (ErrnoException errnoException) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), l);
        this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    private void doClose() {
        PdfEditor.nativeClose(this.mNativeDocument);
        IoUtils.closeQuietly((AutoCloseable)this.mInput);
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private static native void nativeClose(long var0);

    private static native int nativeGetPageCount(long var0);

    private static native long nativeOpen(int var0, long var1);

    private static native int nativeRemovePage(long var0, int var2);

    private static native void nativeWrite(long var0, int var2);

    private void throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private void throwIfPageNotInDocument(int n) {
        if (n < 0 || n >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    public void close() {
        this.throwIfClosed();
        this.doClose();
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    public void removePage(int n) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(n);
        this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, n);
    }

    public void write(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        try {
            this.throwIfClosed();
            PdfEditor.nativeWrite(this.mNativeDocument, parcelFileDescriptor.getFd());
            return;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)parcelFileDescriptor);
        }
    }
}

