/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimatedRotateDrawable;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.LevelListDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Drawable {
    static final PorterDuff.Mode DEFAULT_TINT_MODE;
    private static final Rect ZERO_BOUNDS_RECT;
    private Rect mBounds;
    private WeakReference<Callback> mCallback = null;
    private int mChangingConfigurations = 0;
    private int mLayoutDirection;
    private int mLevel = 0;
    private int[] mStateSet = StateSet.WILD_CARD;
    private boolean mVisible = true;

    static {
        ZERO_BOUNDS_RECT = new Rect();
        DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    }

    public Drawable() {
        this.mBounds = ZERO_BOUNDS_RECT;
    }

    public static Drawable createFromPath(String string2) {
        block5: {
            if (string2 == null) {
                return null;
            }
            Trace.traceBegin(8192L, string2);
            Bitmap bitmap = BitmapFactory.decodeFile(string2);
            if (bitmap == null) break block5;
            Drawable drawable2 = Drawable.drawableFromBitmap(null, bitmap, null, null, null, string2);
            return drawable2;
        }
        Trace.traceEnd(8192L);
        return null;
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2) {
        String string3 = string2 != null ? string2 : "Unknown drawable";
        Trace.traceBegin(8192L, string3);
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(resources, typedValue, inputStream, string2, null);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2, BitmapFactory.Options options) {
        if (inputStream == null) {
            return null;
        }
        Rect rect = new Rect();
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        int n = resources != null ? resources.getDisplayMetrics().noncompatDensityDpi : DisplayMetrics.DENSITY_DEVICE;
        options.inScreenDensity = n;
        Bitmap bitmap = BitmapFactory.decodeResourceStream(resources, typedValue, inputStream, rect, options);
        if (bitmap == null) {
            return null;
        }
        byte[] byArray = bitmap.getNinePatchChunk();
        if (byArray == null || !NinePatch.isNinePatchChunk(byArray)) {
            byArray = null;
            rect = null;
        }
        Rect rect2 = new Rect();
        bitmap.getOpticalInsets(rect2);
        return Drawable.drawableFromBitmap(resources, bitmap, byArray, rect, rect2, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Drawable createFromStream(InputStream inputStream, String string2) {
        String string3 = string2 != null ? string2 : "Unknown drawable";
        Trace.traceBegin(8192L, string3);
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(null, null, inputStream, string2);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    public static Drawable createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return Drawable.createFromXml(resources, xmlPullParser, null);
    }

    public static Drawable createFromXml(Resources resources, XmlPullParser xmlPullParser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        while ((n = xmlPullParser.next()) != 2 && n != 1) {
        }
        if (n != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        if (drawable2 == null) {
            throw new RuntimeException("Unknown initial tag: " + xmlPullParser.getName());
        }
        return drawable2;
    }

    public static Drawable createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Drawable createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        void var5_6;
        String string2 = xmlPullParser.getName();
        if (string2.equals("selector")) {
            StateListDrawable stateListDrawable = new StateListDrawable();
        } else if (string2.equals("animated-selector")) {
            AnimatedStateListDrawable animatedStateListDrawable = new AnimatedStateListDrawable();
        } else if (string2.equals("level-list")) {
            LevelListDrawable levelListDrawable = new LevelListDrawable();
        } else if (string2.equals("layer-list")) {
            LayerDrawable layerDrawable = new LayerDrawable();
        } else if (string2.equals("transition")) {
            TransitionDrawable transitionDrawable = new TransitionDrawable();
        } else if (string2.equals("ripple")) {
            RippleDrawable rippleDrawable = new RippleDrawable();
        } else if (string2.equals("color")) {
            ColorDrawable colorDrawable = new ColorDrawable();
        } else if (string2.equals("shape")) {
            GradientDrawable gradientDrawable = new GradientDrawable();
        } else if (string2.equals("vector")) {
            VectorDrawable vectorDrawable = new VectorDrawable();
        } else if (string2.equals("animated-vector")) {
            AnimatedVectorDrawable animatedVectorDrawable = new AnimatedVectorDrawable();
        } else if (string2.equals("scale")) {
            ScaleDrawable scaleDrawable = new ScaleDrawable();
        } else if (string2.equals("clip")) {
            ClipDrawable clipDrawable = new ClipDrawable();
        } else if (string2.equals("rotate")) {
            RotateDrawable rotateDrawable = new RotateDrawable();
        } else if (string2.equals("animated-rotate")) {
            AnimatedRotateDrawable animatedRotateDrawable = new AnimatedRotateDrawable();
        } else if (string2.equals("animation-list")) {
            AnimationDrawable animationDrawable = new AnimationDrawable();
        } else if (string2.equals("inset")) {
            InsetDrawable insetDrawable = new InsetDrawable();
        } else if (string2.equals("bitmap")) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(resources);
            if (resources != null) {
                bitmapDrawable.setTargetDensity(resources.getDisplayMetrics());
            }
        } else {
            if (!string2.equals("nine-patch")) {
                throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": invalid drawable tag " + string2);
            }
            NinePatchDrawable ninePatchDrawable = new NinePatchDrawable();
            if (resources != null) {
                ninePatchDrawable.setTargetDensity(resources.getDisplayMetrics());
            }
        }
        var5_6.inflate(resources, xmlPullParser, attributeSet, theme);
        return var5_6;
    }

    private static Drawable drawableFromBitmap(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        if (byArray != null) {
            return new NinePatchDrawable(resources, bitmap, byArray, rect, rect2, string2);
        }
        return new BitmapDrawable(resources, bitmap);
    }

    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray) {
        if (theme == null) {
            return resources.obtainAttributes(attributeSet, nArray);
        }
        return theme.obtainStyledAttributes(attributeSet, nArray, 0, 0);
    }

    public static PorterDuff.Mode parseTintMode(int n, PorterDuff.Mode mode) {
        switch (n) {
            default: {
                return mode;
            }
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: 
        }
        return PorterDuff.Mode.ADD;
    }

    public static int resolveOpacity(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == -3 || n2 == -3) {
            return -3;
        }
        if (n == -2 || n2 == -2) {
            return -2;
        }
        return -1;
    }

    public void applyTheme(Resources.Theme theme) {
    }

    public boolean canApplyTheme() {
        return false;
    }

    public void clearColorFilter() {
        this.setColorFilter(null);
    }

    public final Rect copyBounds() {
        return new Rect(this.mBounds);
    }

    public final void copyBounds(Rect rect) {
        rect.set(this.mBounds);
    }

    public abstract void draw(Canvas var1);

    public int getAlpha() {
        return 255;
    }

    public final Rect getBounds() {
        if (this.mBounds == ZERO_BOUNDS_RECT) {
            this.mBounds = new Rect();
        }
        return this.mBounds;
    }

    public Callback getCallback() {
        if (this.mCallback != null) {
            return (Callback)this.mCallback.get();
        }
        return null;
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public ColorFilter getColorFilter() {
        return null;
    }

    public ConstantState getConstantState() {
        return null;
    }

    public Drawable getCurrent() {
        return this;
    }

    public Rect getDirtyBounds() {
        return this.getBounds();
    }

    public void getHotspotBounds(Rect rect) {
        rect.set(this.getBounds());
    }

    public int getIntrinsicHeight() {
        return -1;
    }

    public int getIntrinsicWidth() {
        return -1;
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public final int getLevel() {
        return this.mLevel;
    }

    public int getMinimumHeight() {
        int n = this.getIntrinsicHeight();
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public int getMinimumWidth() {
        int n = this.getIntrinsicWidth();
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public abstract int getOpacity();

    public Insets getOpticalInsets() {
        return Insets.NONE;
    }

    public void getOutline(Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha(0.0f);
    }

    public boolean getPadding(Rect rect) {
        rect.set(0, 0, 0, 0);
        return false;
    }

    public int[] getState() {
        return this.mStateSet;
    }

    public Region getTransparentRegion() {
        return null;
    }

    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        this.inflate(resources, xmlPullParser, attributeSet, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.Drawable, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.Drawable);
        this.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        typedArray.recycle();
    }

    void inflateWithAttributes(Resources resources, XmlPullParser xmlPullParser, TypedArray typedArray, int n) throws XmlPullParserException, IOException {
        this.mVisible = typedArray.getBoolean(n, this.mVisible);
    }

    public void invalidateSelf() {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    public boolean isAutoMirrored() {
        return false;
    }

    public boolean isProjected() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public final boolean isVisible() {
        return this.mVisible;
    }

    public void jumpToCurrentState() {
    }

    public Drawable mutate() {
        return this;
    }

    protected void onBoundsChange(Rect rect) {
    }

    protected boolean onLevelChange(int n) {
        return false;
    }

    protected boolean onStateChange(int[] nArray) {
        return false;
    }

    public void scheduleSelf(Runnable runnable, long l) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, l);
        }
    }

    public abstract void setAlpha(int var1);

    public void setAutoMirrored(boolean bl) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rect rect = this.mBounds;
        if (rect == ZERO_BOUNDS_RECT) {
            this.mBounds = rect = new Rect();
        }
        if (rect.left != n || rect.top != n2 || rect.right != n3 || rect.bottom != n4) {
            if (!rect.isEmpty()) {
                this.invalidateSelf();
            }
            this.mBounds.set(n, n2, n3, n4);
            this.onBoundsChange(this.mBounds);
        }
    }

    public void setBounds(Rect rect) {
        this.setBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final void setCallback(Callback callback) {
        this.mCallback = new WeakReference<Callback>(callback);
    }

    public void setChangingConfigurations(int n) {
        this.mChangingConfigurations = n;
    }

    public void setColorFilter(int n, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(n, mode));
    }

    public abstract void setColorFilter(ColorFilter var1);

    public void setDither(boolean bl) {
    }

    public void setFilterBitmap(boolean bl) {
    }

    public void setHotspot(float f, float f2) {
    }

    public void setHotspotBounds(int n, int n2, int n3, int n4) {
    }

    public void setLayoutDirection(int n) {
        if (this.getLayoutDirection() != n) {
            this.mLayoutDirection = n;
        }
    }

    public final boolean setLevel(int n) {
        if (this.mLevel != n) {
            this.mLevel = n;
            return this.onLevelChange(n);
        }
        return false;
    }

    public boolean setState(int[] nArray) {
        if (!Arrays.equals(this.mStateSet, nArray)) {
            this.mStateSet = nArray;
            return this.onStateChange(nArray);
        }
        return false;
    }

    public void setTint(int n) {
        this.setTintList(ColorStateList.valueOf(n));
    }

    public void setTintList(ColorStateList colorStateList) {
    }

    public void setTintMode(PorterDuff.Mode mode) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setVisible(boolean bl, boolean bl2) {
        if (this.mVisible == bl) return false;
        boolean bl3 = true;
        if (!bl3) return bl3;
        this.mVisible = bl;
        this.invalidateSelf();
        return bl3;
    }

    public void setXfermode(Xfermode xfermode) {
    }

    public void unscheduleSelf(Runnable runnable) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    PorterDuffColorFilter updateTintFilter(PorterDuffColorFilter porterDuffColorFilter, ColorStateList colorStateList, PorterDuff.Mode mode) {
        if (colorStateList == null || mode == null) {
            return null;
        }
        int n = colorStateList.getColorForState(this.getState(), 0);
        if (porterDuffColorFilter == null) {
            return new PorterDuffColorFilter(n, mode);
        }
        porterDuffColorFilter.setColor(n);
        porterDuffColorFilter.setMode(mode);
        return porterDuffColorFilter;
    }

    public static interface Callback {
        public void invalidateDrawable(Drawable var1);

        public void scheduleDrawable(Drawable var1, Runnable var2, long var3);

        public void unscheduleDrawable(Drawable var1, Runnable var2);
    }

    public static abstract class ConstantState {
        public boolean canApplyTheme() {
            return false;
        }

        public Bitmap getBitmap() {
            return null;
        }

        public abstract int getChangingConfigurations();

        public abstract Drawable newDrawable();

        public Drawable newDrawable(Resources resources) {
            return this.newDrawable();
        }

        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return this.newDrawable();
        }
    }
}

