/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationDrawable
extends DrawableContainer
implements Runnable,
Animatable {
    private boolean mAnimating;
    private final AnimationState mAnimationState;
    private int mCurFrame = -1;
    private boolean mMutated;
    private boolean mRunning;

    public AnimationDrawable() {
        this(null, null);
    }

    private AnimationDrawable(AnimationState animationState, Resources resources) {
        AnimationState animationState2;
        this.mAnimationState = animationState2 = new AnimationState(animationState, this, resources);
        this.setConstantState(animationState2);
        if (animationState != null) {
            this.setFrame(0, true, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void nextFrame(boolean bl) {
        int n = 1 + this.mCurFrame;
        int n2 = this.mAnimationState.getChildCount();
        if (n >= n2) {
            n = 0;
        }
        boolean bl2 = !this.mAnimationState.mOneShot || n < n2 - 1;
        this.setFrame(n, bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setFrame(int n, boolean bl, boolean bl2) {
        block5: {
            block4: {
                if (n >= this.mAnimationState.getChildCount()) break block4;
                this.mAnimating = bl2;
                this.mCurFrame = n;
                this.selectDrawable(n);
                if (bl || bl2) {
                    this.unscheduleSelf(this);
                }
                if (bl2) break block5;
            }
            return;
        }
        this.mCurFrame = n;
        this.mRunning = true;
        this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mAnimationState.mDurations[n]);
    }

    public void addFrame(Drawable drawable2, int n) {
        this.mAnimationState.addFrame(drawable2, n);
        if (this.mCurFrame < 0) {
            this.setFrame(0, true, false);
        }
    }

    public int getDuration(int n) {
        return this.mAnimationState.mDurations[n];
    }

    public Drawable getFrame(int n) {
        return this.mAnimationState.getChild(n);
    }

    public int getNumberOfFrames() {
        return this.mAnimationState.getChildCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        int n2;
        TypedArray typedArray = AnimationDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimationDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        this.mAnimationState.setVariablePadding(typedArray.getBoolean(1, false));
        AnimationState.access$102(this.mAnimationState, typedArray.getBoolean(2, false));
        typedArray.recycle();
        int n3 = 1 + xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            Drawable drawable2;
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            TypedArray typedArray2 = AnimationDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimationDrawableItem);
            int n4 = typedArray2.getInt(0, -1);
            if (n4 < 0) {
                throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'duration' attribute");
            }
            int n5 = typedArray2.getResourceId(1, 0);
            typedArray2.recycle();
            if (n5 != 0) {
                drawable2 = resources.getDrawable(n5, theme);
            } else {
                int n6;
                while ((n6 = xmlPullParser.next()) == 4) {
                }
                if (n6 != 2) {
                    throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag" + " defining a drawable");
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
            }
            this.mAnimationState.addFrame(drawable2, n4);
            if (drawable2 == null) continue;
            drawable2.setCallback(this);
        }
        this.setFrame(0, true, false);
    }

    public boolean isOneShot() {
        return this.mAnimationState.mOneShot;
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            AnimationState.access$002(this.mAnimationState, (int[])this.mAnimationState.mDurations.clone());
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void run() {
        this.nextFrame(false);
    }

    public void setOneShot(boolean bl) {
        AnimationState.access$102(this.mAnimationState, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (!bl) {
            this.unscheduleSelf(this);
            return bl3;
        }
        if (bl2 || bl3) {
            boolean bl4 = bl2 || this.mCurFrame < 0 || this.mCurFrame >= this.mAnimationState.getChildCount();
            int n = 0;
            if (!bl4) {
                n = this.mCurFrame;
            }
            this.setFrame(n, true, this.mAnimating);
        }
        return bl3;
    }

    @Override
    public void start() {
        this.mAnimating = true;
        if (!this.isRunning()) {
            this.run();
        }
    }

    @Override
    public void stop() {
        this.mAnimating = false;
        if (this.isRunning()) {
            this.unscheduleSelf(this);
        }
    }

    @Override
    public void unscheduleSelf(Runnable runnable) {
        this.mCurFrame = -1;
        this.mRunning = false;
        super.unscheduleSelf(runnable);
    }

    private static final class AnimationState
    extends DrawableContainer.DrawableContainerState {
        private int[] mDurations;
        private boolean mOneShot;

        AnimationState(AnimationState animationState, AnimationDrawable animationDrawable, Resources resources) {
            super(animationState, animationDrawable, resources);
            if (animationState != null) {
                this.mDurations = animationState.mDurations;
                this.mOneShot = animationState.mOneShot;
                return;
            }
            this.mDurations = new int[this.getCapacity()];
            this.mOneShot = true;
        }

        static /* synthetic */ int[] access$002(AnimationState animationState, int[] nArray) {
            animationState.mDurations = nArray;
            return nArray;
        }

        static /* synthetic */ boolean access$102(AnimationState animationState, boolean bl) {
            animationState.mOneShot = bl;
            return bl;
        }

        public void addFrame(Drawable drawable2, int n) {
            int n2 = super.addChild(drawable2);
            this.mDurations[n2] = n;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[] nArray = new int[n2];
            System.arraycopy((int[])this.mDurations, (int)0, (int[])nArray, (int)0, (int)n);
            this.mDurations = nArray;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimationDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimationDrawable(this, resources);
        }
    }
}

