/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedVectorDrawable
extends Drawable
implements Animatable {
    private static final String ANIMATED_VECTOR = "animated-vector";
    private static final boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private static final String LOGTAG = AnimatedVectorDrawable.class.getSimpleName();
    private static final String TARGET = "target";
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private boolean mMutated;

    public AnimatedVectorDrawable() {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(null);
    }

    private AnimatedVectorDrawable(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources, Resources.Theme theme) {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(animatedVectorDrawableState);
        if (theme != null && this.canApplyTheme()) {
            this.applyTheme(theme);
        }
    }

    private boolean isStarted() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).isStarted()) continue;
            return true;
        }
        return false;
    }

    private void setupAnimatorsForTarget(String string2, Animator animator2) {
        animator2.setTarget(this.mAnimatedVectorState.mVectorDrawable.getTargetByName(string2));
        if (this.mAnimatedVectorState.mAnimators == null) {
            this.mAnimatedVectorState.mAnimators = new ArrayList();
            this.mAnimatedVectorState.mTargetNameMap = new ArrayMap();
        }
        this.mAnimatedVectorState.mAnimators.add(animator2);
        this.mAnimatedVectorState.mTargetNameMap.put(animator2, string2);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        VectorDrawable vectorDrawable = this.mAnimatedVectorState.mVectorDrawable;
        if (vectorDrawable != null && vectorDrawable.canApplyTheme()) {
            vectorDrawable.applyTheme(theme);
        }
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mAnimatedVectorState != null && this.mAnimatedVectorState.mVectorDrawable != null && this.mAnimatedVectorState.mVectorDrawable.canApplyTheme();
    }

    public boolean canReverse() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i).canReverse()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void draw(Canvas canvas) {
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
        if (this.isStarted()) {
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.mChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mAnimatedVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mAnimatedVectorState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpacity();
    }

    @Override
    public void getOutline(Outline outline) {
        this.mAnimatedVectorState.mVectorDrawable.getOutline(outline);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        float f = 1.0f;
        while (n != 1) {
            if (n == 2) {
                String string2 = xmlPullParser.getName();
                if (ANIMATED_VECTOR.equals(string2)) {
                    TypedArray typedArray = AnimatedVectorDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimatedVectorDrawable);
                    int n2 = typedArray.getResourceId(0, 0);
                    if (n2 != 0) {
                        VectorDrawable vectorDrawable = (VectorDrawable)resources.getDrawable(n2, theme).mutate();
                        vectorDrawable.setAllowCaching(false);
                        f = vectorDrawable.getPixelSize();
                        this.mAnimatedVectorState.mVectorDrawable = vectorDrawable;
                    }
                    typedArray.recycle();
                } else if (TARGET.equals(string2)) {
                    TypedArray typedArray = AnimatedVectorDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimatedVectorDrawableTarget);
                    String string3 = typedArray.getString(0);
                    int n3 = typedArray.getResourceId(1, 0);
                    if (n3 != 0) {
                        this.setupAnimatorsForTarget(string3, AnimatorInflater.loadAnimator(resources, theme, n3, f));
                    }
                    typedArray.recycle();
                }
            }
            n = xmlPullParser.next();
        }
        return;
    }

    @Override
    public boolean isRunning() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimatedVectorState.mVectorDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(n);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reverse() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Animator animator2 = arrayList.get(n2);
            if (animator2.canReverse()) {
                animator2.reverse();
            } else {
                Log.w(LOGTAG, "AnimatedVectorDrawable can't reverse()");
            }
            ++n2;
        }
        return;
    }

    @Override
    public void setAlpha(int n) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    @Override
    public void setHotspot(float f, float f2) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspot(f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspotBounds(n, n2, n3, n4);
    }

    @Override
    public void setLayoutDirection(int n) {
        this.mAnimatedVectorState.mVectorDrawable.setLayoutDirection(n);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mAnimatedVectorState.mVectorDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void start() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Animator animator2 = arrayList.get(i);
            if (animator2.isStarted()) continue;
            animator2.start();
        }
        this.invalidateSelf();
    }

    @Override
    public void stop() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).end();
        }
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState {
        ArrayList<Animator> mAnimators;
        int mChangingConfigurations;
        ArrayMap<Animator, String> mTargetNameMap;
        VectorDrawable mVectorDrawable;

        public AnimatedVectorDrawableState(AnimatedVectorDrawableState animatedVectorDrawableState) {
            if (animatedVectorDrawableState != null) {
                this.mChangingConfigurations = animatedVectorDrawableState.mChangingConfigurations;
                if (animatedVectorDrawableState.mVectorDrawable != null) {
                    this.mVectorDrawable = (VectorDrawable)animatedVectorDrawableState.mVectorDrawable.getConstantState().newDrawable();
                    this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setAllowCaching(false);
                    this.mVectorDrawable.setBounds(animatedVectorDrawableState.mVectorDrawable.getBounds());
                }
                if (animatedVectorDrawableState.mAnimators != null) {
                    int n = animatedVectorDrawableState.mAnimators.size();
                    this.mAnimators = new ArrayList(n);
                    this.mTargetNameMap = new ArrayMap(n);
                    for (int i = 0; i < n; ++i) {
                        Animator animator2 = animatedVectorDrawableState.mAnimators.get(i);
                        Animator animator3 = animator2.clone();
                        String string2 = animatedVectorDrawableState.mTargetNameMap.get(animator2);
                        animator3.setTarget(this.mVectorDrawable.getTargetByName(string2));
                        this.mAnimators.add(animator3);
                        this.mTargetNameMap.put(animator3, string2);
                    }
                }
            } else {
                this.mVectorDrawable = new VectorDrawable();
            }
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedVectorDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimatedVectorDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new AnimatedVectorDrawable(this, resources, theme);
        }
    }
}

